//#include "dcmodule.h"
#include"tty.h"
#include"ocpp.h"
#include"poll.h"
#include "modbus.h"

int can_fd= -1;
int nbytes;
struct sockaddr_can addr;
struct ifreq ifr;
struct can_frame frame;
// QQueue<int> can_module;

Can_Module_Transmit CAN_TX_2;
Can_Module_Recieve CAN_RX_2;
struct stErrorbits m_Error;
extern struct LoadSharing Sharing;
extern Can_Module_Transmit CAN_TX;
extern Can_Module_Recieve CAN_RX;
//extern PowerModuleOutput Pm_Out;
extern Charger_Status CCS;
extern Charger_Status CCS2;
//extern Rfid_Auth RAuth;
// extern struct input_event ev[64];
extern struct stOcppKey gstOcppKey;
static unsigned long int can_baudrate = 125000;
unsigned long int baud_size= 10000;
const char * dev_name="can0";
const char * dev_name_2="can1";
/*unsigned int Voltage_Frame[8]={0x03,0x00,0x00,0x21,0x42,0x70,0x00,0x00};
unsigned int Current_Frame[8]={0x03,0x00,0x00,0x22,0x00,0x00,0x00,0x00};

unsigned int flush_buffer[8]={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
uint8_t shutdown_frame[8] = {0x03,0x00,0x00,0x30,0x00,0x01,0x00,0x00};
uint8_t boot_frame[8] = {0x03,0x00,0x00,0x30,0x00,0x00,0x00,0x00};
uint8_t read_volatge[8] = {0x10,0x00,0x00,0x01,0x00,0x00,0x00,0x00};
uint8_t read_current[8] = {0x10,0x00,0x00,0x02,0x00,0x00,0x00,0x00};

uint8_t ReceivedBuff[BuffSize][8]= {0};
uint8_t plc_req =0,plc_req_2=0;

unsigned int ReceivedFrameCounter = 0;
uint16_t ParsedFrameCounter= 0;
bool flag=0,bCabelCharge = 0;
*/
//uint8_t read_Status_A[8] = {0x10,0x00,0x00,0x0c,0x00,0x00,0x00,0x00};
//uint8_t read_Status_B[8] = {0x10,0x00,0x00,0x0d,0x00,0x00,0x00,0x00};
//uint8_t read_Status_C[8] = {0x10,0x00,0x00,0x0e,0x00,0x00,0x00,0x00};
//extern int bIsolation_ok;
extern struct Parameter set_parameter;
//POWER Module 1 82 address send frame id : 0x060c1781, rcv frame Id: 0x860f8411
//POWER Module 2 80 address send frame id : 0x060c0781, rcv frame Id: 0x860f8401
extern stChargerUI_Info ChargerUI_Info,ChargerUI_Info_2;
Dcmodule::Dcmodule(QObject *parent) : QObject(parent)
{

}
int Dcmodule::can_setting(const char* can, const int bitrate, int enable)
{
    int ret = 0;
    char cmdline[128] = { '\0' };

    sprintf(cmdline,
            "ip link set %s down",can);
    ret = system(cmdline);

    sleep(2);
    if(enable == 1){
        sprintf(cmdline,
                "ip link set %s type can bitrate %ld triple-sampling on; ifconfig %s up",
                can, bitrate, can);
    }
    ret = system(cmdline);
    sleep(2);
    return WEXITSTATUS(ret);
}

int Dcmodule::can_setting1( const long int baud_size,int enable)
{
    int ret1 = 0;
    char cmdline[128] = { '\0' };

    if(enable == 1){
        sprintf(cmdline,"ifconfig can1 txqueuelen %ld",baud_size);
    }

    ret1 = system(cmdline);
    sleep(2);
    return WEXITSTATUS(ret1);
}
void Dcmodule::Timer_Init(void)
{
    QTimer *timer = new QTimer();
    timer->setInterval(900);
    connect(timer, SIGNAL(timeout()), this, SLOT(TimerEvent()));
    timer->start();
  //  can_module.enqueue(Pm_On);
    qDebug()<<"Timer Event call "<< endl;
}
void Dcmodule::TestModeEvent(void)
{   
   if(CCS.start == Charging_Start)
    {
       CAN_TX.Dc_main = C_ON;    // change
       CAN_TX.Pm1_voltage = (float)set_parameter.DC_VMAX;
        CAN_TX.Pm1_current = (float)set_parameter.DC_IMAX;
        powerdc(CANID_PM1,CAN_TX.Pm1_voltage,CAN_TX.Pm1_current);
    }
   else if(CCS.start == Charging_Stop || CCS.start == Try_To_Start || CCS.start == Try_To_Stop)
   {
        if(CCS.DC_Voltage_1 < 100)
        {
            CAN_TX.Dc_main = C_OFF;
        //    qDebug()<<"G1 off "<<endl;
        }       
   }
   if(CCS2.start == Charging_Start)
   {
        CAN_TX_2.Dc_main = C_ON;
        CAN_TX_2.Pm1_voltage = (float)set_parameter.DC_VMAX;
        CAN_TX_2.Pm1_current = (float)set_parameter.DC_IMAX;
        powerdc(CANID_PM2,CAN_TX_2.Pm1_voltage,CAN_TX_2.Pm1_current);
   }
   else if(CCS2.start == Charging_Stop || CCS2.start == Try_To_Start || CCS2.start == Try_To_Stop)
   {
        if(CCS2.DC_Voltage_1 < 100)
        {
            CAN_TX_2.Dc_main = C_OFF;
        }
   }
}
void Dcmodule::TimerEvent(void)
{
    if(set_parameter.TestMode_ED == true)
    {
        TestModeEvent();
        return;
    }    
}
unsigned long int  Dcmodule::getStatus(unsigned char CAN_ID)
{
    if(CAN_ID == 1)
    {
        return 0x06080f80;
    }
    else if(CAN_ID == 2)
    {
        return 0x06080780;
    }
    else if(CAN_ID == 3)
    {
        return 0x06081780;
    }
    else if(CAN_ID == 4)
    {
        return 0x06082780;
    }
}
bool Dcmodule::On_Module(unsigned long int can_id){

 #ifdef WINLINE
    stPM_on *pPM_on = new stPM_on(can_id);
    pPM_on->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
    if (write(can_fd, &pPM_on->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        //DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_on)
        return false;
    }
    SAFE_DELETE(pPM_on)
#else
    stNPM_on *pPM_on = new stNPM_on(1);
    /*pPM_on->frame.can_id = (0x029A00F0 | CAN_EFF_FLAG);*/
    pPM_on->frame.can_id = can_id ==CANID_PM1 ? (0x029A00F0 | CAN_EFF_FLAG) :(0x029A01F0 | CAN_EFF_FLAG);
    if (write(can_fd, &pPM_on->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        //DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_on)
        return false;
    }
    SAFE_DELETE(pPM_on)

#endif
    return true;
}
bool Dcmodule::ClearProtection_Module(unsigned char can_id)
{
    stPM_on *pPermission = new stPM_on(can_id);
    pPermission->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
    pPermission->frame.data[0] = 0x03;
    pPermission->frame.data[1] = 0x00;
    pPermission->frame.data[2] = 0x00;
    pPermission->frame.data[3] = 0x3e;
    pPermission->frame.data[4] = 0x00;
    pPermission->frame.data[5] = 0x01;
    pPermission->frame.data[6] = 0x00;
    pPermission->frame.data[7] = 0x00;

    if (write(can_fd, &pPermission->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        //DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPermission)
        return false;
    }
    SAFE_DELETE(pPermission)

    stPM_on *pPM_uv = new stPM_on(can_id);
    pPM_uv->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
    pPM_uv->frame.data[0] = 0x03;
    pPM_uv->frame.data[1] = 0x00;
    pPM_uv->frame.data[2] = 0x00;
    pPM_uv->frame.data[3] = 0x44;
    pPM_uv->frame.data[4] = 0x00;
    pPM_uv->frame.data[5] = 0x01;
    pPM_uv->frame.data[6] = 0x00;
    pPM_uv->frame.data[7] = 0x00;

    if (write(can_fd, &pPM_uv->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        //DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_uv)
        return false;
    }
    SAFE_DELETE(pPM_uv)

    stPM_on *pPM_ov = new stPM_on(can_id);
    pPM_ov->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
    pPM_ov->frame.data[0] = 0x03;
    pPM_ov->frame.data[1] = 0x00;
    pPM_ov->frame.data[2] = 0x00;
    pPM_ov->frame.data[3] = 0x44;
    pPM_ov->frame.data[4] = 0x00;
    pPM_ov->frame.data[5] = 0x01;
    pPM_ov->frame.data[6] = 0x00;
    pPM_ov->frame.data[7] = 0x00;

    if (write(can_fd, &pPM_ov->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        //DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_ov)
        return false;
    }
    SAFE_DELETE(pPM_ov)
    return true;
}
bool Dcmodule::PM_Status(unsigned long int can_id){

    stPM_Status *pPM_status = new stPM_Status(can_id);
    pPM_status->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
    if (write(can_fd, &pPM_status->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        //DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_status)
        return false;
    }
    SAFE_DELETE(pPM_status)   
    return true;
}
void Dcmodule::IO2_transmit(void)
{
    struct can_frame frame;
    frame.can_id  = 0x0A105696 | CAN_EFF_FLAG;
    frame.can_dlc = 8;
    frame.data[0] = 0xff;
    frame.data[1] = CAN_TX_2.Ac_main;
    frame.data[3] = C_OFF; //CAN_TX_2.Precharge;
    frame.data[2] = CAN_TX_2.Dc_main;

    if((CCS2.Error == NoError) /*||(CCS2.ALM_status == true)*/)
    {
        frame.data[4] = C_OFF;
    }
    else
    {
        frame.data[4] = C_ON;
        printf("ERROR+---%d\n ",CCS2.Error);
    }
    frame.data[5] = CAN_TX_2.Load_Sharing;
    frame.data[6] = CAN_TX_2.HardReset; // Hardreset C_ON
    frame.data[7] = 0xff;
  //   printf("Ls: %d\n ",CAN_TX_2.Load_Sharing);
    nbytes = write(can_fd, &frame, sizeof(frame));
    if (nbytes < 0) {
        perror("can raw socket write");
        return ;
    }
    return;
}
#ifdef TwoIn1IOCARD
void Dcmodule::IO_transmit(void)
{
    static unsigned int tRytostopAC = 0;
    struct can_frame frame;
    frame.can_id  = 0x0A105695 | CAN_EFF_FLAG;
    frame.can_dlc = 8;
    frame.data[0] = set_parameter.Temp_Min;
    frame.data[2] = CAN_TX.Dc_main;
    frame.data[3] = set_parameter.Temp_Max;
#ifdef ACMAINDISABLE
    if((CCS.Status == Preparing) || (CCS.Status == Charging) || (CCS2.Status == Preparing) || (CCS2.Status == Charging))
    {
        frame.data[1] = C_ON;
        tRytostopAC = 0;
    }
    else
    {
        if(++tRytostopAC > 120)
        {
            if(set_parameter.TestMode_ED == true)
            {
                 frame.data[1] = C_ON; // CAN_TX.Ac_main;
            }
            else
            {
              frame.data[1] = C_OFF; // CAN_TX.Ac_main;
               m_Error.mclearBit(I_O_WaitForACMains);
            }
            CCS.waitForBootRes = CCS2.waitForBootRes = 0x01;
            tRytostopAC = 120;
        }
    }
#else
   frame.data[1] = C_ON;
#endif
#if defined(ELCOP) || !defined(V1)

   if((CCS.Error == NoError) &&  CCS2.Error == NoError)
    {
        frame.data[4] = C_OFF;
     //   qDebug()<<"CCS.Error :" <<CCS.Error<<endl;
     //   qDebug()<<"CCS2.Error :" <<CCS2.Error<<endl;
    }
    else if(CCS.Error != NoError && CCS2.Error != NoError)
    {
        frame.data[4] = 0xFA;
 //     qDebug()<<"CCS.Error :" <<CCS.Error<<endl;
 //     qDebug()<<"CCS2.Error :" <<CCS2.Error<<endl;
    }
    else if(CCS.Error != NoError)
    {
        frame.data[4] = 0xA0;
        qDebug()<<"CCS.Error :" <<CCS.Error<<endl;

    }
    else if(CCS2.Error != NoError)
    {
        frame.data[4] = 0xB0;
        qDebug()<<"CCS2.Error :" <<CCS2.Error<<endl;
    }
#else
   if((CCS.Error != NoError) || CCS2.Error != NoError)
   {
       frame.data[4] = C_ON;
   }
   else
   {
       frame.data[4] = C_OFF;
   }
#endif

    frame.data[5] = (CCS.Status  > Available && CCS2.Status > Available) ? C_OFF : CAN_TX_2.Load_Sharing;
    //frame.data[5] = CAN_TX_2.Load_Sharing;
    frame.data[6] = CAN_TX.HardReset; // C_ON HardReset
    frame.data[7] = CAN_TX_2.Dc_main;

    // qDebug()<<"DC1 conn Status: "<< frame.data[2]<<endl;
    // qDebug()<<"DC2 conn Status: "<< frame.data[7]<<endl;

    nbytes = write(can_fd, &frame, sizeof(frame));
    if(nbytes < 0) {
        perror("can raw socket write");
        return;
    }
    return;
}
#else
void Dcmodule::IO_transmit(void)
{
    static unsigned int tRytostopAC = 0;
    frame.can_id  = 0x0A105695 | CAN_EFF_FLAG;
    frame.can_dlc = 8;
    frame.data[0] = set_parameter.Temp_Min;
    frame.data[2] = CAN_TX.Dc_main;
    frame.data[3] = set_parameter.Temp_Max;
    if((CCS.Status == Preparing) || (CCS.Status == Charging) || (CCS2.Status == Preparing) || (CCS2.Status == Charging))
    {
        frame.data[1] = C_ON;
        tRytostopAC = 0;
    }
    else
    {
        if(++tRytostopAC > 10)
        {
            if(set_parameter.TestMode_ED == true)
            {
                frame.data[1] = C_ON; // CAN_TX.Ac_main;
            }
            else
            {
                frame.data[1] = C_OFF; // CAN_TX.Ac_main;
            }
            CCS.waitForBootRes = CCS2.waitForBootRes = 0x01;
            tRytostopAC = 10;
        }
    }

    if((CCS.Error == NoError) )
    {
        frame.data[4] = C_OFF;
    }
    else
    {
        frame.data[4] = C_ON;
    }
    frame.data[5] = 0xff;
    frame.data[6] = CAN_TX.HardReset; // C_ON HardReset
    frame.data[7] =  (CAN_TX.Dc_main == C_ON) ? C_ON : ((CAN_TX_2.Dc_main == C_ON) ? C_ON : C_OFF);
    //qDebug()<<"DC Main Contactor Status: "<<CAN_TX.Dc_main<<endl;

    nbytes = write(can_fd, &frame, sizeof(frame));
    if(nbytes < 0) {
        perror("can raw socket write");
        return;
    }
    return;
}
#endif
bool Dcmodule::Off_Module(unsigned long int can_id){

   /*  if(getStatus(can_id) == false)
        return false; */
#ifdef WINLINE
    stPM_off *pPM_off = new stPM_off(can_id);
     pPM_off->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
    if (write(can_fd, &pPM_off->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
       // DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_off)
        return true;
    }        
    SAFE_DELETE(pPM_off)
    if(can_id == CANID_PM2)
    {
        CCS2.waitForBootRes = 1;
        CCS2.DcOutputModule_1 = 0;
       qDebug()<<"Power Module 2 off";
    }
    else if(can_id == CANID_PM1)
    {
        CCS.waitForBootRes = 1;
        CCS.DcOutputModule_1 = 0;
        qDebug()<<"Power Module 1 off";
    }
    return false;
#else
    stNPM_off *pPM_off = new stNPM_off(can_id);
     /*pPM_off->frame.can_id = (0x029A00F0 | CAN_EFF_FLAG);*/
     pPM_off->frame.can_id = can_id ==CANID_PM1 ? (0x029A00F0 | CAN_EFF_FLAG) :(0x029A01F0 | CAN_EFF_FLAG);
    if (write(can_fd, &pPM_off->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
       // DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_off)
        return true;
    }
    SAFE_DELETE(pPM_off)
#endif
}
int  Dcmodule::tempbind(unsigned char selectModule){
    int ret;
    char cmdline[128] = { '\0' };
    printf("Waiting for CAN-id_0\r\n");
    can_fd = socket(PF_CAN, SOCK_RAW, CAN_RAW); //SOCK_DGRAM  SOCK_RAW
    if (can_fd < 0) {
        perror("Socket");
        return 1;
    }
    strcpy(ifr.ifr_name, "can0" );
    ioctl(can_fd, SIOCGIFINDEX, &ifr);

    memset(&addr, 0, sizeof(addr));
    addr.can_family = AF_CAN;
    addr.can_ifindex = ifr.ifr_ifindex;

    if (bind(can_fd, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
        perror("Bind");
        return 1;
    }

    ret = can_setting(dev_name, can_baudrate, 1);
    if( ret < 0){
        printf("Set can device %s failed!\r\n",dev_name);
        exit(EXIT_FAILURE);
    }

    sprintf(cmdline,"ifconfig can0 txqueuelen %ld",100);
    system(cmdline);

    struct can_filter rfilter[4];

#ifdef WINLINE
        rfilter[0].can_id  =  0x060f8000;// 0x060F8411; // G1 // 0x1801A001
        rfilter[0].can_mask= CAN_EFF_MASK;

        rfilter[1].can_id  = 0x060f8008;// 0x060F8401; // G2
        rfilter[1].can_mask= CAN_EFF_MASK;
#else

        rfilter[0].can_id  = 0x0289F000;// ; // G2
        rfilter[0].can_mask= CAN_EFF_MASK;

        rfilter[1].can_id  = 0x029AF000;// ; // G2
        rfilter[1].can_mask= CAN_EFF_MASK;

        rfilter[2].can_id  = 0x0289F001;// ; // G2
        rfilter[2].can_mask= CAN_EFF_MASK;

        rfilter[3].can_id  = 0x029AF001;// ; // G2
        rfilter[3].can_mask= CAN_EFF_MASK;
#endif

        rfilter[4].can_id  =  0x0A100100;
        rfilter[4].can_mask= CAN_EFF_MASK;
    #ifdef TwoIn1IOCARD
        rfilter[5].can_id  =  0x0A100102;
        rfilter[5].can_mask= CAN_EFF_MASK;
    #else
        rfilter[3].can_id  =  0x0A100101;
        rfilter[3].can_mask= CAN_EFF_MASK;
    #endif
        setsockopt(can_fd, SOL_CAN_RAW, CAN_RAW_FILTER, &rfilter, sizeof(rfilter));
        return 0;
}
void Dcmodule::reset_can_interface(const char *iface) {

 //   struct ifreq ifr;
//    memset(&ifr, 0, sizeof(ifr));
//    strncpy(ifr.ifr_name, iface, sizeof(ifr.ifr_name) - 1);

//    // Set the interface down
//    ifr.ifr_flags &= ~IFF_UP;
//    if (ioctl(can_fd, SIOCSIFFLAGS, &ifr) < 0) {
//        perror("Failed to set interface down");
//        close(can_fd);
//    }


//    // Set the interface up
//    ifr.ifr_flags &= IFF_UP;
//    if (ioctl(can_fd, SIOCSIFFLAGS, &ifr) < 0) {
//        perror("Failed to set interface up");
//        close(can_fd);
//    }
//
    QProcess::startDetached("/bin/bash", QStringList() << "-c" <<QString("sudo ip link set can0 down"));
    QThread::msleep(1000);
    QProcess::startDetached("/bin/bash", QStringList() << "-c" <<QString("sudo ip link set can0 up"));
    tempbind(1);
}
void Dcmodule::rcvP12_v(unsigned long int can_id){

#ifdef WINLINE
    stPM_ReadVoltage *pPM_ReadVoltage = new stPM_ReadVoltage(can_id);
    pPM_ReadVoltage->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);

    if (write(can_fd, &pPM_ReadVoltage->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
      //  DebugString("G1 pPM_WriteVoltage Failed to Transmit");
       SAFE_DELETE(pPM_ReadVoltage)
        return ;
    }
    SAFE_DELETE(pPM_ReadVoltage)
    return;
#else
    stNPM_ReadVI *pPM_ReadVoltage = new stNPM_ReadVI(can_id);
    /*pPM_ReadVoltage->frame.can_id = (0x028900F0 | CAN_EFF_FLAG);*/
    pPM_ReadVoltage->frame.can_id = can_id == CANID_PM1 ? (0x028900F0 | CAN_EFF_FLAG) :(0x028901F0 | CAN_EFF_FLAG);

    if (write(can_fd, &pPM_ReadVoltage->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
      //  DebugString("G1 pPM_WriteVoltage Failed to Transmit");
       SAFE_DELETE(pPM_ReadVoltage)
        return ;
    }
    SAFE_DELETE(pPM_ReadVoltage)
    return;
#endif

}
void Dcmodule::rcvP12_i(unsigned long int can_id){

    stPM_ReadCurrent *pPM_ReadCurrent = new stPM_ReadCurrent(can_id);
    pPM_ReadCurrent->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
    if (write(can_fd, &pPM_ReadCurrent->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
      //  DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_ReadCurrent)
        return ;
    }
    SAFE_DELETE(pPM_ReadCurrent)
    return;
}
int Dcmodule::powerdc(unsigned long int can_id ,float voltage,float current){
#ifdef WINLINE

        stPM_WriteVoltage *pPM_WriteVoltage = new stPM_WriteVoltage(can_id,voltage);
        pPM_WriteVoltage->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
        if (write(can_fd, &pPM_WriteVoltage->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
         //   DebugString("G1 pPM_WriteVoltage Failed to Transmit");
            SAFE_DELETE(pPM_WriteVoltage)
            return false;
        }
        SAFE_DELETE(pPM_WriteVoltage)

        stPM_WriteCurrent *pPM_WriteCurrent = new stPM_WriteCurrent(can_id,current);
        pPM_WriteCurrent->frame.can_id = ((getStatus(can_id)) | CAN_EFF_FLAG);
        if(write(can_fd, &pPM_WriteCurrent->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        //    DebugString("G1 pPM_WriteVoltage Failed to Transmit");
            SAFE_DELETE(pPM_WriteCurrent)
            return false;
        }
        SAFE_DELETE(pPM_WriteCurrent)
#else

    stNPM_WriteVI *pPM_WriteVoltage = new stNPM_WriteVI(1,(quint32)(voltage*1000),(quint32)(current*1000));
    pPM_WriteVoltage->frame.can_id = can_id ==CANID_PM1 ? (0x029C00F0 | CAN_EFF_FLAG) :(0x029C01F0 | CAN_EFF_FLAG);
    if (write(can_fd, &pPM_WriteVoltage->frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
     //   DebugString("G1 pPM_WriteVoltage Failed to Transmit");
        SAFE_DELETE(pPM_WriteVoltage)
        return false;
    }
    SAFE_DELETE(pPM_WriteVoltage)

#endif

    return 0;
}
void Dcmodule::rcvS12(unsigned char phase){

    /*frame.can_id  =  0x06080f80| CAN_EFF_FLAG; //for extended id, have to masking with "CAN_EFF_FLAG" //0x060C1781
    frame.can_dlc = 8;
    for (int i = 0; i < frame.can_dlc; i++)
    {
        if(phase == 1)
        {
            frame.data[i]=read_Status_A[i];
        }
        else if(phase == 2)
        {
            frame.data[i]=read_Status_B[i];
        }
        else if(phase == 3)
        {
            frame.data[i]=read_Status_C[i];
        }
    }
    if (write(can_fd, &frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
        printf(" can voltage write frame error module 1");
        return ;
    }*/
#ifdef SIXTEE
     frame.can_id  =  0x06080780 | CAN_EFF_FLAG; //for extended id, have to masking with "CAN_EFF_FLAG" //0x060C0781
     frame.can_dlc = 8;
     for (i = 0; i < frame.can_dlc; i++)
     {
         frame.data[i]=read_Status[i];
     }

     if (write(can2_fd, &frame, sizeof(struct can_frame)) != sizeof(struct can_frame)) {
         printf(" can voltage write frame error module 2");
         return ;
     }
#endif
     return;
}
void Dcmodule::can_module_run(void)
{  
    int num_16_high,num_16_low;
    long int num;
    quint8 IO_card_error=0,try_Next_2 = 0,try_Next = 0;
    quint8  Vx1 = 0;
    qint16 Electricl_Isolation_2,Electricl_Isolation;
    ptr_rf = new RFID(this);
    char frame_232[100];
    static QByteArray rcvData;
    QByteArray databuf;
    int size = 0;
    int call_io = 0;
    int rfidfd = -1;
    int ret = -1;
#ifdef LUBIRFID
     rfidfd =   ptr_rf->OpenSerialPort();
      qDebug() << "can thread" << QThread::currentThreadId();
#else
     rfidfd =   ptr_rf->keypad_init("/dev/input/event4");
#endif
     if(rfidfd ==  -1)
     {
       CCS.SCAN_TAGID = -1;
     }
    while (1) {        
        if(++call_io > 40)
        {
            if(++IO_card_error > 5)
            {
                if(IO_card_error == 6)
                {
                    CCS.CanCommStatus = false;                   
#ifdef TwoIn1IOCARD
                    IO_card_error = 3;
#else
                    IO_card_error = 6;
#endif
                }
            }
            else
            {
#ifdef TwoIn1IOCARD
                IO_transmit(); // test
#else
                IO2_transmit();
                IO_transmit();
#endif                
            }
            call_io = 0;
            EventChecked();

            if(++CCS2.TimeOut > 16)
            {
                CCS2.CanCommStatus = false;
               // qDebug()<<"CAN2 ERROR"<<endl;
                CCS2.TimeOut = 5;
            }
            if(++CCS.TimeOut > 32)
            {
                CAN_RX.rfid_fail = true;
              //  qDebug()<<"rfid_fail"<<endl;
                CCS.TimeOut = 32;
            }
            else
            {
                CAN_RX.rfid_fail = false;
            }
       }
        ret =  (can_fd == -1) ?  -1: tty_read_ready(can_fd);
        if(ret == 1)
        {           
            nbytes = read(can_fd, &frame, sizeof(struct can_frame));           
            if (nbytes < 0) {
                qDebug()<<"CAN 0 down"<<endl;
                perror("CAN 0 Read");
            }
#ifdef WINLINE
            else if(frame.can_id == 0x860f8000)
            {
                num_16_high =(frame.data[4]<<8)|(frame.data[5]);
                num_16_low =(frame.data[6]<<8)|(frame.data[7]);

                num = 0;                
                num = (num_16_high << 16)|(num_16_low);
                if(frame.data[3] == 0x01)
                {
                    CCS2.DcOutputModule_1= *((float*)&num);
                    if(CCS2.DcOutputModule_1 < 0)
                    {
                        CCS2.DcOutputModule_1 = -CCS2.DcOutputModule_1;
                    }                    
                }
                else if(frame.data[3] == 0x02)
                {
                    CCS2.DC_Current_1 = *((float*)&num);
                    if(CCS2.DC_Current_1 < 0)
                    {
                        CCS2.DC_Current_1 = -CCS2.DC_Current_1;
                    }
#ifdef PLC_DEBUG
                    qDebug()<<"Revieve Current Gun2 PM1 : "<< CCS2.DcOutputModule_1 <<endl;
#endif
                }
                else if(frame.data[3] == 0x30) // power module boot response
                {
                    if((frame.data[1] == 0xf0) && (frame.data[5] == 0))
                    {
                        //CCS2.waitForBootRes = 1;
                    //    qDebug()<<"G2 Boot res OK"<<endl;
                    }
                }
                else if(frame.data[3] == 0x40) //  status bit
                {
                    if(frame.data[1] == 0xf0)
                    {
                        CCS2.waitForBootRes = ((frame.data[5] >> 6) & 1); //  22 bit

                        num_16_high =(frame.data[4]<<8)|(frame.data[5]);
                        num_16_low =(frame.data[6]<<8)|(frame.data[7]);

                        quint32 PM_ALARM = (num_16_high << 16)|(num_16_low);
                        qDebug()<<"G2 Status OK" << PM_ALARM<<endl;

                        if(((PM_ALARM >> 0) & 1) == 1)
                        {
                            // Module Fault
                            ChargerUI_Info_2.ui_Charger_ErrorCode = H012;
                        }
                        if(((PM_ALARM >> 3) & 1) == 1)
                        {
                            // Module internal SCI communication failure
                        }
                        if(((PM_ALARM >> 7) & 1) == 1)
                        {
                            // DCDC overvoltage
                        }
                        if(((PM_ALARM >> 8) & 1) == 1)
                        {
                            // PFC voltage abnormal(imbalance, overvoltage or undervoltage)
                            ChargerUI_Info_2.ui_Charger_ErrorCode = H011;
                        }
                        if(((PM_ALARM >> 9) & 1) == 1)
                        {
                            // 9 AC overvoltage
                            ChargerUI_Info_2.ui_Charger_ErrorCode = V004;
                        }
                        if(((PM_ALARM >> 14) & 1) == 1)
                        {
                            //14 AC undervoltage
                            // ChargerUI_Info_2.ui_Charger_ErrorCode = V005;
                        }
                        if(((PM_ALARM >> 16) & 1) == 1)
                        {
                            // 16 CAN communication failure
                        }

                        if(((PM_ALARM >> 24) & 1) == 1)
                        {
                            // 24 Temperature derating
                            m_Error.msetBit(PM2_Derating);
                        }
                        else
                        {
                            m_Error.mclearBit(PM2_Derating);
                        }

                        if(((PM_ALARM >> 27) & 1) == 1)
                        {
                            // 27 Fan fault
                            ChargerUI_Info_2.ui_Charger_ErrorCode = H013;
                        }
                        if(((PM_ALARM >> 30) & 1) == 1)
                        {
                            // 30 DCDC over temperature                            
                        }
                        if(((PM_ALARM >> 31) & 1) == 1)
                        {
                              // 31 DCDC output overvoltage
                              // ChargerUI_Info_2.ui_Charger_ErrorCode = V006;
                        }
                    }
                }
            }
            else if(frame.can_id == 0x860F8008)
            {
                num = 0;
                num_16_high =(frame.data[4]<<8)|(frame.data[5]);
                num_16_low =(frame.data[6]<<8)|(frame.data[7]);
                num = (num_16_high << 16)|(num_16_low);

                if(frame.data[3] == 0x01)
                {
                    CCS.DcOutputModule_1 = *((float*)&num);
                    if( CCS.DcOutputModule_1 < 0)
                    {
                         CCS.DcOutputModule_1 = -CCS.DcOutputModule_1;
                    }
#ifdef PLC_DEBUG
                    qDebug()<<"Revieve Voltage Gun1 PM1 : "<<  CCS.DcOutputModule_1<<endl;
#endif
                }
                else if(frame.data[3] == 0x02)
                {
                    CCS.DC_Current_1 = *((float*)&num);
                    if(CCS.DC_Current_1  < 0)
                    {
                        CCS.DC_Current_1  = -CCS.DC_Current_1;
                    }                  
                }
                else if(frame.data[3] == 0x0c)
                {                    
                    CCS.voltage_L1 = *((float*)&num);
                    qDebug()<< "Phase A: "<< CCS.voltage_L1<<endl;
                }
                else if(frame.data[3] == 0x30) // power module boot response
                {
                    if((frame.data[1] == 0xf0) && (frame.data[5] == 0))
                    {
                        //CCS.waitForBootRes = 1;
                        qDebug()<<"G1 Boot res OK"<<endl;
                    }
                }
                else if(frame.data[3] == 0x40) //  status bit
                {
                    if(frame.data[1] == 0xf0)
                    {
                        CCS.waitForBootRes = ((frame.data[5] >> 6) & 1); //  22 bit
                        qDebug()<<"G1 Status OK" << CCS.waitForBootRes<<endl;
                    }                     
                    num_16_high =(frame.data[4]<<8)|(frame.data[5]);
                    num_16_low =(frame.data[6]<<8)|(frame.data[7]);
                    quint32 PM_ALARM = (num_16_high << 16)|(num_16_low);                    
                    qDebug()<<"G1 Status OK" << PM_ALARM<<endl;

                    if(((PM_ALARM >> 0) & 1) == 1)
                    {
                        // Module Fault
                         ChargerUI_Info.ui_Charger_ErrorCode = H012;
                    }
                    if(((PM_ALARM >> 3) & 1) == 1)
                    {
                        // Module internal SCI communication failure
                    }
                    if(((PM_ALARM >> 7) & 1) == 1)
                    {
                        // DCDC overvoltage
                    }
                    if(((PM_ALARM >> 8) & 1) == 1)
                    {
                        // PFC voltage abnormal(imbalance, overvoltage or undervoltage)
                        ChargerUI_Info.ui_Charger_ErrorCode = H011;
                    }
                    if(((PM_ALARM >> 9) & 1) == 1)
                    {
                        // 9 AC overvoltage
                        ChargerUI_Info.ui_Charger_ErrorCode = V004;
                    }
                    if(((PM_ALARM >> 14) & 1) == 1)
                    {
                        //14 AC undervoltage
                        //  ChargerUI_Info.ui_Charger_ErrorCode = V005;
                    }
                    if(((PM_ALARM >> 16) & 1) == 1)
                    {
                        // 16 CAN communication failure
                    }
                    if(((PM_ALARM >> 24) & 1) == 1)
                    {
                        // 24 Temperature derating
                        m_Error.msetBit(PM_Derating);
                    }
                    else
                    {
                        m_Error.mclearBit(PM_Derating);
                    }
                    if(((PM_ALARM >> 27) & 1) == 1)
                    {
                        // 27 Fan fault
                        ChargerUI_Info.ui_Charger_ErrorCode = H013;
                    }
                    if(((PM_ALARM >> 30) & 1) == 1)
                    {
                        // 30 DCDC over temperature
                        //   ChargerUI_Info.ui_Charger_ErrorCode = H012;
                    }
                    if(((PM_ALARM >> 31) & 1) == 1)
                    {
                        // 31 DCDC output overvoltage
                        // ChargerUI_Info.ui_Charger_ErrorCode = V006;
                    }
                }
            }
#else
            else if(frame.can_id == 0x8289F000 || frame.can_id == 0x8289F001)   // reply: 02 89 F0 00
            {
                uint32_t value =  (frame.data[4] << 24) |
                                  (frame.data[5] << 16) |
                                  (frame.data[6] << 8)  |
                                   frame.data[7];

                if(frame.data[3] == 0xF0)   // reply indicator
                {
                    // Voltage = mV
                    CCS.DcOutputModule_1 = value / 1000.0f; // to volts
                    CCS2.DcOutputModule_1 = value / 1000.0f; // to volts

                    // Current = mA (next 4 bytes)
                    uint32_t current =  (frame.data[8] << 24) |
                                        (frame.data[9] << 16) |
                                        (frame.data[10] << 8) |
                                         frame.data[11];

                    CCS.DC_Current_1 = current / 1000.0f; // to amps
                    CCS2.DC_Current_1 = current / 1000.0f; // to amps
                }
            }
#endif
#ifdef TwoIn1IOCARD
            else if(frame.can_id == 0x8A100102)
            {
              IO_card_error = 0;
              CCS.CanCommStatus = true;
#ifdef LUBIIMD
            CCS.Vbus = (set_parameter.IsolationFault_ED == true) ? ((frame.data[0] << 8) | (frame.data[1])) : CCS.DC_Voltage_1; // change
            CCS2.Vbus = (set_parameter.IsolationFault_ED == true) ? ((frame.data[4] << 8) | (frame.data[5])) : CCS2.DC_Voltage_1; // change
//          qDebug()<<"G1 Vbus: "<<CCS.Vbus<<endl;
//          qDebug()<<"G2 Vbus: "<<CCS2.Vbus<<endl;
#else
            CAN_RX.Status_Imd = frame.data[0];
            CAN_RX.Error_Imd = frame.data[1];
#endif               
              Electricl_Isolation = (set_parameter.IsolationFault_ED == true) ? ((frame.data[3] << 8) | (frame.data[2])) : 1000; // change             
              if(Electricl_Isolation <= 100)
              {
                  if(++try_Next > 10)
                  {
                      try_Next = 2;
                      CAN_RX.Electricl_Isolation = Electricl_Isolation;
                  }
              }
              else
              {
                  try_Next = 0;
                  CAN_RX.Electricl_Isolation = Electricl_Isolation;
              }            

              Electricl_Isolation_2 = (set_parameter.IsolationFault_ED == true) ? ((frame.data[7] << 8) | (frame.data[6])) : 1000; // change
              // qDebug()<<"G2 Electricl_Isolation" << QString::number(Electricl_Isolation_2)<<endl;
              if(Electricl_Isolation_2 <= 100)
              {
                  if(++try_Next_2 > 10)
                  {
                      try_Next_2 = 2;
                      CAN_RX_2.Electricl_Isolation = Electricl_Isolation_2;
                  }
              }
              else
              {
                  try_Next_2 = 0;
                  CAN_RX_2.Electricl_Isolation = Electricl_Isolation_2;
              }
          }
            else if(frame.can_id == 0x8A100100)
            {
             // qDebug()<<"0x8A100100" <<endl;
                CCS.CanCommStatus = true;
                if(CCS2.Reson == PowerLoss)
                {
                    CCS2.CanCommStatus = true;
                    CCS2.TimeOut = 0;
                }
                IO_card_error =0;
                CAN_RX.Em_switch = ((frame.data[0]) & 01);
                CAN_RX.Dlk1_sensor = set_parameter.DoorlOCK_ED == true ? ((frame.data[0] >> 1) & 1) : false;
               // CAN_RX.IMD_Err = set_parameter.IsolationFault_ED == true ? ((frame.data[0] >> 2) & 01) : false;
#ifdef RESETKEYENABLE
                if(CAN_RX.Reset_Key == false)
                {
                    CAN_RX.Reset_Key = ((frame.data[0] >> 3) & 1);
                }
#else
                CAN_RX.Reset_Key = false;
#endif
#ifdef LUBIIMD
//                if((gFault == true) && (((frame.data[0] >> 5) & 01) == true))
//                {
//                    CAN_RX.Ground_Fault =  set_parameter.GroundFault_ED == true ?  ((frame.data[0] >> 5) & 01) : false; //0 -good 1- broken
//                }
//                else
//                {
//                  gFault = ((frame.data[0] >> 5) & 01);
//                }
                CAN_RX.Ground_Fault =  set_parameter.GroundFault_ED == true ?  ((frame.data[0] >> 5) & 01) : false; //0 -good 1- broken
#endif
                if(Vx1 == ((frame.data[0] >> 4) & 01))
                {
                    CAN_RX.AC_Main_Contactor_res = ((frame.data[0] >> 4) & 01);
                }
                Vx1 = ((frame.data[0] >> 4) & 01);                
#ifndef DUALRCD
                if((CAN_RX.RCD_Detect == true) && ((frame.data[0] >> 6) & 01) == false)
                {
                    send_signal(O_Available);
                    send_signal(O2_Available);
                    CCS.Reson =   CCS2.Reson= Other;
                    CCS.Error = CCS2.Error= NoError;
                }
#else
                if((CAN_RX.RCD_Detect == true) && ((frame.data[0] >> 6) & 01) == false)
                {
                    send_signal(O_Available);
                    CCS.Reson = Other;
                    CCS.Error = NoError;
                }
#endif
                CAN_RX.RCD_Detect = ((frame.data[0] >> 6) & 01);
#ifdef SPDFEEDBACK
                CAN_RX.SPD_Detect = ((frame.data[0] >> 7) & 01);
#endif
                CCS.Tempreture_exhaust = frame.data[1];
                CCS.Tempreture_dcP = frame.data[2];
                CCS.Tempreture_dcN = frame.data[3];
                CCS2.Tempreture_dcP = frame.data[4];
                CCS2.Tempreture_dcN = frame.data[5];
#ifdef TATAPOWER
                CCS.Tempreture_inlet = frame.data[7];
#else
                CCS.Tempreture_inlet = 111;
#endif
#ifndef DUALRCD
                CAN_RX_2.RCD_Detect = false;
#else

                if((CAN_RX_2.RCD_Detect == true) && ((frame.data[6] >> 0) & 01) == false)
                {
                    send_signal(O2_Available);
                    CCS2.Reson= Other;
                    CCS2.Error= NoError;
                }
                CAN_RX_2.RCD_Detect =  ((frame.data[6] >> 0) & 1);
#endif
                CAN_RX.DC_LoadSharing_Plus_Contactor_res =  ((frame.data[6] >> 1) & 1);
                CAN_RX.DC_LoadSharing_Minus_Contactor_res =  ((frame.data[6] >> 2) & 1);

                CCS.DC_Gun_Plus_Contactor_res =  ((frame.data[6] >> 3) & 1);
                CCS.DC_Gun_Minus_Contactor_res =  ((frame.data[6] >> 4) & 1);

                CCS2.DC_Gun_Plus_Contactor_res =  ((frame.data[6] >> 5) & 1);
                CCS2.DC_Gun_Minus_Contactor_res =  ((frame.data[6] >> 6) & 1);
#ifdef SMOKEDETECTOR
                CAN_RX.smokeDetector =  ((frame.data[6] >> 7) & 1);
#else
                CAN_RX.smokeDetector = false;
#endif
            }
#else
            else if(frame.can_id == 0x8A100100)
            {
                IO_card_error = 0;
                CCS.CanCommStatus = true;
#ifdef PLC_DEBUG
                qDebug()<<"Revieve Byte PM : "<< nbytes<<endl;
                qDebug()<<"Revieve Byte FROM io card 1 : "<< nbytes<<endl;
#endif
                CAN_RX.Status_Imd = frame.data[0];
             //   bool Max_Bettery_voltage = ((CAN_RX.Status_Imd >> 3) & 01);
                CAN_RX.Error_Imd = frame.data[1];
                // CAN_RX.Ground_Fault =  set_parameter.GroundFault_ED == true ?  ((CAN_RX.Error_Imd >> 5) & 01) : false; //0 -good 1- broken
                CAN_RX.Ground_Fault =  set_parameter.GroundFault_ED == true ?  ((CAN_RX.Status_Imd >> 5) & 01) : false; //0 -good 1- broken

                //  CAN_RX.Electricl_Isolation =set_parameter.IsolationFault_ED == true ? ((frame.data[3] << 8) | (frame.data[2])) : 1000; // change
                Electricl_Isolation = (set_parameter.IsolationFault_ED == true) ? ((frame.data[3] << 8) | (frame.data[2])) : 1000; // change

                if(Electricl_Isolation <= 100)
                {
                    if(++try_Next > 10)
                    {
                        try_Next = 2;
                        CAN_RX.Electricl_Isolation = Electricl_Isolation;
                    }
                }
                else
                {
                    try_Next = 0;
                    CAN_RX.Electricl_Isolation = Electricl_Isolation;
                }
                CAN_RX.Em_switch = ((frame.data[4] >> 0) & 1);
                CAN_RX.Dlk1_sensor = set_parameter.DoorlOCK_ED == true ? ((frame.data[4] >> 1) & 1) : false;
                if(CAN_RX.Reset_Key == false)
                {
                    CAN_RX.Reset_Key = ((frame.data[4] >> 3) & 1);
                }
                //CAN_RX.Smoke_detector = ((frame.data[4] >> 4) & 01);
                CAN_RX.AC_Main_Contactor_res = ((frame.data[4] >> 4) & 01);
                if((CAN_RX.RCD_Detect == true) && ((frame.data[4] >> 6) & 01) == false)
                {
                    send_signal(O_Available);
                    CCS.Reson = Other;
                    CCS.Error = NoError;
                }
                CAN_RX.RCD_Detect = ((frame.data[4] >> 6) & 01);
                CCS.Tempreture_exhaust = frame.data[5];
                CCS.Tempreture_dcP = frame.data[6];
                CCS.Tempreture_dcN = frame.data[7];
            }
            else if(frame.can_id == 0x8A100101)
            {
                CCS.CanCommStatus = true;
                // qDebug()<<"IO_2 Recieved"<<endl;
                CAN_RX.Status_Imd = frame.data[0];
                // Max_Bettery_voltage = ((CAN_RX.Status_Imd >> 3) & 01);
                //Isolation_Status = ((CAN_RX.Status_Imd >> 1) & 01) | ((CAN_RX.Status_Imd >> 0) & 01);
                CAN_RX_2.Error_Imd = frame.data[1];
                CAN_RX_2.Ground_Fault =  set_parameter.GroundFault_ED == true ?  ((CAN_RX_2 .Error_Imd >> 5) & 01) : false; //0 -good 1- broken

                if((CAN_RX_2.RCD_Detect == true) && ((frame.data[4] >> 6) & 01) == true)
                {
                    send_signal(O2_Available);
                    CCS2.Reson = Other;
                    CCS2.Error = NoError;
                }
                CAN_RX_2.RCD_Detect = ((frame.data[4] >> 6) & 01) ? 0 : 1 ;

                Vx1 = ((CAN_RX_2.Error_Imd >> 6) & 01); // 0 - good 1 - Broken
                //Vx2 = ((CAN_RX_2.Error_Imd >> 7) & 01); // 0 - good 1 - Broken

                Electricl_Isolation_2 = (set_parameter.IsolationFault_ED == true) ? ((frame.data[3] << 8) | (frame.data[2])) : 1000; // change

                // DebugString("G2 Electricl_Isolation"+ QString::number(Electricl_Isolation_2));
             //    qDebug()<<"G2 Electricl_Isolation" << QString::number(Electricl_Isolation_2)<<endl;

                if(Electricl_Isolation_2 <= 100)
                {
                    if(++try_Next_2 > 10)
                    {
                        try_Next_2 = 0;
                        CAN_RX_2.Electricl_Isolation = Electricl_Isolation_2;
                    }
                }
                else
                {
                    try_Next_2 = 0;
                    CAN_RX_2.Electricl_Isolation = Electricl_Isolation_2;
                }
                CCS2.Tempreture_exhaust = frame.data[5];
                CCS2.Tempreture_dcP = frame.data[6];
                CCS2.Tempreture_dcN = frame.data[7];
            }
#endif
#ifdef TONHE
            else if(frame.can_id == 0x9801A001) // Tonhe
            {
                if(frame.data[0] == 0x01)
                {
                    CCS.waitForBootRes = 0; //
                    qDebug()<<"G1 Status OK" << CCS.waitForBootRes<<endl;
                }
                else if(frame.data[0] == 0x00)
                {
                    CCS.waitForBootRes = 1; //
                    qDebug()<<"G1 Status OK" << CCS.waitForBootRes<<endl;
                }
                else if(frame.data[0] == 0x11)
                {
                    CCS.waitForBootRes = 0x11; //
                    qDebug()<<"G1 Status OK" << CCS.waitForBootRes<<endl;
                }
            }
            else if(frame.can_id == 0x9801A002)  // tonhe
            {
                if(frame.data[0] == 0x01)
                {
                    CCS2.waitForBootRes = 0; //
                    qDebug()<<"G2 Status OK" << CCS2.waitForBootRes<<endl;
                }
                else if(frame.data[0] == 0x00)
                {
                    CCS2.waitForBootRes = 1; //
                    qDebug()<<"G2 Status OK" << CCS2.waitForBootRes<<endl;
                }
                else if(frame.data[0] == 0x11)
                {
                    CCS2.waitForBootRes = 0x11; //
                    qDebug()<<"G2 Status OK" << CCS2.waitForBootRes<<endl;
                }
            }
#endif
        }
        if(rfidfd > 0)
        {
#ifdef LUBIRFID
            if(tty_read_ready(rfidfd) == 1)
            {
                int bytes = tty_read(rfidfd, frame_232);
                if(bytes < 0)
                {
                    continue;
                }
                // qDebug()<<"LUBI RFID recieve byte " << bytes<<endl;
                databuf = QByteArray(reinterpret_cast<char*>(frame_232), bytes);
                rcvData.append(databuf);
                // qDebug()<<"LUBI RFID" << databuf<<endl;
#ifdef V1
                if(rcvData.size() > 8)
                {
                    size = rcvData.size();
                    if(size > 8 && rcvData.at(0) == 0x5A && rcvData.at(1) == 0xA5)
                    {
                        convertHexToAscii(rcvData.mid(4,8));
                        rcvData.remove(0, 12);
                    }
                    else if(size > 8)
                    {
                        rcvData.clear();
                    }
                }
#else
                if(rcvData.size() > 5)
                {
                    size = rcvData.size();
                    if(rcvData.at(0) == 0x5A && rcvData.at(1) == 0xA5 && rcvData.at(2) == 0x03)
                    {
                        CCS.TimeOut = 0;
                        rcvData.remove(0, 6);
                       //  qDebug()<<"RFID Heartbeat "<<endl;
                    }
                    else if(size > 5 && rcvData.at(0) == 0x5A && rcvData.at(1) == 0xA5)
                    {
                        convertHexToAscii(rcvData.mid(4,8));
                        rcvData.remove(0, 12);
                    }
                    else if(size > 5)
                    {
                        rcvData.clear();
                    }
                }
#endif
            }
#else
            if(rfid_read_ready(rfidfd) == 1)
            {
                if(ptr_rf->readrfid_COM(rfidfd,gstOcppKey.isBigEnidian) ==  -1)
                {
                    CCS.SCAN_TAGID = -1;
                    rfidfd = -1;
                }
            }
#endif
        }

        QThread::msleep(50);
    }
}
void Dcmodule::AC_ContactorStatus(quint8 status)
{
    if(m_ACstatus == status)
    {
        return;
    }

    m_ACstatus = status;
    if(status == 1)
    {
        CCS.waitForBootRes = CCS2.waitForBootRes = 0x01;
    }
    qDebug()<<"AC_Contactor_status changed Recieved"<<status<<endl;
}
#ifdef LUBIRFID
QString Dcmodule::convertHexToAscii(QByteArray hex)
{
   CCS.RfidTagId = QString::fromUtf8(hex);
   qDebug()<<"LUBI RFID" << CCS.RfidTagId<<endl;
   if(CCS.RfidTagId.length() != 8)
   {
       return NULL;
   }
   if(gstOcppKey.isBigEnidian == 1)
   {
        std::reverse(CCS.RfidTagId.begin(), CCS.RfidTagId.end());
        QString Temp = CCS.RfidTagId;
        CCS.RfidTagId.clear();

        CCS.RfidTagId[0] = Temp[1];
        CCS.RfidTagId[1] = Temp[0];

        CCS.RfidTagId[2] = Temp[3];
        CCS.RfidTagId[3] = Temp[2];

        CCS.RfidTagId[4] = Temp[5];
        CCS.RfidTagId[5] = Temp[4];

        CCS.RfidTagId[6] = Temp[7];
        CCS.RfidTagId[7] = Temp[6];
   }
   CCS.SCAN_TAGID = 2;
   return CCS.RfidTagId;
}
#endif
void Dcmodule::EventChecked(void)
{
    static quint8 FailCount =0,comm_count=0,uv_count = 0,ov_count = 0;    
    if((CCS.ModbusCommStatus == false) && (CCS.CanCommStatus == false) /*&& CCS2.ModbusCommStatus == false */&& CCS2.CanCommStatus == false)
    {        
        CCS.Error = CCS2.Error = PowerSwitchFailure;
        CCS.Reson = CCS2.Reson = PowerLoss;
        CAN_RX.PowerLoss = 1;
        CAN_RX.AC_Main_Contactor_res = true;
        CAN_TX.Dc_main = CAN_TX_2.Dc_main = C_OFF;
        CAN_TX.Ac_main = 0;
        m_Error.msetBit(M_PowerSwitchFailure);
        CCS.voltage_L1 = CCS.voltage_L2 = CCS.voltage_L3= 0;
        CCS.current_L1 = CCS.current_L2 = CCS.current_L3 = 0;
        m_Error.mclearBit(M_MeterFailure);
        m_Error.mclearBit(M2_MeterFailure);
        m_Error.mclearBit(CAN2_Communication_Error);
        m_Error.mclearBit(CAN_Communication_Error);
        comm_count = 0;
    }
    else if((++comm_count > 22) && (CCS.ModbusCommStatus == false /*||  CCS2.ModbusCommStatus == false*/ || CCS.CanCommStatus == false || CCS2.CanCommStatus == false /*|| CAN_RX.IMD_Err == true*/))
    {
        comm_count = 22;
        if((CCS.ModbusCommStatus == false || CCS2.ModbusCommStatus == false))
        {
            CCS.Error = CCS2.Error= PowerMeterFailure;
            CAN_TX.Dc_main = CAN_TX_2.Dc_main = C_OFF;
          //  qDebug()<<"Charging stop by PowerMeterFailure";
            CCS2.Reson =  CCS.Reson = Local;
            CAN_RX.PowerLoss = 0;
            if(CCS.ModbusCommStatus == false )
            {
                m_Error.msetBit(M_MeterFailure);
            }
            else
            {
                m_Error.mclearBit(M_MeterFailure);
            }

            if(CCS2.ModbusCommStatus == false )
            {
                m_Error.msetBit(M2_MeterFailure);
            }
            else
            {
                m_Error.mclearBit(M2_MeterFailure);
            }
        }
        m_Error.mclearBit(M_PowerSwitchFailure);
        CAN_RX.PoweMeterFailure = 1;
        if(CCS.CanCommStatus == false || CCS2.CanCommStatus == false)
        {
            if(CCS.CanCommStatus == false)
            {
                m_Error.msetBit(CAN_Communication_Error);
            }
            else
            {
                m_Error.mclearBit(CAN_Communication_Error);
            }
            if(CCS2.CanCommStatus == false)
            {
                m_Error.msetBit(CAN2_Communication_Error);
            }
            else
            {
                m_Error.mclearBit(CAN2_Communication_Error);
            }
        }
    }
    else if(CCS.ModbusCommStatus == true/* &&  CCS2.ModbusCommStatus == true*/ && CCS.CanCommStatus == true && CCS2.CanCommStatus == true)
    {
        if(CAN_RX.PowerLoss == 1)
        {
            comm_count = 0;
            CAN_RX.Reset_Key = 1;
            CAN_RX.PowerLoss = 0;
            reset_can_interface("can0");
        }       
        m_Error.mclearBit(M_MeterFailure);
        m_Error.mclearBit(M_PowerSwitchFailure);
        m_Error.mclearBit(M2_MeterFailure);
        m_Error.mclearBit(CAN2_Communication_Error);
        m_Error.mclearBit(CAN_Communication_Error);        
        CAN_RX.PowerLoss = CAN_RX.PoweMeterFailure = 0;
        comm_count = 0;
    }

    if(CAN_RX.PowerLoss != 1)
    {
        if(CAN_RX.RCD_Detect == 1)
        {
            printf("RCD detect...\r\n");
#ifndef DUALRCD
             CCS.Error = CCS2.Error=  OtherError;
             CCS.Reson = CCS2.Reson = Other;
             m_Error.msetBit(I_O_RCDdetect);
#else
            CCS.Error =  OtherError;
            CCS.Reson =  Other;
            m_Error.msetBit(I_O_RCDdetect);
#endif
        }
        else
        {
            m_Error.mclearBit(I_O_RCDdetect);
        }
        if(CAN_RX_2.RCD_Detect == 1)
        {
            printf("G2 RCD detect...\r\n");
            CCS2.Error = OtherError;
            CCS2.Reson = Other;
            m_Error.msetBit(I2_O_RCDdetect);
        }
        else
        {
            m_Error.mclearBit(I2_O_RCDdetect);
        }
        if(CAN_RX.Em_switch == 1)
        {
            printf("press emergency switch\r\n");
            CCS2.Error = CCS.Error = OtherError;
            CCS2.Reson = CCS.Reson = EmergencyStop;
            m_Error.msetBit(I_O_EMPress);
        }
        else
        {
            m_Error.mclearBit(I_O_EMPress);
        }

        if(CAN_RX.Reset_Key == 1 )
        {
           CCS2.Error =  CCS.Error = OtherError;
           CCS2.Reson = CCS.Reson = HardReset;
           m_Error.msetBit(I_O_ResetKey);
        }
        else
        {
           m_Error.mclearBit(I_O_ResetKey);
        }
#ifdef GFD

        if(CAN_RX.Ground_Fault == 1)
        {
            CCS.Reson = CCS2.Reson =  Local;
            CCS.Error = CCS2.Error = GroundFailure;
            m_Error.msetBit(I_O_GNDFalut);
        }
        else
        {
            m_Error.mclearBit(I_O_GNDFalut);
        }
#endif
        if(CAN_RX.IMD_Err == true)
        {
             m_Error.msetBit(C_ImdFault);
        }
        else
        {
             m_Error.mclearBit(C_ImdFault);
        }
#ifndef V1
        if(CAN_RX.rfid_fail == true)
        {
            m_Error.msetBit(C_RfidFault);
        }
        else
        {
            m_Error.mclearBit(C_RfidFault);
        }
#ifdef TEMPSENSORENABLE

         if(CCS.Tempreture_dcP > 93 || CCS.Tempreture_dcN > 93)
         {
             // temperatur sensor broken
             m_Error.msetBit(GUN1_Temp_broken);
         }
         else
         {
             m_Error.mclearBit(GUN1_Temp_broken);
         }
#endif
#endif
#ifndef V1
#ifdef TEMPSENSORENABLE
         if(CCS2.Tempreture_dcP > 93 || CCS2.Tempreture_dcN > 93)
         {
             // temperatur sensor broken
             m_Error.msetBit(GUN2_Temp_broken);
         }
         else
         {
             m_Error.mclearBit(GUN2_Temp_broken);
         }
#endif
         if(CCS.Tempreture_exhaust > 93)
         {
             // temperatur sensor broken
             m_Error.msetBit(Exhust_Temp_broken);
         }
         else
         {
             m_Error.mclearBit(Exhust_Temp_broken);
         }
#ifdef TATAPOWER
         if(CCS.Tempreture_inlet > 93)
         {
             // temperatur sensor broken
             m_Error.msetBit(Inlet_Temp_broken);
         }
         else
         {
             m_Error.mclearBit(Inlet_Temp_broken);
         }
#endif
#endif
        if(CCS.voltage_L1 > set_parameter.Over_Voltage || CCS.voltage_L2 > set_parameter.Over_Voltage || CCS.voltage_L3 > set_parameter.Over_Voltage)
        {
           printf("Over Voltage L1 : %f - L2 : %f - L3 : %f \r\n",CCS.voltage_L1 ,CCS.voltage_L2,CCS.voltage_L3);
           ov_count++;
        }
        else
        {
            CAN_RX.Over_Voltage = 0;
            ov_count= 0;
            m_Error.mclearBit(M_Over_Voltage);
        }

        if(ov_count > 4)
        {
            ov_count = 4;
            CCS2.Error =  CCS.Error = OverVoltage;
            CCS2.Reson =  CCS.Reson = Local;
            CAN_RX.Over_Voltage = 1;
            m_Error.msetBit(M_Over_Voltage);
        }
       /* if(CCS.voltage_L1 < (float)set_parameter.Under_Voltage && (float)CCS.voltage_L2 < set_parameter.Under_Voltage && (float)CCS.voltage_L3 < set_parameter.Under_Voltage)
        {
           printf("Under Voltage L1 : %f - L2 : %f - L3 : %f \r\n",CCS.voltage_L1 ,CCS.voltage_L2,CCS.voltage_L3);
           uv_count++;
        }
        else
        {
            uv_count = 0;
            CAN_RX.Under_Voltage = 0;
            m_Error.mclearBit(M_Under_Voltage);
        }
        if(uv_count > 20)
        {
             CAN_RX.Under_Voltage = 1;
             m_Error.msetBit(M_Under_Voltage);
             CCS2.Error = CCS.Error = UnderVoltage;
             CCS2.Reson = CCS.Reson = Local;
            uv_count = 20;
        }
        */

        if(CCS.current_L1 > set_parameter.Over_Current_ccs || CCS.current_L2 > set_parameter.Over_Current_ccs || CCS.current_L3 > set_parameter.Over_Current_ccs)
        {
            if(CCS2.Status == Charging || CCS.Status == Charging)
            {
                CCS2.Error = CCS.Error = OverCurrentFailure;
                m_Error.msetBit(M_Over_Current);
                CAN_RX.Over_Current = 1;
            }
            else
            {
                CCS.current_L1 = CCS.current_L2 = CCS.current_L3 = 0;
            }
        }
        else
        {
            CAN_RX.Over_Current = 0;
            m_Error.mclearBit(M_Over_Current);
        }

        if(CAN_RX.Dlk1_sensor == true)
        {
           CCS2.Error = CCS.Error = OtherError;
           CCS2.Reson = CCS.Reson = Local;
           m_Error.msetBit(I_O_DoorLock);
        }
        else
        {
            m_Error.mclearBit(I_O_DoorLock);
        }
#ifdef ACMAINDISABLE
        if(((CAN_TX.Dc_main == C_ON) || (CAN_TX_2.Dc_main == C_ON)) && (CAN_RX.AC_Main_Contactor_res == false))
        {            
            if(++FailCount > 10)
            {
                CAN_TX.Dc_main = CAN_TX_2.Dc_main = C_OFF;
               // qDebug()<<"G1 off FailCount"<<endl;
                m_Error.msetBit(I_O_WaitForACMains);
                CAN_RX.ACMaincontactorFail = true;
                FailCount = 0;
            }
        }
        else
        {
            CAN_RX.ACMaincontactorFail = false;
            FailCount = 0;
        }
#endif
        AC_ContactorStatus(CAN_RX.AC_Main_Contactor_res);
        if(CAN_RX.SPD_Detect == 1)
        {
            CCS2.Error = CCS.Error = OtherError;
            CCS2.Reson = CCS.Reson = Local;
            m_Error.msetBit(SPD_DETECT);
        }
        else
        {
            m_Error.mclearBit(SPD_DETECT);
        }
        if(CAN_RX.smokeDetector == 1)
        {
            CCS2.Error = CCS.Error = OtherError;
            CCS2.Reson = CCS.Reson = Local;
            m_Error.msetBit(smokeDetector);
        }
        else
        {
            m_Error.mclearBit(smokeDetector);
        }       
    }
}
QString Dcmodule::ConvertMacroTostring(quint16  data)
{
    switch(data)
    {
    case C001 : {

    }break;
    case C002 :{
        return "C002";
    } break;
    case C003 :{
        return "C003";
    } break;
    case C004 :{
        return "C004";
    } break;
    case C005 :{
        return "C005";
    } break;
    case C006 :{
        return "C006";
    } break;
    case C007 :{
        return "C007";
    } break;
    case C008 :{
        return "C008";
    } break;
    case C009 :{
        return "C009";
    } break;
    case C010 :{
        return "C010";
    } break;
    case C011 :{
        return "C011";
    } break;
    case C012 :{
        return "C012";
    } break;
    case C013 :{
        return "C013";
    } break;
    case C014 :{
        return "C014";
    } break;
    case C015 :{
        return "C015";
    } break;
    case C016 :{
        return "C016";
    } break;
    case C017 :{
        return "C017";
    } break;
    case C018 :{
        return "C018";
    } break;
    case C019 :{
        return "C019";
    } break;
    case C020 :{
        return "C020";
    } break;
    case C021 :{
        return "C021";
    } break;
    case C022 :{
        return "C022";
    } break;
    case C023 :{
        return "C023";
    } break;
    case C024 :{
        return "C024";
    } break;
    case C025 :{
        return "C025";
    } break;
    case C026 :{
        return "C026";        
    } break;
    case C027 :{
        return "C027";
    } break;
    case C028 :{
        return "C028";
    } break;
    case C029 :{
        return "C029";
    } break;
    case C030 :{
        return "C030";
    } break;
    case C031 :{
        return "C031";
    } break;
    case C032 :{
        return "C032";
    } break;
    case C033 :{
        return "C033";
    } break;
    case C034 :{
        return "C034";
    } break;
    case C035 :{
        return "C035";
    } break;
    case C036 :{
        return "C036";
    } break;
    case C037 :{
        return "C037";
    } break;
    case C038 :{
        return "C038";
    } break;
    case C039 :{
        return "C039";
    } break;
    case E001 :{
        return "E001";
    } break;
    case E002 :{
        return "E002";
    } break;
    case E003 :{
        return "E003";
    } break;
    case E004 :{
        return "E004";
    } break;
    case E005 :{
        return "E005";
    } break;
    case E006 :{
        return "E006";
    } break;
    case E007 :{
        return "E007";
    } break;
    case E008 :{
        return "E008";
    } break;
    case E009 :{
        return "E009";
    } break;
    case E010 :{
        return "E010";
    } break;
    case E011 :{
        return "E011";
    } break;
    case E012 :{
        return "E012";
    } break;
    case E013 :{
        return "E013";
    } break;
    case E014 :{
        return "E014";
    } break;
    case E015 :{
        return "E015";
    } break;
    case E016 :{
        return "E016";
    } break;
    case E017 :{
        return "E017";
    } break;
    case E018 :{
        return "E018";
    } break;
    case E019 :{
        return "E019";
    } break;
    case E020 :{
        return "E020";
    } break;
    case E021 :{
        return "E021";
    } break;
    case E022 :{
        return "E022";
    } break;
    case E023 :{
        return "E023";
    } break;
    case E024 :{
        return "E024";
    } break;
    case E025 :{
        return "E025";
    } break;
    case E026 :{
        return "E026";
    } break;
    case E027 :{
        return "E027";
    } break;
    case E028 :{
        return "E028";
    } break;
    case E029 :{
        return "E029";
    } break;
    case E030 :{
        return "E030";
    } break;
    case E031 :{
        return "E031";
    } break;
    case E032 :{
        return "E032";
    } break;
    case E033 :{
        return "E033";
    } break;
    case E034 :{
        return "E034";
    } break;
    case E035 :{
        return "E035";
    } break;
    case E036 :{
        return "E036";
    } break;
    case E037 :{
        return "E037";
    } break;
    case E038 :{
        return "E038";
    } break;
    case E039 :{
        return "E039";
    } break;
    case E040 :{
        return "E040";
    } break;
    case F001 :{
        return "F001";
    } break;
    case F002 :{
        return "F002";
    } break;
    case G001 :{
        return "G001";
    } break;
    case G002 :{
        return "G002";
    } break;
    case H001 :{
        return "H001";
    } break;
    case H002 :{
        return "H002";
    } break;
    case H003 :{
        return "H003";
    } break;
    case H004 :{
        return "H004";
    } break;
    case H005 :{
        return "H005";
    } break;
    case H006 :{
        return "H006";
    } break;
    case H007 :{
        return "H007";
    } break;
    case H008 :{
        return "H008";
    } break;
    case H009 :{
        return "H009";
    } break;
    case H010 :{
        return "H010";
    } break;
    case H011 :{
        return "H011";
    } break;
    case H012 :{
        return "H012";
    } break;
    case H013 :{
        return "H013";
    } break;
    case H014 :{
        return "H014";
    } break;
    case H015 :{
        return "H015";
    } break;
    case H016 :{
        return "H016";
    } break;
    case H017 :{
        return "H017";
    } break;
    case H018 :{
        return "H018";
    } break;
    case H019 :{
        return "H019";
    } break;
    case H020 :{
        return "H020";
    } break;
    case H021 :{
        return "H021";
    } break;
    case H022 :{
        return "H022";
    } break;
    case H023 :{
        return "H023";
    } break;
    case H024 :{
        return "H024";
    } break;
    case H025 :{
        return "H025";
    } break;
    case P001 :{
        return "P001";
    } break;
    case P002 :{
        return "P002";
    } break;   
    case S001 :{
        return "S001";
    } break;
    case S002 :{
        return "S002";
    } break;
    case V001 :{
        return "V001";
    } break;
    case V002 :{
        return "V002";
    } break;
    case V003 :{
        return "V003";
    } break;
    case V004 :{
        return "V004";
    } break;
    case V005 :{
        return "V005";
    } break;
    case V006 :{
        return "V006";
    } break;    
    case E041 :{
        return "E041";
    } break;
    case E042 :{
        return "E042";
    } break;
    case E043 :{
        return "E043";
    } break;
    case E044 :{
        return "E044";
    } break;
    case E045 :{
        return "E045";
    } break;
    case E046 :{
        return "E046";
    } break;
    case E047 :{
        return "E047";
    } break;
    case E048 :{
        return "E048";
    } break;
    case E049 :{
        return "E049";
    } break;
    case E050 :{
        return "E050";
    } break;
    case E051 :{
        return "E051";
    } break;
    case E052 :{
        return "E052";
    } break;
    case E053 :{
        return "E053";
    } break;
    case E054 :{
        return "E054";
    } break;
    case E055 :{
        return "E055";
    } break;
    case E056 :{
        return "E056";
    } break;
    case E057 :{
        return "E057";
    } break;
    case E058 :{
        return "E058";
    } break;
    case E059 :{
        return "E059";
    } break;
    case E060 :{
        return "E060";
    } break;
    case E061 :{
        return "E061";
    } break;
    case E062 :{
        return "E062";
    } break;
    case E063 :{
        return "E063";
    } break;
    case U001 : {
        return "U001";
    } break;
    case U002 : {
        return "U002";
    } break;
    case U003 : {
        return "U003";}
    break;
    case U004 : {
        return "U004";
    } break;
    case U005 : {
        return "U005";
    } break;
    case U006 : {
        return "U006";
    } break;
    case U007 : {
        return "U007";
    } break;
    case U008 : {
        return "U008";
    } break;
    case I000 : {
        return "I000";
    } break;    
    default:
    {
        return "0000";
    }
    }
}
