// can_decoder.c
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <linux/can.h>
#include <linux/can/raw.h>
#include <stdint.h>

void decode_iso17017_25(uint32_t can_id, uint8_t *data, uint8_t len) {
    printf("Decoding CAN ID: 0x%08X | Data: ", can_id);
    for (int i = 0; i < len; i++) {
        printf("%02X ", data[i]);
    }

    // Example decoder logic based on ID
        if (can_id == 0x500) {
        printf("-> TYPE: Boot or Status Frame\n");
    } else if (can_id == 0x501) {
        printf("-> TYPE: Status Update Frame\n");
    } else if (can_id == 0x582) {
        printf("-> TYPE: Heartbeat from Subsystem A\n");
    } else if (can_id == 0x583) {
        printf("-> TYPE: Heartbeat from Subsystem B\n");
    } else if (can_id == 0x120 || can_id == 0x121) {
        printf("-> TYPE: NMT Command or Node State\n");
    } else if (can_id == 0x00B) {
        printf("-> TYPE: Emergency Frame\n");
    } else if (can_id == 0x040) {
        printf("-> TYPE: Sync Frame\n");
    } else if (can_id == 0x080) {
        printf("-> TYPE: Time Sync Frame\n");
    } else if (can_id == 0x081) {
        printf("-> TYPE: Status Response Frame\n");
    } else if (can_id == 0x213) {
        printf("-> TYPE: Diagnostic or Command Frame\n");
    } else if (can_id == 0x10A080AA) {
        printf("-> TYPE: Extended Frame (e.g., Firmware/Diagnostic)\n");
    } else {
        printf("-> TYPE: Unknown (custom or unsupported ID)\n");
    }

}

int main() {
    int s;
    struct sockaddr_can addr;
    struct ifreq ifr;
    struct can_frame frame;

    const char *can_iface = "vcan0"; // Or "can0" if using real CAN hardware
    if ((s = socket(PF_CAN, SOCK_RAW, CAN_RAW)) < 0) {
        perror("Socket");
        return 1;
    }

    strcpy(ifr.ifr_name, can_iface);
    ioctl(s, SIOCGIFINDEX, &ifr);

    addr.can_family = AF_CAN;
    addr.can_ifindex = ifr.ifr_ifindex;

    if (bind(s, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
        perror("Bind");
        return 1;
    }

    printf("Listening on %s...\n", can_iface);

    while (1) {
        int nbytes = read(s, &frame, sizeof(struct can_frame));
        if (nbytes > 0) {
            decode_iso17017_25(frame.can_id, frame.data, frame.can_dlc);
        }
    }

    close(s);
    return 0;
}
