Step-by-Step: Writing and Running the C CAN Decoder
🧰 Prerequisites:
Make sure you have:

GCC (C compiler): Install with: sudo apt install build-essential

CAN utilities: Install with: sudo apt install can-utils

----------------------------------------------------------

Compile the Program
In the terminal (inside the same folder), compile it:

==========================================================

Setup Virtual CAN Interface (for testing)
If you don't have a CAN adapter connected, you can simulate CAN with a virtual CAN interface:

sudo modprobe vcan
sudo ip link add dev vcan0 type vcan
sudo ip link set up vcan0

==============================================================


Run the CAN Decoder
Start the decoder:

./can_decoder

It will say:
Listening on vcan0...


Now, open another terminal window and send a test CAN frame:

cansend vcan0 500#0020000000000000


You should see decoded output in the decoder window:

Decoding CAN ID: 0x00000500 | Data: 00 20 00 00 00 00 00 00 -> Frame Type: ISO_FRAME_A (0x500), Value: 8192

