/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    stm32f4xx_it.c
  * @brief   Interrupt Service Routines.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32f4xx_it.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "can_comm.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
//extern char pwm_start_stop; //unused variable

//Input read

 uint8_t Emergency_stop_count = 0, Emergency_start_count = 0;
 uint8_t doorlock1_stop_count = 0, doorlock1_start_count = 0;
 uint8_t doorlock2_stop_count = 0, doorlock2_start_count = 0;
 uint8_t resetkey_stop_count = 0, resetkey_start_count = 0;
 uint16_t smokedect_stop_count = 0, smokedect_start_count = 0;
 uint8_t loadshare_stop_count = 0, loadshare_start_count = 0;

 uint8_t loadshare_stop_count_2 = 0, loadshare_start_count_2 = 0;

 uint8_t fin1_stop_count = 0, fin1_start_count = 0;
 uint8_t fin2_stop_count = 0, fin2_start_count = 0;
 uint8_t fin3_stop_count = 0, fin3_start_count = 0;
 uint8_t fin4_stop_count = 0, fin4_start_count = 0;

 uint8_t Emergency_stop = 0;
 uint8_t doorlock1_stop = 0, doorlock2_stop = 0, resetkey_stop = 0, smokedect_stop = 0;
 uint8_t loadshare_stop = 0;
 uint8_t loadshare_stop_2 = 0;

 uint8_t fin1_stop = 0;
 uint8_t fin2_stop = 0;
 uint8_t fin3_stop = 0;
 uint8_t fin4_stop = 0;


 uint8_t SWstatus 	= 0;
 uint8_t SWstatus_2 = 0;	//Added for RCD1 feedback status
extern unsigned char ImdRx[12];
extern uint8_t M_buff;

//output read(contactor sts)

volatile uint8_t ACMain_stop_count = 0, ACMain_start_count = 0;
volatile uint8_t DCMain_stop_count = 0, DCMain_start_count = 0;
volatile uint8_t PRECharge_start_count_1 = 0, PRECharge_stop_count_2, PRECharge_start_count_2 = 0, PRECharge_stop_count_1 = 0;
volatile uint8_t AC02_stop_count = 0, AC02_start_count = 0;
volatile uint8_t SPD_detect = 0, SPD_start_count = 0, SPD_stop_count = 0;

volatile uint8_t ACMAIN_stop = 0, DCMAIN_stop = 0;
uint8_t RCD1_detect = 0, RCD2_detect = 0;

volatile uint8_t starttimeouttick = 0, timeoutflag = 0;
volatile uint8_t GFD_start_count = 0, GFD_stop_count = 0, GndFaultDetected = 0;

extern struct chargersts chrgsts;
extern uint8_t redsts, bluests, greensts, redsts1, bluests1, greensts1, change;

extern volatile int imd1_timeouttick, imd1_errorFlag; 	// -imd2_timeouttick, imd2_errorFlag;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/
extern DMA_HandleTypeDef hdma_adc2;
extern ADC_HandleTypeDef hadc2;
extern CAN_HandleTypeDef hcan1;
extern CAN_HandleTypeDef hcan2;
extern TIM_HandleTypeDef htim2;
extern TIM_HandleTypeDef htim3;
extern TIM_HandleTypeDef htim4;
extern TIM_HandleTypeDef htim5;
extern DMA_HandleTypeDef hdma_usart1_rx;
extern DMA_HandleTypeDef hdma_usart1_tx;
extern UART_HandleTypeDef huart1;
/* USER CODE BEGIN EV */

/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M4 Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
  * @brief This function handles Non maskable interrupt.
  */
void NMI_Handler(void)
{
  /* USER CODE BEGIN NonMaskableInt_IRQn 0 */

  /* USER CODE END NonMaskableInt_IRQn 0 */
  /* USER CODE BEGIN NonMaskableInt_IRQn 1 */
  while (1)
  {
  }
  /* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
  /* USER CODE BEGIN HardFault_IRQn 0 */

  /* USER CODE END HardFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_HardFault_IRQn 0 */
    /* USER CODE END W1_HardFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Memory management fault.
  */
void MemManage_Handler(void)
{
  /* USER CODE BEGIN MemoryManagement_IRQn 0 */

  /* USER CODE END MemoryManagement_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_MemoryManagement_IRQn 0 */
    /* USER CODE END W1_MemoryManagement_IRQn 0 */
  }
}

/**
  * @brief This function handles Pre-fetch fault, memory access fault.
  */
void BusFault_Handler(void)
{
  /* USER CODE BEGIN BusFault_IRQn 0 */

  /* USER CODE END BusFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_BusFault_IRQn 0 */
    /* USER CODE END W1_BusFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Undefined instruction or illegal state.
  */
void UsageFault_Handler(void)
{
  /* USER CODE BEGIN UsageFault_IRQn 0 */

  /* USER CODE END UsageFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_UsageFault_IRQn 0 */
    /* USER CODE END W1_UsageFault_IRQn 0 */
  }
}

/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{
  /* USER CODE BEGIN SVCall_IRQn 0 */

  /* USER CODE END SVCall_IRQn 0 */
  /* USER CODE BEGIN SVCall_IRQn 1 */

  /* USER CODE END SVCall_IRQn 1 */
}

/**
  * @brief This function handles Debug monitor.
  */
void DebugMon_Handler(void)
{
  /* USER CODE BEGIN DebugMonitor_IRQn 0 */

  /* USER CODE END DebugMonitor_IRQn 0 */
  /* USER CODE BEGIN DebugMonitor_IRQn 1 */

  /* USER CODE END DebugMonitor_IRQn 1 */
}

/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{
  /* USER CODE BEGIN PendSV_IRQn 0 */

  /* USER CODE END PendSV_IRQn 0 */
  /* USER CODE BEGIN PendSV_IRQn 1 */

  /* USER CODE END PendSV_IRQn 1 */
}

/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
  /* USER CODE BEGIN SysTick_IRQn 0 */

#if target == gun1
	if(!USER_IN3_READ)
	{
		Emergency_stop_count++;
		if(Emergency_stop_count >= 50)
		{
			Emergency_stop = 1;
			chrgsts.empress = 1;
			SWstatus |= 0x01;

			G_LED_OFF;	//GREEN
			starttimeouttick = 30;
			AC_MAIN_OFF;		//AC main supply off

			Emergency_stop_count = 0;
		}
	}
	else
	{
		if(++Emergency_start_count > 50)
		{
			if(Emergency_stop == 1)
			{
				chrgsts.empress = 0;
				starttimeouttick = 30;
			}
			SWstatus &= 0xFE;
			Emergency_start_count = 0;
			Emergency_stop_count = 0;
			Emergency_stop = 0;
		}
	}

	if(USER_IN2_READ)
	{
		doorlock1_stop_count++;
		if(doorlock1_stop_count >= 50)
		{
			doorlock1_stop = 1;
			chrgsts.doorlock = 1;
			SWstatus |= 0x02;
			doorlock1_stop_count = 0;
		}
	}
	else
	{
		if(++doorlock1_start_count > 50)
		{
			SWstatus &= 0xFD;
			chrgsts.doorlock = 0;
			doorlock1_start_count = 0;
			doorlock1_stop_count = 0;
			doorlock1_stop = 0;
		}
	}
#ifdef GROUND_FAULT
	if(USER_IN4_READ)	//Ground Fault Detection
	{
		GFD_stop_count++;
		if(GFD_stop_count >= 50)
		{
			SWstatus |= 0x20;
			GFD_stop_count = 0;
			GndFaultDetected = 1;
		}
	}
	else
	{
		if(++GFD_start_count > 50)
		{
			GFD_start_count = 0;
			SWstatus &= 0xDF;
			GFD_stop_count = 0;
			GndFaultDetected = 0;
		}
	}
#endif
	/////////contactor switching///////////////
	if(USER_IN5_READ)
	{
		ACMain_stop_count++;
		if(ACMain_stop_count >= 50)
		{
			ACMAIN_stop = 1;
			SWstatus |= 0x10;
			ACMain_stop_count = 0;
		}
	}
	else
	{
		if(++ACMain_start_count > 50)
		{
			ACMain_start_count = 0;
			SWstatus &= 0xEF;
			ACMain_stop_count = 0;
			ACMAIN_stop = 0;
		}
	}

	if(!USER_IN6_READ)							//Reset key
	{
		resetkey_stop_count++;
		if(resetkey_stop_count >= 50)
		{
			resetkey_stop = 1;
			chrgsts.resetactive = 1;
			SWstatus |= 0x40;
			resetkey_stop_count = 0;
		}
	}
	else
	{
		if(++resetkey_start_count > 50)
		{
			SWstatus &= 0xBF;
			chrgsts.resetactive = 0;
			resetkey_start_count = 0;
			resetkey_stop_count = 0;
			resetkey_stop = 0;
		}
	}


	if(USER_IN1_READ)							//RCD2  FEEDBACK
	{
		PRECharge_stop_count_1++;
		if(PRECharge_stop_count_1 >= 50)
		{
			RCD2_detect = 1;
			SWstatus_2 |= 0x01;
			PRECharge_stop_count_1 = 0;
		}
	}
	else
	{
		if(++PRECharge_start_count_1 > 50)
		{
			PRECharge_start_count_1 = 0;
			SWstatus_2 &= 0xFE;
			PRECharge_stop_count_1 = 0;
			RCD2_detect = 0;
		}
	}

	//Gun1 feedback
	if(!USER_IN8_READ)
	{
		loadshare_stop_count++;
		if (loadshare_stop_count >= 50)
		{
			loadshare_stop = 1;
			SWstatus_2 |= 0x02;
			loadshare_stop_count = 0;
		}
	}
	else
	{
		if(++loadshare_stop_count > 50)
		{
			loadshare_stop_count = 0;
			SWstatus_2 &= 0xFD;
			loadshare_stop_count = 0;
			loadshare_stop = 0;
		}
	}
#ifdef SMOKE_DETECTOR
	//Smoke detector
	if(!USER_IN9_READ)
	{
		smokedect_stop_count++;
		if(smokedect_stop_count>=500)
		{
			smokedect_stop = 1;
			SWstatus_2 |= 0x80;
			smokedect_stop_count = 0;
		}
	}
	else
	{
		if(++smokedect_start_count > 5)
		{
			smokedect_start_count = 0;
			SWstatus_2 &= 0x7F;
			smokedect_stop_count = 0;
			smokedect_stop = 0;
		}
	}
#endif
	//SPD feedback
	if(!USER_IN7_READ)
	{
		if(++SPD_stop_count >= 50)
		{
			SPD_stop_count = 0;
			SWstatus |= 0x80;
			SPD_detect = 1;
		}
	}
	else
	{
		if(++SPD_start_count > 50)
		{
			SPD_start_count = 0;
			SPD_stop_count = 0;
			SWstatus &= 0x7F;
			SPD_detect = 0;
		}
	}

	//GUN1 Positive connector feedback
#ifdef EXTENSION
	if(FIN1_READ)
	{
		fin1_stop_count++;
		if(fin1_stop_count>=50)
		{
			fin1_stop = 1;
			SWstatus_2 |= 0x08;
			fin1_stop_count = 0;
		}
	}
	else
	{
		if(++fin1_stop_count > 50)
		{
			fin1_stop_count = 0;
			SWstatus_2 &= 0xF7;
			fin1_stop_count = 0;
			fin1_stop = 0;
		}
	}

	//GUN1 Negative connector feedback
	if(FIN2_READ)
	{
		fin2_stop_count++;
		if(fin2_stop_count>=50)
		{
			fin2_stop = 1;
			SWstatus_2 |= 0x10;
			fin2_stop_count = 0;
		}
	}
	else
	{
		if(++fin2_stop_count > 50)
		{
			fin2_stop_count = 0;
			SWstatus_2 &= 0xEF;
			fin2_stop_count = 0;
			fin2_stop = 0;
		}
	}

	//GUN2 Positive connector feedback
	if(FIN3_READ)
	{
		fin3_stop_count++;
		if(fin3_stop_count>=50)
		{
			fin3_stop = 1;
			SWstatus_2 |= 0x20;
			fin3_stop_count = 0;
		}
	}
	else
	{
		if(++fin3_stop_count > 50)
		{
			fin3_stop_count = 0;
			SWstatus_2 &= 0xDF;
			fin3_stop_count = 0;
			fin3_stop = 0;
		}
	}

	//GUN2 Negative connector feedback
	if(FIN4_READ)
	{
		fin4_stop_count++;
		if(fin4_stop_count>=50)
		{
			fin4_stop = 1;
			SWstatus_2 |= 0x40;
			fin4_stop_count = 0;
		}
	}
	else
	{
		if(++fin4_stop_count > 50)
		{
			fin4_stop_count = 0;
			SWstatus_2 &= 0xBF;
			fin4_stop_count = 0;
			fin4_stop = 0;
		}
	}
#endif

	//COMMENT LATER //ONLY FOR ARAI PANEL
//	SWstatus &= 0xBF;	//FOR ARAI PANEL
	//for Lubi IMD
	if(imd1_errorFlag == 1)
	{
		SWstatus |= 0x04;
	}
	else
	{
		SWstatus &= 0xFB;
	}




#elif target == gun2

	SWstatus &= 0xFE;
	SWstatus &= 0xFD;
	SWstatus &= 0xF7;
	SWstatus &= 0xEF;
	SWstatus &= 0x7F;
	chrgsts.doorlock =0;
	chrgsts.resetactive =0;
	chrgsts.empress =0;
	if(!USER_IN2_READ)	// load sharing contactor + feedback
	{
		doorlock2_stop_count++;
		if(doorlock2_stop_count>=50)
		{
			doorlock2_stop = 1;
			SWstatus |= 0x04;
			doorlock2_stop_count = 0;
		}
	}
	else
	{
		if(++doorlock2_start_count > 50)
		{
			SWstatus &= 0xFB;
			doorlock2_start_count =0;
			doorlock2_stop_count=0;

		}
	}
	if(!USER_IN6_READ)							// load sharing contactor - feedback
	{
	PRECharge_stop_count++;
		if(PRECharge_stop_count>=50)
		{
			RCD1_detect = 1;
			SWstatus |= 0x40;
			PRECharge_stop_count = 0;
		}
	}
	else
	{
		if(++PRECharge_start_count > 50)
		{
			PRECharge_start_count =0;
			SWstatus &= 0xBF;
			PRECharge_stop_count=0;
		}
	}
#endif


	if ((chrgsts.empress == 1)
			|| (chrgsts.G1_fault == 1)
			|| (SPD_detect == 1)
			|| (chrgsts.resetactive == 1)
#ifndef DUALRCD
			|| (RCD1_detect == 1)
#endif
#ifdef SMOKE_DETECTOR
			|| (smokedect_stop == 1)
#endif
			)
	{
		redsts = redsts1 = 1;
		change = 1;
		bluests = greensts =  bluests1 = greensts1 = 0;
	}
	else
	{
#ifdef dualgun
		if(RCD1_detect || chrgsts.G1_fault)
		{
			redsts = 1;
			redsts1 = 0;
			bluests = greensts = 0;
			change = 1;
		}
		else
#endif
		{
#ifndef dualgun
			redsts = redsts1 = 0;
#else
			redsts = 0;
#endif
			if(chrgsts.charging_G1 == 1)
			{
				if(greensts == 0)
				{
					greensts = 1;
					change = 1;
				}
				bluests = 0;
			}
			else
			{
				if(bluests == 0)
				{
					bluests = 1;
					change = 1;
				}
				greensts = 0;
			}
		}
#ifdef dualgun
		if(RCD2_detect || chrgsts.G2_fault)
		{
			redsts1 = 1;
			redsts = 0;
			bluests1 = greensts1 = 0;
			change = 1;
		}
		else
		{
			redsts1 = 0;
			if(chrgsts.charging_G2 == 1)
			{
				if(greensts1 == 0)
				{
					greensts1 = 1;
					change = 1;
				}
				bluests1 = 0;
			}
			else
			{
				if(bluests1 == 0)
				{
					bluests1 = 1;
					change = 1;
				}
				greensts1 = 0;
			}
		}
#endif
	}

	//////////////////////////////////////
	can2TX_msg_2[can2TX_SWstatus] = SWstatus;

	//RCD1, load sharing positive, load sharing negative status bit
	can2TX_msg_2[can2TX_SWstatus_2] = SWstatus_2;

	/* USER CODE END SysTick_IRQn 0 */
	HAL_IncTick();
	/* USER CODE BEGIN SysTick_IRQn 1 */

	/* USER CODE END SysTick_IRQn 1 */
}

/******************************************************************************/
/* STM32F4xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32f4xx.s).                    */
/******************************************************************************/

/**
  * @brief This function handles ADC1, ADC2 and ADC3 global interrupts.
  */
void ADC_IRQHandler(void)
{
  /* USER CODE BEGIN ADC_IRQn 0 */

  /* USER CODE END ADC_IRQn 0 */
  HAL_ADC_IRQHandler(&hadc2);
  /* USER CODE BEGIN ADC_IRQn 1 */

  /* USER CODE END ADC_IRQn 1 */
}

/**
  * @brief This function handles CAN1 TX interrupts.
  */
void CAN1_TX_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_TX_IRQn 0 */

  /* USER CODE END CAN1_TX_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_TX_IRQn 1 */

  /* USER CODE END CAN1_TX_IRQn 1 */
}

/**
  * @brief This function handles CAN1 RX0 interrupts.
  */
void CAN1_RX0_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_RX0_IRQn 0 */

  /* USER CODE END CAN1_RX0_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_RX0_IRQn 1 */

  /* USER CODE END CAN1_RX0_IRQn 1 */
}

/**
  * @brief This function handles CAN1 RX1 interrupt.
  */
void CAN1_RX1_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_RX1_IRQn 0 */

  /* USER CODE END CAN1_RX1_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_RX1_IRQn 1 */

  /* USER CODE END CAN1_RX1_IRQn 1 */
}

/**
  * @brief This function handles CAN1 SCE interrupt.
  */
void CAN1_SCE_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_SCE_IRQn 0 */

  /* USER CODE END CAN1_SCE_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_SCE_IRQn 1 */

  /* USER CODE END CAN1_SCE_IRQn 1 */
}

/**
  * @brief This function handles TIM2 global interrupt.
  */
void TIM2_IRQHandler(void)
{
  /* USER CODE BEGIN TIM2_IRQn 0 */

  /* USER CODE END TIM2_IRQn 0 */
  HAL_TIM_IRQHandler(&htim2);
  /* USER CODE BEGIN TIM2_IRQn 1 */

  /* USER CODE END TIM2_IRQn 1 */
}

/**
  * @brief This function handles TIM3 global interrupt.
  */
void TIM3_IRQHandler(void)
{
  /* USER CODE BEGIN TIM3_IRQn 0 */

  /* USER CODE END TIM3_IRQn 0 */
  HAL_TIM_IRQHandler(&htim3);
  /* USER CODE BEGIN TIM3_IRQn 1 */

  /* USER CODE END TIM3_IRQn 1 */
}

/**
  * @brief This function handles TIM4 global interrupt.
  */
void TIM4_IRQHandler(void)
{
  /* USER CODE BEGIN TIM4_IRQn 0 */

  /* USER CODE END TIM4_IRQn 0 */
  HAL_TIM_IRQHandler(&htim4);
  /* USER CODE BEGIN TIM4_IRQn 1 */

  /* USER CODE END TIM4_IRQn 1 */
}

/**
  * @brief This function handles USART1 global interrupt.
  */
void USART1_IRQHandler(void)
{
  /* USER CODE BEGIN USART1_IRQn 0 */
	__HAL_UART_FLUSH_DRREGISTER(&huart1);
	HAL_UART_Receive_DMA(&huart1, (uint8_t*) &M_buff, 1);
  /* USER CODE END USART1_IRQn 0 */
  HAL_UART_IRQHandler(&huart1);
  /* USER CODE BEGIN USART1_IRQn 1 */

  /* USER CODE END USART1_IRQn 1 */
}

/**
  * @brief This function handles TIM5 global interrupt.
  */
void TIM5_IRQHandler(void)
{
  /* USER CODE BEGIN TIM5_IRQn 0 */

  /* USER CODE END TIM5_IRQn 0 */
  HAL_TIM_IRQHandler(&htim5);
  /* USER CODE BEGIN TIM5_IRQn 1 */

  /* USER CODE END TIM5_IRQn 1 */
}

/**
  * @brief This function handles DMA2 stream2 global interrupt.
  */
void DMA2_Stream2_IRQHandler(void)
{
  /* USER CODE BEGIN DMA2_Stream2_IRQn 0 */

  /* USER CODE END DMA2_Stream2_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_usart1_rx);
  /* USER CODE BEGIN DMA2_Stream2_IRQn 1 */

  /* USER CODE END DMA2_Stream2_IRQn 1 */
}

/**
  * @brief This function handles DMA2 stream3 global interrupt.
  */
void DMA2_Stream3_IRQHandler(void)
{
  /* USER CODE BEGIN DMA2_Stream3_IRQn 0 */

  /* USER CODE END DMA2_Stream3_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_adc2);
  /* USER CODE BEGIN DMA2_Stream3_IRQn 1 */

  /* USER CODE END DMA2_Stream3_IRQn 1 */
}

/**
  * @brief This function handles CAN2 TX interrupts.
  */
void CAN2_TX_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_TX_IRQn 0 */

  /* USER CODE END CAN2_TX_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_TX_IRQn 1 */

  /* USER CODE END CAN2_TX_IRQn 1 */
}

/**
  * @brief This function handles CAN2 RX0 interrupts.
  */
void CAN2_RX0_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_RX0_IRQn 0 */

  /* USER CODE END CAN2_RX0_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_RX0_IRQn 1 */

  /* USER CODE END CAN2_RX0_IRQn 1 */
}

/**
  * @brief This function handles CAN2 RX1 interrupt.
  */
void CAN2_RX1_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_RX1_IRQn 0 */

  /* USER CODE END CAN2_RX1_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_RX1_IRQn 1 */

  /* USER CODE END CAN2_RX1_IRQn 1 */
}

/**
  * @brief This function handles CAN2 SCE interrupt.
  */
void CAN2_SCE_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_SCE_IRQn 0 */

  /* USER CODE END CAN2_SCE_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_SCE_IRQn 1 */

  /* USER CODE END CAN2_SCE_IRQn 1 */
}

/**
  * @brief This function handles DMA2 stream7 global interrupt.
  */
void DMA2_Stream7_IRQHandler(void)
{
  /* USER CODE BEGIN DMA2_Stream7_IRQn 0 */

  /* USER CODE END DMA2_Stream7_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_usart1_tx);
  /* USER CODE BEGIN DMA2_Stream7_IRQn 1 */

  /* USER CODE END DMA2_Stream7_IRQn 1 */
}

/* USER CODE BEGIN 1 */
void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
{
	static unsigned char prev = 0, i = 0, start_frame = 0;
	if (huart->Instance == USART1)
	{
		__HAL_UART_FLUSH_DRREGISTER(&huart1);

		imd1_timeouttick = 300;
		//USER_OUT8_OFF
#ifdef IMDV_1000  // 1000V TATAPOWER IMD
			 if(start_frame == 1)
			 		 {
			 			ImdRx[i++] = M_buff;
			 			if(i > 10)
			 			{
			 				can2TX_msg[0] = ImdRx[3]; 	// 	g1 bus high byte
			 				can2TX_msg[1] = ImdRx[4];	//	g1 bus low byte
			 				can2TX_msg[4] = ImdRx[5]; 	//  g2 bus high byte
			 				can2TX_msg[5] = ImdRx[6]; 	//  g2 bus low byte

			 				// g1 isolation value
			 				if ((ImdRx[7] == 0xff) || (ImdRx[9] == 0xff))
			 				{
			 					can2TX_msg[3] = 0x00; 	// high byte
			 					can2TX_msg[2] = 0x00;	// low byte
			 				}
			 				else
			 				{
			 					can2TX_msg[3] = 0x03; 	// high byte
			 					can2TX_msg[2] = 0xE8; 	// low byte
			 				}

			 				// g2 isolation value
			 				if ((ImdRx[8] == 0xff) || (ImdRx[10] == 0xff))
			 				{
			 					can2TX_msg[7] = 0;		// high byte
			 					can2TX_msg[6] = 0; 		// low byte
			 				}
			 				else
			 				{
			 					can2TX_msg[7] = 0x03; 	// high byte
			 					can2TX_msg[6] = 0xE8; 	// low byte
			 				}
			 				start_frame = i = 0;
			 			}
			 		}

			 		if((prev == 0xA5) && (M_buff == 0x5A))
			 		{
			 			start_frame = 1;
			 			i = 2;
			 		}
			 		prev =  M_buff;
	#else  // 750V reguler IMD

		if (start_frame == 1) {
			ImdRx[i++] = M_buff;
			if (i > 6) {
				// g1 isolation value
				if ((ImdRx[3] == 0xff) || (ImdRx[5] == 0xff)) {
					can2TX_msg[3] = 0x00; // high byte
					can2TX_msg[2] = 0x0; // low byte
				} else {
					can2TX_msg[3] = 0x03; // high byte
					can2TX_msg[2] = 0xE8; // low byte
				}

				// g2 isolation value
				if ((ImdRx[4] == 0xff) || (ImdRx[6] == 0xff)) {
					can2TX_msg[7] = 0; // high byte
					can2TX_msg[6] = 0; // low byte
				} else {
					can2TX_msg[7] = 0x03; // high byte
					can2TX_msg[6] = 0xE8; // low byte
				}
				start_frame = i = 0;
			}
		}

		if ((prev == 0xA5) && (M_buff == 0x5A)) {
			start_frame = 1;
			i = 2;
		}
		prev = M_buff;
#endif
	}
}



void HAL_UART_ErrorCallback(UART_HandleTypeDef *huart)
{
	if(huart->Instance==USART1)
	{
	//	HAL_UART_DeInit(&huart1);
		HAL_UART_Receive_DMA(&huart1,(uint8_t*)&M_buff,1);
	}

}
/* USER CODE END 1 */
