/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define PWM_Gun1_Pin GPIO_PIN_9
#define PWM_Gun1_GPIO_Port GPIOE

#define PWM_DUTY_CYCLE_0	0    //for not selected
#define PWM_DUTY_CYCLE_1	16   // 10/0.6 => 16.666
#define PWM_DUTY_CYCLE_2	26	 // 16/0.6 => 26.666
#define PWM_DUTY_CYCLE_3	33	 // 20/0.6 => 33.333
#define PWM_DUTY_CYCLE_4	41   // 25/0.6 => 41.666
#define PWM_DUTY_CYCLE_5	53   // 32/0.6 => 53.333

//V501change

//V501change
#if cpchange == no
#define STATE_A_LEVEL   3540//ioncharge count 3650 // 3739// 3680 //3650  // 3594  // 3530//3511
#define STATE_B_LEVEL  3080 //ion charge 3189// 3249// 3189 //3230  // 3108  //3080
#define STATE_C_LEVEL    2650//ion charge 2722//2784//2722 //3220  // 2986  // 2667
#define STATE_D_LEVEL    2260 //3120  // 2864  // 2248

#define STATE_A_LEVEL_1  3650// 3087 // 3739// 3680 //3650  // 3594  // 3530
#define STATE_B_LEVEL_1  3100//ion charge 3180//2691// 3249// 3189 //3230  // 3108  //
#define STATE_C_LEVEL_1   2639//2321//2784//2722 //3220  // 2986  // 2667
#define STATE_D_LEVEL_1    2260//2000 //3120  // 2864  // 2248
#endif


/* two dispatched to ion charge count
#define STATE_A_LEVEL  3650 // 3739// 3680 //3650  // 3594  // 3530
#define STATE_B_LEVEL  3189// 3249// 3189 //3230  // 3108  //
#define STATE_C_LEVEL    2722//2784//2722 //3220  // 2986  // 2667
#define STATE_D_LEVEL    2260 //3120  // 2864  // 2248

#define STATE_A_LEVEL_1  3650// 3087 // 3739// 3680 //3650  // 3594  // 3530
#define STATE_B_LEVEL_1  3180//2691// 3249// 3189 //3230  // 3108  //
#define STATE_C_LEVEL_1   2639//2321//2784//2722 //3220  // 2986  // 2667
#define STATE_D_LEVEL_1    2260//2000 //3120  // 2864  // 2248
*/
//#define STATE_A_LEVEL   3739// 3680 //3650  // 3594  // 3530
//#define STATE_B_LEVEL   3249// 3189 //3230  // 3108  //
//#define STATE_C_LEVEL    2784//2722 //3220  // 2986  // 2667
//#define STATE_D_LEVEL    2260 //3120  // 2864  // 2248

#define STATE_A   0
#define STATE_B   1
#define STATE_C   2
#define STATE_D   3
#define STATE_UNKNOWN   4


extern uint8_t powerfailure_flag;
#define FLASH_CS_GPIO_Port GPIOA
#define FLASH_CS_Pin GPIO_PIN_4

#define RELAY_G1_Pin GPIO_PIN_13
#define RELAY_G1_GPIO_Port GPIOD

#define GFD_Pin GPIO_PIN_0
#define GFD_GPIO_Port GPIOC

#define HMI_TX_Pin GPIO_PIN_10
#define HMI_TX_GPIO_Port GPIOB

#define HMI_RX_Pin GPIO_PIN_11
#define HMI_RX_GPIO_Port GPIOB

#define EMERGENCY_STOP_Pin GPIO_PIN_8
#define EMERGENCY_STOP_GPIO_Port GPIOE

#define Buzzer_Pin GPIO_PIN_7
#define Buzzer_GPIO_Port GPIOD

#define Energy_module_RX_Pin GPIO_PIN_9
#define Energy_module_RX_GPIO_Port GPIOA

#define Energy_Module_TX_Pin GPIO_PIN_10
#define Energy_Module_TX_GPIO_Port GPIOA

#define ESP32_TX_Pin GPIO_PIN_5
#define ESP32_TX_GPIO_Port GPIOD

#define ESP32_RX_Pin GPIO_PIN_6
#define ESP32_RX_GPIO_Port GPIOD

#define RCD1_out_Pin GPIO_PIN_12
#define RCD1_out_GPIO_Port GPIOA

#define RCD1_READ HAL_GPIO_ReadPin(RCD1_out_GPIO_Port,RCD1_out_Pin)

#define BUZZER_ON HAL_GPIO_WritePin(Buzzer_GPIO_Port,Buzzer_Pin,GPIO_PIN_SET);
#define BUZZER_OFF HAL_GPIO_WritePin(Buzzer_GPIO_Port,Buzzer_Pin,GPIO_PIN_RESET);
#define TOGGLE_BUZZER HAL_GPIO_TogglePin(Buzzer_GPIO_Port,Buzzer_Pin);

#define EMG_SW_READ HAL_GPIO_ReadPin(EMERGENCY_STOP_GPIO_Port,EMERGENCY_STOP_Pin)


#define RELAY_SW_ESP_pin GPIO_PIN_4
#define RELAY_SW_ESP_GPIO_Port GPIOE

#define ESPON_pin GPIO_PIN_5
#define ESPON_GPIO_Port GPIOE

#define GSMON_pin GPIO_PIN_3
#define GSMON_GPIO_Port GPIOE

#define HTBEAT_pin GPIO_PIN_2
#define HTBEAT_GPIO_Port GPIOE

#define RELAY_SW_ESPON HAL_GPIO_WritePin(RELAY_SW_ESP_GPIO_Port,RELAY_SW_ESP_pin,GPIO_PIN_RESET);
#define RELAY_SW_ESPOFF HAL_GPIO_WritePin(RELAY_SW_ESP_GPIO_Port,RELAY_SW_ESP_pin,GPIO_PIN_SET);

#define ESPON HAL_GPIO_WritePin(ESPON_GPIO_Port,ESPON_pin,GPIO_PIN_RESET);
#define ESPOFF HAL_GPIO_WritePin(ESPON_GPIO_Port,ESPON_pin,GPIO_PIN_SET);

#define GSMON HAL_GPIO_WritePin(GSMON_GPIO_Port,GSMON_pin,GPIO_PIN_RESET);
#define GSMOFF HAL_GPIO_WritePin(GSMON_GPIO_Port,GSMON_pin,GPIO_PIN_SET);

#define GFD_READ HAL_GPIO_ReadPin(GFD_GPIO_Port,GFD_Pin)

#define HTBEATON HAL_GPIO_WritePin(HTBEAT_GPIO_Port,HTBEAT_pin,GPIO_PIN_RESET);
#define HTBEATOFF HAL_GPIO_WritePin(HTBEAT_GPIO_Port,HTBEAT_pin,GPIO_PIN_SET);
#define HTBEATTOGGLE HAL_GPIO_TogglePin(HTBEAT_GPIO_Port,HTBEAT_pin);
/////////////////////////////v4.x.8//////////////////////////////////////////////////
typedef enum reset_cause_e
{
    RESET_CAUSE_UNKNOWN = 0,
    RESET_CAUSE_LOW_POWER_RESET,
    RESET_CAUSE_WINDOW_WATCHDOG_RESET,
    RESET_CAUSE_INDEPENDENT_WATCHDOG_RESET,
    RESET_CAUSE_SOFTWARE_RESET,
    RESET_CAUSE_POWER_ON_POWER_DOWN_RESET,
    RESET_CAUSE_EXTERNAL_RESET_PIN_RESET,
    RESET_CAUSE_BROWNOUT_RESET,
} reset_cause_t;


void send_data_g070(void);
/* USER CODE BEGIN Private defines */
extern uint8_t Temperature, Humidity;
/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
