/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * @file           : main.c
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * Copyright (c) 2022 STMicroelectronics.
 * All rights reserved.
 *
 * This software is licensed under terms that can be found in the LICENSE file
 * in the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "dma.h"
#include "iwdg.h"
#include "spi.h"
#include "tim.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "mfrc522.h"
#include "Common.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

static uint8_t g_txframe[6], g_buff[30];
static int g_status;
static uint8_t g_CardID[4];
static uint8_t g_type;
static uint8_t sensitivity_data = 0;

unsigned int generated_CRC = 0, Recieved_CRC = 0;

extern volatile uint8_t uart_tx_busy;
//extern volatile char cardRXenable;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_SPI1_Init();
  MX_USART1_UART_Init();
  MX_IWDG_Init();
//  MX_TIM1_Init();
//  MX_TIM3_Init();
  /* USER CODE BEGIN 2 */
	MFRC522_Init();
	HAL_Delay(100);
	g_stage_change = 1;
	g_stage_level = Init;
	g_error_code = 0;

	HAL_Delay(20);
	sensitivity_data = MFRC522_ReadRegister(MFRC522_RFC_FG_REG);
	HAL_UART_Receive_IT(&huart1, &g_u1rxbyte, 1);
	HAL_TIM_Base_Start_IT(&htim3);
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
	while (1) {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */

		HAL_IWDG_Refresh(&hiwdg);
		/////////////////////RFID section////////////////////////
		g_status = MFRC522_CheckCard(g_CardID, &g_type);

		if (g_status == RFID_OK) {
			for (unsigned char i = 0; i < 4; i++) {
				g_txframe[i] = g_CardID[i];
			}

			int g_BuffIndex = 0;
			g_buff[g_BuffIndex++] = 0x5A;									//START BYTE1
			g_buff[g_BuffIndex++] = 0xA5;									//START BYTE2
			g_buff[g_BuffIndex++] = 0x00;									//data length
			g_buff[g_BuffIndex++] = 0X52;									//Frame type
			g_buff[g_BuffIndex++] = Hex_ascii((g_CardID[3] & 0xf0) >> 4);	//data
			g_buff[g_BuffIndex++] = Hex_ascii(g_CardID[3] & 0x0f);
			g_buff[g_BuffIndex++] = Hex_ascii((g_CardID[2] & 0xf0) >> 4); 	//data
			g_buff[g_BuffIndex++] = Hex_ascii(g_CardID[2] & 0x0f);
			g_buff[g_BuffIndex++] = Hex_ascii((g_CardID[1] & 0xf0) >> 4); 	//data
			g_buff[g_BuffIndex++] = Hex_ascii(g_CardID[1] & 0x0f);
			g_buff[g_BuffIndex++] = Hex_ascii((g_CardID[0] & 0xf0) >> 4); 	//data
			g_buff[g_BuffIndex++] = Hex_ascii(g_CardID[0] & 0x0f);
			g_buff[g_BuffIndex++] = 0x03; 									//END BYTE

			g_buff[2] = g_BuffIndex - 3; //data length

			if (!uart_tx_busy)
			{
				uart_tx_busy = 1;
				HAL_UART_Transmit(&huart1, (uint8_t*) g_buff, g_BuffIndex, 0xffff);
			}

			g_CardID[0] = g_CardID[1] = g_CardID[2] = g_CardID[3] = 0;

		} else {
			if (g_status == RFID_ERR) {
				//Error
			}
		}
		g_status = 0;

		if (g_u1_rxedFrame == 1) {

			if (g_u1_rxbuffer[1] == 0X50) {
				if (g_stage_level != g_u1_rxbuffer[2]) {
					g_stage_level = g_u1_rxbuffer[2];
					g_stage_change = 1;
				}
				if (g_error_code != g_u1_rxbuffer[3]) {
					g_error_code = g_u1_rxbuffer[3];
					g_stage_change = 1;
				}

				//////////////////////////////////////////////////////////
				int g_BuffIndex = 0;
				g_buff[g_BuffIndex++] = 0x5A;	//START BYTE1
				g_buff[g_BuffIndex++] = 0xA5;	//START BYTE2
				g_buff[g_BuffIndex++] = 0x00;	//data length
				g_buff[g_BuffIndex++] = 0X51;	//Frame type
				g_buff[g_BuffIndex++] = 0x00;	//data
				g_buff[g_BuffIndex++] = 0x03;	//END BYTE

				g_buff[2] = g_BuffIndex - 3; 	//data length

				if (!uart_tx_busy)
				{
				    uart_tx_busy = 1;
					HAL_UART_Transmit(&huart1, (uint8_t*) g_buff, g_BuffIndex, 0xffff);
				}
				///////////////////////////////////////////////////////////////
			} else if (g_u1_rxbuffer[1] == 0X53) {
				if (g_u1_rxbuffer[2] == 1) {
					//RFID OK
				} else if (g_u1_rxbuffer[2] == 3) {
					//RFID auth failed
				} else {
					//RFID not OK
				}
			}
		}
		g_u1_rxedFrame = 0;
	}

  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI|RCC_OSCILLATORTYPE_LSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSIDiv = RCC_HSI_DIV1;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.LSIState = RCC_LSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLM = RCC_PLLM_DIV1;
  RCC_OscInitStruct.PLL.PLLN = 8;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
	/* User can add his own implementation to report the HAL error return state */
	__disable_irq();
	while (1) {
	}
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
