# Smart Socket Application Firmware

This is a firmware project developed for a **Smart EV Charging Socket** based on **STM32 microcontrollers**. It is designed to support key charging standards, protocols, and real-time control for intelligent electric vehicle (EV) charging.

---

## 📦 Features

- ⏱️ **FreeRTOS**: Real-time task management for stable multi-threaded operation.
- ⚡ **OCPP Support (Open Charge Point Protocol)**:
  - Plug & play OCPP 1.6 JSON support
  - Communication with EV charging backends
- 🔁 **Modbus RTU**:
  - Interface with energy meters, ADCs, or backend controllers
- 🆔 **RFID Authentication**:
  - MIFARE card support for secure user authentication
- 📊 **ADC Integration**:
  - Real-time voltage and current monitoring
- 🕒 **RTC Support**:
  - Real-time timestamping for logs and billing
- 🌐 **Network Interfaces**:
  - Wi-Fi
  - GSM
  - Ethernet
- 🔒 **Watchdog Timers**:
  - IWDG and WWDG support for system reliability
- 💡 **User Feedback**:
  - LED and button interface

---

## 🛠️ Configuration Mode

Since this charger does not have an onboard HMI display, the system includes a **Wi-Fi-based Configuration Mode** for setting parameters such as OCPP credentials, network selection, RFID setup, and firmware update.

### 🔧 Configuration Steps

1. **Power OFF** the EV charger.
2. **Press** the **Emergency Stop** push button.
3. **Power ON** the charger.
4. Wait until the LED **turns purple**.
5. On your **PC/Laptop**, search and connect to Wi-Fi network:  
   **SSID:** `Smart_socket_config`  
   **Password:** `mypassword`
6. Open a web browser and go to:  
   `http://192.168.4.1`
7. Login using:  
   **Username:** `admin`  
   **Password:** `12345`

You will now be on the configuration page where you can:

- Set OCPP parameters  
- Update firmware  
- Choose network type (`wifi`, `eth`, `gsm`)

To access **RFID and Ethernet Settings**:

- Repeat steps 1–5
- Use the following login:  
  **Username:** `admin2`  
  **Password:** `12345`

### ⚙️ Configuration Tips

- Only **M1-type RFID cards** are supported.
- **Network Type**:
  - `wifi` → Use Wi-Fi for OCPP
  - `eth` → Use Ethernet for OCPP
  - `gsm` → Use GSM for OCPP
  - `none` → Disable OCPP communication
- **Enable Ethernet Communication**:
  - Set IP to `255.255.255.255`
  - Write `eth` into `EthernetEnableSts`
- **GSM Firmware Update**:
  - Set `EthernetEnableSts` to `gsm`
  - Click `Send` and `Logout`
  - Release Emergency Stop and restart charger

⚠️ **Important**: After editing any configuration:
- Click **Send**
- Then click **Logout**
- The **yellow LED** should blink continuously
- Restart the charger to apply changes

---

## 📁 Directory Structure

```
SmartSocketCharger/
├── AC001_0_0_ThreeGun_ARAI.ioc       # STM32CubeMX configuration file
├── Core/                             # Application source (main, startup, interrupts, FreeRTOS tasks, etc.)
├── Drivers/                          # HAL/LL and BSP drivers
├── Middlewares/                      # Third-party libraries (FreeRTOS, LWIP, etc.)
├── Debug/                            # STM32CubeIDE-generated debug output
├── README.md                         # Project description
├── ReadMe.txt                        # Legacy or brief notes
├── STM32F407VETX_FLASH.ld            # Linker script for FLASH
├── STM32F407VETX_RAM.ld              # Linker script for RAM
├── Smart_socket_F407 Debug.launch    # STM32CubeIDE Debug configuration
```

---

## 🚀 Getting Started

### 🛠 Requirements

- STM32CubeIDE
- STM32CubeMX (for config generation)
- Supported STM32 board (e.g., STM32G070CBT6, STM32F103C8T6)
- USB-to-UART for debug/console
- Wi-Fi/GSM/Ethernet module
- RFID Reader (UART/SPI based)

### 🔧 Build & Flash

1. Open the `.ioc` file with STM32CubeIDE.
2. Generate code and build the project.
3. Connect the board and flash using ST-LINK.
4. Use UART/USB for debug logs (115200 baud default).

---

## 📡 Communication Stack

| Layer        | Protocol     | Description                            |
|--------------|--------------|----------------------------------------|
| Application  | OCPP 1.6 JSON| Cloud/backend integration              |
| Control      | FreeRTOS     | Real-time task handling                |
| Field        | Modbus RTU   | Energy metering / ADC control          |
| Auth         | RFID UART    | User access control                    |
| Transport    | GSM/Wi-Fi/Ethernet | Network connectivity            |

---

## 🔐 Security and Reliability

- Implements **IWDG** and **WWDG** watchdog timers
- Validates OCPP messages
- Protects relay and power electronics against overload via real-time monitoring

---

## 📝 License

This project is released under the MIT License. See [LICENSE](LICENSE) for details.
