/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * @file    stm32f4xx_it.c
 * @brief   Interrupt Service Routines.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32f4xx_it.h"
#include "FreeRTOS.h"
#include "task.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "modbus.h"
#include "OCPP.h"
#include <ctype.h>
#include <string.h>
#include "w25qxx.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
unsigned int flag;
uint8_t rxBuffer, hmi_buff, hmi_buff1, WIFI_Setting, rxBuffer_prev;
char START_FLAG;
__IO ITStatus UartReady = RESET;
uint8_t i;
volatile uint16_t blue_led_blink = 0;
volatile uint16_t red_led_blink = 0, red_led_blink2 = 0, red_led_blink3 = 0,
		red_led_blink1 = 0;
volatile uint16_t green_led_blink = 0;
volatile uint16_t Emergency_stop_count = 0;
volatile uint16_t buzzer_enable_time = 0;
volatile char buzzer_enable;
volatile uint16_t count = 0, bytecount = 0;
int rxindex = 0, rxindex1 = 0;
char Local_Added = 0;
uint8_t adctempcnt = 0;
char tagid[15];
char id[15], recieve_complete, Type2_OCPP_Authorization_Flag;
uint8_t hmi_buffer[100], internet_connection, Emergency_start_count;
uint8_t RCD1_stop_count, RCD1_stop, RCD1_start_count;
volatile uint8_t recieve_complete_2;
uint8_t M_buff, M_buff1, Send_meter;
volatile uint16_t bytecount_M = 0, count_M = 0;
char START_FLAG, START_FLAG_M;
volatile unsigned long int millisec = 0;
extern uint8_t logout, rfid_sts_update;				// ronak 170425
		/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */
char ether_connection_varify(void);
char wifi_connection_varify(void);
int validate_ip(unsigned char *ip);
void delay_ms(uint32_t mS);

extern void process_ReceiveArray(void);
extern void adc_check();
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/
extern DMA_HandleTypeDef hdma_adc1;
extern DMA_HandleTypeDef hdma_adc2;
extern ADC_HandleTypeDef hadc1;
extern ADC_HandleTypeDef hadc2;
extern TIM_HandleTypeDef htim1;
extern TIM_HandleTypeDef htim2;
extern TIM_HandleTypeDef htim5;
extern DMA_HandleTypeDef hdma_usart1_rx;
extern DMA_HandleTypeDef hdma_usart1_tx;
extern DMA_HandleTypeDef hdma_usart2_tx;
extern DMA_HandleTypeDef hdma_usart2_rx;
extern DMA_HandleTypeDef hdma_usart3_rx;
extern DMA_HandleTypeDef hdma_usart3_tx;
extern DMA_HandleTypeDef hdma_usart6_rx;
extern UART_HandleTypeDef huart1;
extern UART_HandleTypeDef huart2;
extern UART_HandleTypeDef huart3;
extern UART_HandleTypeDef huart6;
/* USER CODE BEGIN EV */

extern enum {
	no_alarm = 0, activealarm, mutealarm,
} alarmstatus;

extern uint8_t rxmsg[50];
extern uint8_t server_packet[500];
extern char current_page, otp_ocpp[30];
volatile extern uint8_t Emergency_stop;
volatile extern uint8_t LocalListAdding, Local_List_Update;
extern char websocket_success;
extern char EVSE_status[20];
extern char pwm_start_stop, pwm_start_stop_1;
volatile extern char admin, history, mode, start, back_1, enter_1, Touch_Action,Clear_Register;
volatile extern char read_flash;
extern struct Config_Parameter OCPP;
extern const struct Config_Parameter_OCPP default_params_ocpp;
extern char Rfid_Add;
extern uint16_t enrgyread1_timouttick, enrgyread2_timouttick,enrgyread3_timouttick;
extern uint8_t energymeter_err[3];
extern volatile uint16_t ticktimerflag, ticktickcnt;
extern volatile char flash_writing, flash_reading;
extern volatile uint8_t HMI_alarmstsupdate;
extern uint8_t G070_sts_tx_frame;
extern volatile char alarm;

/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M4 Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
 * @brief This function handles Non maskable interrupt.
 */
void NMI_Handler(void)
{
	/* USER CODE BEGIN NonMaskableInt_IRQn 0 */
	/* USER CODE END NonMaskableInt_IRQn 0 */
	/* USER CODE BEGIN NonMaskableInt_IRQn 1 */
	while (1)
	{

	}
	/* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
 * @brief This function handles Hard fault interrupt.
 */
void HardFault_Handler(void)
{
	/* USER CODE BEGIN HardFault_IRQn 0 */

	/* USER CODE END HardFault_IRQn 0 */
	while (1)
	{
		/* USER CODE BEGIN W1_HardFault_IRQn 0 */
		/* USER CODE END W1_HardFault_IRQn 0 */
	}
}

/**
 * @brief This function handles Memory management fault.
 */
void MemManage_Handler(void)
{
	/* USER CODE BEGIN MemoryManagement_IRQn 0 */

	/* USER CODE END MemoryManagement_IRQn 0 */
	while (1)
	{
		/* USER CODE BEGIN W1_MemoryManagement_IRQn 0 */
		/* USER CODE END W1_MemoryManagement_IRQn 0 */
	}
}

/**
 * @brief This function handles Pre-fetch fault, memory access fault.
 */
void BusFault_Handler(void)
{
	/* USER CODE BEGIN BusFault_IRQn 0 */

	/* USER CODE END BusFault_IRQn 0 */
	while (1)
	{
		/* USER CODE BEGIN W1_BusFault_IRQn 0 */
		/* USER CODE END W1_BusFault_IRQn 0 */
	}
}

/**
 * @brief This function handles Undefined instruction or illegal state.
 */
void UsageFault_Handler(void)
{
	/* USER CODE BEGIN UsageFault_IRQn 0 */

	/* USER CODE END UsageFault_IRQn 0 */
	while (1)
	{
		/* USER CODE BEGIN W1_UsageFault_IRQn 0 */
		/* USER CODE END W1_UsageFault_IRQn 0 */
	}
}

/**
 * @brief This function handles Debug monitor.
 */
void DebugMon_Handler(void)
{
	/* USER CODE BEGIN DebugMonitor_IRQn 0 */

	/* USER CODE END DebugMonitor_IRQn 0 */
	/* USER CODE BEGIN DebugMonitor_IRQn 1 */

	/* USER CODE END DebugMonitor_IRQn 1 */
}

/**
 * @brief This function handles System tick timer.
 */
void SysTick_Handler(void)
{
	/* USER CODE BEGIN SysTick_IRQn 0 */

	/*if(++counter > 100)
	 {
	 OCPP_data();
	 counter = 0;
	 }*/
//
	if (logout == 1)
	{
		if (red_led_blink == 0)
		{
			red_led_blink = 500;
			//blue_led_blink++;
			rfid_sts_update = 4;
		}
	}
	if (red_led_blink1)
		red_led_blink1--;
	if (red_led_blink)
		red_led_blink--;

//	if(green_led_blink)green_led_blink--;
	if (buzzer_enable_time)
		buzzer_enable_time--;
//	if(relay_delay)
//	{
//		relay_delay--;
//	}

	if (!EMG_SW_READ)
	{
		Emergency_stop_count++;
		if (Emergency_stop_count >= 50)
		{
			Emergency_stop = 1;
			charger_status_G1.reson = EmergencyStop;
			if ((charger_status_G1.error != InternalError))
			{
				charger_status_G1.error = InternalError;
				charger_status_G1.vendorErrorCode = VENDOR_ERR_EmergencyStop;		// Added by Nihar
				G070_sts_tx_frame = 1;	//ac001
			}
			if (charger_status_G1.charging_status == Charging_ChargerPoint)
			{
				charger_status_G1.start = Started;
			}

			if (charger_status_G1.start == Started)
			{
				charger_status_G1.stop = Try_To_Stop;
			}
			Emergency_stop_count = 0;
		}
	}
	else
	{
		if (++Emergency_start_count > 50)
		{
			Emergency_start_count = 0;
			Emergency_stop_count = 0;
			if ((charger_status_G1.error == InternalError))
			{
				charger_status_G1.error = NoError_ChargerPoint;
				charger_status_G1.vendorErrorCode = VENDOR_ERR_NoError;		// Added by Nihar
				G070_sts_tx_frame = 1;	//ac001
			}
			Emergency_stop = 0;
		}
	}
	//////////////////////////////////////////////////////////////////

	if (Emergency_stop)
	{

	}
	else
	{
		if ((charger_status_G1.charging_status == Faulted_ChargerPoint))
		{

//				if(charger_status_G1.error != PowerSwitchFailure )
//				{
			////////V5.0.0A//////////
//				alarm = 1;

			////////////////////////
//				}
		}
		else
		{
			////////V5.0.0A//////////
//				alarm = 0;

			///////////////////////
		}

		if (charger_status_G1.charging_status== Faulted_ChargerPoint/* || (charger_status_G1.error == PowerMeterFailure)*/)
		{
			if (red_led_blink1 == 0)
			{
				red_led_blink1 = 500;

				if ((RCD1_stop != 1))
				{
					alarm = 1;
				}
				//alarm = 1;
				//TOGGLE_BUZZER;
			}
		}
		else if (charger_status_G1.charging_status == Charging_ChargerPoint)
		{

			//BUZZER_OFF
		}
		else
		{
			//BUZZER_OFF;
		}
	}

	if (!RCD1_READ)
	{
		RCD1_stop_count++;
		if (RCD1_stop_count >= 50)
		{
			RCD1_stop = 1;
			if (charger_status_G1.charging_status == Charging_ChargerPoint)
			{
				charger_status_G1.start = Started;
			}

			if (charger_status_G1.start == Started)
			{
				charger_status_G1.stop = Try_To_Stop;
			}
			charger_status_G1.charging_status = Faulted_ChargerPoint;
			charger_status_G1.error = OtherError;
			//charger_status_G1.start = 99;
			RCD1_stop_count = 0;
		}

	}
	else
	{
		if (++RCD1_start_count > 50)
		{
			RCD1_start_count = 0;
			RCD1_stop = 0;
		}
		RCD1_stop_count = 0;

	}

//	if(alarm)
	/*		if(alarmstatus	== activealarm)	//V5.0.0A
	 {
	 if(!buzzer_enable_time)
	 {
	 buzzer_enable_time=500;
	 buzzer_enable=!buzzer_enable;
	 }
	 if(buzzer_enable){
	 TOGGLE_BUZZER;
	 }
	 else{
	 BUZZER_OFF;
	 }
	 }
	 else
	 {
	 BUZZER_OFF;
	 }*/

	/*if((pwm_start_stop==0) &&(pwm_start_stop_1==0))
	 {
	 adc_check();
	 }*/
#if target == actype2
	if((pwm_start_stop==0) && (flash_writing == 0) && ++adctempcnt >100)
		{
			adc_check();
			adctempcnt=0;
		}
#endif
	/* USER CODE END SysTick_IRQn 0 */
	HAL_IncTick();
#if (INCLUDE_xTaskGetSchedulerState == 1 )
	if (xTaskGetSchedulerState() != taskSCHEDULER_NOT_STARTED)
	{
#endif /* INCLUDE_xTaskGetSchedulerState */
		xPortSysTickHandler();
#if (INCLUDE_xTaskGetSchedulerState == 1 )
	}
#endif /* INCLUDE_xTaskGetSchedulerState */
	/* USER CODE BEGIN SysTick_IRQn 1 */

	/* USER CODE END SysTick_IRQn 1 */
}
/******************************************************************************/
/* STM32F4xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32f4xx.s).                    */
/******************************************************************************/

/**
 * @brief This function handles DMA1 stream1 global interrupt.
 */
void DMA1_Stream1_IRQHandler(void)
{
	/* USER CODE BEGIN DMA1_Stream1_IRQn 0 */

	/* USER CODE END DMA1_Stream1_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart3_rx);

	/* USER CODE BEGIN DMA1_Stream1_IRQn 1 */

	/* USER CODE END DMA1_Stream1_IRQn 1 */
}
/**
 * @brief This function handles DMA1 stream3 global interrupt.
 */
void DMA1_Stream3_IRQHandler(void)
{
	/* USER CODE BEGIN DMA1_Stream3_IRQn 0 */

	/* USER CODE END DMA1_Stream3_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart3_tx);
	/* USER CODE BEGIN DMA1_Stream3_IRQn 1 */

	/* USER CODE END DMA1_Stream3_IRQn 1 */
}

/**
 * @brief This function handles DMA1 stream5 global interrupt.
 */
void DMA1_Stream5_IRQHandler(void)
{
	/* USER CODE BEGIN DMA1_Stream5_IRQn 0 */

	/* USER CODE END DMA1_Stream5_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart2_rx);
	/* USER CODE BEGIN DMA1_Stream5_IRQn 1 */

	/* USER CODE END DMA1_Stream5_IRQn 1 */
}

/**
 * @brief This function handles DMA1 stream6 global interrupt.
 */
void DMA1_Stream6_IRQHandler(void)
{
	/* USER CODE BEGIN DMA1_Stream6_IRQn 0 */

	/* USER CODE END DMA1_Stream6_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart2_tx);
	/* USER CODE BEGIN DMA1_Stream6_IRQn 1 */

	/* USER CODE END DMA1_Stream6_IRQn 1 */
}

/**
 * @brief This function handles ADC1, ADC2 and ADC3 global interrupts.
 */
void ADC_IRQHandler(void)
{
	/* USER CODE BEGIN ADC_IRQn 0 */

	/* USER CODE END ADC_IRQn 0 */
//  HAL_ADC_IRQHandler(&hadc1);
	HAL_ADC_IRQHandler(&hadc2);
	/* USER CODE BEGIN ADC_IRQn 1 */

	/* USER CODE END ADC_IRQn 1 */
}

/**
 * @brief This function handles TIM1 update interrupt and TIM10 global interrupt.
 */
void TIM1_UP_TIM10_IRQHandler(void)
{
	/* USER CODE BEGIN TIM1_UP_TIM10_IRQn 0 */

	/* USER CODE END TIM1_UP_TIM10_IRQn 0 */
	HAL_TIM_IRQHandler(&htim1);

	/* USER CODE BEGIN TIM1_UP_TIM10_IRQn 1 */
//  for(int i=0;i<4090;i++);
	HAL_TIM_Base_Start_IT(&htim5);
	// HAL_TIM_Base_Start_IT(&htim5);
	//HAL_TIMEx_OnePulseN_Start_IT(&htim5, TIM_CHANNEL_ALL);
	//HAL_TIM_OnePulse_Start_IT(&htim5, TIM_CHANNEL_ALL);
	//adc_check();
	/* USER CODE END TIM1_UP_TIM10_IRQn 1 */
}

/**
 * @brief This function handles TIM2 global interrupt.
 */
void TIM2_IRQHandler(void)
{
	/* USER CODE BEGIN TIM2_IRQn 0 */

	/* USER CODE END TIM2_IRQn 0 */
	HAL_TIM_IRQHandler(&htim2);
	/* USER CODE BEGIN TIM2_IRQn 1 */

	/* USER CODE END TIM2_IRQn 1 */
}

void TIM5_IRQHandler(void)
{
	/* USER CODE BEGIN TIM2_IRQn 0 */

	/* USER CODE END TIM2_IRQn 0 */
	HAL_TIM_IRQHandler(&htim5);
#if target == actype2
  adc_check();
#endif

	/* USER CODE BEGIN TIM2_IRQn 1 */

	/* USER CODE END TIM2_IRQn 1 */
}
/**
 * @brief This function handles USART1 global interrupt.
 */
void USART1_IRQHandler(void)
{
	/* USER CODE BEGIN USART1_IRQn 0 */
	__HAL_UART_FLUSH_DRREGISTER(&huart1);
	HAL_UART_Receive_DMA(&huart1, (uint8_t*) &M_buff, 1);
	/* USER CODE END USART1_IRQn 0 */
	HAL_UART_IRQHandler(&huart1);

	/* USER CODE BEGIN USART1_IRQn 1 */
	// for(int i=0;i<2000;i++);
	// HAL_UART_Transmit(&huart6,rxmsg,37,0xffffff);
	/* USER CODE END USART1_IRQn 1 */
}

/**
 * @brief This function handles USART2 global interrupt.
 */
void USART2_IRQHandler(void)
{
	/* USER CODE BEGIN USART2_IRQn 0 */
	/*
	 * HAL_UART_AbortReceive(&huart2);

	 //	if(USART2-> HAL_UART_STATE_TIMEOUT)
	 //	if(USART2 -> RxState == HAL_UART_STATE_TIMEOUT)
	 if (huart2.RxState == HAL_UART_STATE_READY)
	 {
	 //	DMA1->CNDTR=10;
	 //HAL_UART_AbortReceive(&huart2);
	 HAL_UART_Receive_DMA(&huart2, (uint8_t*)server_packet,100);
	 i=0;
	 while(server_packet[i] != '\r')
	 {
	 rx[i]= server_packet[i];
	 i++;
	 }
	 rx[i] = '\r';
	 i++;
	 rx[i] = '\n';
	 i++;
	 rx[i] = '\0';
	 HAL_UART_Transmit_DMA(&huart1, (uint8_t*)rx,i+1);
	 i =0;

	 //USART2->ICR=USART_ICR_RTOCF;
	 huart2.RxState=HAL_UART_STATE_RESET;

	 //	memset(server_packet,0, 8*sizeof(char));

	 //	HAL_GPIO_TogglePin(LD4_GPIO_Port, LD4_Pin);

	 process_ReceiveArray();

	 }
	 */
	//HAL_UART_Receive_DMA(&huart2, (uint8_t*)server_packet, 98);
	//   AC001_OCPP_Charger_Status = 0;
	//OCPP_State_ACType2 = 1;
	//AC001_OCPP_Charger_Status = 0;
	//
	__HAL_UART_FLUSH_DRREGISTER(&huart2);
	HAL_UART_Receive_DMA(&huart2, &rxBuffer, 1);
	/* USER CODE END USART2_IRQn 0 */
	HAL_UART_IRQHandler(&huart2);
	/* USER CODE BEGIN USART2_IRQn 1 */

	/* USER CODE END USART2_IRQn 1 */
}

/**
 * @brief This function handles USART3 global interrupt.
 */
void USART3_IRQHandler(void)
{
	/* USER CODE BEGIN USART3_IRQn 0 */
	__HAL_UART_FLUSH_DRREGISTER(&huart3);
	HAL_UART_Receive_DMA(&huart3, &hmi_buff, 1);
	/* USER CODE END USART3_IRQn 0 */
	HAL_UART_IRQHandler(&huart3);
	/* USER CODE BEGIN USART3_IRQn 1 */

	/* USER CODE END USART3_IRQn 1 */
}

/**
 * @brief This function handles DMA2 stream0 global interrupt.
 */
/**
 * @brief This function handles DMA2 stream1 global interrupt.
 */
void DMA2_Stream1_IRQHandler(void)
{
	/* USER CODE BEGIN DMA2_Stream1_IRQn 0 */

	/* USER CODE END DMA2_Stream1_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart6_rx);
	/* USER CODE BEGIN DMA2_Stream1_IRQn 1 */

	/* USER CODE END DMA2_Stream1_IRQn 1 */
}

/**
 * @brief This function handles DMA2 stream2 global interrupt.
 */
void DMA2_Stream2_IRQHandler(void)
{
	/* USER CODE BEGIN DMA2_Stream2_IRQn 0 */

	/* USER CODE END DMA2_Stream2_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart1_rx);
	/* USER CODE BEGIN DMA2_Stream2_IRQn 1 */

	/* USER CODE END DMA2_Stream2_IRQn 1 */
}

/**
 * @brief This function handles DMA2 stream3 global interrupt.
 */
void DMA2_Stream3_IRQHandler(void)
{
	/* USER CODE BEGIN DMA2_Stream3_IRQn 0 */
	/* USER CODE END DMA2_Stream3_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_adc2);
	/* USER CODE BEGIN DMA2_Stream3_IRQn 1 */

	/* USER CODE END DMA2_Stream3_IRQn 1 */
}
void DMA2_Stream4_IRQHandler(void)
{
	/* USER CODE BEGIN DMA2_Stream4_IRQn 0 */

	/* USER CODE END DMA2_Stream4_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_adc1);
	/* USER CODE BEGIN DMA2_Stream4_IRQn 1 */

	/* USER CODE END DMA2_Stream4_IRQn 1 */
}
/**
 * @brief This function handles DMA2 stream7 global interrupt.
 */
void DMA2_Stream7_IRQHandler(void)
{
	/* USER CODE BEGIN DMA2_Stream7_IRQn 0 */

	/* USER CODE END DMA2_Stream7_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart1_tx);
	/* USER CODE BEGIN DMA2_Stream7_IRQn 1 */

	/* USER CODE END DMA2_Stream7_IRQn 1 */
}

/**
 * @brief This function handles USART6 global interrupt.
 */
void USART6_IRQHandler(void)
{
	/* USER CODE BEGIN USART6_IRQn 0 */
//	__HAL_UART_FLUSH_DRREGISTER(&huart6);
//	HAL_UART_Receive_DMA(&huart6,id,14);
	/* USER CODE END USART6_IRQn 0 */
	HAL_UART_IRQHandler(&huart6);
	/* USER CODE BEGIN USART6_IRQn 1 */

	/* USER CODE END USART6_IRQn 1 */
}
void EXTI9_5_IRQHandler(void)
{
	/* USER CODE BEGIN EXTI9_5_IRQn 0 */

	/* USER CODE END EXTI9_5_IRQn 0 */
	HAL_GPIO_EXTI_IRQHandler(GPIO_PIN_5);
	/* USER CODE BEGIN EXTI9_5_IRQn 1 */

	/* USER CODE END EXTI9_5_IRQn 1 */
}
/* USER CODE BEGIN 1 */
void HAL_UART_ErrorCallback(UART_HandleTypeDef *huart)
{
//	if(huart->Instance==USART6)
//	{
//		//HAL_UART_DeInit(&huart6);
//		HAL_UART_Receive_DMA(&huart6,(uint8_t*)id,14);
//	}
	if (huart->Instance == USART2)
	{
		//	HAL_UART_DeInit(&huart2);
		HAL_UART_Receive_DMA(&huart2, &rxBuffer, 1);
	}
	else if (huart->Instance == USART3)
	{
		//HAL_UART_DeInit(&huart3);
		HAL_UART_Receive_DMA(&huart3, &hmi_buff, 1);
	}
	else if (huart->Instance == USART1)
	{
		//HAL_UART_DeInit(&huart1);
		HAL_UART_Receive_DMA(&huart1, (uint8_t*) &M_buff, 1);
	}

}
void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
{
	if (huart->Instance == USART2)
	{
		__HAL_UART_FLUSH_DRREGISTER(&huart2); // Clear the buffer to prevent overrun

		if ((rxBuffer_prev == '\r' && rxBuffer == '\n') && (rxindex >= 3)) // If Enter
		{
			server_packet[rxindex] = '\n';

			//HAL_UART_Transmit(&huaGrt6, (uint8_t*)server_packet,rxindex+1,0xffff);
			recieve_complete_2 = 1;
			//process_ReceiveArray();
			rxindex = 0;
		}
		else
		{
			if (rxindex == 0 && rxBuffer == 254) //to filter noise
			{

			}
			else
			{
				server_packet[rxindex] = rxBuffer; // Add that character to the string
				rxindex++;
			}

		}

		rxBuffer_prev = rxBuffer;
	}
	else if (huart->Instance == USART1)
	{
		__HAL_UART_FLUSH_DRREGISTER(&huart1); // Clear the buffer to prevent overrun
//  HAL_UART_Transmit(&huart6,(uint8_t *)rxmsg,37,0xffff);
//  modbus_check();
		if (bytecount_M)
		{
			rxmsg[count_M++] = M_buff;
			bytecount_M--;
			if (bytecount_M == 0)
			{
				modbus_check();
				Send_meter = 0;
			}
		}
		if (START_FLAG_M == 1)
		{
			bytecount_M = M_buff + 2;
			rxmsg[2] = M_buff;
			START_FLAG_M = 0;
			count_M = 3;
		}

//		if(Send_meter == 1)
//		{
		if ((M_buff == 03) && (M_buff1 == 01))
		{
			START_FLAG_M = 1;
			count_M = 2;
			rxmsg[0] = M_buff1;
			rxmsg[1] = M_buff;
		}
//		}
//		else if(Send_meter == 2)
//		{
		else if ((M_buff == 03) && (M_buff1 == 02))
		{
			START_FLAG_M = 1;
			count_M = 2;
			rxmsg[0] = M_buff1;
			rxmsg[1] = M_buff;
		}
		else if ((M_buff == 03) && (M_buff1 == 02))
		{
			START_FLAG_M = 1;
			count_M = 2;
			rxmsg[0] = M_buff1;
			rxmsg[1] = M_buff;
		}
		else if ((M_buff == 03) && (M_buff1 == 03))
		{
			START_FLAG_M = 1;
			count_M = 2;
			rxmsg[0] = M_buff1;
			rxmsg[1] = M_buff;
		}
//		}
		M_buff1 = M_buff;
	}

	else if (huart->Instance == USART3)
	{
		__HAL_UART_FLUSH_DRREGISTER(&huart3); // Clear the buffer to prevent overrun
		if (bytecount)
		{
			hmi_buffer[count++] = hmi_buff;
			bytecount--;
			if (bytecount == 0)
			{
				recieve_complete = 1;
			}
		}
		if (START_FLAG == 1)
		{
			bytecount = hmi_buff;
			START_FLAG = 0;
			count = 0;
			hmi_buffer[count++] = hmi_buff;
			//HMI_Process(hmi_buffer);
		}
		if ((hmi_buff1 == 0x5a) && (hmi_buff == 0xa5))
		{
			START_FLAG = 1;
			//		USART_ClearITPendingBit(&huart3, USART_CR1_RXNEIE);
		}
		hmi_buff1 = hmi_buff;
	}
}
void HAL_ADC_ConvCpltCallback(ADC_HandleTypeDef *hadc)
{

}
void HAL_UART_TxCpltCallback(UART_HandleTypeDef *UartHandle)
{
	UartReady = SET;
}

/**
 * @brief Verify WiFi Connection
 *
 * This function verifies the presence of WiFi connection by checking if the WiFi SSID is set.
 *
 * @return
 *   - 0: WiFi SSID is not set or is NULL.
 *   - 1: WiFi SSID is set, indicating a valid WiFi connection.
 */
char wifi_connection_varify(void)
{
	if (OCPP.wifi_ssid == NULL)
	{
		return 0;
	}
	return 1;
}

/**
 * @brief Delay in Milliseconds
 *
 * This function introduces a delay in milliseconds using a busy-wait loop.
 *
 * @param mS Delay time in milliseconds.
 * @note This function is blocking and may not be suitable for applications requiring precise timing.
 *       Consider using hardware timers or an operating system for non-blocking delays.
 */
void delay_ms(uint32_t mS)
{
	millisec = mS;
	while (millisec)
	{
		;
	}
}
/* USER CODE END 1 */
/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
