# 🆔 Smart Socket Indicator Board (G030) Firmware

This firmware powers the **RFID reader subsystem** of a Smart Socket Charger. It detects MIFARE cards, sends UIDs to a main controller via UART, and provides comprehensive LED-based visual feedback using a WS2812 RGB LED strip.

---

## 🔧 Features

- 📡 **RFID M1 Type Card Support**
- 📤 **UART Communication with Smart Charger Controller**
- 💡 **WS2812 RGB LED Strip for Charging State & Error Display**
- 🔒 **IWDG Watchdog Integration for System Safety**

---

## 📁 Directory Structure

```
Smart_socket_G030/
├── Core/ 				# Application source files (main.c, interrupts, etc.)
├── Drivers/ 				# HAL drivers and peripheral interfaces
├── Debug/ 				# STM32CubeIDE build and debug output
├── Smart_socket_G030.ioc 		# STM32CubeMX project configuration file
├── STM32G030K6TX_FLASH.ld		# Linker script for STM32G030K6TX
├── RFID_pcb_V1.0_100922.launch 	# Debug configuration for RFID hardware
├── Smart_socket_G030.launch 		# STM32CubeIDE debug launch file
└── README.md 				# Project documentation
```

---

## 🚦 LED Color Indicators

| Status                      | LED Behavior                  | Description                                            |
|----------------------------|-------------------------------|--------------------------------------------------------|
| Available                  | 🟢 Green Blink                | Charger is idle and ready for RFID scan               |
| Preparing                  | 🟢 Green Stable               | System is transitioning from idle to active           |
| Charging                   | 🔵 Blue Blink                 | Charging session is in progress                       |
| Internet Error             | 🔴 25% Red                    | Internet connection problem                           |
| OCPP Error                 | 🔴 50% Red                    | Backend communication error                           |
| Protection Error           | 🔴 75% Red                    | Hardware protection triggered                         |
| Emergency Stop             | 🔴 100% Red Blink             | Emergency stop pressed                                |
| RFID Authenticated         | 🟣 Purple Blink               | RFID accepted                                         |
| RFID Invalid               | ❌ Full Red Blink Once        | Unknown/unauthorized RFID card                        |
| RFID Read Error            | ⚠ 50% Red Blink Once         | Card read failure                                     |
| FOTA/Communication Issue   | 🟡 Solid Yellow               | Firmware upgrade or lost comms with main CPU          |
| Config Data Saved          | 🟡 Yellow Blink               | Config updated; restart charger to apply              |

---

## 📡 Communication Protocol

- **Transmit UID to Charger Controller**:
Frame: [0x5A, 0xA5, Length, 0x52, 8-byte UID (ASCII), 0x03]
- **Receive Control Commands**:
- `0x50`: Update charger stage & error
- `0x53`: Indicate RFID auth result (1 = OK, 3 = FAIL)

---

## 🧠 Requirements

- STM32F1/F4 MCU
- MFRC522 RFID Reader (SPI interface)
- WS2812 LED Strip (1-wire protocol)
- UART communication line to charger controller
- STM32CubeIDE project (HAL)

---

## 🛠 Build Instructions

1. Open `.ioc` file using STM32CubeIDE
2. Generate and compile the code
3. Flash using ST-LINK debugger
4. Monitor UART output to verify communication

---

## 🏷️ Version

- **Name:** Smart Socket RFID Module  
- **Version:** 1.0  
- **Date:** May 2025

---


## 📄 License

This firmware is proprietary and intended only for use within approved Smart Charger solutions. Commercial redistribution is prohibited.