/*
 * ws2812_led.c
 *
 *  Created on: Dec 12, 2023
 *      Author: lubi
 */
#include "tim.h"
#include "ws2812_led.h"

#define MAX_LED 24
#define PI 3.14159265

 //#define USE_BRIGHTNESS 1
static uint8_t g_LED_Data[MAX_LED][4];
#if USE_BRIGHTNESS
static uint8_t g_LED_Mod[MAX_LED][4];  // for brightness
#endif

//static char datasentflag =0;

static uint16_t g_pwmData[(24*MAX_LED)+50];
/**
 * @brief Sets the RGB values for a specific LED.
 *
 * This function sets the RGB values (Red, Green, Blue) for a specified LED.
 *
 * @param[in] LEDnum The index of the LED.
 * @param[in] Red The intensity of the red color component (0-255).
 * @param[in] Green The intensity of the green color component (0-255).
 * @param[in] Blue The intensity of the blue color component (0-255).
 */
void Set_LED (int LEDnum, int Red, int Green, int Blue)
{
	g_LED_Data[LEDnum][0] = LEDnum;
	g_LED_Data[LEDnum][1] = Green;
	g_LED_Data[LEDnum][2] = Red;
	g_LED_Data[LEDnum][3] = Blue;
}

/**
 * @brief Sets the brightness of all LEDs.
 *
 * This function adjusts the brightness of all LEDs based on the given brightness level.
 * The brightness level ranges from 0 to 45. A higher value indicates a lower brightness.
 * Note: USE_BRIGHTNESS macro must be defined to enable brightness adjustment.
 *
 * @param[in] brightness The brightness level to be set (0-45).
 */

void Set_Brightness (int brightness)  // 0-45
{
#if USE_BRIGHTNESS

	if (brightness > 45) brightness = 45;
	for (int i=0; i<MAX_LED; i++)
	{
		g_LED_Mod[i][0] = g_LED_Data[i][0];
		for (int j=1; j<4; j++)
		{
			float angle = 90-brightness;  // in degrees
			angle = angle*PI / 180;  // in rad
			g_LED_Mod[i][j] = (g_LED_Data[i][j])/(tan(angle));
		}
	}

#endif

}

/**
 * @brief Sends the RGB data to WS2812 LED strip.
 *
 * This function constructs the PWM data for the WS2812 LED strip based on the RGB data set previously.
 * It encodes the RGB data into PWM signals and sends them to the LED strip for display.
 * Note: USE_BRIGHTNESS macro must be defined to enable brightness adjustment.
 */

void WS2812_Send (void)
{
	uint32_t indx=0;
	uint32_t color;

	for (int i= 0; i<MAX_LED; i++)
	{
#if USE_BRIGHTNESS
		color = ((g_LED_Mod[i][1]<<16) | (g_LED_Mod[i][2]<<8) | (g_LED_Mod[i][3]));
#else
		color = ((g_LED_Data[i][1]<<16) | (g_LED_Data[i][2]<<8) | (g_LED_Data[i][3]));
#endif

		for (int i=23; i>=0; i--)
		{
			if (color&(1<<i))
			{
				g_pwmData[indx] = 53;  // 2/3 of 90
			}

			else g_pwmData[indx] = 27;  // 1/3 of 90

			indx++;
		}

	}

	for (int i=0; i<50; i++)
	{
		g_pwmData[indx] = 0;
		indx++;
	}

	HAL_TIM_PWM_Start_DMA(&htim1, TIM_CHANNEL_2, (uint32_t *)g_pwmData, indx);
//	while (!datasentflag){};
//	datasentflag = 0;
}
