/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "dma.h"
#include "iwdg.h"
#include "spi.h"
#include "tim.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "mfrc522.h"
//#include <stdio.h>
#include "Common.h"
#include "ws2812_led.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

	static uint8_t g_txframe[6],g_buff[30];
	static int g_status;
	static uint8_t g_CardID[4];
	static uint8_t g_type;
	static uint8_t sensitivity_data=0;
//	static uint8_t AllowedCardID[4] = { 0x4D, 0xAF, 0x84, 0x59 };
//	uint16_t line;
//	uint8_t allowed = 0; // For communication with the servo motor
//	uint8_t stringlen=0;


//	int pass_cnt,fail_con=0;

	unsigned int generated_CRC=0,Recieved_CRC=0;

	extern volatile char cardRXenable;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
 HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_SPI1_Init();
  MX_USART1_UART_Init();
  MX_IWDG_Init();
  MX_TIM1_Init();
  /* USER CODE BEGIN 2 */
  MFRC522_Init();
  HAL_Delay(100);
  g_blink=0;
  g_stage_change=1;
  g_stage_level=Init;
  g_error_code=0;

  /*		Comment by Nihar For Adani
  //initially blue color
	for (int i=0; i<13; i++)
	{
	Set_LED(i,0,0,255 );
	//HAL_Delay (50);
	}
  */
	WS2812_Send();
	HAL_Delay(20);
	sensitivity_data = MFRC522_ReadRegister(MFRC522_RFC_FG_REG);
	HAL_UART_Receive_IT(&huart1,&g_u1rxbyte,1);


  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
	//  WS2812_Send();
	  HAL_IWDG_Refresh(&hiwdg);
	  /////////////////////RFID section////////////////////////
	  		  	g_status = MFRC522_CheckCard(g_CardID, &g_type);
	  	  		if (g_status == RFID_OK)
	  	  		{
//	  	  			pass_cnt++;
//	  				int temp_buff[10]={0};
	  	  			 for(char i=0;i<4;i++)
	  				 {
	  	  				g_txframe[i] = g_CardID[i];
	  				 }


	  	  			int g_BuffIndex=0;
	  				g_buff[g_BuffIndex++]=0x5A;//START BYTE1
	  				g_buff[g_BuffIndex++]=0xA5;//START BYTE2
	  				g_buff[g_BuffIndex++]=0x00;//data length
	  				g_buff[g_BuffIndex++]=0X52;// Frame type
	  				g_buff[g_BuffIndex++]=Hex_ascii((g_CardID[3] & 0xf0) >>4)  ;//data
	  				g_buff[g_BuffIndex++]= Hex_ascii(g_CardID[3] & 0x0f) ;
	  				g_buff[g_BuffIndex++]=Hex_ascii((g_CardID[2] & 0xf0) >>4);//data
	  				g_buff[g_BuffIndex++]=Hex_ascii(g_CardID[2] & 0x0f) ;
	  				g_buff[g_BuffIndex++]=Hex_ascii((g_CardID[1] & 0xf0) >>4);//data
	  				g_buff[g_BuffIndex++]=Hex_ascii(g_CardID[1] & 0x0f) ;
	  				g_buff[g_BuffIndex++]=Hex_ascii((g_CardID[0] & 0xf0)  >>4);//data
	  				g_buff[g_BuffIndex++]=Hex_ascii(g_CardID[0] & 0x0f) ;
	  //				memcpy(&g_buff[g_BuffIndex],temp_buff,strlen(temp_buff)); //6 &7

	  	  			g_buff[g_BuffIndex++]=0x03; //END BYTE


	  				g_buff[2]=g_BuffIndex-3; //data length
	  				HAL_UART_Transmit(&huart1, (uint8_t*)g_buff,g_BuffIndex,0xffff);


	  	  			g_CardID[0]=g_CardID[1]=g_CardID[2]=g_CardID[3]=0;
	  //				MFRC522_PrettyPrint((unsigned char*) CardID, sizeof(CardID), &result);
	  //				printf("Found tag: %s\r\n", result);

	  //				Clear the display and start at line 1 again
	  //	  			if (line >= 20) {
	  //	  				//BSP_LCD_Clear(LCD_COLOR_WHITE);
	  //	  				line = 0;
	  //			}

	  //	  			snprintf(lcd_msg_1, sizeof(lcd_msg_1), "Found tag: %s", result);
	  //	  			BSP_LCD_DisplayStringAtLine(line, lcd_msg_1);
	  //	  			line++;
	  //
	  //	  			MFRC522_PrettyPrint((unsigned char&hspi1&hspi1*) &type, 1, &result);
	  //	  			printf("Type is: %s\r\n", result);

	  // 			Check if card is allowed
	  //	  			if (MFRC522_CompareIDs(CardID, AllowedCardID) == RFID_OK) {
	  ////	  				printf("Known ID, access is allowed\r\n");
	  ////
	  //
	  ////	  				snprintf(lcd_msg_2, sizeof(lcd_msg_2), "Access is allowed");
	  ////	  				BSP_LCD_DisplayStringAtLine(line, lcd_msg_2);
	  ////	  				BSP_LED_On(LED_GREEN);
	  ////	  				BSP_LED_Off(LED_RED);
	  //
	  //	  			}
	  //	  			else
	  //	  			{
	  ////	  				printf("Unknown ID, access is denied\r\n");
	  ////
	  ////	  				snprintf(lcd_msg_2, sizeof(lcd_msg_2), "Access is denied");
	  ////	  				BSP_LCD_DisplayStringAtLine(line, lcd_msg_2);
	  ////	  				line++;
	  //	  			}

	  	  		}
	    	  	  	else
	    	  	  	{
	  	  			if (g_status == RFID_ERR)
	  	  			{
//	  	  				fail_con++;
	  //	  				printf("Error\r\n");
	  	  			g__half_red_blink =1;
	  				  g_blink=1;

	  	  			}
	  	  		}
	  	 		g_status=0;

	  ////////////LED logic//////////////////
	  if(g_blink == 1)
	  {
		  if(g_red_blink == 1)
		  {
		  for (int i=0; i<13; i++)
		  	  	{
		  			Set_LED(i, 255,0, 0);	//red green blue
		  			WS2812_Send();
		  			 HAL_Delay(20);
		  	  	}
		  for (int i=13; i>=0; i--)
		  		{
		  			Set_LED(i, 0,0, 0);
		  			WS2812_Send();
		  			 HAL_Delay(20);
		  		}
		  g_red_blink=0;
		  }
		  else if(g_auth_failed_blink == 1)
		  {
			  for (int i=0; i<13; i++)
					{
						Set_LED(i, 255, 255,  0);	//red green blue
						WS2812_Send();
						 HAL_Delay(20);
					}
			  for (int i=13; i>=0; i--)
					{
						Set_LED(i, 0,0, 0);
						WS2812_Send();
						 HAL_Delay(20);
					}
			 g_auth_failed_blink=0;
		  }
		  else if(g__half_red_blink == 1)
		  {

			  for (int i=0; i<6; i++)
				{
					Set_LED(i, 255,0, 0);	//red green blue
					WS2812_Send();
					 HAL_Delay(20);
				}
			  for (int i=6; i>=13; i--)
				{
					Set_LED(i, 0,0, 0);
					WS2812_Send();
					 HAL_Delay(20);
				}
		  g__half_red_blink=0;
		  }
		  else if(g_purple_blink == 1)
		  {
			for (int i=0; i<13; i++)
				{
					Set_LED(i, 255,0, 255);	//red green blue
					WS2812_Send();
					 HAL_Delay(20);
				}
			for (int i=13; i>=0; i--)
				{
					Set_LED(i, 0,0, 0);
					WS2812_Send();
					 HAL_Delay(20);
				}
			g_purple_blink=0;
		  }
		  else if(g_blue_blink == 1)
		  {
			  for (int i=13; i>=0; i--)
			{
				Set_LED(i, 0,0, 0);
				WS2812_Send();
				 HAL_Delay(20);
			}
			  for (int i=0; i<13; i++)
				{
					Set_LED(i, 0,0, 255);	//red green blue
					WS2812_Send();
					 HAL_Delay(20);
				}

			g_blue_blink=0;
		  }

		  else if(g_green_blink == 1)		//Added by Nihar For Adani
		  {
			  for (int i=13; i>=0; i--)
			  {
				  Set_LED(i, 0,0, 0);
				  WS2812_Send();
				  HAL_Delay(20);
			  }
			  for (int i=0; i<13; i++)
			  {
				  Set_LED(i, 0,255, 0);
				  WS2812_Send();
				  HAL_Delay(20);
			  }

			  g_green_blink = 0;
		  }

		  else if(g_emred_blink == 1)		//Added by Nihar For Adani
		  {
			  for (int i=13; i>=0; i--)
			  {
				  Set_LED(i, 0,0, 0);
				  WS2812_Send();
				  HAL_Delay(10);
			  }
			  for (int i=0; i<13; i++)
			  {
				  Set_LED(i, 255,0, 0);
				  WS2812_Send();
				  HAL_Delay(10);
			  }

			  g_emred_blink = 0;
		  }

		  /*********Added FOTA RGB Color ************/
		  else if(g_fota_blink == 1)	//Added by Nihar For Adani
		  {
			  for (int i=13; i>=0; i--)
			  {
				  Set_LED(i, 0,0, 0);
				  WS2812_Send();
				  HAL_Delay(10);
			  }
			  for (int i=0; i<13; i++)
			  {
				  Set_LED(i, 128, 128, 128);
				  WS2812_Send();
				  HAL_Delay(10);
			  }
			  g_fota_blink =0;
		  }
		  else if(g_fota_stuck == 1)	//Added by Nihar For Adani
		  {
			  for (int i=0; i<7; i++)
			  {
				  Set_LED(i, 128, 128, 128);
				  WS2812_Send();
				  HAL_Delay(10);
			  }
			  for (int i=7; i<13; i++)
			  {
				  Set_LED(i, 0, 0, 0);
				  WS2812_Send();
				  HAL_Delay(10);
			  }
			  g_fota_stuck = 0;
		  }
		  else if(g_fota_failed  == 1)
		  {
			  for (int i=0; i<7; i++)
			  {
				  Set_LED(i, 128, 128, 128);
				  WS2812_Send();
				  HAL_Delay(10);
			  }
			  for (int i=7; i<13; i++)
			  {
				  Set_LED(i, 255, 0, 0);
				  WS2812_Send();
				  HAL_Delay(10);
			  }
			  g_fota_failed = 0;
		  }


		  g_blink=0;
		  g_stage_change=1;
	  }
	  else
	  {
		   if(g_stage_level == 6)		//config Stage
		  {
			for (int i=13; i>=0; i--)
			{
				Set_LED(i, 255,0, 255);	//red green blue
				WS2812_Send();
				 HAL_Delay(20);
			}
		  }
		  else if(g_stage_change == 1)
		  {
			  if(g_stage_level == Init)
			  {
				  for (int i=0; i<13; i++)	//red green blue
					{
						Set_LED(i, 255,255,0);
						WS2812_Send();
						 HAL_Delay(20);
					}
			  }
			  /*		// COMMENT FOR ADANI  // Comment by Nihar
			  else if(g_stage_level == Available)			//Available Stage
			  {
				for (int i=0; i<13; i++)	//red green blue
				{
					Set_LED(i, 0,0, 255);
					WS2812_Send();
					 HAL_Delay(20);
				}
			  }
			  else if(g_stage_level == Preparing)		//Preparing Stage
			  {
				  g_blue_blink=1;
				  g_blink=1;
			  }
			  else if(g_stage_level == Charging)		//Charging Stage
			  {
				for (int i=13; i>=0; i--)
				{
					Set_LED(i, 0,255, 0);	//red green blue
					WS2812_Send();
					 HAL_Delay(20);
				}
			  }
			  */

			  // Below Added By Nihar For Adani
			  else if(g_stage_level == Available)			//Available Stage
			  {
				for (int i=0; i<13; i++)	//red green blue
				{
					g_green_blink = 1;
					g_blink = 1;
				}
			  }
			  else if(g_stage_level == Preparing)		//Preparing Stage
			  {
				  for (int i=0; i<13; i++)
				  {
					  Set_LED(i, 0,255, 0);		//Green For Adani
					  WS2812_Send();
					  HAL_Delay(20);
				  }
			  }
			  else if(g_stage_level == Charging)		//Charging Stage
			  {
				for (int i=13; i>=0; i--)
				{
					g_blue_blink = 1;
					g_blink = 1;
				}
			  }

			   if(g_stage_level == Error)	   //Fault Stage
			  {
				  if(g_error_code == NoError)		//No error
				  {
						g_stage_level=1;
						g_green_blink = 1;		// ADDED FOR ADANI Added by Nihar
						g_blink = 1;			// ADDED FOR ADANI Added by Nihar

						/*		Comment For Adani comment by Nihar
						for (int i=0; i<13; i++)
						{
							Set_LED(i, 0,0, 255);	//red green blue
							WS2812_Send();
							 HAL_Delay(20);
						}
						*/
				  }
				  else if(g_error_code == Internet_err)	//Internet Error	//%25 red lights only
				  {
					  for (int i=0; i<3; i++)
						{
							Set_LED(i, 255,0, 0);	//red green blue
						}
					  for (int i=3; i<13; i++)
						{
							Set_LED(i, 0,0, 0);
						}
						WS2812_Send();
						 HAL_Delay(20);
				  }
				  else if(g_error_code == Ocpp_err)	//OCPP error	//%50 error solve
				  {
					  for (int i=0; i<6; i++)
						{
						  Set_LED(i, 255,0, 0);
						}
					  for (int i=6; i<13; i++)
						{
							Set_LED(i, 0,0, 0);
						}
						WS2812_Send();
						 HAL_Delay(20);
				  }
				  else if(g_error_code == Protection_err)	//Protection Error	//75%error
				  {
					  for (int i=0; i<9; i++)
						{
						  Set_LED(i, 255,0, 0);
						}
					  for (int i=9; i<13; i++)
						{
							Set_LED(i, 0,0, 0);
						}
						WS2812_Send();
						 HAL_Delay(20);
				  }
				  else if(g_error_code == Emergancy_err)	//Emergancy press
				  {
					  // Added By Nihar For Adani
					  g_emred_blink = 1;
					  g_blink = 1;

					  /*		// Comment By Nihar For Adani
					  for (int i=13; i>=0; i--)
					{
						  Set_LED(i, 255,0, 0);

					}
					  WS2812_Send();
					 HAL_Delay(20);
					 */
				  }

			  	  }
		  }			//stage change here
			  g_stage_change = 0;
	  }		//else ends here


	  if(g_u1_rxedFrame == 1)
	  {

		  if(g_u1_rxbuffer[1] == 0X50)
		  {
			  if(g_stage_level	!=	g_u1_rxbuffer[2])
			  {
				  g_stage_level	=	g_u1_rxbuffer[2];
				  g_stage_change=1;
			  }
			  if(g_error_code	!=  g_u1_rxbuffer[3])
			  {
				  g_error_code	=	g_u1_rxbuffer[3];
				  g_stage_change=1;
			  }

			//////////////////////////////////////////////////////////
			int g_BuffIndex=0;
			g_buff[g_BuffIndex++]=0x5A;//START BYTE1
			g_buff[g_BuffIndex++]=0xA5;//START BYTE2
			g_buff[g_BuffIndex++]=0x00;//data length
			g_buff[g_BuffIndex++]=0X51;// Frame type
			g_buff[g_BuffIndex++]=0x00;//data
			g_buff[g_BuffIndex++]=0x03; //END BYTE

			g_buff[2]=g_BuffIndex-3; //data length
			HAL_UART_Transmit(&huart1, (uint8_t*)g_buff,g_BuffIndex,0xffff);
			///////////////////////////////////////////////////////////////
		  }
		  else if(g_u1_rxbuffer[1] == 0X53)
		  {
			  if(g_u1_rxbuffer[2] == 1)		//RFID OK
			  {
				  g_purple_blink =1;
				  g_blink=1;
			  }
			  else if (g_u1_rxbuffer[2] == 3) 	//RFID auth failed
			  {
				  g_auth_failed_blink =1;
				  g_blink=1;
			  }
			  else							//RFID not OK
			  {
				  g_red_blink =1;
				  g_blink=1;
			  }
		  }

		  /*********Added FOTA RGB Color ************/

		  else if (g_u1_rxbuffer[1] == 0x94 || g_u1_rxbuffer[1] == 0x97) // FOTA command
		  {
		      uint8_t fota_value = g_u1_rxbuffer[2];

		      g_fota_blink = 0;
		      g_fota_stuck = 0;
		      g_fota_failed = 0;

		      switch (fota_value)
		      {
		          case 0x01: // Downloading
		              g_fota_blink = 1;
		              g_blink = 1;
		              break;

		          case 0x02: // Stuck
		              g_fota_stuck = 1;
		              break;

		          case 0x03: // Failed
		              g_fota_failed = 1;
		              break;

		          default:
		              // Unknown status
		              break;
		      }
		  }

//		  else if (g_u1_rxbuffer[1] == 0x54) // FOTA command
//		  {
//		      uint8_t fota_value = g_u1_rxbuffer[2];
//
//		      g_fota_blink = 0;
//		      g_fota_stuck = 0;
//		      g_fota_failed = 0;
//
//		      switch (fota_value)
//		      {
//		          case 0x01: // Downloading
//		              g_fota_blink = 1;
//		              g_blink = 1;
//		              break;
//		          case 0x02: // Stuck
//		              g_fota_stuck = 1;
//		              break;
//		          case 0x03: // Failed
//		              g_fota_failed = 1;
//		              break;
//		          default:
//		              // Unknown
//		              break;
//		      }
//		  }

//		  else if(g_u1_rxbuffer[1] == 0x54)		//Added by Nihar For Adani
//		  {
//			  if(g_u1_rxbuffer[2] == 1)		//FW Downloading
//			  {
//				  g_fota_blink = 1;
//				  g_blink = 1;
//			  }
//			  else if(g_u1_rxbuffer[2] == 2)	//FW Stuck
//			  {
//				  g_fota_stuck = 1;
//			  }
//			  else if(g_u1_rxbuffer[2] == 3)		//FW Fail
//			  {
//				  g_fota_failed = 1;
//			  }
//		  }

	  }
	  g_u1_rxedFrame=0;
	}


  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI|RCC_OSCILLATORTYPE_LSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSIDiv = RCC_HSI_DIV1;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.LSIState = RCC_LSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
  RCC_OscInitStruct.PLL.PLLM = RCC_PLLM_DIV1;
  RCC_OscInitStruct.PLL.PLLN = 8;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */
//void StartMFRC522Task(void *argument) {
//	/* Recognized card ID */
//	uint8_t CardID[4];
//	uint8_t type;
//	char *result;
//	int status;
//	uint16_t line = 0;
//	uint8_t lcd_msg_1[50];
//	uint8_t lcd_msg_2[50];
//
//	printf("Started MFRC522 task\r\n");
//
//	for (;;) {
//		status = MFRC522_CheckCard(CardID, &type);
//		if (status == RFID_OK) {
//			MFRC522_PrettyPrint((unsigned char*) CardID, sizeof(CardID), &result);
//			printf("Found tag: %s\r\n", result);
//
//			// Clear the display and start at line 1 again
//			if (line >= 20) {
//				BSP_LCD_Clear(LCD_COLOR_WHITE);
//				line = 0;
//			}
//
//			snprintf(lcd_msg_1, sizeof(lcd_msg_1), "Found tag: %s", result);
//			BSP_LCD_DisplayStringAtLine(line, lcd_msg_1);
//			line++;
//
//			MFRC522_PrettyPrint((unsigned char*) &type, 1, &result);
//			printf("Type is: %s\r\n", result);
//
//			// Check if card is allowed
//			if (MFRC522_CompareIDs(CardID, AllowedCardID) == RFID_OK) {
//				printf("Known ID, access is allowed\r\n");
//
//				snprintf(lcd_msg_2, sizeof(lcd_msg_2), "Access is allowed");
//				BSP_LCD_DisplayStringAtLine(line, lcd_msg_2);
//				BSP_LED_On(LED_GREEN);
//				BSP_LED_Off(LED_RED);
//				allowed = 1;
//				line++;
//			} else {
//				printf("Unknown ID, access is denied\r\n");
//
//				snprintf(lcd_msg_2, sizeof(lcd_msg_2), "Access is denied");
//				BSP_LCD_DisplayStringAtLine(line, lcd_msg_2);
//				line++;
//			}
//		} else {
//			if (status == RFID_ERR) {
//				printf("Error\r\n");
//			}
//		}
//
//		osDelay(1);
//	}
//}
/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
