/**************INCLUDE BLOCK**************/

#include "modbus.h"
#include "main.h"
#include "usart.h"
#include "w25qxx.h"

/***********INCLUDE BLOCK END*************/

/***** Data Type, Constant, and Macro Definitions *****/


union
{
	unsigned short int word;
	uint32_t dword;
	float dfloat;
	unsigned char byte[4];
} split_int;

/* Global variables*/

uint16_t enrgyread1_timouttick = 5000, enrgyread2_timouttick = 5000, enrgyread3_timouttick = 5000;
uint8_t energymeter_err[3];
volatile OCPP_States OCPP_State_ACType2;
char wifi_connected;
unsigned char meterquerycntr = 0;

unsigned char modbus_cmd;
unsigned short int modbus_addr;
short int modbus_dat;
unsigned short int modbus_length;
unsigned short int modbus_crc16;
unsigned short int cal_crc;
uint8_t rxmsg[100];
volatile uint32_t energy;
uint16_t temp;
char meter1whclear = 0, meter2whclear = 0;

/* Extern Data Declarations */

//extern uint8_t powerfailure_flag;
extern uint8_t meter_failed;
// extern uint8_t gun_3, gun_2, gun_1, gun, RCD2_stop, RCD1_stop, RCD3_stop;
extern char Send_meter;

/* Static Data Declarations */

static unsigned char modbus_device_addr;

/***** Data Type, Constant, and Macro Definitions END *****/

/***** Public Function Bodies *****/
uint16_t ModCRC(uint8_t buf[], int len);

/***** Public Function Bodies END *****/

/**
 * @brief Calculate the Modbus CRC (Cyclic Redundancy Check) for a given data block.
 *
 * This function calculates the Modbus CRC using the standard polynomial 0xA001.
 *
 * @param[in] buf Pointer to the data block.
 * @param[in] len Length of the data block.
 * @return The calculated Modbus CRC.
 */
uint16_t ModCRC(uint8_t buf[], int len)
{
	uint16_t crc = 0xFFFF;

	for (int pos = 0; pos < len; pos++)
	{
		crc ^= (uint16_t)buf[pos]; // XOR byte into least sig. byte of crc

		for (int i = 8; i != 0; i--)
		{ // Loop over each bit
			if ((crc & 0x0001) != 0)
			{			   // If the LSB is set
				crc >>= 1; // Shift right and XOR 0xA001
				crc ^= 0xA001;
			}
			else		   // Else LSB is not set
				crc >>= 1; // Just shift right
		}
	}
	// Note, this number has low and high bytes swapped, so use it accordingly (or swap bytes)
	return crc;
}
/**
 * @brief Check and process Modbus messages.
 *
 * This function checks and processes Modbus messages received via UART.
 * It calculates the CRC, checks the validity of the message, and updates charger status accordingly.
 *
 * @return NA (No meaningful return value).
 */
void modbus_check(void)
{
	enrgyread1_timouttick = 20000;
	modbus_device_addr = rxmsg[0];
	uint16_t lclCRCchk = 0;
	unsigned short TEMP = 0;
	uint8_t temparray[2];

	// uint8_t buff[50];
	lclCRCchk = ModCRC(rxmsg, 35);
	TEMP = (lclCRCchk & 0X00FF);
	temparray[0] = (uint8_t)(TEMP);
	lclCRCchk >>= 8;
	TEMP = 0;
	TEMP = (lclCRCchk & 0X00FF);
	temparray[1] = (uint8_t)(TEMP);
	if (modbus_device_addr == 0x01)
	{
		if ((temparray[0] == rxmsg[35]) && (temparray[1] == rxmsg[36]))
		{

			split_int.byte[3]  = rxmsg[3];
			split_int.byte[2]  = rxmsg[4];
			split_int.byte[1]  = rxmsg[5];
			split_int.byte[0]  = rxmsg[6]; // VOLTAGE
			charger_status_G1.voltage = split_int.dword / 10000;

			split_int.byte[3]  = rxmsg[7];
			split_int.byte[2]  = rxmsg[8];
			split_int.byte[1]  = rxmsg[9];
			split_int.byte[0]  = rxmsg[10]; // CURRENT
			charger_status_G1.current = (float)split_int.dword / 10000;

			split_int.byte[3]  = rxmsg[11];
			split_int.byte[2]  = rxmsg[12];
			split_int.byte[1]  = rxmsg[13];
			split_int.byte[0]  = rxmsg[14]; // KW
			charger_status_G1.power = (float)split_int.dword / 10000;

			split_int.byte[3] /*= hmi[18]*/ = rxmsg[15];
			split_int.byte[2] /*= hmi[19]*/ = rxmsg[16];
			split_int.byte[1] /*= hmi[20]*/ = rxmsg[17];
			split_int.byte[0] /*= hmi[21]*/ = rxmsg[18]; // ENERGY

			energy = (uint32_t)split_int.dword / 10;

			///////////////////////////////////////////////////////////////////////////////////////

//			if (charger_status_G1.charging_status == Charging_ChargerPoint)
//			{
//				charger_status_G1.energy = (unsigned long int)energy - (unsigned int)charger_status_G1.start_energy;
//			}
//			else
//			{
//				charger_status_G1.energy = 0;
//			}

		}
	}

}
/**
 * @brief Perform energy meter read/write operations.
 *
 * This function sends commands to the energy meter via UART based on the specified operation.
 *
 * @param[in] rw Operation type:
 *            - 1: Write command for Meter 1 (sends the query for meter 1).
 *            - 2: Write command for Meter 2 (sends the query for meter 2).
 *            - 3: Write command for Meter 3 (sends the query for meter 3).
 *            - 4: Write command to clear accumulated energy for Meter 1.
 *            - 5: Write command to clear accumulated energy for Meter 2.
 *            - 6: Write command to clear accumulated energy for Meter 3.
 *
 *@return NA
 */
void Energy_MeterRead(char rw)
{
	uint8_t buff[12];
	if (rw == 1)
	{
		buff[0] = 0x01;
		buff[1] = 0x03;
		buff[2] = 0x00;
		buff[3] = 0x48; // write
		buff[4] = 0x00;
		buff[5] = 0x08;
		buff[6] = 0xC4;
		buff[7] = 0x1A;
		HAL_UART_Transmit(&hlpuart1, (uint8_t *)buff, 8, 0xffff);
		// __HAL_UART_FLUSH_DRREGISTER(&huart1);
		// HAL_UART_Receive_DMA(&huart1,(uint8_t*)rxmsg,97); =
		Send_meter = 1;
	}

	else if (rw == 2)
	{
		buff[0] = 0x02;
		buff[1] = 0x03;
		buff[2] = 0x00;
		buff[3] = 0x48; // write
		buff[4] = 0x00;
		buff[5] = 0x08;
		buff[6] = 0xC4;
		buff[7] = 0x29;
		HAL_UART_Transmit(&hlpuart1, (uint8_t *)buff, 8, 0xffff);
		Send_meter = 2;
	}
	else if (rw == 3)
	{
		buff[0] = 0x03;
		buff[1] = 0x03;
		buff[2] = 0x00;
		buff[3] = 0x48; // write
		buff[4] = 0x00;
		buff[5] = 0x08;
		buff[6] = 0xC5;
		buff[7] = 0xf8;
		HAL_UART_Transmit(&hlpuart1, (uint8_t *)buff, 8, 0xffff);
	}

	else if (rw == 4)
	{
		buff[0] = 0x01;
		buff[1] = 0x10;
		buff[2] = 0x00;
		buff[3] = 0x4B; // write 0 yn to kwh
		buff[4] = 0x00;
		buff[5] = 0x02;
		buff[6] = 0x04;
		buff[7] = 0x00;
		buff[8] = 0x00;
		buff[9] = 0x00;
		buff[10] = 0x00;
		buff[11] = 0xB6;
		buff[12] = 0x2C;
		HAL_UART_Transmit(&hlpuart1, (uint8_t *)buff, 13, 0xffff);
		meter1whclear = 0;
	}
	else if (rw == 5)
	{
		buff[0] = 0x02;
		buff[1] = 0x10;
		buff[2] = 0x00;
		buff[3] = 0x4B; // write 0 INK
		buff[4] = 0x00;
		buff[5] = 0x02;
		buff[6] = 0x04;
		buff[7] = 0x00;
		buff[8] = 0x00;
		buff[9] = 0x00;
		buff[10] = 0x00;
		buff[11] = 0xB9;
		buff[12] = 0x68;
		HAL_UART_Transmit(&hlpuart1, (uint8_t *)buff, 13, 0xffff);
		meter2whclear = 0;
	}
}
