/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * @file           : main.c
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * Copyright (c) 2025 STMicroelectronics.
 * All rights reserved.
 *
 * This software is licensed under terms that can be found in the LICENSE file
 * in the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "adc.h"
#include "dma.h"
#include "fdcan.h"
#include "iwdg.h"
#include "usart.h"
#include "rtc.h"
#include "spi.h"
#include "tim.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include <stdio.h>
#include <string.h>
#include "modbus.h"
#include "w25qxx.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define GUN1_RED_LED_ON		{HAL_TIM_PWM_Stop_IT(&htim1, TIM_CHANNEL_3); HAL_TIM_PWM_Stop_IT(&htim1, TIM_CHANNEL_2); HAL_TIM_PWM_Start_IT(&htim1, TIM_CHANNEL_1);}
#define GUN1_GREEN_LED_ON 	{HAL_TIM_PWM_Stop_IT(&htim1, TIM_CHANNEL_3); HAL_TIM_PWM_Stop_IT(&htim1, TIM_CHANNEL_1); HAL_TIM_PWM_Start_IT(&htim1, TIM_CHANNEL_2);}
#define GUN1_BLUE_LED_ON 	{HAL_TIM_PWM_Stop_IT(&htim1, TIM_CHANNEL_1); HAL_TIM_PWM_Stop_IT(&htim1, TIM_CHANNEL_2); HAL_TIM_PWM_Start_IT(&htim1, TIM_CHANNEL_3);}

#define GUN2_RED_LED_ON		{HAL_TIM_PWM_Stop_IT(&htim4, TIM_CHANNEL_2); HAL_TIM_PWM_Stop_IT(&htim4, TIM_CHANNEL_3); HAL_TIM_PWM_Start_IT(&htim4, TIM_CHANNEL_1);}
#define GUN2_GREEN_LED_ON 	{HAL_TIM_PWM_Stop_IT(&htim4, TIM_CHANNEL_1); HAL_TIM_PWM_Stop_IT(&htim4, TIM_CHANNEL_3); HAL_TIM_PWM_Start_IT(&htim4, TIM_CHANNEL_2);}
#define GUN2_BLUE_LED_ON 	{HAL_TIM_PWM_Stop_IT(&htim4, TIM_CHANNEL_1); HAL_TIM_PWM_Stop_IT(&htim4, TIM_CHANNEL_2); HAL_TIM_PWM_Start_IT(&htim4, TIM_CHANNEL_3);}

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
#define RELAY_ON_TIME 20  // 2 second if timer fires every 100 ms
#define RELAY_OFF_TIME 40 // 4 seconds total

#define ADC_BUFFER_SIZE 6
volatile uint16_t adcValues[ADC_BUFFER_SIZE];
volatile int averaging[ADC_BUFFER_SIZE][10], sensor_value[ADC_BUFFER_SIZE];

uint32_t ch1_averaging = 0, ch2_averaging = 0, ch3_averaging = 0, ch4_averaging = 0, ch5_averaging = 0, ch6_averaging = 0;
volatile float tempvolt[ADC_BUFFER_SIZE];
volatile uint8_t tempsen[ADC_BUFFER_SIZE];

//CP1 and CP2 ADC read
uint32_t ADC_CP1, ADC_CP2;
volatile float CP1_VOLT = 0, CP2_VOLT = 0;

volatile char update_modbus = 1;
extern uint8_t M_buff;

volatile uint8_t temp_min = 35, temp_max = 55;
uint8_t adccmpl = 0, offset = 30, stop_fanpwm = 0; //offset = 32 for testing | original value = 30
float vt_factor = 2.657;
volatile uint8_t redled = 0, blueled = 0, greenled = 0, change = 0;
static volatile uint16_t tim15_tick = 0, brinc = 1, brdec = 0, brightnesscntr = 0;

//For energy meter read
uint8_t trigger;

// FDCAN
FDCAN_TxHeaderTypeDef TxHeader1, TxHeader2, TxHeader3;
FDCAN_RxHeaderTypeDef RxHeader;
uint8_t TxData1[8] = { 0xFF, 0x00, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x0A };
uint8_t RxData[8];

extern FDCAN_HandleTypeDef hfdcan1;
extern FDCAN_HandleTypeDef hfdcan2;
extern FDCAN_HandleTypeDef hfdcan3;

extern char Send_meter;
extern char meter1whclear, meter2whclear;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
void setup_can(FDCAN_HandleTypeDef *hfdcan, FDCAN_TxHeaderTypeDef *txHeader, uint32_t id)
{
	txHeader->Identifier = id;
	txHeader->IdType = FDCAN_EXTENDED_ID;
	txHeader->TxFrameType = FDCAN_DATA_FRAME;
	txHeader->DataLength = FDCAN_DLC_BYTES_8;
	txHeader->ErrorStateIndicator = FDCAN_ESI_ACTIVE;
	txHeader->BitRateSwitch = FDCAN_BRS_OFF;
	txHeader->FDFormat = FDCAN_CLASSIC_CAN;
	txHeader->TxEventFifoControl = FDCAN_NO_TX_EVENTS;
	txHeader->MessageMarker = 0;

	HAL_FDCAN_Start(hfdcan);
	HAL_FDCAN_ActivateNotification(hfdcan, FDCAN_IT_RX_FIFO0_NEW_MESSAGE, 0);
}

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_ADC1_Init();
  MX_ADC2_Init();
  MX_ADC3_Init();
  MX_FDCAN1_Init();
  MX_FDCAN2_Init();
  MX_FDCAN3_Init();
  MX_SPI1_Init();
  MX_SPI2_Init();
  MX_USART1_UART_Init();
  MX_LPUART1_UART_Init();
  MX_TIM1_Init();
  MX_TIM2_Init();
  MX_TIM3_Init();
  MX_TIM4_Init();
  MX_TIM5_Init();
  // MX_IWDG_Init();
  MX_RTC_Init();
  MX_TIM15_Init();
  /* USER CODE BEGIN 2 */
	HAL_TIM_Base_Start_IT(&htim1);
	HAL_TIM_Base_Start_IT(&htim15);

	HAL_Delay(1000);

	HAL_ADC_Start_DMA(&hadc1, (uint32_t*)adcValues, ADC_BUFFER_SIZE);
	HAL_ADC_Start_DMA(&hadc2, (uint32_t*)&ADC_CP1, 1);
	HAL_ADC_Start_DMA(&hadc3, (uint32_t*)&ADC_CP2, 1);

	HAL_Delay(1000);

	HAL_UART_Receive_IT(&hlpuart1, (uint8_t*) &M_buff, 1);

	W25qxx_Init(); // same on AC Charger
	blueled = 1;
	change = 1;

	setup_can(&hfdcan1, &TxHeader1, 0x101);
	setup_can(&hfdcan2, &TxHeader2, 0x102);
	setup_can(&hfdcan3, &TxHeader3, 0x103);


	ALL_RELAYON
//	HAL_Delay(2000);
//	ALL_RELAYOFF

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
	while (1)
	{
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
		if (change == 1)
		{
			change = 0;
			if (redled == 1)
			{
				GUN1_RED_LED_ON
				GUN2_RED_LED_ON // NO RED
			}
			else if (greenled == 1)
			{
				GUN1_GREEN_LED_ON
				GUN2_GREEN_LED_ON
			}
			else if (blueled == 1)
			{
				GUN1_BLUE_LED_ON
				GUN2_BLUE_LED_ON
			}
		}
		HAL_Delay(100);
	}
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.LSIState = RCC_LSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLM = RCC_PLLM_DIV2;
  RCC_OscInitStruct.PLL.PLLN = 48;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLQ = RCC_PLLQ_DIV2;
  RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV4;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_4) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */

void HAL_FDCAN_RxFifo0Callback(FDCAN_HandleTypeDef *hfdcan, uint32_t RxFifo0ITs)
{
	if ((RxFifo0ITs & FDCAN_IT_RX_FIFO0_NEW_MESSAGE) != RESET)		// Checks if the "new message received" bit is set in the interrupt flags.
	{
		if(hfdcan->Instance == FDCAN1)
		{
			if (HAL_FDCAN_GetRxMessage(&hfdcan1, FDCAN_RX_FIFO0, &RxHeader, RxData) != HAL_OK)
			{
				Error_Handler();
			}
		}
		if(hfdcan->Instance == FDCAN2)
		{
			if (HAL_FDCAN_GetRxMessage(&hfdcan2, FDCAN_RX_FIFO0, &RxHeader, RxData) != HAL_OK)
			{
				Error_Handler();
			}
		}
		if(hfdcan->Instance == FDCAN3)
		{
			if (HAL_FDCAN_GetRxMessage(&hfdcan3, FDCAN_RX_FIFO0, &RxHeader, RxData) != HAL_OK)
			{
				Error_Handler();
			}
		}
	}
}

/**
 * @brief  Period elapsed callback in non blocking mode
 * @note   This function is called  when TIM6 interrupt took place, inside
 * HAL_TIM_IRQHandler(). It makes a direct call to HAL_IncTick() to increment
 * a global variable "uwTick" used as application time base.
 * @param  htim : TIM handle
 * @retval None
 */
void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim)
{
	/* USER CODE BEGIN Callback 0 */
	if (htim->Instance == TIM1)
	{
		//LED1
		if (brinc == 1)
		{
			if (++brightnesscntr > 100)
			{
				brightnesscntr = 100;
				brinc = 0;
				brdec = 1;
			}
		}
		else if (brdec == 1)
		{
			if (--brightnesscntr < 10)
			{
				brightnesscntr = 10;		// Keeps it within safe bounds
				brinc = 1;
				brdec = 0;

				if (blueled)
				{
					greenled = 1;
					blueled = 0;
					redled = 0;
				}
				else if (greenled)
				{
					redled = 1;
					greenled = 0;
					blueled = 0;
				}
				else if (redled)
				{
					blueled = 1;
					redled = 0;
					greenled = 0;
				}
				change = 1;
			}
		}
//		redled = 1;
//		change = 1;
//		brightnesscntr = 100;
		htim1.Instance->CCR1 = htim1.Instance->CCR2 = htim1.Instance->CCR3 = brightnesscntr;
		htim4.Instance->CCR2 = htim4.Instance->CCR3 = htim4.Instance->CCR4 = brightnesscntr;
	}
	else if (htim->Instance == TIM4)
	{
		//LED2
	}
	else if (htim->Instance == TIM15)
	{
		//100 ms timer
		++tim15_tick;
		HAL_ADC_Start_DMA(&hadc2, &ADC_CP1, 1);
		CP1_VOLT = (float) (ADC_CP1 * (3.3 / 4096));



		if (tim15_tick == RELAY_ON_TIME)
		{
			HAL_FDCAN_AddMessageToTxFifoQ(&hfdcan2, &TxHeader1, TxData1);
			// ALL_RELAYON
		}
		else if (tim15_tick == RELAY_OFF_TIME)
		{
			//  ALL_RELAYOFF
			tim15_tick = 0;
		}
		if(++trigger > 10)
		{
			trigger = 0;
			Energy_MeterRead(1);

			HAL_ADC_Start_DMA(&hadc3, &ADC_CP2, 1);
			CP2_VOLT = (float) (ADC_CP2 * (3.3 / 4096));
		}


//		if(Send_meter)
//		{
//			if(++trigger > 60)
//			{
//				Send_meter = 0;
//				trigger = 0;
//			}
//		}
//		else
//		{
//			trigger = 0;
//
//			if (meter1whclear == 0)
//			{
//				Energy_MeterRead(1);
//			}
////			else
////			{
////				Energy_MeterRead(4);
////			}
//		}
	}

	/* USER CODE END Callback 0 */

	/* USER CODE BEGIN Callback 1 */

	/* USER CODE END Callback 1 */
}


void HAL_ADC_ConvCpltCallback(ADC_HandleTypeDef *hadc)
{
	static uint8_t avgcnt = 0;

	if(hadc->Instance == ADC1)
	{
		HAL_ADC_Start_DMA(&hadc1, (uint32_t*)adcValues, ADC_BUFFER_SIZE);

		ch1_averaging += adcValues[0];
		ch2_averaging += adcValues[1];
		ch3_averaging += adcValues[2];
		ch4_averaging += adcValues[3];
		ch5_averaging += adcValues[4];
		ch6_averaging += adcValues[5];

		avgcnt++;

		if(avgcnt > 9)
		{
			avgcnt = 0;

			tempvolt[0] = (float)(ch1_averaging *(3.3 / 4096));
			tempsen[0] = (uint8_t) (((tempvolt[0] * 10) / vt_factor) - offset);
			ch1_averaging = 0;

			tempvolt[1] = (float)(ch2_averaging *(3.3 / 4096));
			tempsen[1] = (uint8_t) (((tempvolt[1] * 10) / vt_factor) - offset);
			ch2_averaging = 0;

			tempvolt[2] = (float)(ch3_averaging *(3.3 / 4096));
			tempsen[2] = (uint8_t) (((tempvolt[2] * 10) / vt_factor) - offset);
			ch3_averaging = 0;


			tempvolt[3] = (float)(ch4_averaging *(3.3 / 4096));
			tempsen[3] = (uint8_t) (((tempvolt[3] * 10) / vt_factor) - offset);
			ch4_averaging = 0;


			tempvolt[4] = (float)(ch5_averaging *(3.3 / 4096));
			tempsen[4] = (uint8_t) (((tempvolt[4] * 10) / vt_factor) - offset);
			ch5_averaging = 0;


			tempvolt[5] = (float)(ch6_averaging *(3.3 / 4096));
			tempsen[5] = (uint8_t) (((tempvolt[5] * 10) / vt_factor) - offset);
			ch6_averaging = 0;
		}
	}
//	 else if(hadc->Instance == ADC2)
//	{
//		 HAL_ADC_Start_DMA(&hadc2, &ADC_CP1, 1);
//		//HAL_ADC_Start_IT(&hadc2);
//		//ADC_CP1 = HAL_ADC_GetValue(&hadc2);
//		CP1_VOLT = (float) (ADC_CP1 * (3.3 / 4096));
//	//	ADC_CP1 = 0;
//	}
//	else if(hadc->Instance == ADC3)
//	{
//		 HAL_ADC_Start_DMA(&hadc3, &ADC_CP2, 1);
//		//HAL_ADC_Start_IT(&hadc3);
//		// ADC_CP1 = HAL_ADC_GetValue(&hadc3);
//		CP2_VOLT = (float) (ADC_CP2 * (3.3 / 4096));
//	//	ADC_CP2 = 0;
//	}
}
/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
