/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "dma.h"
#include "rtc.h"
#include "spi.h"
#include "tim.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

#include "App_main.h"
#include "App_internalFlash.h"
#include "App_ESP.h"
#include "string.h"
#include "App_Flash.h"

#define APPLICATION_START_ADDRESS 0x08010000 //0x08008000

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
void Bootloader_JumpToApplication(void);
uint32_t read_fw_size(void);
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
uint32_t fw_address;
volatile uint16_t Emergency_stop_count=0,Emergency_start_count;
char Emergency_stop;
/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

//  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  ESPON;
  GSMON;
  MX_DMA_Init();
  //MX_RTC_Init();
  MX_SPI1_Init();
  MX_USART2_UART_Init();
  MX_USART3_UART_Init();
  MX_TIM2_Init();
//  /* USER CODE BEGIN 2 */
  HAL_UART_Receive_DMA(&ESP32_UART, &ESP32RxBfr[0],1);
  HAL_UART_Receive_DMA(&HMI_UART, &HMIRxBfr[0],1);
  HAL_TIM_Base_Start_IT(&htim2);
  Application_init();

  HAL_Delay(100);
//  ESPON;
//  GSMON;
  //App_System.jmp_App =1;
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
//  if(App_System.jmp_App == 1)
//  {
//	   AllPheripheralDeint();
//	    Bootloader_JumpToApplication();
//	    App_System.jmp_App =0;
//  }
	while (1)
	{
		/* USER CODE END WHILE */

		/* USER CODE BEGIN 3 */

		Application_Process();

		if(!EMG_SW_READ)
		{
			Emergency_stop_count++;
			if(Emergency_stop_count >= 50)
			{
				Emergency_stop = 1;
				Emergency_stop_count = 0;
			}
		}
		else
		{
			if(++Emergency_start_count > 50)
			{
				Emergency_start_count = 0;
				Emergency_stop_count = 0;
				Emergency_stop = 0;
			}
		}

		if(Emergency_stop == 1)
		{
			if(OCPP.fw_status)
			{
				//setting firmware status to 8. which indicates download has failed
				OCPP.fw_status = 8;
				FlashWrite_OCPPConfig();
				HAL_Delay(100);
			}
			AllPheripheralDeint();
			Bootloader_JumpToApplication();
			App_System.jmp_App = 0;
			Emergency_stop = 0;
		}

		if(App_System.jmp_App == 1)
		{
			AllPheripheralDeint();
			Bootloader_JumpToApplication();
			App_System.jmp_App = 0;
			Emergency_stop = 0;
		}
	}
	/* USER CODE END 3 */
}


/*
 *
 *
 *Make sure the Application system clock is same as the application code
 *
 *
 */


void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
  RCC_PeriphCLKInitTypeDef PeriphClkInitStruct = {0};
  /** Configure the main internal regulator output voltage
  */
  __HAL_RCC_PWR_CLK_ENABLE();
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.LSIState = RCC_LSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLM = 6;
  RCC_OscInitStruct.PLL.PLLN = 96;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLQ = 4;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV4;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_3) != HAL_OK)
  {
    Error_Handler();
  }
    PeriphClkInitStruct.PeriphClockSelection = RCC_PERIPHCLK_RTC;
    PeriphClkInitStruct.RTCClockSelection = RCC_RTCCLKSOURCE_LSI;
    if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInitStruct) != HAL_OK)
    {
      Error_Handler();
    }
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config_old(void)
{

  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
  RCC_PeriphCLKInitTypeDef PeriphClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  __HAL_RCC_PWR_CLK_ENABLE();
  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);
  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.LSIState = RCC_LSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLM = 12;
  RCC_OscInitStruct.PLL.PLLN = 192;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLQ = 4;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {

    Error_Handler();

  }

  /** Initializes the CPU, AHB and APB buses clocks
  */

  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV2;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK)
  {
    Error_Handler();
  }
  PeriphClkInitStruct.PeriphClockSelection = RCC_PERIPHCLK_RTC;
  PeriphClkInitStruct.RTCClockSelection = RCC_RTCCLKSOURCE_LSI;
  if (HAL_RCCEx_PeriphCLKConfig(&PeriphClkInitStruct) != HAL_OK)
  {
    Error_Handler();
  }
}
/* USER CODE BEGIN 4 */
void Bootloader_JumpToApplication(void)
{

		//just a function pointer to hold the address of the reset handler of the user app.
	    void (*app_reset_handler)(void);
	    //printmsg("BL_DEBUG_MSG:bootloader_jump_to_user_app\n");
	    // 1. configure the MSP by reading the value from the base address of the sector 2
	    uint32_t msp_value = *(volatile uint32_t *)APPLICATION_START_ADDRESS;

	   // printmsg("BL_DEBUG_MSG:MSP value : %#x\n",msp_value);
	   // This function comes from CMSIS.
	    __set_MSP(msp_value);

	    //SCB->VTOR = FLASH_SECTOR1_BASE_ADDRESS;

	    	/* 2. Now fetch the reset handler address of the user application
	    	 * from the location FLASH_SECTOR2_BASE_ADDRESS+4
	    	 */

	    uint32_t resethandler_address = *(volatile uint32_t *) (APPLICATION_START_ADDRESS + 4);
	    app_reset_handler = (void*) resethandler_address;

	    // printmsg("BL_DEBUG_MSG: app reset handler addr : %#x\n",app_reset_handler);
	    //3. jump to reset handler of the user application
	    app_reset_handler();



/*	void (*app_reset_handler)(void);


	uint32_t msp_value = 0;
	uint32_t reset_handler_address  = 0 ;

	msp_value = *(volatile uint32_t *)(ADDR_FLASH_SECTOR_4);
	__set_MSP(msp_value);
	reset_handler_address  = *(volatile uint32_t *)(ADDR_FLASH_SECTOR_4 + 4);
	app_reset_handler = (void *)reset_handler_address;
	app_reset_handler();*/
}

//uint32_t read_fw_size(void)
//{

//	uint8_t data[50];
//	char buf[25];
//    uint8_t dt_len;
//    uint32_t fw_len=0;
//    uint32_t address=(w25qxx.SectorCount-2)*w25qxx.SectorSize;
//
//	W25qxx_ReadBytes(data,address,6);
//	if((data[0]==0xAA)&&(data[1]==0x55))//rmu firmware
//	{
//		fw_len=data[2]&0xFF;
//		fw_len<<=8;
//		fw_len|=data[3]&0xFF;
//		fw_len<<=8;
//		fw_len|=data[4]&0xFF;
//		fw_len<<=8;
//		fw_len|=data[5]&0xFF;
//		fw_address=(w25qxx.SectorCount-64)*w25qxx.SectorSize;
//	}
//
//	return fw_len;

//}


void AllPheripheralDeint(void)
{

//	  __HAL_RCC_GPIOC_CLK_DISABLE();
//	  __HAL_RCC_GPIOH_CLK_DISABLE();
//	  __HAL_RCC_GPIOA_CLK_DISABLE();
//	  __HAL_RCC_GPIOB_CLK_DISABLE();
//	  __HAL_RCC_GPIOD_CLK_DISABLE();
		 HAL_TIM_OC_MspDeInit(&htim2);
		 HAL_TIM_Base_Stop_IT(&htim2);
		 HAL_UART_MspDeInit(&huart3);
		 HAL_UART_MspDeInit(&huart2);
		 HAL_SPI_MspDeInit(&hspi1);
		 __HAL_RCC_DMA1_CLK_DISABLE();
	     HAL_UART_DMAStop(&ESP32_UART);
	     HAL_UART_DMAStop(&HMI_UART);


	     HAL_NVIC_DisableIRQ(TIM2_IRQn);
	    // HAL_NVIC_DisableIRQ(TIM5_IRQn);
	     HAL_NVIC_DisableIRQ(DMA1_Stream1_IRQn);
	     HAL_NVIC_DisableIRQ(DMA1_Stream3_IRQn);
	     HAL_NVIC_DisableIRQ(DMA1_Stream5_IRQn);
	     HAL_NVIC_DisableIRQ(DMA1_Stream6_IRQn);
         __disable_irq();



//	    // HAL_RCC_DeInit();
//	     HAL_DeInit();
//
//
//		 SysTick->CTRL = 0;
//		 SysTick->LOAD = 0;
//		 SysTick->VAL = 0;

}





/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {

  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
