/*
 * App_main.c
 *
 *  Created on: Aug 30, 2022
 *      Author: LUBI
 */



#include "main.h"
#include "dma.h"
#include "rtc.h"
#include "spi.h"
#include "usart.h"
#include "gpio.h"

#include "App_main.h"
#include "App_ESP.h"
#include "App_HMI.h"
#include "App_FOTA.h"
#include "App_Flash.h"
#include "App_internalFlash.h"
#include "string.h"
#include "stdio.h"

uint8_t ESP32RxBfr[4]={0};
uint8_t HMIRxBfr[4]={0};

SystemStatus App_System={0};
UpdateState  F_OTAStatus;

unsigned char  FirmwareArr[300]={0};
unsigned short FirmwareReadByte=0;

unsigned char test=0,sendconnect=0;
//#define DEBUGMODE 1
#ifdef DEBUGMODE
 _write(int fd, char* ptr, int len)
{
    HAL_UART_Transmit(&huart3, (uint8_t *) ptr, len, HAL_MAX_DELAY);
    return len;
}

#endif

 void App_FirmwareUpdateProcess(void);
 void ReadFirmwareBack(void);

void Application_init(void)
{


#ifdef DEBUGMODE
	  printf("\nProject          :AC_BOOTLODER\n");
	  printf("\nFrequency        :%lu Hz\n",HAL_RCC_GetSysClockFreq());
	  printf("\nFw Date Time     :%s %s\n",__DATE__,__TIME__);
#endif
	  Init_FlashMemory();
	 // ExtFlash_ChipErase();
	  FlashRead_CurrentConfig();
	  Flash_readOCPPParameter();
	  F_OTAStatus=ISINTERNETCONNECTEDCKECK;
	  ESP32_restart();
}

void Application_Process(void)
{
	ProcessESP();
	ProcessHMI();
	ProcessESPFrames();
	App_FirmwareUpdateProcess();
}


void App_FirmwareUpdateProcess(void)
{
   switch(F_OTAStatus)
   {

     case ISINTERNETCONNECTEDCKECK:
     {
    	 if(App_System.gu8_WifiCredentialQuery==1)
    	 {
             if(App_System.gu8_FrameTimerFlag==1)
             {
            	 if(OCPP.Communication_Mode == 3 )
				 {
					 ESPConnectEthernet();
				 }
				 else if(OCPP.Communication_Mode == 1)
				 {
					 GSMConnect(); //V5.0 changes
				 }
				 else
				 {
					 ESPConnectwifi();
				 }
            	 App_System.gu8_FrameTimerFlag=0;
            	 App_System.gu8_WifiCredentialQuery=0;
#ifdef DEBUGMODE
printf("\nInternet query\n");
#endif
             }
    	 }

     }break;
     case FIRMWARELENGHTFOUND:
     {
    	 if((App_System.gu8_FirmwareUpgradeQuery==1))
    	 {
    		 if(App_System.gu8_FrameTimerFlag==1)
    		 {
    			 FirmwareDownloadQuery();
    			 App_System.gu8_FrameTimerFlag=0;
    			 App_System.gu8_FirmwareUpgradeQuery=0;
    			 memset((unsigned char*)&F_OTA,0x00,sizeof(F_OTA));
    			 memcpy((unsigned char*)&Database,(unsigned char*)&DefaultDatabase,sizeof(Database));
    			 //ExtFlash_ChipErase();
    			 EraseFirmwareMemory();
    			 indexCrc=0;
#ifdef DEBUGMODE
printf("\nFirmware Download Query send\n");
#endif
    		 }
    	 }
     }break;
     case FIRMWAREPACKETRECEIVE:
     {

    	 if(F_OTA.FirmwarePacket>F_OTA.RecFirmwarePacket)
    	 {

    		 if((App_System.gu8_NextFwPacketQuery==1))
    		 {
    			 FirmwarePacketQuery();
    			 App_System.gu8_NextFwPacketQuery=0;
    			 App_System.gu8_FrameTimerFlag=0;
    		 }
    	 }
    	 else if(F_OTA.FirmwarePacket==F_OTA.RecFirmwarePacket)
    	 {
             if(F_OTA.Firmware_size==F_OTA.RecFirmware_size)
             {
            	 F_OTAStatus=ERASEAPPLICATIONPROGRAM;
#ifdef DEBUGMODE
printf("\nFull Firmware savedOk\n");
#endif
             }
    	 }
     }break;
     case ERASEAPPLICATIONPROGRAM:
     {
    	   InternalFlash_Unlock();
    	   EraseApplicationProgramMemory();
    	   F_OTAStatus=FIRMWAREDOWNLODEDOK;

     }break;
     case FIRMWAREDOWNLODEDOK:
     {
    	 	 ReadFirmwareBack();
     }break;

     case FIRMWAREWRITETOFLASHOK:
     {

#ifdef DEBUGMODE
printf("\nJump to Application ok\n");
#endif
		 HMI_Send(0);
         HAL_Delay(100);
         //App_System.jmp_App = 1;

         //setting firmware status paramter to 128, which indicates that installation is done
         OCPP.fw_status = 128;
         FlashWrite_OCPPConfig();
         HAL_Delay(100);
         AllPheripheralDeint();
    	 Bootloader_JumpToApplication();
     }
     default:
     {
    	 ;
     }

   }

}


void ReadFirmwareBack(void)
{

     unsigned short CRCFlash=0;
//	 unsigned char  FirmwareArr[300]={0};
//	 unsigned short FirmwareReadByte=0;
     static unsigned short crcind=0;
     if(F_OTA.FlashWirteFirmware_size<F_OTA.RecFirmware_size)
     {

    	 if((F_OTA.RecFirmware_size-F_OTA.FlashWirteFirmware_size)<256)
    	 {
    		 FirmwareReadByte=(F_OTA.RecFirmware_size%256);
    	 }
    	 else
    	 {
    		 FirmwareReadByte=256;
    	 }

    	 memset((unsigned char*)&FirmwareArr[0],0x00,sizeof(FirmwareArr));
    	 ExtFlash_Read(&FirmwareArr[0],FirwareDatabase.CurrentSector,FirwareDatabase.CurrentPage,0,FirmwareReadByte);
    	 F_OTA.FlashWirteFirmware_size+=FirmwareReadByte;

    	 if(FirmwareReadByte > 255)
    	 {
    		 FirwareDatabase.CurrentPage++;
    	 }

         if(FirwareDatabase.CurrentPage > 255)
         {
        	 FirwareDatabase.CurrentSector++;
        	 FirwareDatabase.CurrentPage=0;
         }

         WriteFirmwarePacketToFlash(&FirmwareArr[0],FirmwareReadByte);
         CRCFlash=Crc16(&FirmwareArr[0],FirmwareReadByte);

#ifdef DEBUGMODE


         	 printf("\nFlash CRC    0x%x",CRCFlash);
         	 printf("\nFlash sector %d",FirwareDatabase.CurrentSector);
         	 printf("\nFlash page   %d",FirwareDatabase.CurrentPage);
         	 printf("\nFlash rbyt   %d",F_OTA.FlashWirteFirmware_size);
           	 printf("\nFlashPgrm    %d",F_OTA.FlashWirteFirmware_size);
         	 printf("\nFlash byte   %d",FirmwareReadByte);
#endif
         	 if(CRCFlash!=CRCArr[crcind])
         	 {
         		App_System.jmp_App = 1;

         		// while(1);

         		/*
         		    	 *
         		    	 * remove while 1
         		    	 * add error  message to display erase mcu application code space
         		    	 * and restart
         		    	 *
         		    	 *
         		    	 */
         	 }
         	 crcind++;
//#endif

     }
     else
     {

#ifdef DEBUGMODE
	 printf("\n\nAppplication Code Write to flash ok\n");
#endif

	 InternalFlash_Lock();
	 F_OTAStatus=FIRMWAREWRITETOFLASHOK;
     }


}



void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
{

	    if(huart->Instance==USART2)
	    {

            if((gu8_ESPBufferFlag1 != gu8_ESPBufferFlag2) &&( (gu32_ESPrecDataIndex[gu8_ESPBufferFlag1] > gu32_ESPrecDataIndex[gu8_ESPBufferFlag2]))  )
            {



            }
            else
            {
            	gu8_ESPrecData[gu32_ESPrecDataIndex[gu8_ESPBufferFlag1]] = ESP32RxBfr[0];
            	gu32_ESPrecDataIndex[gu8_ESPBufferFlag1]++;
            }
			if(gu32_ESPrecDataIndex[gu8_ESPBufferFlag1] > ESPBUFFERSIZE)
			{
				gu8_ESPBufferFlag1=1-gu8_ESPBufferFlag1;
				gu32_ESPrecDataIndex[gu8_ESPBufferFlag1]=0;
			}

	    	HAL_UART_Receive_DMA(&ESP32_UART, &ESP32RxBfr[0],1);
	    }
	    else if(huart->Instance==USART3)
	    {
			if((gu8_HMIBufferFlag1 != gu8_HMIBufferFlag2) &&( (gu32_HMIrecDataIndex[gu8_HMIBufferFlag1] > gu32_HMIrecDataIndex[gu8_HMIBufferFlag2]))  )
			{


			}
			else
			{
				gu8_HMIrecData[gu32_HMIrecDataIndex[gu8_HMIBufferFlag1]] = HMIRxBfr[0];
				gu32_HMIrecDataIndex[gu8_HMIBufferFlag1]++;
			}
			if(gu32_HMIrecDataIndex[gu8_HMIBufferFlag1] > HMIBUFFERSIZE)
			{
				gu8_HMIBufferFlag1=1-gu8_HMIBufferFlag1;
				gu32_HMIrecDataIndex[gu8_HMIBufferFlag1]=0;
			}
			//HAL_UART_Transmit_IT(&huart2, &ESP32RxBfr[0], 1);
			//while(!(__HAL_UART_GET_FLAG(&huart2, UART_FLAG_TC)));
			HAL_UART_Receive_DMA(&HMI_UART, &HMIRxBfr[0],1);
	    }
}

void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim)
{

	 if(htim->Instance==TIM2)
	 {

		 if(App_System.gu8_BootloderTimeoutFlag==1)
		 {
			 App_System.gu8_BootloderTimeoutCounter++;

             if(App_System.gu8_BootloderTimeoutCounter>10)
             {
            	 App_System.jmp_App=1;
            	 App_System.gu8_BootloderTimeoutCounter=0;
             }
		 }
		 App_System.gu8_FrameTimerFlag=1;

	 }

}
