/*
 * App_internalFlash.c
 *
 *  Created on: 12-Sep-2022
 *      Author: LUBI
 */


#include "App_internalFlash.h"
#include "main.h"


static FLASH_EraseInitTypeDef EraseInitStruct;

unsigned char Buffer256[260]={0};
unsigned int  ProgramWord256=0;

InternalFlashDatabase ProgramFlash;

void InternalFlash_Unlock(void)
{
	HAL_FLASH_Unlock();
}
void EraseApplicationProgramMemory(void)
{

	uint32_t SectorError = 0;
	EraseInitStruct.TypeErase = FLASH_TYPEERASE_SECTORS;
	EraseInitStruct.VoltageRange = FLASH_VOLTAGE_RANGE_3;
	EraseInitStruct.Sector = 4;
	EraseInitStruct.NbSectors =4;
	ProgramFlash.AppCodeWriteAddress=ADDR_FLASH_SECTOR_4;


	if(HAL_FLASHEx_Erase(&EraseInitStruct, &SectorError) != HAL_OK)
	{
		 Error_Handler();
	}

	__HAL_FLASH_DATA_CACHE_DISABLE();
	__HAL_FLASH_INSTRUCTION_CACHE_DISABLE();
	__HAL_FLASH_DATA_CACHE_RESET();
	__HAL_FLASH_INSTRUCTION_CACHE_RESET();
	__HAL_FLASH_INSTRUCTION_CACHE_ENABLE();
	__HAL_FLASH_DATA_CACHE_ENABLE();

}

void InternalFlash_Lock(void)
{
	  HAL_FLASH_Lock();
}
void Write_to_InternalFlash(void)
{

//      unsigned int  Address=0;
//	  Address = FLASH_PROGRAM_START_ADDR;
//
//	  while (Address < FLASH_PROGRAM_END_ADDR)
//	  {
//		  if (HAL_FLASH_Program(FLASH_TYPEPROGRAM_WORD, Address, 0x0000) == HAL_OK)
//		  {
//			  Address = Address + 4;
//		  }
//		  else
//		  {
//			  /* Error occurred while writing data in Flash memory.
//	         	 User can add here some code to deal with this error */
//			  /*
//	        	FLASH_ErrorTypeDef errorcode = HAL_FLASH_GetError();
//			   */
//			  Error_Handler();
//		  }
//
//	  }

}
void WriteFirmwarePacketToFlash(unsigned char* FirmwareBytePAcket,unsigned short PacketSize)
{

	unsigned short  PacketLength=0;
	uint64_t   ProgramWord=0;
	//unsigned int   ProgramWord=0;
	unsigned int    Address=0;
    unsigned char   ProgramByte=0;

     for(PacketLength=0;PacketLength<PacketSize;PacketLength+=4)
     {

    	 ProgramWord=0;
    	 ProgramWord=FirmwareBytePAcket[PacketLength+3] & 0xFF;
    	 ProgramWord<<=8;
    	 ProgramWord|=(FirmwareBytePAcket[PacketLength+2] & 0xFF );
    	 ProgramWord<<=8;
    	 ProgramWord|=(FirmwareBytePAcket[PacketLength+1] & 0xFF);
    	 ProgramWord<<=8;
    	 ProgramWord|=(FirmwareBytePAcket[PacketLength] & 0xFF);

    	 /*ProgramWord<<=8;
    	 ProgramWord|=(FirmwareBytePAcket[PacketLength+4] & 0xFF);
    	 ProgramWord<<=8;
    	 ProgramWord|=(FirmwareBytePAcket[PacketLength+5] & 0xFF);
    	 ProgramWord<<=8;
    	 ProgramWord|=(FirmwareBytePAcket[PacketLength+6] & 0xFF);
    	 ProgramWord<<=8;
    	 ProgramWord|=(FirmwareBytePAcket[PacketLength+7] & 0xFF);*/

    	 if (HAL_FLASH_Program(FLASH_TYPEPROGRAM_WORD, ProgramFlash.AppCodeWriteAddress, ProgramWord) == HAL_OK)
    	 {
    		 ProgramFlash.AppCodeWriteAddress = ProgramFlash.AppCodeWriteAddress + 4;
    	 }
    	 else
    	 {
			  /* Error occurred while writing data in Flash memory.
				 User can add here some code to deal with this error */
			  /*
				FLASH_ErrorTypeDef errorcode = HAL_FLASH_GetError();
			   */
			  Error_Handler();
    	 }

     }

}

