/*
 *      App_HMI.c
 *
 *      Created on: Aug 31, 2022
 *      Author: LUBI
 *
 *
 *
 *
 *
 */


#include "App_HMI.h"
#include "main.h"
#include "usart.h"
unsigned char  gu8_HMIrecData[HMIBUFFERSIZE+1],gu8_HMIrecCh = 0;
volatile extern int Percent;
unsigned int   gu32_HMIrecDataIndex[2]={0,0},gu32_HMIprocessIndex = 0,gu32_HMIdataIndex = 0;
unsigned char  gu8_HMIBufferFlag1 = 0, gu8_HMIBufferFlag2 = 0,gu8_HMIStartByte=0;
unsigned char SET_TOUCH[10]={0x5A, 0xA5, 0x07, 0x82, 0x00, 0x84, 0x5a,0x01,0x00,0x00};
unsigned char WRITE_TOUCH[110]={0x5A, 0xA5, 0x05, 0x82, 0x10,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0,0,0,0,0,0};


void ProcessHMI(void)
{

	if((gu32_HMIprocessIndex < gu32_HMIrecDataIndex[gu8_HMIBufferFlag2] ))
	{

		for(gu32_HMIdataIndex=gu32_HMIprocessIndex; gu32_HMIdataIndex < gu32_HMIrecDataIndex[gu8_HMIBufferFlag2]; gu32_HMIdataIndex++)
		{

			 //gu8_GSMrecData[gu32_GSMdataIndex];



	       //HAL_UART_Transmit_IT(&huart3, &gu8_HMIrecData[gu32_HMIdataIndex], 1);   //
	    //	while(!(__HAL_UART_GET_FLAG(&huart3, UART_FLAG_TC)));

		}

		gu32_HMIprocessIndex = gu32_HMIrecDataIndex[gu8_HMIBufferFlag2];

		if(gu32_HMIprocessIndex > HMIBUFFERSIZE)
		{
			gu32_HMIrecDataIndex[gu8_HMIBufferFlag2]=0;
			gu8_HMIBufferFlag2 = 1 - gu8_HMIBufferFlag2;
			gu32_HMIprocessIndex = 0;
		}

	}

}
void HMI_Send(unsigned char cmd)
{
	switch (cmd)
	{
	case 36:
					SET_TOUCH[9] = 36; //Firmware Page
					HAL_UART_Transmit_IT(&huart3, (uint8_t*)SET_TOUCH,10);// jmp to page 36
					break;
	case 0:
					SET_TOUCH[9] = 0x00; //PAGE 0 logo
					HAL_UART_Transmit_IT(&huart3, (uint8_t*)SET_TOUCH,10);
				break;    //jmp to page 0
	case 1 :
					WRITE_TOUCH[2] = 0x05;
					WRITE_TOUCH[4] = 0x10;
					WRITE_TOUCH[5] = 0x08; //WRITE BUTTON
					WRITE_TOUCH[6] = (Percent >> 8);
					WRITE_TOUCH[7] = Percent;
					HAL_UART_Transmit(&huart3, (uint8_t*)WRITE_TOUCH,8,0xffff);

				break;  //update percentage
	case 2:
					WRITE_TOUCH[2] = 9;
					WRITE_TOUCH[4] = 0x10;
					WRITE_TOUCH[5] = 0x20;
					WRITE_TOUCH[6] = 'E';
					WRITE_TOUCH[7] = 'R';
					WRITE_TOUCH[8] = 'R';
					WRITE_TOUCH[9] = 'O';
					WRITE_TOUCH[10] = 'R';
					WRITE_TOUCH[11] = ' ';
					HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,12);
				break;  //status


	case 3:

				WRITE_TOUCH[2] = 9;
				WRITE_TOUCH[4] = 0x10;
				WRITE_TOUCH[5] = 0x20;
				WRITE_TOUCH[6] = 'E';
				WRITE_TOUCH[7] = 'R';
				WRITE_TOUCH[8] = 'R';
				WRITE_TOUCH[9] = 'O';
				WRITE_TOUCH[10] = 'R';
				WRITE_TOUCH[11] = ' ';
				HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,12);

				break;  //status
	}
}
