/*
 * App_Flash.c
 *
 *  Created on: 02-Sep-2022
 *      Author: LUBI
 */


#include "App_Flash.h"
#include "stdio.h"
#include "string.h"
#include "App_main.h"
#define	W25qxx_Delay(delay)		HAL_Delay(delay)

extern SystemStatus App_System;

w25qxx_t WinbodFlash;

FlashExternal Database={0};
Config_Parameter OCPP, OCPP_READ;

FlashExternal DefaultDatabase=
{

		        .CurrentByteAddr=0,
				.CurrentPage=0,
				.CurrentSector=241,                       //Firmware Offset

				.FlashCommunicationOkFlag=0,
				.FullSectorWrittenFlag=0,
				.LastReadByteAddr=0,
				.EntryCount=0,

				.LastReadByteAddr=0,
				.LastReadSector=0,
				.ReadCount=0
};


FlashExternal FirwareDatabase=
{
		        .CurrentByteAddr=0,
				.CurrentPage=0,
				.CurrentSector=241,                       //Firmware Offset

				.FlashCommunicationOkFlag=0,
				.FullSectorWrittenFlag=0,
				.LastReadByteAddr=0,
				.EntryCount=0,

				.LastReadByteAddr=0,
				.LastReadSector=0,
				.ReadCount=0
};

//

uint8_t	W25qxx_Spi(uint8_t	Data)
{
	uint8_t	ret;
	HAL_SPI_TransmitReceive(&_W25QXX_SPI,&Data,&ret,1,10);
	return ret;
}

void ExtFlashBusyCheck(void)
{
	HAL_Delay(50);
	NSS_LOW;
	W25qxx_Spi(0x05);   				 //Write  Enable command

	while ((W25qxx_Spi(0xA0) & 0x01)==0x01)
	{
		HAL_Delay(50);
	}
	NSS_HIGH;
}

//
void ExtFlashEraseSector(unsigned short sectorNo)
{
	    NSS_LOW;
		W25qxx_Spi(0x06);   				               //Write  Enable command
		NSS_HIGH;

	    NSS_LOW;
	    W25qxx_Spi(0xD8);
	    W25qxx_Spi(sectorNo);   				           //Write  Enable command
		W25qxx_Spi(0);
		W25qxx_Spi(0);
		NSS_HIGH;

		ExtFlashBusyCheck();
}

void ExtFlash_ChipErase(void)
{

	NSS_LOW;
	W25qxx_Spi(0x06);   				 //Write  Enable command
	NSS_HIGH;

	NSS_LOW;
	W25qxx_Spi(0xC7);   //Chip Erase command
	NSS_HIGH;
	ExtFlashBusyCheck();

}


void EraseFirmwareMemory(void)
{
	unsigned short FirmwareStartSectro=DATABASE_SECTOR_START;
	unsigned short FirmwareLastSector=DATABASE_SECTOR_LIMIT;
	unsigned short EraseSector=0;

	for(EraseSector=FirmwareStartSectro;EraseSector<=FirmwareLastSector;EraseSector++)
	{
		ExtFlashEraseSector(EraseSector);
	}
}

unsigned short Get_ExtFlash_LastSector(void)
{
	unsigned short SectorNumber=0,PageNumber=0,ByteNumber=0;
	for(SectorNumber=0;SectorNumber<DATABASE_SECTOR_LIMIT;SectorNumber+=1)
	{
		NSS_LOW;
		W25qxx_Spi(0x03);
		W25qxx_Spi(SectorNumber);
		W25qxx_Spi(PageNumber);
		W25qxx_Spi(ByteNumber);

		if(W25qxx_Spi(0xA0)==0xFF)         //no data return to above given address
		{
			NSS_HIGH;
			break;
		}
		NSS_HIGH;
		//W25qxx_Delay(500);
		HAL_Delay(50);
		ExtFlashBusyCheck();
	}
    if(SectorNumber==0)                    //Whole Flash is Empty or Whole Flash is full without zeroth Sector
    {
    	NSS_LOW;
    	W25qxx_Spi(0x03);
    	W25qxx_Spi(DATABASE_SECTOR_LIMIT-1);
    	W25qxx_Spi(0);
    	W25qxx_Spi(0);
    	if(W25qxx_Spi(0xA0)==0xFF)         //whole Flash is Empty
    	{
    		 NSS_HIGH;
    		 return SectorNumber;
    	}
    	else                               //
    	{
    		return DATABASE_SECTOR_LIMIT;  //last allowed Sector is Written
    	}
    	NSS_HIGH
    }
    else
    {
    	return (SectorNumber-1);           // last written sector is these
    }
}

unsigned short Get_ExtFlash_LastPage(unsigned short LastSectorNumber)
{
	unsigned short PageNumber=0,ByteNumber=0;

	for(PageNumber=0;PageNumber<=255;PageNumber++)
	{

		NSS_LOW;
		W25qxx_Spi(0x03);
		W25qxx_Spi(LastSectorNumber);
		W25qxx_Spi(PageNumber);
		W25qxx_Spi(ByteNumber);


		if(W25qxx_Spi(0xA0)==0xFF)                //0xFF is consider as the Blank  Byte
		{
			NSS_HIGH;
			break;

		}
		HAL_Delay(50);
		NSS_HIGH;
		ExtFlashBusyCheck();

	}
	if(PageNumber==0)
	{
		PageNumber+=1;
	}

	return PageNumber-1;                            					 //page is half written or Full Written
}

//
//

unsigned short Get_ExtFlash_LastByteAdd(unsigned short LastPageNumber,unsigned short LastSectorNumber)
{

	signed short ByteAddress=0;

		for(ByteAddress=255;ByteAddress>=0;ByteAddress--)
		{

			NSS_LOW;

			W25qxx_Spi(0x03);                                       //
			W25qxx_Spi(LastSectorNumber);                           //
			W25qxx_Spi(LastPageNumber);                             //
			W25qxx_Spi(ByteAddress);                                //

			if(W25qxx_Spi(0xA0)=='#')
			{
				NSS_HIGH;
			    ByteAddress++;
				break;
			}
			NSS_HIGH;

			//W25qxx_Delay(500);

			HAL_Delay(50);
			ExtFlashBusyCheck();
		}
    if(ByteAddress<=0)
    {
    	ByteAddress=0;

    }
	return ByteAddress;
}
//
//

void Get_CurrentFlashAddress()
{
		if(Database.FlashCommunicationOkFlag==1)    //if Flash is working
		{

			Database.CurrentSector=Get_ExtFlash_LastSector();
			Database.CurrentPage=Get_ExtFlash_LastPage(Database.CurrentSector);
			Database.CurrentByteAddr=Get_ExtFlash_LastByteAdd(Database.CurrentPage,Database.CurrentSector);





//					if(ExtFlash.CurrentByteAddr>255)
//	 				{
//
//							ExtFlash.CurrentByteAddr=0;
//							ExtFlash.CurrentPage++;
//
//							if(ExtFlash.CurrentPage>=256)
//							{
//
//								ExtFlash.CurrentPage=0;
//								ExtFlash.CurrentSector++;
//
//								//roll over flag=1;
//
//								if(ExtFlash.CurrentSector<DATABASE_SECTOR_LIMIT)
//								{
//
//									W25qxx_EraseSector(ExtFlash.CurrentSector);
//
//									if(ExtFlash.CurrentSector+1<DATABASE_SECTOR_LIMIT)
//									{
//
//										W25qxx_EraseSector(ExtFlash.CurrentSector+1);
//
//									}
//									else
//									{
//
//										W25qxx_EraseSector(0);
//									}
//
//								}
//								else
//								{
//
//									W25qxx_EraseSector(0);
//									ExtFlash.CurrentSector=0;
//									W25qxx_EraseSector(ExtFlash.CurrentSector+1);
//
//								}
//
//							}
//
//					}
//
//					if(ExtFlash.CurrentPage>0)
//					{
//						//ExtFlash.CurrentPage--;
//					}

		}
		else
		{

#ifdef DEBUGON
		   printf("\nFlash not Working ");
#endif



		}
#ifdef DEBUGON
		   printf("\nCurrent Sector   :%d",Database.CurrentSector);
		   printf("\nCurrent page     :%d",Database.CurrentPage);
		   printf("\nCurrent Byte Add :%d",Database.CurrentByteAddr);
#endif

}
//
//
//
//
//

void ExtFlash_Program(unsigned char *wStr_Pointer,unsigned char wCurr_Sector,unsigned char wCurr_page,unsigned char wCurr_ByteAdd,unsigned int wStr_Length)
{
	unsigned int wbyteCount=0;
	NSS_LOW;
	W25qxx_Spi(0x06);   				 //Write  Enable command
	NSS_HIGH;
	HAL_Delay(50);

	NSS_LOW;
	W25qxx_Spi(0x02);    				//Page program command
	W25qxx_Spi(wCurr_Sector);
	W25qxx_Spi(wCurr_page);
	W25qxx_Spi(wCurr_ByteAdd);

	for(wbyteCount=0;wbyteCount<wStr_Length;wbyteCount++)
	{
		if((wCurr_ByteAdd+wbyteCount)>255)
		{
			wCurr_ByteAdd=0;
			NSS_HIGH;
			HAL_Delay(10);
			NSS_LOW;
			W25qxx_Spi(0x06);   				 //Write  Enable command
			NSS_HIGH;
			HAL_Delay(50);
			NSS_LOW;
			W25qxx_Spi(0x02);

			W25qxx_Spi(wCurr_Sector);
			W25qxx_Spi(wCurr_page+1);
			W25qxx_Spi(wCurr_ByteAdd);
		}

		W25qxx_Spi(*wStr_Pointer);
		//printf("\n WRITE byte:0x%x",(*wStr_Pointer));
		wStr_Pointer++;
	}
	NSS_HIGH;
   //ExtFlashBusyCheck();
	HAL_Delay(50);
}

/*to  write multiple pages into the flash memory*/
void ExtFlash_Program_FW(unsigned char *wStr_Pointer, unsigned char wCurr_Sector, unsigned char wCurr_page, unsigned char wCurr_ByteAdd, unsigned int wStr_Length)
{
	int len = wStr_Length;
	int page_len;

	ExtFlash_PageWrite(wStr_Pointer, wCurr_Sector, wCurr_page, (wStr_Length > 255 ? 256 : wStr_Length));

	if(wStr_Length > 256)
	{
		len -= 256;
		wCurr_page++;
		wStr_Pointer += 256;
	}
	else
	{
		len = 0;
	}

	while(len > 0)
	{
		page_len = len > 255 ? 256 : len;
		ExtFlash_PageWrite(wStr_Pointer, wCurr_Sector, wCurr_page, page_len);
		len -= 256;
		wCurr_page++;
		wStr_Pointer += 256;
	}
	HAL_Delay(50);
}

/*to write single page into the external flash*/
void ExtFlash_PageWrite(unsigned char *wStr_Pointer, unsigned char wCurr_Sector, unsigned char wCurr_page, unsigned int wStr_Length)
{
	unsigned int wbyteCount = 0;
	int wCurr_ByteAdd = 0;

	NSS_LOW;
	W25qxx_Spi(0x06);   				 //Write  Enable command
	NSS_HIGH;
	HAL_Delay(50);

	NSS_LOW;
	W25qxx_Spi(0x02);    				//Page program command
	W25qxx_Spi(wCurr_Sector);
	W25qxx_Spi(wCurr_page);
	W25qxx_Spi(wCurr_ByteAdd);

	for(wbyteCount = 0; wbyteCount < wStr_Length; wbyteCount++)
	{
		W25qxx_Spi(*wStr_Pointer);
		wStr_Pointer++;
	}
	NSS_HIGH;
	HAL_Delay(50);
}


void ExtFlash_Read(unsigned char *rStr_Pointer,unsigned char rCurr_Sector,unsigned char rCurr_page,unsigned char rCurr_ByteAdd,unsigned int rStr_Length)
{
	unsigned int rbyteCount=0;

	NSS_LOW;
	W25qxx_Spi(0x03);    				//Page read command

	W25qxx_Spi(rCurr_Sector);
	W25qxx_Spi(rCurr_page);
	W25qxx_Spi(rCurr_ByteAdd);

	for(rbyteCount = 0; rbyteCount < rStr_Length; rbyteCount++)
	{

		(*rStr_Pointer) = W25qxx_Spi(0xA0);
		//printf("0x%x,",(*rStr_Pointer));
		rStr_Pointer++;
	}
	NSS_HIGH;
	//ExtFlashBusyCheck();
}



//
//
//


void Ext_FlashDEbug(void)
{
	    unsigned int byteCount=0;
        unsigned char Rbyte=0;

//
//    	NSS_LOW;
//    	W25qxx_Spi(0x06);   				 //Write  Enable command
//    	NSS_HIGH;
//    	HAL_Delay(50);


        NSS_LOW;
    	W25qxx_Spi(0x03);    				//Page read command
    	W25qxx_Spi(CONFIGURATIION_SECTOR);
    	W25qxx_Spi(0);
    	W25qxx_Spi(0);


    	for(;byteCount!=255;)
    	{

    			(Rbyte)=W25qxx_Spi(0xA0);
    			byteCount++;

    			printf("\nCurrent ByteCount:%d,ByteCount:%c",byteCount,Rbyte);
    			HAL_Delay(50);
    	}

    NSS_HIGH;

}



void Flash_readOCPPParameter(void)
{
		ExtFlashBusyCheck();
		ExtFlash_Read((unsigned char*)&OCPP, OCPP_PARAMETER_SECTOR, 0, 0, sizeof(OCPP));

			   printf("\nOCPP.wifi_ssid      :%s",OCPP.wifi_ssid);
			   printf("\nOCPP.wifi_password  :%s",OCPP.wifi_password);
			   printf("\nOCPP.fw_Password    :%s",OCPP.fw_Password);

			   printf("\nOCPP.fw_Port        :%s",OCPP.fw_Port);
			   printf("\nOCPP.fw_servername  :%s",OCPP.fw_servername);

			   printf("\nOCPP.fw_uri         :%s",OCPP.fw_uri);
			   printf("\nOCPP.fw_username    :%s",OCPP.fw_username);

			   printf("\nOCPP.networkoperator    :%s",OCPP.networkoperator);

			   if(OCPP.Boot_Magic_value == 0xbbaa)
			   {
				   if(OCPP.fw_status == 64)
				   {
					   if((OCPP.Communication_Mode == 2 ) || (OCPP.Communication_Mode == 3))
					   {
						   //ESPON;
						   RELAY_SW_ESPON;
					   }
					   else
					   {
						 //  GSMON;
						   RELAY_SW_ESPOFF;
					   }
					   HMI_Send(36);
				   }
				   else {
					   App_System.jmp_App = 1;
					   //HMI_Send(0);
				   }
			   }
			   else
			   {
				   App_System.jmp_App = 1;
			   }



}

void FlashWrite_CurrentConfig(void)
{
	ExtFlashEraseSector(CONFIGURATIION_SECTOR);
	ExtFlashBusyCheck();
	ExtFlash_Program((unsigned char*)&Database, CONFIGURATIION_SECTOR, 0, 0, sizeof(Database));
}

void FlashWrite_OCPPConfig(void)
{
	ExtFlashEraseSector(OCPP_PARAMETER_SECTOR);
	ExtFlashBusyCheck();
	ExtFlash_Program_FW((unsigned char*)&OCPP, OCPP_PARAMETER_SECTOR, 0, 0, sizeof(OCPP));
}

void FlashRead_CurrentConfig(void)
{
	ExtFlashBusyCheck();
	ExtFlash_Read((unsigned char*)&Database, CONFIGURATIION_SECTOR, 0, 0, sizeof(Database));
    if((Database.ReadCount == 0xFFFF) || (Database.EntryCount == 0xFFFF))
    {
    	printf("\nFlash Config sector is Empty");
        memcpy((unsigned char*)&Database, (unsigned char*)&DefaultDatabase, sizeof(Database));
    	FlashWrite_CurrentConfig();
    }
    else
    {
    	printf("\nFlash Config sector Read\n");
//#ifdef DEBUGON
		   printf("\nCurrent Sector   :%d",Database.CurrentSector);
		   printf("\nCurrent page     :%d",Database.CurrentPage);
		   printf("\nCurrent Byte Add :%d",Database.CurrentByteAddr);

		   printf("\nWrite Count      :%d",Database.EntryCount);
		   printf("\nRead  Count      :%d",Database.ReadCount);

//#endif
    }
}

uint32_t W25qxx_ReadID(void)
{
	  uint32_t Temp = 0, Temp0 = 0, Temp1 = 0, Temp2 = 0;
  	  HAL_GPIO_WritePin(_W25QXX_CS_GPIO,_W25QXX_CS_PIN,GPIO_PIN_RESET);
  	  W25qxx_Spi(0x9F);
  	  Temp0 = W25qxx_Spi(W25QXX_DUMMY_BYTE);
  	  Temp1 = W25qxx_Spi(W25QXX_DUMMY_BYTE);
  	  Temp2 = W25qxx_Spi(W25QXX_DUMMY_BYTE);
  	  HAL_GPIO_WritePin(_W25QXX_CS_GPIO,_W25QXX_CS_PIN,GPIO_PIN_SET);
  	  Temp = (Temp0 << 16) | (Temp1 << 8) | Temp2;
  	  return Temp;

}

void W25qxx_ReadUniqID(void)
{
    HAL_GPIO_WritePin(_W25QXX_CS_GPIO,_W25QXX_CS_PIN,GPIO_PIN_RESET);
    W25qxx_Spi(0x4B);
	for(uint8_t	i=0;i<4;i++)
	{
		W25qxx_Spi(W25QXX_DUMMY_BYTE);

	}
	for(uint8_t	i=0;i<8;i++)
	{
		WinbodFlash.UniqID[i] = W25qxx_Spi(W25QXX_DUMMY_BYTE);

	}
	HAL_GPIO_WritePin(_W25QXX_CS_GPIO,_W25QXX_CS_PIN,GPIO_PIN_SET);
}

uint8_t Init_FlashMemory(void)
{
	    while(HAL_GetTick()<1000)
		{
			W25qxx_Delay(1);

		}

	    WinbodFlash.ChipID  =W25qxx_ReadID();
	    WinbodFlash.ChipID  =W25qxx_ReadID();

	    switch(WinbodFlash.ChipID&0x0000FFFF)
	    {
	    		case 0x401A:
	    		{

	    			WinbodFlash.BlockCount=1024;
	    			//printf("w25qxx Chip: w25q512\r\n");

	    		}break;
	    		case 0x4019:
	    		{
	    			WinbodFlash.BlockCount=512;
	    			//printf("w25qxx Chip: w25q256\r\n");
	    		}break;
	    		case 0x4018:
	    		{

	    			WinbodFlash.BlockCount=256;
	    			//printf("w25qxx Chip: w25q128\r\n");
	    		}break;
	    		case 0x4017:
	    		{

	    			WinbodFlash.BlockCount=128;
	    			//printf("w25qxx Chip: w25q64\r\n");
	    		}break;
	    		case 0x4016:
	    		{

	    			WinbodFlash.BlockCount=64;
	    			//printf("w25qxx Chip: w25q32\r\n");

	    		}break;
	    		case 0x4015:
	    		{

	    			WinbodFlash.BlockCount=32;
	    			//printf("w25qxx Chip: w25q16\r\n");
	    		}break;
	    		case 0x4014:
	    		{

	    			WinbodFlash.BlockCount=16;
	    		//	printf("w25qxx Chip: w25q80\r\n");

	    		}break;
	    		case 0x4013:
	    		{

	    			WinbodFlash.BlockCount=8;
	    		//	printf("w25qxx Chip: w25q40\r\n");

	    		}break;
	    		case 0x4012:
	    		{

	    			WinbodFlash.BlockCount=4;
	    			//printf("w25qxx Chip: w25q20\r\n");

	    		}break;
	    		case 0x4011:
	    		{

	    			WinbodFlash.BlockCount=2;
	    			//printf("w25qxx Chip: w25q10\r\n");

	    		}break;
	    		default:
	    		{
	    		//	printf("unknown ID or GarbageVlaue \r\n");
	    			//flash_error=1;
	    			return 0;
	    		}
	   }

	    WinbodFlash.PageSize=256;
	    WinbodFlash.SectorSize=0x1000;
	    WinbodFlash.SectorCount=WinbodFlash.BlockCount*16;
	    WinbodFlash.PageCount=(WinbodFlash.SectorCount*WinbodFlash.SectorSize)/WinbodFlash.PageSize;
	    WinbodFlash.BlockSize=WinbodFlash.SectorSize*16;
	    WinbodFlash.CapacityInKiloByte=(WinbodFlash.SectorCount*WinbodFlash.SectorSize)/1024;
	    return 1;
}
