
/*
 * App_FOTA.c
 *
 *  Created on: Aug 31, 2022
 *      Author: LUBI
 */

#include "App_FOTA.h"
#include "App_main.h"
#include "App_ESP.h"
#include "App_Flash.h"

#include "string.h"
#include "stdio.h"

FirmwareInfo F_OTA={0};

unsigned short CRCArr[MAX_FW_SIZE]={0},indexCrc=0,fourgtxBufferIndex=0;
unsigned char fourGtxBuffer[1000]={0};
uint8_t buff[200];

void Firmware_Save_toFlash(const uint8_t *FwPdata, uint32_t Fwplen)
{


    // unsigned char  FlashFirmwareBuffer[300];
     //unsigned short FlashFirmwareBufferIndex=0;

	 ExtFlash_Program(FwPdata,Database.CurrentSector,Database.CurrentPage,Database.CurrentByteAddr,Fwplen);
	 Database.CurrentByteAddr+=Fwplen;

	if(Database.CurrentByteAddr>255)
	{
		Database.CurrentByteAddr=Database.CurrentByteAddr-256;
		Database.CurrentPage++;

        if(Database.CurrentPage>255)
        {
        	Database.CurrentPage=0;
        	Database.CurrentSector++;
        	if(Database.CurrentSector>=DATABASE_SECTOR_LIMIT)
        	{
        		Database.CurrentSector=1;                         //firmware offset is sector 1 so 1
        		ExtFlashEraseSector(Database.CurrentSector);      //W25qxx_EraseSector(Database.CurrentSector);
        		ExtFlashEraseSector(Database.CurrentSector+1);    ///W25qxx_EraseSector(Database.CurrentSector+1);
        		//erase the current sector and next sector
        	}
        	else
        	{
        		ExtFlashEraseSector(Database.CurrentSector);     //W25qxx_EraseSector(Database.CurrentSector);
        	    ExtFlashEraseSector(Database.CurrentSector+1);   ///W25qxx_EraseSector(Database.CurrentSector+1);
        		//W25qxx_EraseSector(Database.CurrentSector);
        		//W25qxx_EraseSector(Database.CurrentSector+1);
        		//erase the current sector
        	}
        }
	}

#ifdef DEBUGMODE
	printf("\nRecord save to Flash");
	printf("\nCurrent Sector    :%d\n",Database.CurrentSector);
	printf("\nCurrent Page      :%d\n",Database.CurrentPage);
	printf("\nCurrent Byte Add  :%d\n",Database.CurrentByteAddr);
#endif


}


unsigned char GetFirmwareLength(unsigned char *FindLengthBfr,unsigned short FindLengthBfrIndex)
{


   unsigned int Rec_FirmwareSize=0;
   char Lengthindex=0;
   unsigned char RecBuffer[10]={};



    for(Lengthindex=0;Lengthindex<FindLengthBfrIndex;Lengthindex++)
    {
    	RecBuffer[Lengthindex]=*FindLengthBfr;
    	FindLengthBfr++;
    }
    RecBuffer[Lengthindex]=0x00;
    F_OTA.Firmware_size=atoi(RecBuffer);
    F_OTA.FirmwarePacket=(F_OTA.Firmware_size/256);
    if(F_OTA.Firmware_size%256!=0)
    {	F_OTA.FirmwarePacket++;}


    if((F_OTA.Firmware_size>MAXFWSIZE) || F_OTA.Firmware_size<256)
    {
       return 0;
    }

#ifdef DEBUGMODE
	   printf("\nFirmware length          %d",Rec_FirmwareSize);
	   printf("\nRequired Firmware packet %s",F_OTA.FirmwarePacket);
#endif

return 1;
}

unsigned char  FirmwarePacketValidate(unsigned char *FindLengthBfr,unsigned  short FramedataIndex)
{

    unsigned short ReceivedCRC=0;
    unsigned short FlashCRC=0;
	F_OTA.FirmwarePacketCRC=0;

    ReceivedCRC=(FindLengthBfr[0]);
	ReceivedCRC<<=8;
	ReceivedCRC|=FindLengthBfr[1];

	F_OTA.FirmwarePacketCRC=Crc16(&FindLengthBfr[2],FramedataIndex-2);

	printf("\n\ncal-CRC:0x%x\n",F_OTA.FirmwarePacketCRC);
	printf("\nrec-CRC:0x%x\n\n",ReceivedCRC);
	CRCArr[indexCrc++]=ReceivedCRC;
    if(F_OTA.FirmwarePacketCRC!=ReceivedCRC)
    {
    	App_System.jmp_App =1;
    	//while(1);

    	/*
    	 *
    	 * remove while 1
    	 * add error  message to display erase winbond fota space
    	 * and restart
    	 *
    	 *
    	 */


    }
    else
    {

    	//DummyDatabase.CurrentPage=Database.CurrentPage;
    	//DummyDatabase.CurrentSector=Database.CurrentSector;


    	Firmware_Save_toFlash(&FindLengthBfr[2],FramedataIndex-2);




#ifdef DEBUGMODE

//    	HAL_Delay(100);
//        memset((unsigned char*)&DebugArr[0],0x00,sizeof(DebugArr));
//    	ExtFlash_Read(&DebugArr[0],DummyDatabase.CurrentSector,DummyDatabase.CurrentPage,0,256);
//    	FlashCRC=Crc16(&DebugArr[0],256);
//    	printf("\nFlash-CRC:0x%x\n\n",FlashCRC);
//
//    	if(F_OTA.FirmwarePacketCRC!=FlashCRC)
//    	{
//    		printf("\nError in Received CRC");
//            while(1);
//    	}
#endif

    }


}






void ESP32_restart(void)
{

	memset((unsigned char*)&ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
	int Buffindex=0;
	ESPtxBuffer[Buffindex++]=0x02;
	ESPtxBuffer[Buffindex++]=0x90;
	ESPtxBuffer[Buffindex++]=0x00;
	ESPtxBuffer[Buffindex++]=0x00;
	ESPtxBuffer[Buffindex++]=0x01;
	ESPtxBuffer[Buffindex++]=0x01;
	ESPtxBuffer[Buffindex++]=0x03;
	//sprintf(ESPtxBuffer,"esp32_restart*");
	HAL_UART_Transmit(&ESP32_UART, (uint8_t*)ESPtxBuffer,Buffindex,0xffff);
}

void FirmwarePacketQuery(void)
{

	//////////////////////////////////////////////////////////////////////////////////////////////////////
		memset((unsigned char*)fourGtxBuffer,0x00,sizeof(fourGtxBuffer));
		memset((unsigned char*)buff,0x00,sizeof(buff));

		//		       	sprintf(&buff,"%u",content_length);
		fourgtxBufferIndex =0;
		fourGtxBuffer[fourgtxBufferIndex++]=0x02;//start byte //0
		fourGtxBuffer[fourgtxBufferIndex++]=0x98;//wifi credentials connect req
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//sub frame  //2
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length high //3
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length Low  //4
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length Low  //4
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//  //5

		sprintf(ESPtxBuffer,"firmware_upgrade*next");
		memcpy(&fourGtxBuffer[fourgtxBufferIndex],&buff,strlen(buff)); //6 &7

		fourgtxBufferIndex+=strlen(buff);

		fourGtxBuffer[fourgtxBufferIndex++]=0x03;//end byte //8

		fourGtxBuffer[3]=((fourgtxBufferIndex-6)/256);  //3
		fourGtxBuffer[4]= (fourgtxBufferIndex-6) % 256;   //4

		HAL_UART_Transmit(&huart2, (uint8_t*)fourGtxBuffer,fourgtxBufferIndex,0Xffff);








	//////////////////////////////////////////////////////////////////////////////////

//	memset((unsigned char*)&ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
//	sprintf(ESPtxBuffer,"firmware_upgrade*next");
//	HAL_UART_Transmit(&ESP32_UART, (uint8_t*)ESPtxBuffer,strlen(ESPtxBuffer),0xffff);

}

void InternetAccessQuery(void)
{

	memset((unsigned char*)&ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
	sprintf(ESPtxBuffer,"firmware_upgrade*isConnected");
	HAL_UART_Transmit(&ESP32_UART, (uint8_t*)ESPtxBuffer,strlen(ESPtxBuffer),0xffff);

}
void FirmwareDownloadQuery(void)
{

//	memset((unsigned char*)&ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
//	sprintf(ESPtxBuffer,"firmware_upgrade*start");
//	HAL_UART_Transmit(&ESP32_UART, (uint8_t*)ESPtxBuffer,strlen(ESPtxBuffer),0xffff);

	//////////////////////////////////////////////////////////////////////////////////////////////////////
	memset((unsigned char*)fourGtxBuffer,0x00,sizeof(fourGtxBuffer));
		memset((unsigned char*)buff,0x00,sizeof(buff));

		//		       	sprintf(&buff,"%u",content_length);
		fourgtxBufferIndex =0;
		fourGtxBuffer[fourgtxBufferIndex++]=0x02;//start byte //0
		fourGtxBuffer[fourgtxBufferIndex++]=0x97;//wifi credentials connect req
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//sub frame  //2
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length high //3
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length Low  //4
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length Low  //4
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//  //5

		sprintf(buff,"firmware_upgrade*start*http://%s:%s%s*%s*%s\0",OCPP.fw_servername,OCPP.fw_Port,OCPP.fw_uri,OCPP.fw_username,OCPP.fw_Password);
		memcpy(&fourGtxBuffer[fourgtxBufferIndex],&buff,strlen(buff)); //6 &7

		fourgtxBufferIndex+=strlen(buff);

		fourGtxBuffer[fourgtxBufferIndex++]=0x03;//end byte //8

		fourGtxBuffer[3]=((fourgtxBufferIndex-6)/256);  //3
		fourGtxBuffer[4]= (fourgtxBufferIndex-6) % 256;   //4

		HAL_UART_Transmit(&huart2, (uint8_t*)fourGtxBuffer,fourgtxBufferIndex,0Xffff);








	///////////////////////////////////////////////////////////////////////////////////////////
//	memset((unsigned char*)&ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
//		//sprintf(ESPtxBuffer,"firmware_upgrade*start");
//		sprintf(ESPtxBuffer,"firmware_upgrade*start*http://%s:%s%s*%s*%s\0",OCPP.fw_servername,OCPP.fw_Port,OCPP.fw_uri,OCPP.fw_username,OCPP.fw_Password);
//		HAL_UART_Transmit(&ESP32_UART, (uint8_t*)ESPtxBuffer,strlen(ESPtxBuffer),0xffff);
///////////////////////////////////////////////////////////////////////////////////////////////////////




   /*
    *responce :"firmware_upgrade*123456*\r\n"
    *
    *
    */

}

void ESPConnectwifi(void)
{


	memset((unsigned char*)fourGtxBuffer,0x00,sizeof(fourGtxBuffer));
	memset((unsigned char*)buff,0x00,sizeof(buff));

	//		       	sprintf(&buff,"%u",content_length);
	fourgtxBufferIndex =0;
	fourGtxBuffer[fourgtxBufferIndex++]=0x02;//start byte //0
	fourGtxBuffer[fourgtxBufferIndex++]=0x96;//wifi credentials connect req
	fourGtxBuffer[fourgtxBufferIndex++]=0x01;//sub frame  //2
	fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length high //3
	fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length Low  //4


	sprintf(buff,"%s%c%s%c",OCPP.wifi_ssid,0x07,OCPP.wifi_password,0x07);
	memcpy(&fourGtxBuffer[fourgtxBufferIndex],&buff,strlen(buff)); //6 &7
	fourgtxBufferIndex+=strlen(buff);

	fourGtxBuffer[fourgtxBufferIndex++]=0x03;//end byte //8

	fourGtxBuffer[3]=((fourgtxBufferIndex-6)/256);  //3
	fourGtxBuffer[4]= (fourgtxBufferIndex-6) % 256;   //4

	HAL_UART_Transmit(&huart2, (uint8_t*)fourGtxBuffer,fourgtxBufferIndex,0Xffff);



//	memset((unsigned char*)&ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
//	//sprintf(ESPtxBuffer,"wifi*LubiJio%cLubi@Jio%c",0x07,0x07);
//	sprintf(ESPtxBuffer,"wifi*%s%c%s%c",OCPP.wifi_ssid,0x07,OCPP.wifi_password,0x07);
//	HAL_UART_Transmit(&huart2,(uint8_t*)ESPtxBuffer,strlen(ESPtxBuffer),0xffff);

   //IF gsm is used then it is fota mode query

}

void GSMConnect(void)		//V5.0 changes
{
	char lclarray[7];
	  if(OCPP.ipselection == 0) //V4=1
		{
			lclarray[0] = 'I';
			lclarray[1] = 'P';//v4
			lclarray[2] = '\0';

		}
		else if(OCPP.ipselection == 1)//V6=1
		{
			lclarray[0] = 'I';
			lclarray[1] = 'P';
			lclarray[2] = 'V';
			lclarray[3] = '6';
			lclarray[4] = '\0';
		}
		else if(OCPP.ipselection == 2)//V4V6=1
		{
			lclarray[0] = 'I';
			lclarray[1] = 'P';
			lclarray[2] = 'V';
			lclarray[3] = '4';
			lclarray[4] = 'V';
			lclarray[5] = '6';
			lclarray[6] = '\0';
		}

	   memset((unsigned char*)fourGtxBuffer,0x00,sizeof(fourGtxBuffer));
	   memset((unsigned char*)buff,0x00,sizeof(buff));

	//		       	sprintf(&buff,"%u",content_length);
		fourgtxBufferIndex =0;
		fourGtxBuffer[fourgtxBufferIndex++]=0x02;//start byte //0
		fourGtxBuffer[fourgtxBufferIndex++]=0x96;//frame info firmware info //1
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//sub frame  //2
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length high //3
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length Low  //4

		sprintf(buff,"%s%c%s%c",OCPP.networkoperator,0x07,lclarray,0x07);

		memcpy(&fourGtxBuffer[fourgtxBufferIndex],&buff,strlen(buff)); //6 &7

		fourgtxBufferIndex+=strlen(buff);

		fourGtxBuffer[fourgtxBufferIndex++]=0x03;//end byte //8

		fourGtxBuffer[3]=((fourgtxBufferIndex-6)/256);  //3
		fourGtxBuffer[4]= (fourgtxBufferIndex-6) % 256;   //4

		HAL_UART_Transmit(&huart2, (uint8_t*)fourGtxBuffer,fourgtxBufferIndex,0Xffff);
		 // sprintf(buff,"wifi*%s%c%s%c",OCPP.wifi_ssid,0x07,OCPP.wifi_password,0x07);
		 // HAL_UART_Transmit(&huart2, (uint8_t*)buff,strlen(buff),0xffff);

}
void ESPConnectEthernet(void)
{

	   memset((unsigned char*)fourGtxBuffer,0x00,sizeof(fourGtxBuffer));
	   memset((unsigned char*)buff,0x00,sizeof(buff));

//		       	sprintf(&buff,"%u",content_length);
		fourgtxBufferIndex =0;
		fourGtxBuffer[fourgtxBufferIndex++]=0x02;//start byte //0
		fourGtxBuffer[fourgtxBufferIndex++]=0x9A;//frame info firmware info //1
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//sub frame  //2
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length high //3
		fourGtxBuffer[fourgtxBufferIndex++]=0x01;//length Low  //4

		//sprintf(buff,"%s%c%s%c",OCPP.wifi_ssid,0x07,OCPP.wifi_password,0x07);
		  sprintf(buff,"%d.%d.%d.%d%c%d.%d.%d.%d%c%d.%d.%d.%d%c",OCPP.ether_ip[0],OCPP.ether_ip[1],OCPP.ether_ip[2],OCPP.ether_ip[3],0x07,OCPP.ether_getway[0],OCPP.ether_getway[1],OCPP.ether_getway[2],OCPP.ether_getway[3],0x07,OCPP.ether_subnetmask[0],OCPP.ether_subnetmask[1],OCPP.ether_subnetmask[2],OCPP.ether_subnetmask[3],0x07);
		memcpy(&fourGtxBuffer[fourgtxBufferIndex],buff,strlen(buff)); //6 &7

		fourgtxBufferIndex+=strlen(buff);

		fourGtxBuffer[fourgtxBufferIndex++]=0x03;//end byte //8

		fourGtxBuffer[3]=((fourgtxBufferIndex-6)/256);  //3
		fourGtxBuffer[4]= (fourgtxBufferIndex-6) % 256;   //4

		HAL_UART_Transmit(&huart2, (uint8_t*)fourGtxBuffer,fourgtxBufferIndex,0Xffff);



//	memset((unsigned char*)&ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
//	//sprintf(ESPtxBuffer,"wifi*LubiJio%cLubi@Jio%c",0x07,0x07);
//	sprintf(ESPtxBuffer,"wifi*%s%c%s%c",OCPP.wifi_ssid,0x07,OCPP.wifi_password,0x07);
//	HAL_UART_Transmit(&huart2,(uint8_t*)ESPtxBuffer,strlen(ESPtxBuffer),0xffff);

   //IF gsm is used then it is fota mode query

}
/*
 *
 * Frame 1: ESP Internet connect
 *
 *      0x02 0x82 01 00 01 01 03                                if ok
 *      0x02 0x82 01 00 01 00 03                                if error
 *frame 2 Firmware Info

 *      0x02 0x80 01 00 07 01 0x 0x 0x 0x 0x 0x 03               if  ok
 *      0x02 0x80 01 00 01 00 03                                 if error
 *
 *frame 3 Firmware packet
 *
 *
 *      0x02 0x81 01 00 07 01 0x 0x 0x 0x 0x 0x 03               if  ok
 *      0x02 0x81 01 00 01 00 03                                 if error
 *
 *
 */
