/*
 *
 *      App_ESP.c
 *      Created on: Aug 30, 2022
 *      Author: LUBI
 *
 *
 */



#include "App_ESP.h"
#include "App_main.h"
#include "App_FOTA.h"
#include "App_HMI.h"
#include "main.h"
#include "usart.h"
#include "string.h"
#include "stdio.h"

/*
 *firmware
 *
 *
 *
 */


#define FRAMEDATAINDEX_OFFSET 6

FrameInfo ESPFrame={0};

unsigned char  gu8_ESPrecData[ESPBUFFERSIZE+1],gu8_ESPrecCh = 0;
volatile unsigned int   gu32_ESPrecDataIndex[2]={0,0},gu32_ESPprocessIndex = 0,gu32_ESPdataIndex = 0;
volatile unsigned char  gu8_ESPBufferFlag1 = 0, gu8_ESPBufferFlag2 = 0,gu8_ESPStartByte=0;
char  *ESPStringPtr=0;
volatile int Percent=0;
unsigned char  ESPtxBuffer[256]={0};
 unsigned char  gu8_ESPRxBuffer[512]={0};
 unsigned char  gu8_ESPRxDataBuffer[512]={0};
volatile unsigned short gu16_ESPRxDataBufferIndex=0;
volatile unsigned short gu16_ESPRxBufferIndex=0,ESPFrame_Length=0;

volatile unsigned char ESPrxChar=0;

static const uint16_t crc_tbl[16] = {
    0x0000, 0x1081, 0x2102, 0x3183,
    0x4204, 0x5285, 0x6306, 0x7387,
    0x8408, 0x9489, 0xa50a, 0xb58b,
    0xc60c, 0xd68d, 0xe70e, 0xf78f
};

unsigned short Crc16(const uint8_t *data, uint32_t len)
{
        uint8_t  byte;
        uint16_t CrcVal=0;
    	while (len--)
	    {
    		byte= *data++;
    		CrcVal = ((CrcVal >> 4) & 0x0fff) ^ crc_tbl[((CrcVal ^ byte) & 15)];
        	byte>>= 4;
        	CrcVal = ((CrcVal >> 4) & 0x0fff) ^ crc_tbl[((CrcVal ^ byte) & 15)];
    	}
    	return CrcVal;
}


void ProcessESP(void)
{

	if((gu32_ESPprocessIndex < gu32_ESPrecDataIndex[gu8_ESPBufferFlag2] ))
	{

		for(gu32_ESPdataIndex=gu32_ESPprocessIndex; gu32_ESPdataIndex < gu32_ESPrecDataIndex[gu8_ESPBufferFlag2]; gu32_ESPdataIndex++)
		{

			ESPrxChar = gu8_ESPrecData[gu32_ESPdataIndex];
			if((ESPrxChar == 0x02) && (gu8_ESPStartByte==0))
			{
				  gu8_ESPStartByte = 1;
				  gu16_ESPRxBufferIndex=0;
                  memset((unsigned char*)gu8_ESPRxBuffer,0x00,sizeof(gu8_ESPRxBuffer));

			}
			else if((ESPrxChar == 0x03) && (gu8_ESPStartByte == 1))
			{
				ESPFrame_Length=((gu8_ESPRxBuffer[3]<<8)|(gu8_ESPRxBuffer[4]));
				if(ESPFrame_Length==(gu16_ESPRxBufferIndex-(FRAMEDATAINDEX_OFFSET)+1 ))
				{
					gu8_ESPStartByte = 2;
				}
				else
				{
					gu8_ESPStartByte = 1;
				}
			}

			if((gu8_ESPStartByte==1)||(gu8_ESPStartByte==2))
			{
				//if(gu16_ESPRxBufferIndex<(sizeof(gu8_ESPRxBuffer)-1))
				{
					gu8_ESPRxBuffer[gu16_ESPRxBufferIndex] = ESPrxChar;
					gu16_ESPRxBufferIndex++;
				}
		    }

		}

		gu32_ESPprocessIndex = gu32_ESPrecDataIndex[gu8_ESPBufferFlag2];
		if(gu32_ESPprocessIndex > ESPBUFFERSIZE)
		{
			gu32_ESPrecDataIndex[gu8_ESPBufferFlag2]=0;
			gu8_ESPBufferFlag2 = 1 - gu8_ESPBufferFlag2;
			gu32_ESPprocessIndex = 0;
		}

	}

}



void ProcessESPFrames(void)
{
   int breaak=0;

   if(gu8_ESPStartByte==2)
   {
	     ESPFrame.gu32_ESPFerameType=0;
	     ESPFrame.gu32_ESPFrameLength=0;
	     ESPFrame.gu32_ESPFerameType=gu8_ESPRxBuffer[FRAMEPACKETINDEX];

	     ESPFrame.gu32_ESPFrameLength=gu8_ESPRxBuffer[LENGTHINDEXHIGH];
	     ESPFrame.gu32_ESPFrameLength*=256;
	     ESPFrame.gu32_ESPFrameLength|=gu8_ESPRxBuffer[LENGTHINDEXLOW];


         //if(App_System.testMode!=1)
         {
	    	 memset(&gu8_ESPRxDataBuffer[0],0x00,sizeof(gu8_ESPRxDataBuffer));
	    	 gu16_ESPRxDataBufferIndex= ESPFrame.gu32_ESPFrameLength-1;
	    	 memcpy(&gu8_ESPRxDataBuffer[0],&gu8_ESPRxBuffer[DATAINDEXOFFSET],gu16_ESPRxDataBufferIndex);
         }

#ifdef DEBUGMODE
         printf("\nLEngth:%d,%d\n",gu16_ESPRxDataBufferIndex,ESPFrame.gu32_ESPFerameType);
#endif
	   switch (ESPFrame.gu32_ESPFerameType)
	   {
	          case 0x80://FIRMWAREINFO:
	          {
	        	  	if(gu8_ESPRxBuffer[5]==0x01)
	        	  	{

	        		  	if(GetFirmwareLength(gu8_ESPRxDataBuffer,gu16_ESPRxDataBufferIndex)==1)
	                	{
	                		F_OTAStatus=FIRMWAREPACKETRECEIVE;
	                		App_System.gu8_NextFwPacketQuery=1;
 	                	}
	        		  	else
	        		  	{
	    					HMI_Send(3);
	    					App_System.gu8_BootloderTimeoutCounter=0;
	    					App_System.gu8_BootloderTimeoutFlag=1;

	        		  	}
#ifdef DEBUGMODE
printf("\n Firmware Length Received ");
#endif
	        	  	}
	          }break;
	          case 0x81://FIRMWAREPACKET:
	          {

	        	  F_OTA.RecFirmwarePacket++;
	        	  App_System.gu8_NextFwPacketQuery=1;
	        	  F_OTA.RecFirmware_size+=(ESPFrame.gu32_ESPFrameLength-3);
	        	  FirmwarePacketValidate(&gu8_ESPRxDataBuffer[0],gu16_ESPRxDataBufferIndex);
	        	  Percent=(int)((F_OTA.RecFirmwarePacket*100)/(F_OTA.FirmwarePacket-1));
	        	  //if((Percent % 2) == 0)
	        	  {
	        		  HMI_Send(1);
	        	  }

#ifdef DEBUGMODE

printf("FwP:%d\r\n",  F_OTA.RecFirmwarePacket);
printf("Fws:%d\r\n",  F_OTA.RecFirmware_size);
//printf("Download Percent :%f %\r\n",  Percent*100);
#endif
App_System.testMode=1;
//printf("Download Percent :%f \r\n",  Percent);

	          }break;
	          case 0x82://WIFIINTERNETSTATUS:
	          {
	        	if(gu8_ESPRxBuffer[5]==0x01)
	        	{
#ifdef DEBUGMODE
printf("\nInternet connected Okk ");
#endif
	        	}
	        	else
	        	{
	        		App_System.gu8_WifiCredentialQuery=1;
	        		App_System.gu8_isInternetConnected=0;
	        		App_System.gu8_FirmwareUpgradeQuery=0;
	        		F_OTAStatus=ISINTERNETCONNECTEDCKECK;
#ifdef DEBUGMODE
printf("\n Wifi credential Query  ");
#endif
	        	}
	          }break;
	          case 0x83://INTERNETSTSTUS:
	          {

#ifdef DEBUGMODE
printf("\n Internet Status Received ");
#endif
	        	  if(gu8_ESPRxBuffer[5]==0x01)
	        	  {
					  App_System.gu8_isInternetConnected=1;
                      App_System.gu8_FirmwareUpgradeQuery=1;
                      F_OTAStatus=FIRMWARELENGHTFOUND;
#ifdef DEBUGMODE
printf("\n Internet connected Okk ");
#endif
  	        	  }

	          }break;
	          case 0x88://FILENOTFOUND
	          {

					if(gu8_ESPRxBuffer[5]==0x01)
					{

					#ifdef DEBUGMODE
					printf("\n Internet connected Okk ");
					#endif

					HMI_Send(3);
					App_System.gu8_BootloderTimeoutCounter=0;
					App_System.gu8_BootloderTimeoutFlag=1;

					}

	          }break;



	          default:
	          {
	        	  ;
	          }break;
	   	   }
	       gu8_ESPStartByte=0;
   }

}
