/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
extern void Bootloader_JumpToApplication(void);
extern void AllPheripheralDeint(void);
/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define HMI_TX_Pin GPIO_PIN_10
#define HMI_TX_GPIO_Port GPIOB
#define HMI_RX_Pin GPIO_PIN_11
#define HMI_RX_GPIO_Port GPIOB
#define EMERGENCY_STOP_Pin GPIO_PIN_8
#define EMERGENCY_STOP_GPIO_Port GPIOD

#define EMG_SW_READ HAL_GPIO_ReadPin(EMERGENCY_STOP_GPIO_Port,EMERGENCY_STOP_Pin)

/* USER CODE BEGIN Private defines */
//////////////////////////4G CHANGES////////////////////////////////////////////
#define RELAY_SW_ESP_pin GPIO_PIN_1
#define RELAY_SW_ESP_GPIO_Port GPIOD

#define ESPON_pin GPIO_PIN_2
#define ESPON_GPIO_Port GPIOD

#define GSMON_pin GPIO_PIN_3
#define GSMON_GPIO_Port GPIOD

#define RFIDON_pin GPIO_PIN_11
#define RFIDON_GPIO_Port GPIOD

#define RFIDON HAL_GPIO_WritePin(RFIDON_GPIO_Port,RFIDON_pin,GPIO_PIN_RESET);
#define RFIDOFF HAL_GPIO_WritePin(RFIDON_GPIO_Port,RFIDON_pin,GPIO_PIN_SET);

#define RELAY_SW_ESPON HAL_GPIO_WritePin(RELAY_SW_ESP_GPIO_Port,RELAY_SW_ESP_pin,GPIO_PIN_RESET);
#define RELAY_SW_ESPOFF HAL_GPIO_WritePin(RELAY_SW_ESP_GPIO_Port,RELAY_SW_ESP_pin,GPIO_PIN_SET);

#define ESPON HAL_GPIO_WritePin(ESPON_GPIO_Port,ESPON_pin,GPIO_PIN_RESET);
#define ESPOFF HAL_GPIO_WritePin(ESPON_GPIO_Port,ESPON_pin,GPIO_PIN_SET);

#define GSMON HAL_GPIO_WritePin(GSMON_GPIO_Port,GSMON_pin,GPIO_PIN_RESET);
#define GSMOFF HAL_GPIO_WritePin(GSMON_GPIO_Port,GSMON_pin,GPIO_PIN_SET);

/////////////////////////////////////////////////////////////////////////////
/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
