/*
 * App_internalFlash.h
 *
 *  Created on: 12-Sep-2022
 *      Author: LUBI
 */

#ifndef INC_APP_INTERNALFLASH_H_
#define INC_APP_INTERNALFLASH_H_

/* Base address of the Flash sectors */
#define ADDR_FLASH_SECTOR_0     ((uint32_t)0x08000000) /* Base @ of Sector 0, 16 Kbytes */
#define ADDR_FLASH_SECTOR_1     ((uint32_t)0x08004000) /* Base @ of Sector 1, 16 Kbytes */
#define ADDR_FLASH_SECTOR_2     ((uint32_t)0x08008000) /* Base @ of Sector 2, 16 Kbytes */
#define ADDR_FLASH_SECTOR_3     ((uint32_t)0x0800C000) /* Base @ of Sector 3, 16 Kbytes */

#define ADDR_FLASH_SECTOR_4     ((uint32_t)0x08010000) /* Base @ of Sector 4, 64 Kbytes */
#define ADDR_FLASH_SECTOR_5     ((uint32_t)0x08020000) /* Base @ of Sector 5, 128 Kbytes */
#define ADDR_FLASH_SECTOR_6     ((uint32_t)0x08040000) /* Base @ of Sector 6, 128 Kbytes */ //if Flash size is 512Kb



#define ADDR_FLASH_SECTOR_7     ((uint32_t)0x08060000) /* Base @ of Sector 7, 128 Kbytes */
#define ADDR_FLASH_SECTOR_8     ((uint32_t)0x08080000) /* Base @ of Sector 8, 128 Kbytes */
#define ADDR_FLASH_SECTOR_9     ((uint32_t)0x080A0000) /* Base @ of Sector 9, 128 Kbytes */
#define ADDR_FLASH_SECTOR_10    ((uint32_t)0x080C0000) /* Base @ of Sector 10, 128 Kbytes */
#define ADDR_FLASH_SECTOR_11    ((uint32_t)0x080E0000) /* Base @ of Sector 11, 128 Kbytes */





#define FLASH_PROGRAM_START_ADDR   ADDR_FLASH_SECTOR_4
#define FLASH_PROGRAM_END_ADDR     ADDR_FLASH_SECTOR_6


typedef struct
{

    volatile  unsigned int AppCodeStartAdd;
    volatile  unsigned int AppCodeMaxAdd;
    volatile  unsigned int AppCodeWriteAddress;

}InternalFlashDatabase;
extern InternalFlashDatabase ProgramFlash;



extern void WriteFirmwarePacketToFlash(unsigned char* FirmwareBytePAcket,unsigned short PacketSize);
extern void EraseApplicationProgramMemory(void);
extern void InternalFlash_Unlock(void);
extern void InternalFlash_Lock(void);


#endif /* INC_APP_INTERNALFLASH_H_ */
