/*
 * App_Flash.h
 *
 *  Created on: 02-Sep-2022
 *      Author: LUBI
 */

#ifndef INC_APP_FLASH_H_
#define INC_APP_FLASH_H_


#include <stdbool.h>
#include "main.h"
#include "spi.h"

#define	FLASH_CS_GPIO_Port   						GPIOA
#define	FLASH_CS_Pin		  						GPIO_PIN_4

#define		_W25QXX_SPI								hspi1
#define		_W25QXX_CS_GPIO							GPIOA
#define		_W25QXX_CS_PIN		 					GPIO_PIN_4
#define      W25QXX_DUMMY_BYTE                      0xA5

#define DEVICEID_COMMAND
#define DEVICE_UNIQUEID_COMMAND
#define WRITE_ENABLE_COMMAND


#define DATABASE_SECTOR_LIMIT 255
#define DATABASE_SECTOR_START 241
#define CONFIGURATIION_SECTOR 239
#define OCPP_PARAMETER_SECTOR 240


#define NSS_LOW              						HAL_GPIO_WritePin(_W25QXX_CS_GPIO,_W25QXX_CS_PIN,GPIO_PIN_RESET);
#define NSS_HIGH            						HAL_GPIO_WritePin(_W25QXX_CS_GPIO,_W25QXX_CS_PIN,GPIO_PIN_SET);


typedef enum
{
	W25Q10=1,
	W25Q20,
	W25Q40,
	W25Q80,
	W25Q16,
	W25Q32,
	W25Q64,
	W25Q128,
	W25Q256,
	W25Q512,

}W25QXX_ID_t;
typedef struct {
	char fw_status;//364
	char fw_uri[100]; //181
	char fw_servername[30]; //211
	char fw_username[20]; //231
	char fw_Password[20]; //251
	char fw_Port[5]; //256
	char Communication_Mode;
	char wifi_ssid[20];
	char wifi_password[20];
	unsigned char ether_ip[10]; //61
	unsigned char ether_getway[10]; //71
	unsigned char ether_subnetmask[10];  //81
	char ipselection;				//V5.0 changes
	char networkoperator[32];		//V5.0 changes
	unsigned int Boot_Magic_value;

	char Mob_Num[20];
	char config_password[6];

	int energy_charges;
	int time_charges;
	int energy_charges_AC02;
	int time_charges_AC02;

	char ocpp_uri[100]; //181
	char OCPP_servername[30]; //211
	char OCPP_username[20]; //231
	char OCPP_Password[20]; //251
	char OCPP_Port[7]; //256
	char ocpp_status[2]; //258
	signed int under_voltage; //337
	signed int over_voltage; //341
	signed int over_current; //345
	signed int over_current_AC02;
	char vendor_id[16]; //13+350=363
	char serial_no[16];

	unsigned int STATE_A_LEVEL;
	unsigned int STATE_B_LEVEL;
	unsigned int STATE_C_LEVEL;
	unsigned int STATE_D_LEVEL;
	unsigned int auxinput;

	uint32_t acc_enery1;
	uint32_t acc_enery2;
	uint32_t acc_enery3;

	unsigned int magic_value; //368
}Config_Parameter;
extern  Config_Parameter OCPP, OCPP_READ;

typedef struct
{


	uint8_t			UniqID[8];
	uint8_t			StatusRegister1;
	uint8_t			StatusRegister2;
	uint8_t			StatusRegister3;
	uint32_t    	PageSize;
	uint32_t		ChipID;
	uint32_t		PageCount;
	uint32_t		SectorSize;
	uint32_t		SectorCount;
	uint32_t		BlockSize;
	uint32_t		BlockCount;
	uint32_t		CapacityInKiloByte;

}w25qxx_t;

typedef struct
{

	unsigned short FlashCommunicationOkFlag;
	unsigned short FullSectorWrittenFlag;
	unsigned short CurrentSector;
	unsigned short CurrentPage;
	unsigned short CurrentByteAddr;
	unsigned short LastReadSector;
	unsigned short LastReadPage;
	unsigned short LastReadByteAddr;
	unsigned short EntryCount;
	unsigned short ReadCount;
	unsigned short SDFlushCount;

} FlashExternal;

extern FlashExternal Database,FirwareDatabase,DefaultDatabase;

uint8_t Init_FlashMemory(void);
void FlashRead_CurrentConfig(void);
uint8_t	W25qxx_Spi(uint8_t	Data);
void ExtFlashBusyCheck(void);
void ExtFlashEraseSector(unsigned short sectorNo);
void ExtFlash_ChipErase(void);
unsigned short Get_ExtFlash_LastSector(void);
unsigned short Get_ExtFlash_LastPage(unsigned short LastSectorNumber);
unsigned short Get_ExtFlash_LastByteAdd(unsigned short LastPageNumber,unsigned short LastSectorNumber);
void Get_CurrentFlashAddress();
void ExtFlash_Program(unsigned char *wStr_Pointer,unsigned char wCurr_Sector,unsigned char wCurr_page,unsigned char wCurr_ByteAdd,unsigned int wStr_Length);
void ExtFlash_Read(unsigned char *rStr_Pointer,unsigned char rCurr_Sector,unsigned char rCurr_page,unsigned char rCurr_ByteAdd,unsigned int rStr_Length);
void Ext_FlashDEbug(void);
void FlashWrite_CurrentConfig(void);
void FlashWrite_OCPPConfig(void);
void ExtFlash_PageWrite(unsigned char *wStr_Pointer, unsigned char wCurr_Sector, unsigned char wCurr_page, unsigned int wStr_Length);
void ExtFlash_Program_FW(unsigned char *wStr_Pointer, unsigned char wCurr_Sector, unsigned char wCurr_page, unsigned char wCurr_ByteAdd, unsigned int wStr_Length);

void EraseFirmwareMemory(void);
void Flash_readOCPPParameter(void);

#endif /* INC_APP_FLASH_H_ */
