/*
 * App_ESP.h
 *
 *  Created on: Aug 30, 2022
 *      Author: LUBI
 */

#ifndef INC_APP_ESP_H_
#define INC_APP_ESP_H_

#include "stdio.h"
#include "main.h"
#include "usart.h"

#define ESP32_UART    huart2
#define ESPBUFFERSIZE 512

#define FRAMESTARTBYTEINDEDX  0X00
#define FRAMEPACKETINDEX      0X01
#define FRAMEPACKETSUBINDEX   0X02
#define LENGTHINDEXHIGH       0X03
#define LENGTHINDEXLOW        0X04
#define DATAINDEXOFFSET        0X06
typedef struct
{
	uint32_t   gu32_ESPFerameType;
	uint32_t   gu32_ESPFrameLength;
}FrameInfo;



extern unsigned char  ESPtxBuffer[256];
extern  unsigned char  gu8_ESPrecData[ESPBUFFERSIZE+1],gu8_ESPrecCh ;
extern volatile unsigned int   gu32_ESPrecDataIndex[2],gu32_ESPprocessIndex,gu32_ESPdataIndex ;
extern volatile unsigned char  gu8_ESPBufferFlag1, gu8_ESPBufferFlag2,gu8_ESPStartByte;



void ProcessESP(void);
void ProcessESPFrames(void);
unsigned short Crc16(const uint8_t *data, uint32_t len);
#endif /* INC_APP_ESP_H_ */
