# Home Charger 7.4kW With RFID

This repository contains the firmware for the Home Charger, designed for charging electric vehicles with a maximum power of 7.4kW. The firmware is written for STM32 microcontrollers and includes various features for controlling the charging process, managing states, and providing safety features such as Emergency Stop and Ground Fault Detection (GFD).

## Features

- **State Management**: The charger operates in multiple states: State A (idle), State B (charging), and State C (completed charging).
- **PWM Control**: PWM signals are used for controlling the charger’s power.
- **ADC Monitoring**: ADCs monitor key parameters like voltage and current.
- **Emergency Stop**: The charger will stop if an emergency is detected.
- **Ground Fault Detection (GFD)**: The system detects ground faults to ensure safe charging.
- **RFID Authentication**: The system supports RFID-based authentication for secure access to the charger.
- **Internal Flash Storage**: Configuration data and RFID parameters are stored in internal Flash memory.
- **UART Communication**: UART communication is used for interaction with external devices and debugging.
- **Watchdog Timer**: The system uses an independent watchdog timer (IWDG) for system stability.

## Hardware

The firmware is designed for STM32F1 microcontrollers. The key hardware components involved include:

- STM32F1 Microcontroller
- Relay control for switching charging states
- PWM driver for power regulation
- ADC inputs for monitoring voltage and current
- UART for external communication
- Internal Flash memory for configuration storage
- RFID reader for secure charging access

## System Configuration

The system works in three main states:

- **State A**: The charger is in idle mode. No charging is happening.
- **State B**: The charger is actively charging the vehicle.
- **State C**: The charging process has completed.

### State Transitions

- **State A → State B**: Charging begins when a vehicle is connected, safety checks pass (no emergency stop, GFD clear), and RFID authentication succeeds.
- **State B → State C**: Transition occurs when the vehicle signals that charging is complete or the charger detects full battery.
- **State B → State A**: Happens if charging is manually stopped, the vehicle disconnects, or a fault/error occurs.
- **State A → State C**: ❌ [This transition is invalid in typical operation and should be removed unless specifically required for edge-case handling.]

## Error Handling

- **Emergency Stop**: The charger stops immediately when an emergency stop is triggered.
- **Ground Fault Detection (GFD)**: If a ground fault is detected, the system stops the charging process for safety.
- **ADC Errors**: If there are ADC errors (e.g., values out of expected range), the system triggers a reset to avoid damage.

## Configuration Mode

The charger can be configured using UART commands, allowing the user to modify settings like RFID data or charging parameters. To enter configuration mode:

|   Command    |         Function              |
|  *1##        | Enable RFID Config Mode       |
|  *2##        | Read all stored RFIDs         |
|  *A1##       | Add RFID to slot 1            |
|  *A2##       | Add RFID to slot 2            |
|  *A3##       | Add RFID to slot 3            |
|  *R1##       | Remove RFID from slot 1       |
|  *R2##       | Remove RFID from slot 2       |
|  *R3##       | Remove RFID from slot 3       |
|  *4##        | Save RFID data                |
|  *5##        | Enable CP config mode         |
|  *6##        | Print current CP ADC value    |
|  *7A##       | Set thresholds for CP states  |
|  *7B##       | Set thresholds for CP states  |
|  *7C##       | Set thresholds for CP states  |
|  *7D##       | Set thresholds for CP states  |
|  *8##        | Save thresholds	       |
|  *9##        | Read stored threshold values  |


## Directory Structure

```
/HOME_CHARGER_WITH_RFID_7.4kW
    ├── Core/                      # Application source and header files (main.c, system config, etc.)
    ├── Drivers/                   # CMSIS and STM32 HAL drivers
    ├── Debug/                     # Compiled output and debug files
    ├── HOME_CHARGER_WITH_RFID_7.4kW.ioc     # STM32CubeMX project configuration file
    ├── HOME_CHARGER_WITH_RFID_7.4kW Debug.launch  # Debug configuration
    ├── STM32F103C8TX_FLASH.ld     # Linker script
    └── README.md                  # Project documentation

```

## Usage

1. **Build the firmware**: Use STM32CubeIDE or another compatible toolchain to compile the firmware.
2. **Flash the firmware**: Upload the firmware to the STM32 microcontroller using a programmer like ST-Link.
3. **Monitor the charging process**: Use UART to communicate with the charger for real-time data or to send commands for configuration.

## Safety Considerations

- Always ensure that the charger is connected to the correct power source and the vehicle is compatible with the 7.4kW charging capacity.
- Regularly check the GFD system to ensure that there are no electrical faults.
- Ensure that the Emergency Stop button is functional and easily accessible.

## License

This project is licensed under the BSD 3-Clause License. See the LICENSE file for more information.

## References

- STMicroelectronics STM32F1 Series
- STM32CubeIDE
