/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f1xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */
void HAL_TIM_MspPostInit(TIM_HandleTypeDef *htim);
/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/

#define UTX_Pin GPIO_PIN_9
#define U_GPIO_Port GPIOA

#define URX_Pin GPIO_PIN_10
#define U_GPIO_Port GPIOA

#define LED3_Pin GPIO_PIN_3 //hearbeat
#define LED3_GPIO_Port GPIOA
#define LED2_Pin GPIO_PIN_4 //hearbeat
#define LED2_GPIO_Port GPIOA
#define LED1_Pin GPIO_PIN_5 //hearbeat
#define LED1_GPIO_Port GPIOA
#define EMG_SW_Pin GPIO_PIN_7
#define EMG_SW_GPIO_Port GPIOB
#define BUZZER_Pin GPIO_PIN_7
#define BUZZER_GPIO_Port GPIOA

#define USART3_TX_Pin GPIO_PIN_10
#define USART3_TX_GPIO_Port GPIOB
#define USART3_RX_Pin GPIO_PIN_11
#define USART3_RX_GPIO_Port GPIOB

#define RELAY1_Pin GPIO_PIN_12
#define RELAY1_GPIO_Port GPIOB
#define LED6_Pin GPIO_PIN_15
#define LED6_GPIO_Port GPIOA
#define LED5_Pin GPIO_PIN_4
#define LED5_GPIO_Port GPIOB
#define LED4_Pin GPIO_PIN_5
#define LED4_GPIO_Port GPIOB


#define GFD_Pin GPIO_PIN_13
#define GFD_GPIO_Port GPIOC
/* USER CODE BEGIN Private defines */


#define GFD_READ HAL_GPIO_ReadPin(GFD_GPIO_Port,GFD_Pin)
#define EMG_SW_READ HAL_GPIO_ReadPin(EMG_SW_GPIO_Port,EMG_SW_Pin)

#define LED1_ON HAL_GPIO_WritePin(LED1_GPIO_Port,LED1_Pin,GPIO_PIN_RESET);
#define LED1_OFF HAL_GPIO_WritePin(LED1_GPIO_Port,LED1_Pin,GPIO_PIN_SET);
#define TOGGLE_LED1 HAL_GPIO_TogglePin(LED1_GPIO_Port,LED1_Pin);

#define LED2_ON HAL_GPIO_WritePin(LED2_GPIO_Port,LED2_Pin,GPIO_PIN_RESET);
#define LED2_OFF HAL_GPIO_WritePin(LED2_GPIO_Port,LED2_Pin,GPIO_PIN_SET);
#define TOGGLE_LED2 HAL_GPIO_TogglePin(LED2_GPIO_Port,LED2_Pin);

#define LED3_ON HAL_GPIO_WritePin(LED3_GPIO_Port,LED3_Pin,GPIO_PIN_RESET);
#define LED3_OFF HAL_GPIO_WritePin(LED3_GPIO_Port,LED3_Pin,GPIO_PIN_SET);
#define TOGGLE_LED3 HAL_GPIO_TogglePin(LED3_GPIO_Port,LED3_Pin);

//extern red
#define LED4_ON HAL_GPIO_WritePin(LED4_GPIO_Port,LED4_Pin,GPIO_PIN_SET);
#define LED4_OFF HAL_GPIO_WritePin(LED4_GPIO_Port,LED4_Pin,GPIO_PIN_RESET);
#define TOGGLE_LED4 HAL_GPIO_TogglePin(LED4_GPIO_Port,LED4_Pin);

//extern green
#define LED5_ON HAL_GPIO_WritePin(LED5_GPIO_Port,LED5_Pin,GPIO_PIN_SET);
#define LED5_OFF HAL_GPIO_WritePin(LED5_GPIO_Port,LED5_Pin,GPIO_PIN_RESET);
#define TOGGLE_LED5 HAL_GPIO_TogglePin(LED5_GPIO_Port,LED5_Pin);

//extern blue
#define LED6_ON HAL_GPIO_WritePin(LED6_GPIO_Port,LED6_Pin,GPIO_PIN_SET);
#define LED6_OFF HAL_GPIO_WritePin(LED6_GPIO_Port,LED6_Pin,GPIO_PIN_RESET);
#define TOGGLE_LED6 HAL_GPIO_TogglePin(LED6_GPIO_Port,LED6_Pin);

#define ALL_LED_OFF {LED1_OFF;LED2_OFF;LED3_OFF;LED4_OFF;LED5_OFF;LED6_OFF;}

#define BUZZER_ON HAL_GPIO_WritePin(BUZZER_GPIO_Port,BUZZER_Pin,GPIO_PIN_SET);
#define BUZZER_OFF HAL_GPIO_WritePin(BUZZER_GPIO_Port,BUZZER_Pin,GPIO_PIN_RESET);
#define TOGGLE_BUZZER HAL_GPIO_TogglePin(BUZZER_GPIO_Port,BUZZER_Pin);

#define relayOff HAL_GPIO_WritePin(RELAY1_GPIO_Port,RELAY1_Pin,GPIO_PIN_SET); //relay OFF
#define relayOn HAL_GPIO_WritePin(RELAY1_GPIO_Port,RELAY1_Pin,GPIO_PIN_RESET); //relay ON
/* Equation for duty cycle

   for 6A to 51A => Current(A) = DutyCycle(%)*0.6  => DutyCycle= Current/0.6
	 for 51A to 80A => Current(A) = [DutyCycle(%)-64]*2.5 => DutyCycle => [Current/2.5]+64

*/
#define PWM_DUTY_CYCLE_0	0    //for not selected
#define PWM_DUTY_CYCLE_1	16   // 10/0.6 => 16.666
#define PWM_DUTY_CYCLE_2	26	 // 16/0.6 => 26.666
#define PWM_DUTY_CYCLE_3	33	 // 20/0.6 => 33.333
#define PWM_DUTY_CYCLE_4	41   // 25/0.6 => 41.666
#define PWM_DUTY_CYCLE_5	53   // 32/0.6 => 53.333

#define STATE_A   0
#define STATE_B   1
#define STATE_C   2
#define STATE_D   3

// Added by Nihar
struct rfid_data{
	uint8_t rfid1[14];
	uint8_t rfid2[14];
	uint8_t rfid3[14];
	uint8_t GFDBypassEn;
	uint8_t RFIDBypassEn;
	uint8_t dummy;
    uint16_t STATE_A_LEVEL;
    uint16_t STATE_B_LEVEL;
    uint16_t STATE_C_LEVEL;
    uint16_t STATE_D_LEVEL;
    uint16_t magic_value;
};

extern const struct rfid_data	default_params;


/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
