/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    stm32g0xx_it.c
  * @brief   Interrupt Service Routines.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32g0xx_it.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "string.h"
#include "ext_var.h"
#include "ext_fun.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/
extern DMA_HandleTypeDef hdma_adc1;
extern ADC_HandleTypeDef hadc1;
extern TIM_HandleTypeDef htim3;
extern TIM_HandleTypeDef htim6;
extern TIM_HandleTypeDef htim7;
extern DMA_HandleTypeDef hdma_usart1_tx;
extern DMA_HandleTypeDef hdma_usart1_rx;
extern UART_HandleTypeDef huart1;
/* USER CODE BEGIN EV */

/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M0+ Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
  * @brief This function handles Non maskable interrupt.
  */
void NMI_Handler(void)
{
  /* USER CODE BEGIN NonMaskableInt_IRQn 0 */

  /* USER CODE END NonMaskableInt_IRQn 0 */
  /* USER CODE BEGIN NonMaskableInt_IRQn 1 */
  while (1)
  {
  }
  /* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
  /* USER CODE BEGIN HardFault_IRQn 0 */

  /* USER CODE END HardFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_HardFault_IRQn 0 */
    /* USER CODE END W1_HardFault_IRQn 0 */
  }
}

/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{
  /* USER CODE BEGIN SVC_IRQn 0 */

  /* USER CODE END SVC_IRQn 0 */
  /* USER CODE BEGIN SVC_IRQn 1 */

  /* USER CODE END SVC_IRQn 1 */
}

/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{
  /* USER CODE BEGIN PendSV_IRQn 0 */

  /* USER CODE END PendSV_IRQn 0 */
  /* USER CODE BEGIN PendSV_IRQn 1 */

  /* USER CODE END PendSV_IRQn 1 */
}

/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
  /* USER CODE BEGIN SysTick_IRQn 0 */

	if((pwm_start_stop==0)  && (++adctempcnt >100))
	{
		adctempcnt=0;
		adc_check();

	}

		if(blue_led_blink)blue_led_blink--;
		if(red_led_blink)red_led_blink--;
		if(green_led_blink)green_led_blink--;
		if(blue_led_blink_1)blue_led_blink_1--;
		if(red_led_blink_1)red_led_blink_1--;
		if(green_led_blink_1)green_led_blink_1--;
		if(buzzer_enable_time)buzzer_enable_time--;




	if(!EMG_SW_READ)
	{
		Emergency_stop_count++;
		if(Emergency_stop_count>=100)
		{
      Emergency_stop=1;
		}
	}
	else
	{
		Emergency_stop_count=0;
		Emergency_stop=0;
	}

	if(!USERBUTTON2_READ)
	{
		user1_stop_count++;
		if(user1_stop_count>=100)
		{
			user1_stop=1;
		}
	}
	else
	{
		user1_stop_count=0;
		user1_stop=0;
	}

	if(!USERBUTTON3_READ)
		{
			user2_stop_count++;
			if(user2_stop_count>=100)
			{
				user2_stop=1;
			}
		}
		else
		{
			user2_stop_count=0;
			user2_stop=0;
		}

	if(configparameters.GFDBypassEn == 1)
	{
		if(GFD_READ)
		{
			GFD_stop_count++;
			if(GFD_stop_count>=100)
			{
				GFD_stop=1;
			}
		}
		else
		{
			GFD_stop_count=0;
			GFD_stop=0;
		}
	}
	else
	{
		GFD_stop_count=0;
		GFD_stop=0;
	}



	if(Emergency_stop || GFD_stop)
	{
		if(red_led_blink==0)
		{
			red_led_blink=500;
			TOGGLE_LED1R;
			TOGGLE_LED2R;
		}
		LED1G_OFF;
		LED1B_OFF;
		LED2G_OFF;
		LED2B_OFF;
		alarm=1;
	}
	else
	{

		if(CURRENT_STATE==STATE_A)
		{

//			if(!blue_led_blink)
//			{
//				blue_led_blink=500;
//				TOGGLE_LED1B;
//			}

			LED1B_ON;

			if(Emergency_stop==0 && GFD_stop == 0)
			 {
				LED1R_OFF;
			 }

			alarm=0;
		}
		else if(CURRENT_STATE==STATE_B)
		{

			LED1R_OFF;

			if(GUN1.Authentication_done == 1 )
			{

				if(!blue_led_blink)
					{
							lclflagLED = 1- lclflagLED;

						blue_led_blink=500;
						if(	lclflagLED)
						{
							LED1G_ON;
							LED1B_ON;
						}
						else
						{
							LED1G_OFF;
							LED1B_OFF;
						}

					}
			}
			else{

					if(!blue_led_blink)
					{
						blue_led_blink=500;
						TOGGLE_LED1B;
					}
					LED1G_OFF;
			}
			alarm=0;
		}
		else if(CURRENT_STATE==STATE_C && GUN1.chargingStop == 0)
		{
			 LED1G_ON;
			 LED1R_OFF;
			 LED1B_OFF;
			 alarm=0;
		}
		else if(CURRENT_STATE==STATE_C && GUN1.chargingStop == 1)
		{
			if(!blue_led_blink)
			{
				blue_led_blink=500;
			}
			LED1G_OFF;
			LED1B_ON;
		  LED1R_ON;


			alarm=0;
		}
		else if(CURRENT_STATE==STATE_D)
		{
			 if(Emergency_stop==0 && GFD_stop == 0)
			 {
				 LED1R_ON;
			 }

			 LED1G_OFF;
			 LED1B_OFF;

			 alarm=1;
		}

		if(CURRENT_STATE_1==STATE_A)
				{

		//			if(!blue_led_blink)
		//			{
		//				blue_led_blink=500;
		//				TOGGLE_LED1B;
		//			}

					LED2B_ON;

					if(Emergency_stop==0 && GFD_stop == 0)
					 {
						LED2R_OFF;
					 }

					alarm=0;
				}
				else if(CURRENT_STATE_1==STATE_B)
				{

					LED2R_OFF;

					if(GUN2.Authentication_done == 1 )
					{

						if(!blue_led_blink_1)
							{
									lclflagLED = 1- lclflagLED;

								blue_led_blink_1=500;
								if(	lclflagLED)
								{
									LED2G_ON;
									LED2B_ON;
								}
								else
								{
									LED2G_OFF;
									LED2B_OFF;
								}

							}
					}
					else{

							if(!blue_led_blink_1)
							{
								blue_led_blink_1=500;
								TOGGLE_LED2B;
							}
							LED2G_OFF;
					}
					alarm=0;
				}
				else if(CURRENT_STATE_1==STATE_C && GUN2.chargingStop == 0)
				{
					 LED2G_ON;
					 LED2R_OFF;
					 LED2B_OFF;
					 alarm=0;
				}
				else if(CURRENT_STATE_1==STATE_C && GUN2.chargingStop == 1)
				{
					if(!blue_led_blink_1)
					{
						blue_led_blink_1=500;
					}
					LED2G_OFF;
					LED2B_ON;
					LED2R_ON;
					alarm=0;
				}
 }


	/******buzzer**********/
	if(alarm)
	{
	 if(!buzzer_enable_time)
	 {
		 if(Emergency_stop || GFD_stop)
		 buzzer_enable_time=100;
		 else
		 buzzer_enable_time=500;
		 buzzer_enable=!buzzer_enable;
	 }

	 if(buzzer_enable)
	 {
		 TOGGLE_BUZZER;
	 }
	 else
	 {
		 BUZZER_OFF;
	 }
	}
	else BUZZER_OFF;

	/******buzzer**********/

/*	if(pwm_start_stop==0)// && ++adctempcnt >100 && uart_rxFlag==0)
	{
	adc_check();
	}*/



//	if(pwm_start_stop_1==0  && ( ++adctempcnt_1 >100))
//	{
//		adc_check_2();
//		adctempcnt_1=0;
//	}


  /* USER CODE END SysTick_IRQn 0 */
  HAL_IncTick();
  /* USER CODE BEGIN SysTick_IRQn 1 */

  /* USER CODE END SysTick_IRQn 1 */
}

/******************************************************************************/
/* STM32G0xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32g0xx.s).                    */
/******************************************************************************/

/**
  * @brief This function handles RCC global interrupt.
  */
void RCC_IRQHandler(void)
{
  /* USER CODE BEGIN RCC_IRQn 0 */

  /* USER CODE END RCC_IRQn 0 */
  /* USER CODE BEGIN RCC_IRQn 1 */

  /* USER CODE END RCC_IRQn 1 */
}

/**
  * @brief This function handles DMA1 channel 1 interrupt.
  */
void DMA1_Channel1_IRQHandler(void)
{
  /* USER CODE BEGIN DMA1_Channel1_IRQn 0 */

  /* USER CODE END DMA1_Channel1_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_usart1_tx);
  /* USER CODE BEGIN DMA1_Channel1_IRQn 1 */

  /* USER CODE END DMA1_Channel1_IRQn 1 */
}

/**
  * @brief This function handles DMA1 channel 2 and channel 3 interrupts.
  */
void DMA1_Channel2_3_IRQHandler(void)
{
  /* USER CODE BEGIN DMA1_Channel2_3_IRQn 0 */

  /* USER CODE END DMA1_Channel2_3_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_adc1);
  HAL_DMA_IRQHandler(&hdma_usart1_rx);
  /* USER CODE BEGIN DMA1_Channel2_3_IRQn 1 */

  /* USER CODE END DMA1_Channel2_3_IRQn 1 */
}

/**
  * @brief This function handles ADC1 interrupt.
  */
void ADC1_IRQHandler(void)
{
  /* USER CODE BEGIN ADC1_IRQn 0 */

  /* USER CODE END ADC1_IRQn 0 */
  HAL_ADC_IRQHandler(&hadc1);
  /* USER CODE BEGIN ADC1_IRQn 1 */

  /* USER CODE END ADC1_IRQn 1 */
}

/**
  * @brief This function handles TIM3 global interrupt.
  */
void TIM3_IRQHandler(void)
{
  /* USER CODE BEGIN TIM3_IRQn 0 */

  /* USER CODE END TIM3_IRQn 0 */
  HAL_TIM_IRQHandler(&htim3);
  /* USER CODE BEGIN TIM3_IRQn 1 */
  HAL_TIM_Base_Start_IT(&htim7);
/*	for(int i=0;i<300;i++);
	adc_check();*/

  /* USER CODE END TIM3_IRQn 1 */
}

/**
  * @brief This function handles TIM6 global interrupt.
  */
void TIM6_IRQHandler(void)
{
  /* USER CODE BEGIN TIM6_IRQn 0 */

  /* USER CODE END TIM6_IRQn 0 */
  HAL_TIM_IRQHandler(&htim6);
  /* USER CODE BEGIN TIM6_IRQn 1 */

  /* USER CODE END TIM6_IRQn 1 */
}

/**
  * @brief This function handles TIM7 global interrupt.
  */
void TIM7_IRQHandler(void)
{
  /* USER CODE BEGIN TIM7_IRQn 0 */

  /* USER CODE END TIM7_IRQn 0 */
  HAL_TIM_IRQHandler(&htim7);
  /* USER CODE BEGIN TIM7_IRQn 1 */

  adc_check();
  HAL_TIM_Base_Stop_IT(&htim7);
  /* USER CODE END TIM7_IRQn 1 */
}

/**
  * @brief This function handles USART1 global interrupt / USART1 wake-up interrupt through EXTI line 25.
  */
void USART1_IRQHandler(void)
{
  /* USER CODE BEGIN USART1_IRQn 0 */
	__HAL_UART_FLUSH_DRREGISTER(&huart1);
//	if(ui8fivesectimeout == 1)
//	{
//		HAL_UART_Receive_DMA(&huart1,id,14);
//	}
//	else
//	{
		HAL_UART_Receive_DMA(&huart1,&rxchar,1);
//	}
  /* USER CODE END USART1_IRQn 0 */
  HAL_UART_IRQHandler(&huart1);
  /* USER CODE BEGIN USART1_IRQn 1 */

  /* USER CODE END USART1_IRQn 1 */
}

/* USER CODE BEGIN 1 */
void HAL_UART_ErrorCallback(UART_HandleTypeDef *huart)
{
	if(huart->Instance == USART1)
	{
//		if(ui8fivesectimeout == 1)
//		{
//			HAL_UART_Receive_DMA(&huart1,id,14);
//		}
//		else
//		{
			HAL_UART_Receive_DMA(&huart1,&rxchar,1);
//		}
	}
}

void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart)
{

	if(huart->Instance == USART1)
	{
		char tagid[15];
		int i;
	    static uint8_t lclcounter=0;
		if(ui8fivesectimeout == 1 )
		{
			if(rxchar == 2 && startFrame == 0)
						{
							startFrame=1;
							lclcounter=0;
							id[lclcounter++]=rxchar;
						}
						else if(startFrame == 1 && rxchar != 3 && (lclcounter <= 15))
						{
							id[lclcounter++]=rxchar;
						}
						else if(startFrame == 1 && rxchar == 3)
						{
							id[lclcounter++]=rxchar;
							lclcounter=0;
							startFrame=0;
					        if((id[0] == 2) && (id[13] == 3) )
							 {
								 for(i=1;i<13;i++)
								 {
									 tagid[i-1] = id[i];
								 }
								 tagid[i-1] = '\0';

								 if(strcmp(tagid,configparameters.gun1TagId) == 0)
								 {
									 GUN1.Type2_OCPP_Authorization_Flag = 1;
								 }
								 else if(strcmp(tagid,configparameters.gun2TagId) == 0)
								 {
									 GUN2.Type2_OCPP_Authorization_Flag = 1;
								 }
								 else
								 {
									 GUN1.Authentication_done = 0;
									 GUN2.Authentication_done = 0;
									 GUN1.Type2_OCPP_Authorization_Flag = 0;
									 GUN2.Type2_OCPP_Authorization_Flag = 0;
								 }
								 if(GUN1.Type2_OCPP_Authorization_Flag == 1)
								 {
									 if(CURRENT_STATE==STATE_B && GUN1.chargingStart == 0)
									 {
										 GUN1.Authentication_done =1;
									 }
									 else if(CURRENT_STATE==STATE_C && GUN1.chargingStart == 1 && GUN1.chargingStop == 0)
									 {
										 GUN1.Authentication_done =1;
										 GUN1.chargingStop=1;

									 }
									 GUN1.Type2_OCPP_Authorization_Flag=0;
								 }
								 else if(GUN2.Type2_OCPP_Authorization_Flag == 1)
								 {
									 if(CURRENT_STATE_1==STATE_B && GUN2.chargingStart == 0)
									 {
										 GUN2.Authentication_done =1;
									 }
									 else if(CURRENT_STATE_1==STATE_C && GUN2.chargingStart == 1 && GUN2.chargingStop == 0)
									 {
										 GUN2.Authentication_done =1;
										 GUN2.chargingStop=1;

									 }
									 GUN2.Type2_OCPP_Authorization_Flag=0;
								 }
							 }

						}
						else
						{
							startFrame=0;
						}
						rxchar=0;

		}
		else
		{
			if(rxchar == '*' && startFrame == 0)
			{
				startFrame=1;
				lclcounter=0;
				rxbuff[lclcounter++]=rxchar;
			}
			else if(startFrame == 1 && rxchar != '#' && (lclcounter < 50))
			{
				rxbuff[lclcounter++]=rxchar;
			}
			else if(startFrame == 1 && rxchar == '#')
			{
				rxbuff[lclcounter++]=rxchar;
				lclcounter=0;
				cmdrxd=1;
				startFrame=0;
				configmode=1;
			}
			else
			{
				startFrame=0;
			}
			rxchar=0;
		}
	}//if(huart->Instance == USART1) ENDs HERE



}//void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart) ENDs HERE

/* USER CODE END 1 */
