/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32g0xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define GFD_Pin GPIO_PIN_13
#define GFD_GPIO_Port GPIOC
#define CP1_ADC_Pin GPIO_PIN_0
#define CP1_ADC_GPIO_Port GPIOA
#define CP2_ADC_Pin GPIO_PIN_1
#define CP2_ADC_GPIO_Port GPIOA
#define CP1_PWM_Pin GPIO_PIN_6
#define CP1_PWM_GPIO_Port GPIOA
#define CP2_PWM_Pin GPIO_PIN_7
#define CP2_PWM_GPIO_Port GPIOA
#define RELAY_GUN1_Pin GPIO_PIN_0
#define RELAY_GUN1_GPIO_Port GPIOB
#define RELAY_GUN2_Pin GPIO_PIN_1
#define RELAY_GUN2_GPIO_Port GPIOB
#define RFID_TX_Pin GPIO_PIN_9
#define RFID_TX_GPIO_Port GPIOA
#define RFID_RX_Pin GPIO_PIN_10
#define RFID_RX_GPIO_Port GPIOA
#define EM_SWITCH_Pin GPIO_PIN_15
#define EM_SWITCH_GPIO_Port GPIOA
#define USER_BUTTON1_Pin GPIO_PIN_0
#define USER_BUTTON1_GPIO_Port GPIOD
#define USER_BUTTON2_Pin GPIO_PIN_1
#define USER_BUTTON2_GPIO_Port GPIOD
#define USER_BUTTON3_Pin GPIO_PIN_3
#define USER_BUTTON3_GPIO_Port GPIOD
#define BUZZER_Pin GPIO_PIN_3
#define BUZZER_GPIO_Port GPIOB
#define LED2_B_Pin GPIO_PIN_4
#define LED2_B_GPIO_Port GPIOB
#define LED2_G_Pin GPIO_PIN_5
#define LED2_G_GPIO_Port GPIOB
#define LED2_R_Pin GPIO_PIN_6
#define LED2_R_GPIO_Port GPIOB
#define LED1_B_Pin GPIO_PIN_7
#define LED1_B_GPIO_Port GPIOB
#define LED1_G_Pin GPIO_PIN_8
#define LED1_G_GPIO_Port GPIOB
#define LED1_R_Pin GPIO_PIN_9
#define LED1_R_GPIO_Port GPIOB

/* USER CODE BEGIN Private defines */

#define GFD_READ HAL_GPIO_ReadPin(GFD_GPIO_Port,GFD_Pin)

#define GUN1RELAY_ON HAL_GPIO_WritePin(RELAY_GUN1_GPIO_Port,RELAY_GUN1_Pin,GPIO_PIN_RESET);
#define GUN2RELAY_ON HAL_GPIO_WritePin(RELAY_GUN2_GPIO_Port,RELAY_GUN2_Pin,GPIO_PIN_RESET);

#define GUN1RELAY_OFF HAL_GPIO_WritePin(RELAY_GUN1_GPIO_Port,RELAY_GUN1_Pin,GPIO_PIN_SET);
#define GUN2RELAY_OFF HAL_GPIO_WritePin(RELAY_GUN2_GPIO_Port,RELAY_GUN2_Pin,GPIO_PIN_SET);

#define LED1R_ON HAL_GPIO_WritePin(LED1_R_GPIO_Port,LED1_R_Pin,GPIO_PIN_SET);
#define LED1G_ON HAL_GPIO_WritePin(LED1_G_GPIO_Port,LED1_G_Pin,GPIO_PIN_SET);
#define LED1B_ON HAL_GPIO_WritePin(LED1_B_GPIO_Port,LED1_B_Pin,GPIO_PIN_SET);

#define LED1R_OFF HAL_GPIO_WritePin(LED1_R_GPIO_Port,LED1_R_Pin,GPIO_PIN_RESET);
#define LED1G_OFF HAL_GPIO_WritePin(LED1_G_GPIO_Port,LED1_G_Pin,GPIO_PIN_RESET);
#define LED1B_OFF HAL_GPIO_WritePin(LED1_B_GPIO_Port,LED1_B_Pin,GPIO_PIN_RESET);

#define TOGGLE_LED1R HAL_GPIO_TogglePin(LED1_R_GPIO_Port,LED1_R_Pin);
#define TOGGLE_LED1G HAL_GPIO_TogglePin(LED1_G_GPIO_Port,LED1_G_Pin);
#define TOGGLE_LED1B HAL_GPIO_TogglePin(LED1_B_GPIO_Port,LED1_B_Pin);

#define LED2R_ON HAL_GPIO_WritePin(LED2_R_GPIO_Port,LED2_R_Pin,GPIO_PIN_SET);
#define LED2G_ON HAL_GPIO_WritePin(LED2_G_GPIO_Port,LED2_G_Pin,GPIO_PIN_SET);
#define LED2B_ON HAL_GPIO_WritePin(LED2_B_GPIO_Port,LED2_B_Pin,GPIO_PIN_SET);

#define LED2R_OFF HAL_GPIO_WritePin(LED2_R_GPIO_Port,LED2_R_Pin,GPIO_PIN_RESET);
#define LED2G_OFF HAL_GPIO_WritePin(LED2_G_GPIO_Port,LED2_G_Pin,GPIO_PIN_RESET);
#define LED2B_OFF HAL_GPIO_WritePin(LED2_B_GPIO_Port,LED2_B_Pin,GPIO_PIN_RESET);

#define TOGGLE_LED2R HAL_GPIO_TogglePin(LED2_R_GPIO_Port,LED2_R_Pin);
#define TOGGLE_LED2G HAL_GPIO_TogglePin(LED2_G_GPIO_Port,LED2_G_Pin);
#define TOGGLE_LED2B HAL_GPIO_TogglePin(LED2_B_GPIO_Port,LED2_B_Pin);

#define ALL_LED_G1_OFF {LED1R_OFF;LED1G_OFF;LED1B_OFF;}
#define ALL_LED_G2_OFF {LED2R_OFF;LED2G_OFF;LED2B_OFF;}

#define BUZZER_ON HAL_GPIO_WritePin(BUZZER_GPIO_Port,BUZZER_Pin,GPIO_PIN_SET);
#define BUZZER_OFF HAL_GPIO_WritePin(BUZZER_GPIO_Port,BUZZER_Pin,GPIO_PIN_RESET);
#define TOGGLE_BUZZER HAL_GPIO_TogglePin(BUZZER_GPIO_Port,BUZZER_Pin);

#define EMG_SW_READ HAL_GPIO_ReadPin(EM_SWITCH_GPIO_Port,EM_SWITCH_Pin)

#define USERBUTTON1_READ HAL_GPIO_ReadPin(USER_BUTTON1_GPIO_Port,USER_BUTTON1_Pin)
#define USERBUTTON2_READ HAL_GPIO_ReadPin(USER_BUTTON2_GPIO_Port,USER_BUTTON2_Pin)
#define USERBUTTON3_READ HAL_GPIO_ReadPin(USER_BUTTON3_GPIO_Port,USER_BUTTON3_Pin)

/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
