/* Ethernet Basic Example

   This example code is in the Public Domain (or CC0 licensed, at your option.)


   Unless required by applicable law or agreed to in writing, this
   software is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
   CONDITIONS OF ANY KIND, either express or implied.
*/
/* Ethernet Basic Example

   This example code is in the Public Domain (or CC0 licensed, at your option.)

   Unless required by applicable law or agreed to in writing, this
   software is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
   CONDITIONS OF ANY KIND, either express or implied.
*/
#include <stdio.h>
#include <string.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "nvs_flash.h"
#include "esp_http_server.h"

#include "freertos/semphr.h"
#include "freertos/event_groups.h"
#include "freertos/queue.h"
#include "esp_task_wdt.h"

#include "lwip/err.h"
#include "lwip/sockets.h"
#include "lwip/sys.h"
#include "lwip/netdb.h"
#include "lwip/dns.h"

#include "esp_wifi.h"
#include "esp_system.h"
#include "esp_netif.h"
#include "esp_eth.h"
#include "esp_event.h"
#include "esp_log.h"
#include "mbedtls/base64.h"
#include "driver/gpio.h"
#include "sdkconfig.h"
#include "driver/uart.h"
#include "ping/ping_sock.h"
#include "esp_websocket_client.h"
#include "esp_http_client.h"
/****************new**********/
#include<ctype.h>


#if CONFIG_ETH_USE_SPI_ETHERNET
#include "driver/spi_master.h"
#endif // CONFIG_ETH_USE_SPI_ETHERNET
static const char *TAG = "eth_example";

#define NO_DATA_TIMEOUT_SEC 10

#define WIFI_CONNECTED_BIT BIT0
#define WIFI_FAIL_BIT      BIT1

#define EXAMPLE_ESP_WIFI_SSID     "LubiJio"    //"honor 7A_8D92"// "dlink-34AC"
#define EXAMPLE_ESP_WIFI_PASS     "Lubi@Jio"       //"ronak@1993"//"home@2010"

/* acess point */
#define EXAMPLE_ESP_WIFI_AP_SSID      "Smart_socket_config"
#define EXAMPLE_ESP_WIFI_AP_PASS      "mypassword"
//#define EXAMPLE_ESP_WIFI_AP_SSID             "myssid"
//#define EXAMPLE_ESP_WIFI_AP_PASS             "Sagar#123@"
#define EXAMPLE_ESP_WIFI_AP_CHANNEL   1
#define EXAMPLE_MAX_STA_AP_CONN       4

#define TAG "HTTP_SERVER"
#define FIXED_USERNAME "admin"
#define FIXED_PASSWORD "12345"
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define SESSION_TOKEN_LEN 50
#define SERVER_PORT 80
static httpd_handle_t server = NULL;
////////////////////////////4g frames parameters////////////////////////

#define espRestart 0x90
#define sendOcppuri 0x91
#define ocppEnable 0x92
#define ocppApi 0x94
#define gsmParameters 0x95
#define wifiparameters 0x96
#define fwUpgradestart 0x97
#define fwUpgradenext 0x98
#define ethernetpara 0x9A

/////////////////////////////////////////////////////////////////
/* new series */
#define configuration_mode 0x70
#define config_structRX 0x72
#define ack_datatx 0x75


/***************************************************************************/
/////////version4.1-25112023 -end /////////

//for DHCP
#define ENABLE_DHCP  1
#define DISABLE_DHCP 0

//for DHCP
unsigned char  IP_CONFIG = DISABLE_DHCP;
/***************************************************************************/

//#define Acknowledgement 0x72  // need to discusss
//static char index_html[4096];

/*
typedef struct {
	 int data1_value;
	 int data2_value;
	 int data3_value;
	 int data4_value;
	 int data5_value;
    char data6_value[50];
    char data7_value[50];
    char data8_value[50];
    char data9_value[50];
    char data10_value[50];
    int data11_value;
    char data12_value[50];
    int data13_value;
    int data14_value;
    int data15_value;
    char data16_value[50];
    int data17_value;
    int data18_value;
    int data19_value;
    int data20_value;
    int data21_value;
    int data22_value;
    int data23_value;
    int data24_value;
    int data25_value;
    int data26_value;
    int data27_value;
    int data28_value;
    int data29_value;
    int data30_value;
    int data31_value;
    int data32_value;
} FormData;
FormData form_data = {
	.data1_value = 337,
	.data2_value = 341,
	.data3_value = 123,
    .data4_value = 256,
	.data5_value = 111,
    .data6_value = "230.56",
    .data7_value = "134",
    .data8_value = "50.50",
    .data9_value = "60",
    .data10_value = "Hello, EV Charging World !",
	.data11_value=192,
	.data12_value = "Lubiev",
    .data13_value=192,
	.data14_value=80,
	.data15_value=9016831537,
	.data16_value= "JIO",
	.data17_value=91,
	.data18_value=12345678,
	.data19_value=123,
	.data20_value=123004,
     .data21_value=004,
	 .data22_value=999,
	 .data23_value=000,
	 .data24_value=0123,
	 .data25_value=456,
	 .data26_value=789,
     .data27_value=999,
     .data28_value=999,
	 .data29_value=999,
	 .data30_value=111,
	 .data31_value=111,
     .data32_value=111,
    // ... initialize other variables ...

};
*/
typedef struct {
		unsigned int under_voltage;
		unsigned int over_voltage;
		unsigned int over_current;
		unsigned int STATE_A_LEVEL;
		unsigned int STATE_B_LEVEL;
		unsigned int STATE_C_LEVEL;
		unsigned int STATE_D_LEVEL;
		unsigned int auxinput;
		char wifi_ssid[16];
		char wifi_password[16]; //13+350=363
		char serial_no[8];
		char networkoperator[24];
		char ocpp_uri[50]; //181
		char OCPP_servername[30]; //211
		char OCPP_username[20]; //231
		char OCPP_Password[20]; //251
		char OCPP_Port[8]; //256
		char ocpp_status[2];
		char fw_status[2];//364
		char fw_uri[30]; //181
		char fw_servername[20]; //211
		char fw_Port[6];
		char ipselection[2];
		char	rfid1[14];
		char    rfid2[14];
		char    rfid3[14];
	    char ether_ip[16];
	    //int ether_ip1;
	    //int ether_ip2;
		//char ether_ip1[3];
		char ether_getway[16];
	    char ether_subnetmask[16];
		/*int ether_subnetmask1;
		int ether_subnetmask2;*/
		char ethernet_enable_sts[4];


} FormDataPart1;

FormDataPart1 part1 = {.under_voltage = 0, .over_voltage = 0, .over_current = 0, .STATE_A_LEVEL = 0, .STATE_B_LEVEL = 0,
		.STATE_C_LEVEL = 0, .STATE_D_LEVEL = 0, .auxinput = 0, .wifi_ssid = "9979235", .wifi_password = "2222",.serial_no = "88888",.networkoperator="jio",.ocpp_uri = "/v1.6/lubismart", .OCPP_servername = "api.plugeasy.in", .OCPP_username = "sagar", .OCPP_Password = "1234", .OCPP_Port = "90",.ocpp_status ="ok",
        .fw_status="1" ,.fw_uri="fota",.fw_servername="123",.fw_Port="123",.ipselection="1",.rfid1 = "123", .rfid2 ="11111", .rfid3 = "222222",.ether_ip = "192.168.0",.ether_getway="255.255.255",.ether_subnetmask="255.255.0",.ethernet_enable_sts="ye"};
/*for webserver pages */
static const char *login_html = "<html><body><h1>Login Page</h1>"
                                "<form action='/login' method='post'>"
                                "Username: <input type='text' name='username'><br><br>"
                                "Password: <input type='password' name='password'><br><br>"
                                "<input type='submit' value='Login'>"
                                "</form></body></html>";
static char index_html[4096];
unsigned int  recieved_length;
bool is_authenticated = false;
bool isUserLoggedIn=false;
bool isUserAuthenticated() {
    return is_authenticated;
}

void url_decode(const char *src, char *dst, size_t dst_size) {
    char a, b;
    while (*src && dst_size > 1) {
        if ((*src == '%') &&
            ((a = src[1]) && (b = src[2])) &&
            (isxdigit(a) && isxdigit(b))) {
            if (a >= 'a')
                a -= 'a' - 'A';
            if (a >= 'A')
                a -= ('A' - 10);
            else
                a -= '0';
            if (b >= 'a')
                b -= 'a' - 'A';
            if (b >= 'A')
                b -= ('A' - 10);
            else
                b -= '0';
            *dst++ = 16 * a + b;
            src += 3;
            dst_size--;
        } else {
            *dst++ = *src++;
            dst_size--;
        }
    }
    *dst = '\0';
}
//static void firmware_upgrade(void * pvParameters);
//void app_main();
esp_err_t login_get_handler(httpd_req_t *req);
esp_err_t login_post_handler(httpd_req_t *req);
static esp_err_t favicon_get_handler(httpd_req_t *req);
esp_err_t index_get_handler(httpd_req_t *req) ;
esp_err_t view_get_handler(httpd_req_t *req);
esp_err_t otp_get_handler(httpd_req_t *req);
esp_err_t data_get_handler(httpd_req_t *req);
esp_err_t root_get_handler(httpd_req_t *req);
esp_err_t data1_get_handler(httpd_req_t *req);
esp_err_t data2_get_handler(httpd_req_t *req);
esp_err_t logout_get_handler(httpd_req_t *req);

esp_err_t logout_post_handler(httpd_req_t *req);
httpd_uri_t root_uri = {
    .uri = "/",
    .method = HTTP_GET,
    .handler = root_get_handler
};
httpd_uri_t login_uri = {
    .uri = "/login",
    .method = HTTP_GET,
    .handler = login_get_handler
};

httpd_uri_t login_submit_uri = {
    .uri = "/login",
    .method = HTTP_POST,
    .handler = login_post_handler
};

httpd_uri_t index_uri = {
    .uri = "/index",
    .method = HTTP_GET,
    .handler = index_get_handler
};

httpd_uri_t data_uri = {
    .uri = "/data",
    .method = HTTP_GET,
    .handler = data_get_handler
};
httpd_uri_t logout_uri = {
    .uri = "/logout",
    .method = HTTP_POST,
    .handler = logout_post_handler
};

httpd_uri_t view_uri = {
    .uri = "/view",
    .method = HTTP_GET,
    .handler = view_get_handler
};
httpd_uri_t data1_get_uri = {
    .uri = "/data1",
    .method = HTTP_GET,
    .handler = data1_get_handler,
    .user_ctx = NULL
};

httpd_uri_t otp_uri = {
    .uri = "/otp",
    .method = HTTP_GET,
    .handler = otp_get_handler
};

httpd_uri_t data2_get_uri = {
    .uri = "/data2",
    .method = HTTP_GET,
    .handler = data2_get_handler,

};
static httpd_uri_t favicon = {
    .uri       = "/favicon.ico",
    .method    = HTTP_GET,
    .handler   = favicon_get_handler,
    .user_ctx  = NULL
};

static TaskHandle_t xTask1 = NULL,xTask2 = NULL;
const char *additional_js = "<script>"
                            "function showPopup() {"
                            "    alert('Data saved successfully');"
                            "}"
                            "</script>";
esp_err_t index_get_handler(httpd_req_t *req) {
    if (!isUserAuthenticated()) {
        // If the user is not authenticated, redirect them to the login page
        httpd_resp_set_status(req, "302 Found");
        httpd_resp_set_hdr(req, "Location", "/login");
        httpd_resp_send(req, NULL, 0);
        return ESP_OK;
    }

    // Fetch the necessary data parts (part1, part2, part3) after username and password verification

    		 snprintf(index_html, sizeof(index_html),
    		   "<html><body><h1>View Page</h1>"
    		    "<form action='/data' method='get'>"
        		"under_voltage: <input type='text' name='data1' placeholder='%u'><br><br>"
        		 "over_voltage: <input type='text' name='data2' placeholder='%u'><br><br>"
        		  "over_current: <input type='text' name='data3' placeholder='%u'><br><br>"
        		  "STATE_A_LEVEL: <input type='text' name='data4'placeholder='%u'><br><br>"
        		   "STATE_B_LEVEL: <input type='text' name='data5' placeholder='%u'><br><br>"
    		        "STATE_C_LEVEL: <input type='text' name='data6' placeholder='%u'><br><br>"
    		        "STATE_D_LEVEL: <input type='text' name='data7' placeholder='%u'><br><br>"
    		         "auxinput: <input type='text' name='data8' placeholder='%u'><br><br>"
    		         "wifi_ssid: <input type='text' name='data9'placeholder='%s'><br><br>"
    		          "wifi_password: <input type='text' name='data10' placeholder='%s'><br><br>"
    		           "serial_no: <input type='text' name='data11' placeholder='%s'><br><br>"
    				   "networkoperator: <input type='text' name='data12' placeholder='%s'><br><br>"
        	//	"<input type='submit' value='Send' onclick='showPopup();'><br></br>"
    			 "<input type='submit' value='Send' '><br></br>"
        		//"<input type='submit' formaction='/' value='logout' value='data saved sucessfully'><br></br>"
//    				 "<button type='button' onclick='logout()'>Logout</button><br><br>"
//    		    "<input type='submit' formaction='/login' value='logout' ><br></br>"		//change 180624

    		   // "<input type='submit' onclick='showPopup();' formaction='/login' value='logout' ><br></br>"		//change 180624
    				// "<input type='submit' formaction='/' value='logout'><br></br>"
        		"<input type='button' value='refresh'  onClick='window.location.reload()'><br></br>"
    		     "</form><br>"
				 "<form action='/logout' method='post'>"  // Add form for logout
											 "<input type='submit' value='Logout'><br></br>"
											 "</form>"

                 "</body></html>",
				 part1.under_voltage, part1.over_voltage,part1.over_current, part1.STATE_A_LEVEL, part1.STATE_B_LEVEL,
				 part1.STATE_C_LEVEL, part1.STATE_D_LEVEL,part1.auxinput, part1.wifi_ssid ,
				 part1.wifi_password,part1.serial_no,part1.networkoperator);

    		 size_t len = strlen(index_html) + strlen(additional_js) + 1;
    		    char *combined_response = malloc(len);
    		    snprintf(combined_response, len, "%s%s", index_html, additional_js);

    		    // Send the combined response
    		    httpd_resp_send(req, combined_response, HTTPD_RESP_USE_STRLEN);
    		    free(combined_response);

    //httpd_resp_send(req,index_html, HTTPD_RESP_USE_STRLEN);

    return ESP_OK;
}
esp_err_t view_get_handler(httpd_req_t *req) {
    if (!isUserAuthenticated()) {

        httpd_resp_set_status(req, "302 Found");
        httpd_resp_set_hdr(req, "Location", "/login");
        httpd_resp_send(req, NULL, 0);
        return ESP_OK;
    }
    char decoded_ocpp_uri[100];
        url_decode(part1.ocpp_uri, decoded_ocpp_uri, sizeof(decoded_ocpp_uri));
       // printf("Decoded URL: %s\n", decoded_url);
        // Decode FW URI
        char decoded_fw_uri[100];
        url_decode(part1.fw_uri, decoded_fw_uri, sizeof(decoded_fw_uri));
       // printf("Decoded URL: %s\n", decoded_url);

 //      url_decode(part1.OCPP_servername);
 //      url_decode(part1.OCPP_username);
 //      url_decode(part1.OCPP_Password);
 //      url_decode(part1.OCPP_Port);
 //      url_decode(part1.ocpp_status);
 //      url_decode(part1.fw_status);

 //      url_decode(part1.fw_servername);
 //      url_decode(part1.fw_Port);
 //      url_decode(part1.ipselection);

              snprintf(index_html, sizeof(index_html),
                 "<html><body><h1>View Page</h1>"
    		      "<form action='/data1' method='get'>"
        		 "ocpp_uri:  <input type='text' name='data13'  placeholder='%s'><br><br>"
        		 "OCPP_servername: <input type='text' name='data14' placeholder='%s'><br><br>"
        		  "OCPP_username: <input type='text' name='data15' placeholder='%s'><br><br>"
        		   "OCPP_Password: <input type='text' name='data16' placeholder='%s'><br><br>"
        		  "OCPP_Port: <input type='text' name='data17' placeholder='%s'><br><br>"
    		     "ocpp_status: <input type='text' name='data18' placeholder='%s'><br><br>"
    		        "fw_status: <input type='text' name='data19' placeholder='%s'><br><br>"
    			    "fw_uri: <input type='text' name='data20' placeholder='%s'><br><br>"
    			 	"fw_servername: <input type='text' name='data21' placeholder='%s'><br><br>"
    			   "fw_Port: <input type='text' name='data22' placeholder='%s'><br><br>"
    		      "ipselection: <input type='text' name='data23' placeholder='%s'><br><br>"
        		"<input type='submit' value='Send'><br></br>"
//        		 "<input type='submit' formaction='/' value='logout' ><br></br>"
        		   "<input type='button' value='refresh'  onClick='window.location.reload()'><br></br>"
                   "</form><br>"
           		     "</form><br>"
         				 "<form action='/logout' method='post'>"  // Add form for logout
         											 "<input type='submit' value='Logout'><br></br>"
         											 "</form>"
                 "</body></html>",
                 part1.ocpp_uri, part1.OCPP_servername, part1.OCPP_username, part1.OCPP_Password,part1.OCPP_Port, part1.ocpp_status,
				 part1.fw_status ,part1.fw_uri,part1.fw_servername,part1.fw_Port,part1.ipselection);
                httpd_resp_send(req, index_html, HTTPD_RESP_USE_STRLEN);
                return ESP_OK;

}
esp_err_t otp_get_handler(httpd_req_t *req) {
    if (!isUserAuthenticated()) {
        // If the user is not authenticated, redirect them to the login page
        httpd_resp_set_status(req, "302 Found");
        httpd_resp_set_hdr(req, "Location", "/login");
        httpd_resp_send(req, NULL, 0);
        return ESP_OK;
    }


    snprintf(index_html, sizeof(index_html),
                 "<html><body><h1>OTP Page</h1>"
    		     "<form action='/data2' method='get'>"
    		"Rfid1: <input type='text' name='data24' placeholder='%s'><br><br>"
    	     "Rfid2: <input type='text' name='data25' placeholder='%s'><br><br>"
    		 "Rfid3: <input type='text' name='data26' placeholder='%s'><br><br>"
    		 "Ethernet IP: <input type='text' name='data27' placeholder='%s'><br><br>"
    		 "Ethernet GATEWAY: <input type='text' name='data28' placeholder='%s'><br><br>"
    	   	"Ethernet SUBNET: <input type='text' name='data29' placeholder='%s'><br><br>"

    		/*"Ethernet IP: <input type='text' name='data27' placeholder='%d'><input type='text' name='data28' placeholder='%d'><input type='text' name='data29' placeholder='%d'><br><br>"
    		"Ethernet GATEWAY: <input type='text' name='data30' placeholder='%d'><input type='text' name='data31' placeholder='%d'><input type='text' name='data32' placeholder='%d'><br><br>"
    		"Ethernet SUBNET: <input type='text' name='data33' placeholder='%d'><input type='text' name='data34' placeholder='%d'><input type='text' name='data35' placeholder='%d'><br><br>"*/
    		"Etherentenablests: <input type='text' name='data30' placeholder='%s'><br><br>"
        		"<input type='submit' value='Send'><br></br>"
//        		 "<input type='submit' formaction='/' value='logout'><br></br>"
				  "<input type='button' value='refresh'  onClick='window.location.reload()'><br></br>"
    		      "</form><br>"
 		     "</form><br>"
				 "<form action='/logout' method='post'>"  // Add form for logout
											 "<input type='submit' value='Logout'><br></br>"
											 "</form>"
    		       "</body></html>",
                 part1.rfid1, part1.rfid2, part1.rfid3, part1.ether_ip,part1.ether_getway,
				 part1.ether_subnetmask,part1.ethernet_enable_sts);
    httpd_resp_send(req, index_html, HTTPD_RESP_USE_STRLEN);
    return ESP_OK;
}

esp_err_t login_get_handler(httpd_req_t *req) {
	if (!req) return ESP_FAIL;
    httpd_resp_send(req, login_html, HTTPD_RESP_USE_STRLEN);
    return ESP_OK;
}
static esp_err_t favicon_get_handler(httpd_req_t *req)
{
    // You can either send a small default icon or a 404 not found response.
    const char *favicon = "data:image/x-icon;base64,"
                          "AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAQAQ"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
                          "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    httpd_resp_set_type(req, "image/x-icon");
    httpd_resp_send(req, favicon, HTTPD_RESP_USE_STRLEN);
    return ESP_OK;
}

/*
esp_err_t logout_get_handler(httpd_req_t *req) {

	httpd_resp_send(req, login_html, HTTPD_RESP_USE_STRLEN);
	 httpd_unregister_uri(server, "/index");
	 httpd_unregister_uri(server,"/view");
	 httpd_unregister_uri(server,"/otp");


	  printf("logut call");




    return ESP_OK;
}*/

esp_err_t logout_post_handler(httpd_req_t *req) {
    // Process the logout request here
    // After successful logout:
	printf("Logout call from logout handler entry\r\n");
//	vTaskDelay(pdMS_TO_TICKS(500));
	isUserLoggedIn = false;
	is_authenticated = false;
    // Notify xTask2 about the logout event

    // Unregister specific URIs related to logged-in functionalities
    httpd_unregister_uri(server, "/index");
    httpd_unregister_uri(server, "/view");
    httpd_unregister_uri(server, "/otp");

    // Redirect to the login page
    httpd_resp_set_status(req, "302 Found");
    httpd_resp_set_hdr(req, "Location", "/login");
    httpd_resp_send(req, NULL, 0);



    printf("Logout call from logout handler\r\n");
    xTaskNotify(xTask2, (1 << 5), eSetBits);
    // Restart the ESP32 device
  //  esp_restart();

    return ESP_OK;
}

esp_err_t logout_get_handler(httpd_req_t *req) {
    // Process the logout request here
    // After successful logout:
	printf("Logout call from logout handler entry\r\n");
//	vTaskDelay(pdMS_TO_TICKS(500));
	isUserLoggedIn = false;
	is_authenticated = false;
    // Notify xTask2 about the logout event

    // Unregister specific URIs related to logged-in functionalities
    httpd_unregister_uri(server, "/index");
    httpd_unregister_uri(server, "/view");
    httpd_unregister_uri(server, "/otp");

    // Redirect to the login page
    httpd_resp_set_status(req, "302 Found");
    httpd_resp_set_hdr(req, "Location", "/login");
    httpd_resp_send(req, NULL, 0);



    printf("Logout call from logout handler\r\n");
    xTaskNotify(xTask2, (1 << 5), eSetBits);
    // Restart the ESP32 device
  //  esp_restart();

    return ESP_OK;
}

typedef struct {
    char username[50];
    char password[50];
} UserCredentials;

// Define fixed user credentials for different pages
UserCredentials index_credentials = {"admin", "12345"};
UserCredentials view_credentials = {"admin1", "12345"};
UserCredentials otp_credentials = {"admin2", "12345"};


esp_err_t login_post_handler(httpd_req_t *req) {
    char buf[200]; // Adjust buffer size as needed for handling POST data
    int ret, remaining = sizeof(buf);

    if (!req) return ESP_FAIL;
    // Read POST data from the request
    while ((ret = httpd_req_recv(req, buf, remaining)) > 0) {
        remaining -= ret;
    }

    // Perform user authentication logic here based on the received POST data
    char username[50];
    char password[50];
    // Parse the POST data to extract username and password
    char *token = strtok(buf, "&=");
    while (token != NULL) {
        if (strcmp(token, "username") == 0) {
            token = strtok(NULL, "&=");
            strncpy(username, token, sizeof(username) - 1);
            username[sizeof(username) - 1] = '\0'; // Ensure null-terminated string
        } else if (strcmp(token, "password") == 0) {
            token = strtok(NULL, "&=");
            strncpy(password, token, sizeof(password) - 1);
            password[sizeof(password) - 1] = '\0'; // Ensure null-terminated string
        }
        token = strtok(NULL, "&=");
    }
    /***************************************/



        // Redirect to the appropriate page based on successful login
        if (strcmp(username, index_credentials.username) == 0) {
        	 is_authenticated = true;
            httpd_resp_set_status(req, "302 Found");
            httpd_register_uri_handler(server, &index_uri);
            httpd_register_uri_handler(server, &data_uri);
           // httpd_register_uri_handler(server, &logout_uri);
//            if (httpd_register_uri_handler(server, &logout_uri) == ESP_OK)
//            {
//			printf("Logout URI handler registered successfully in login_post_handler index.\n");
//            }
//            else
//            {
//			printf("Failed to register logout URI handler. login_post_handler index\n");
//            }
            httpd_resp_set_hdr(req, "Location", "/index");



        } else if (strcmp(username, view_credentials.username) == 0) {
        	 is_authenticated = true;
            httpd_resp_set_status(req, "302 Found");
            httpd_register_uri_handler(server, &view_uri);
            httpd_register_uri_handler(server, &data1_get_uri);
            // httpd_register_uri_handler(server, &logout_uri);
//                     if (httpd_register_uri_handler(server, &logout_uri) == ESP_OK)
//                     {
//         			printf("Logout URI handler registered successfully in login_post_handler view.\n");
//                     }
//                     else
//                     {
//         			printf("Failed to register logout URI handler. login_post_handler view\n");
//                     }
            httpd_resp_set_hdr(req, "Location", "/view");
        } else if (strcmp(username, otp_credentials.username) == 0) {
        	 is_authenticated = true;
            httpd_resp_set_status(req, "302 Found");

            httpd_register_uri_handler(server, &otp_uri);
            httpd_register_uri_handler(server, &data2_get_uri);
            // httpd_register_uri_handler(server, &logout_uri);
//                     if (httpd_register_uri_handler(server, &logout_uri) == ESP_OK)
//                     {
//         			printf("Logout URI handler registered successfully in login_post_handler otp.\n");
//                     }
//                     else
//                     {
//         			printf("Failed to register logout URI handler. login_post_handler otp\n");
//                     }
            httpd_resp_set_hdr(req, "Location", "/otp");
        }
        else
        {
        	 is_authenticated = false;
        	 const char *error_message = "<html><body><h1>Authentication failed</h1></body></html>";
			httpd_resp_send(req, error_message, HTTPD_RESP_USE_STRLEN);
			return ESP_FAIL; // Or handle as appropriate
        }
        httpd_resp_send(req, NULL, 0);
        return ESP_OK;

}

esp_err_t root_get_handler(httpd_req_t *req) {
	//int sep=0,Length=0,lclindex=0;char buffer[1024];
	//printf("logut calling");
	//printf("size of stuct is :%d r\n",Length);
	//memcpy(&part1,&buffer[5],Length);
	//printf("uv status iss %u  \r\n", part1.under_voltage);
//    xTaskNotify(xTask2,(1<<5),eSetBits);

    httpd_resp_set_status(req, "302 Found");
    httpd_resp_set_hdr(req, "Location", "/login");
    httpd_resp_send(req, NULL, 0);
    return ESP_OK;
}


esp_err_t data_get_handler(httpd_req_t *req) {
    char *buf;
    size_t buf_len;
  //  FormDataPart1 form_data_copy = part1;
    buf_len = httpd_req_get_url_query_len(req) + 1;

    if (buf_len > 1) {
            buf = malloc(buf_len);

            if (httpd_req_get_url_query_str(req, buf, buf_len) == ESP_OK) {
                char key[30];
                char value[30];
              //  FormDataPart1 part1 = part1;
                // Make a copy of the form_data structure
                char decoded_value[100];
                char decode_value[100];
                char *token = strtok(buf, "&");
                while (token != NULL) {
                    if (sscanf(token, "%29[^=]=%29[^&]", key, value) == 2) {
                    	// ESP_LOGI(TAG, "Received Data: Key=%s, Value=%s", key, value);
                    	url_decode(value, decoded_value, sizeof(decoded_value));
                    	url_decode(value, decode_value, sizeof(decode_value));
                    	 if (strcmp(key, "data1") == 0) {
                    		 part1.under_voltage = atoi(value);
                    	     ESP_LOGI(TAG, "Received Data1: Key=%s, Value=%s", key, value);
                    	    }
                    	 else if (strcmp(key, "data2") == 0) {
                    		       part1.over_voltage = atoi(value);
                    	           ESP_LOGI(TAG, "Received Data2: Key=%s, Value=%s", key, value);
                    	           }
                    	 else if (strcmp(key, "data3") == 0) {
                    		 part1.over_current = atoi(value);
                    	       ESP_LOGI(TAG, "Received Data3: Key=%s, Value=%s", key, value);
                    	                 }
                    	 else if (strcmp(key, "data4") == 0) {
                    	         part1.STATE_A_LEVEL = atoi(value);
                    	        ESP_LOGI(TAG, "Received Data4: Key=%s, Value=%s", key, value);
                    	        }
                    	 else if (strcmp(key, "data5") == 0) {
                    	   part1.STATE_B_LEVEL = atoi(value);
                    	   ESP_LOGI(TAG, "Received Data5: Key=%s, Value=%s", key, value);
                    	                  }
                    	 else if (strcmp(key, "data6") == 0) {
                    	           part1.STATE_C_LEVEL = atoi(value);
                    	            ESP_LOGI(TAG, "Received Data6: Key=%s, Value=%s", key, value);
                    	          }
                    	 else if (strcmp(key, "data7") == 0) {
                    	            part1.STATE_D_LEVEL = atoi(value);
                    	             ESP_LOGI(TAG, "Received Data7: Key=%s, Value=%s", key, value);
                    	       }
                    	 else if (strcmp(key, "data8") == 0) {
                    	            part1.auxinput = atoi(value);
                    	            ESP_LOGI(TAG, "Received Data8: Key=%s, Value=%s", key, value);
                    	        }
                    	 else if (strcmp(key, "data9") == 0) {
                    	       // part1.Mob_Num = atoi(value);
                    		     strcpy(part1.wifi_ssid,decoded_value);
                    	        ESP_LOGI(TAG, "Received Data9: Key=%s, Value=%s", key,decoded_value);
                    	     }
                    	 else if (strcmp(key, "data10") == 0) {
                    	   // part1.vendor_id = atoi(value);
                    		 strcpy(part1.wifi_password,decoded_value);
                    	    ESP_LOGI(TAG, "Received Data10: Key=%s, Value=%s", key,decoded_value);
                    	 }
                    	 else if (strcmp(key, "data11") == 0) {
                    	    // part1.serial_no = atoi(value);
                    		 strcpy(part1.serial_no, value);
                    	    ESP_LOGI(TAG, "Received Data11: Key=%s, Value=%s", key, value);
                    	 }
                    	 else if (strcmp(key, "data12") == 0) {

                    	       strcpy(part1.networkoperator, value);
                    	    ESP_LOGI(TAG, "Received Data12: Key=%s, Value=%s", key, value);
                     }

                    }
                    token = strtok(NULL, "&");
                }

                // After processing, update the original form_data structure with the modified copy

            }
            free(buf);
        } else {
            ESP_LOGI(TAG, "No query parameters present in the URL");
        }

        // Respond with an appropriate message or page if needed
        httpd_resp_send(req, index_html, HTTPD_RESP_USE_STRLEN);

        return ESP_OK;
    }
esp_err_t data1_get_handler(httpd_req_t *req) {
    char *buf;
    size_t buf_len;
    buf_len = httpd_req_get_url_query_len(req) + 1;

    if (buf_len > 1) {
        buf = malloc(buf_len);

        if (httpd_req_get_url_query_str(req, buf, buf_len) == ESP_OK) {
            // Process the query parameters for the view_html page
            char key[30];
            char value[60];
            char decoded_value[100];
            char decode_value[100];
            // ...similar to the previous data_get_handler
            char *token = strtok(buf, "&");
            while (token != NULL) {
                if (sscanf(token, "%29[^=]=%59[^&]", key, value) == 2) {
                	url_decode(value, decoded_value, sizeof(decoded_value));
                	url_decode(value, decode_value, sizeof(decode_value));
                    // Update form_data fields for data6 to data10
                    if (strcmp(key, "data13") == 0) {
                    	// char decoded_ocpp_uri[50];
                    	// url_decode(part1.ocpp_uri);
                    	//char decoded_fw_uri[100];
                    	//url_decode(part1.ocpp_uri,decoded_ocpp_uri, sizeof(decoded_ocpp_uri));
                      //  strcpy(part1.ocpp_uri, value);
                    	 strcpy(part1.ocpp_uri, decoded_value);
                    	 ESP_LOGI(TAG, "Received Data13: Key=%s, Value=%s", key, decoded_value);
                       // ESP_LOGI(TAG, "Received Data13: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data14") == 0) {

                        strcpy( part1.OCPP_servername, value);
                        ESP_LOGI(TAG, "Received Data14: Key=%s, Value=%s", key, value);
                    }
                    else if (strcmp(key, "data15") == 0) {

                                            strcpy(part1.OCPP_username, value);

                                            ESP_LOGI(TAG, "Received Data15: Key=%s, Value=%s", key, value);
                                        }
                    else if (strcmp(key, "data16") == 0) {


                    	 strcpy(part1.OCPP_Password, value);
                        ESP_LOGI(TAG, "Received Data16: Key=%s, Value=%s", key, value);
                                                           }
                    else if (strcmp(key, "data17") == 0) {

                                           strcpy(part1.OCPP_Port, value);
                                            ESP_LOGI(TAG, "Received Data17: Key=%s, Value=%s", key, value);
                                                        }
                    else if (strcmp(key, "data18") == 0) {

                             strcpy(part1.ocpp_status, value);
                             part1.ocpp_status[sizeof(part1.ocpp_status)-1]='\0';
                              ESP_LOGI(TAG, "Received Data18: Key=%s, Value=%s", key, value);
                                        }
                    else if (strcmp(key, "data19") == 0) {

                        strcpy(part1.fw_status, value);
                         ESP_LOGI(TAG, "Received Data19: Key=%s, Value=%s", key, value);
                              }

                    else if (strcmp(key, "data20") == 0) {

                             //strcpy(part1.fw_uri, value);
                    	     strcpy(part1.fw_uri, decode_value);
                           //  ESP_LOGI(TAG, "Received Data20: Key=%s, Value=%s", key, value);
                    	     ESP_LOGI(TAG, "Received Data13: Key=%s, Value=%s", key, decoded_value);
                                       }
                   else if (strcmp(key, "data21") == 0) {

                           strcpy( part1.fw_servername, value);
                            ESP_LOGI(TAG, "Received Data21: Key=%s, Value=%s", key, value);
                                }
                    else if (strcmp(key, "data22") == 0) {

                      strcpy(part1.fw_Port, value);
                     ESP_LOGI(TAG, "Received Data22: Key=%s, Value=%s", key, value);
                       }
                    else if (strcmp(key, "data23") == 0) {

                         strcpy(part1.ipselection, value);
                          part1.ipselection[sizeof(part1.ipselection)-1]='\0';
                          ESP_LOGI(TAG, "Received Data23: Key=%s, Value=%s", key, value);
                          }

                    // Continue this pattern for data8 to data10 similarly
                }
                token = strtok(NULL, "&");
            }
        }
        free(buf);
    } else {
        ESP_LOGI(TAG, "No query parameters present in the URL");
    }

    // Respond with view_html page or appropriate message if needed
    httpd_resp_send(req,index_html, HTTPD_RESP_USE_STRLEN);
    return ESP_OK;
}

esp_err_t data2_get_handler(httpd_req_t *req) {
    char *buf;
    size_t buf_len;
  //  FormDataPart1 form_data_copy = part1;
    buf_len = httpd_req_get_url_query_len(req) + 1;

    if (buf_len > 1) {
            buf = malloc(buf_len);

            if (httpd_req_get_url_query_str(req, buf, buf_len) == ESP_OK) {
                char key[30];
                char value[30];
              //  FormDataPart1 part1 = part1;
                // Make a copy of the form_data structure

                char *token = strtok(buf, "&");
                while (token != NULL) {
                    if (sscanf(token, "%29[^=]=%29[^&]", key, value) == 2) {
                    	// ESP_LOGI(TAG, "Received Data: Key=%s, Value=%s", key, value);
                    	 if (strcmp(key, "data24") == 0) {
                    		 strcpy(part1.rfid1, value);
                    	     ESP_LOGI(TAG, "Received Data24: Key=%s, Value=%s", key, value);
                    	    }
                    	 else if (strcmp(key, "data25") == 0) {
                    		       strcpy(part1.rfid2, value);
                    	           ESP_LOGI(TAG, "Received Data25: Key=%s, Value=%s", key, value);
                    	           }
                    	 else if (strcmp(key, "data26") == 0) {
                    		            strcpy(part1.rfid3, value);
                    	                 ESP_LOGI(TAG, "Received Data26: Key=%s, Value=%s", key, value);
                    	                }
                    	 else if (strcmp(key, "data27") == 0) {
                    		     strcpy(part1.ether_ip, value);
                    		   //  part3.ether_ip = atoi(value);
                    	        ESP_LOGI(TAG, "Received Data27: Key=%s, Value=%s", key, value);
                    	        }

                    	 else if (strcmp(key, "data28") == 0) {
                    		         strcpy(part1.ether_getway, value);
                    		         ESP_LOGI(TAG, "Received Data28: Key=%s, Value=%s", key, value);
                    	       }

                    	 else if (strcmp(key, "data29") == 0) {
                    		 strcpy(part1.ether_subnetmask, value);
                    		ESP_LOGI(TAG, "Received Data29: Key=%s, Value=%s", key, value);
                    	 }
                         else if (strcmp(key, "data30") == 0) {
                    		 strcpy(part1.ethernet_enable_sts, value);
                    	       ESP_LOGI(TAG, "Received Data30: Key=%s, Value=%s", key, value);
                    	                    	}

                    }
                    token = strtok(NULL, "&");
                }



            }
            free(buf);
        } else {
            ESP_LOGI(TAG, "No query parameters present in the URL");
        }

        // Respond with an appropriate message or page if needed
        httpd_resp_send(req, index_html, HTTPD_RESP_USE_STRLEN);
        return ESP_OK;
    }


/*
esp_err_t login_get_handler(httpd_req_t *req) {
    httpd_resp_send(req, login_html, HTTPD_RESP_USE_STRLEN);
    return ESP_OK;
}
esp_err_t login_post_handler(httpd_req_t *req) {
    char buf[100]; // Adjust buffer size as needed for handling POST data
    int ret, remaining = sizeof(buf);

    // Read POST data from the request
    while ((ret = httpd_req_recv(req, buf, remaining)) > 0) {
        remaining -= ret;
    }

    // Perform user authentication logic here based on the received POST data
    char username[50];
    char password[50];
    // Parse the POST data to extract username and password
    char *token = strtok(buf, "&=");
    while (token != NULL) {
        if (strcmp(token, "username") == 0) {
            token = strtok(NULL, "&=");
            strncpy(username, token, sizeof(username) - 1);
            username[sizeof(username) - 1] = '\0'; // Ensure null-terminated string
        } else if (strcmp(token, "password") == 0) {
            token = strtok(NULL, "&=");
            strncpy(password, token, sizeof(password) - 1);
            password[sizeof(password) - 1] = '\0'; // Ensure null-terminated string
        }
        token = strtok(NULL, "&=");
    }

    // Verify the extracted username and password
    // Replace 'FIXED_USERNAME' and 'FIXED_PASSWORD' with actual predefined values
    if (strcmp(username, FIXED_USERNAME) == 0 && strcmp(password, FIXED_PASSWORD) == 0) {
        // If authenticated, set 'is_authenticated' to 'true'
        is_authenticated = true;

        // Redirect to the index page upon successful login
        httpd_resp_set_status(req, "302 Found");
        httpd_resp_set_hdr(req, "Location", "/index");
        httpd_resp_send(req, NULL, 0);
        return ESP_OK;
    } else {
        // If authentication fails, handle accordingly (send an error message)
        const char *error_message = "<html><body><h1>Authentication failed</h1></body></html>";
        httpd_resp_send(req, error_message, HTTPD_RESP_USE_STRLEN);
        return ESP_FAIL; // Or handle as appropriate
    }
}
esp_err_t root_get_handler(httpd_req_t *req) {
    httpd_resp_set_status(req, "302 Found");
    httpd_resp_set_hdr(req, "Location", "/login");
    httpd_resp_send(req, NULL, 0);
    return ESP_OK;
}

esp_err_t index_get_handler(httpd_req_t *req) {



	if (!isUserAuthenticated()) {
	        // If the user is not authenticated, redirect them to the login page
	        httpd_resp_set_status(req, "302 Found");
	        httpd_resp_set_hdr(req, "Location", "/login");
	        httpd_resp_send(req, NULL, 0);
	        return ESP_OK;
	    }

	snprintf(index_html, sizeof(index_html),
		                 "<html><body><h1>Index Page</h1>"
		                 "<form action='/data' method='get'>"
		                 "Under Voltage: <input type='text' name='data1' placeholder='%d'><br><br>"
		                 " Inputcurrent: <input type='text' name='data2' placeholder='%d'><br><br>"
		                 "Overcurrent: <input type='text' name='data3' placeholder='%d'><br><br>"
		                 "OverVoltage: <input type='text' name='data4'placeholder='%d'><br><br>"
		                 "Port: <input type='text' name='data5' placeholder='%d'><br><br>"
		                 "RFID1:  <input type='text' name='data6'  placeholder='%s'><br><br>"
		                 " RFID2: <input type='text' name='data7' placeholder='%s'><br><br>"
		                 "RFID3: <input type='text' name='data8' placeholder='%s'><br><br>"
		                 "Charger Rating: <input type='text' name='data9' placeholder='%s'><br><br>"
		        		 "Path: <input type='text' name='data10' placeholder='%s'><br><br>"
		        		 "Server: <input type='text' name='data11' placeholder='%d'><br><br>"
		        		 "Username: <input type='text' name='data12' placeholder='%s'><br><br>"
		        		  "Password: <input type='text' name='data13' placeholder='%d'><br><br>"
		        		"Port: <input type='text' name='data14' placeholder='%d'><br><br>"
		        		"Mobile: <input type='text' name='data15' placeholder='%d'><br><br>"
		        		"Network: <input type='text' name='data16' placeholder='%s'><br><br>"
		        		 "CSQ: <input type='text' name='data17' placeholder='%d'><br><br>"
		        		 "IMEI NO: <input type='text' name='data18' placeholder='%d'><br><br>"
		        		 "Wifi SSID: <input type='text' name='data19' placeholder='%d'><br><br>"
		        	     "Wifi Password: <input type='text' name='data20' placeholder='%d'><br><br>"
		        		"Serialnumber: <input type='text' name='data21' placeholder='%d'><br><br>"
		        		"Vendor ID: <input type='text' name='data22' placeholder='%d'><br><br>"
		        		"Firmware Version: <input type='text' name='data23' placeholder='%d'><br><br>"
		        		"Ethernet IP: <input type='text' name='data24' placeholder='%d'><input type='text' name='data25' placeholder='%d'><input type='text' name='data26' placeholder='%d'><br><br>"
		        		"Ethernet GATEWAY: <input type='text' name='data27' placeholder='%d'><input type='text' name='data28' placeholder='%d'><input type='text' name='data29' placeholder='%d'><br><br>"
		        		"Ethernet SUBNET: <input type='text' name='data30' placeholder='%d'><input type='text' name='data31' placeholder='%d'><input type='text' name='data32' placeholder='%d'><br><br>"
		                 "<input type='submit' value='Send'><br></br>"
		        		 "<input type='submit' formaction='/' value='logout'><br></br>"
		        	      "<input type='button' value='refresh'  onClick='window.location.reload()'><br></br>"
		        		  "</form><br>"
		                 "</body></html>",
						 form_data.data1_value,form_data.data2_value,form_data.data3_value,form_data.data4_value,form_data.data5_value, form_data.data6_value,form_data.data7_value,form_data.data8_value,form_data.data9_value,form_data.data10_value,form_data.data11_value,form_data.data12_value,form_data.data13_value,form_data.data14_value,form_data.data15_value,form_data.data16_value,form_data.data17_value,form_data.data18_value,form_data.data19_value,form_data.data20_value,form_data.data21_value,form_data.data22_value,form_data.data23_value,form_data.data24_value,form_data.data25_value,form_data.data26_value,form_data.data27_value,form_data.data28_value,form_data.data29_value,form_data.data30_value,form_data.data31_value,form_data.data32_value);



	 	        		httpd_resp_send(req, index_html, HTTPD_RESP_USE_STRLEN);

																																																																																																																																																																																																																		//uart_write_bytes(req, (const char*)index_html,strlen(index_html));
																																																																																																																																																																																																																	   // transmitDataOverUART(index_html, strlen(index_html));


    return ESP_OK;
}




esp_err_t data_get_handler(httpd_req_t *req) {
    char *buf;
    size_t buf_len;
   // FormData form_data_copy = form_data;
    buf_len = httpd_req_get_url_query_len(req) + 1;

    if (buf_len > 1) {
        buf = malloc(buf_len);

        if (httpd_req_get_url_query_str(req, buf, buf_len) == ESP_OK) {
            char key[55];
            char value[55];
            FormData form_data_copy = form_data;  // Make a copy of the form_data structure

            char *token = strtok(buf, "&");
            while (token != NULL) {
                if (sscanf(token, "%54[^=]=%54[^&]", key, value) == 2) {
                	// ESP_LOGI(TAG, "Received Data: Key=%s, Value=%s", key, value);
                	 if (strcmp(key, "data1") == 0) {
                	     form_data_copy.data1_value = atoi(value);
                	     ESP_LOGI(TAG, "Received Data1: Key=%s, Value=%s", key, value);
                	    }
                	 else if (strcmp(key, "data2") == 0) {
                	           form_data_copy.data2_value = atoi(value);
                	           ESP_LOGI(TAG, "Received Data2: Key=%s, Value=%s", key, value);
                	           }
                	 else if (strcmp(key, "data3") == 0) {
                	       form_data_copy.data3_value = atoi(value);
                	       ESP_LOGI(TAG, "Received Data3: Key=%s, Value=%s", key, value);
                	                 }
                	 else if (strcmp(key, "data4") == 0) {
                	         form_data_copy.data4_value = atoi(value);
                	        ESP_LOGI(TAG, "Received Data4: Key=%s, Value=%s", key, value);
                	        }
                	 else if (strcmp(key, "data5") == 0) {
                	   form_data_copy.data5_value = atoi(value);
                	   ESP_LOGI(TAG, "Received Data5: Key=%s, Value=%s", key, value);
                	                  }
                	 else if (strcmp(key, "data6") == 0) {
                        strcpy(form_data_copy.data6_value, value);
                        ESP_LOGI(TAG, "Received Data6: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data7") == 0) {
                        strcpy(form_data_copy.data7_value, value);
                        ESP_LOGI(TAG, "Received Data7: Key=%s, Value=%s", key, value);
                    }
                    // Update other form_data_copy members based on keys/values
                    else if (strcmp(key, "data8") == 0) {
                        strcpy(form_data_copy.data8_value, value);
                        ESP_LOGI(TAG, "Received Data8: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data9") == 0) {
                        strcpy(form_data_copy.data9_value, value);
                        ESP_LOGI(TAG, "Received Data9: Key=%s, Value=%s", key, value);
                    }
                    // Continue for all 32 data fields...
                    else if (strcmp(key, "data10") == 0) {
                        strcpy(form_data_copy.data10_value, value);
                        ESP_LOGI(TAG, "Received Data10: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data11") == 0) {
                        form_data_copy.data11_value = atoi(value);
                        ESP_LOGI(TAG, "Received Data11: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data12") == 0) {
                        strcpy(form_data_copy.data12_value, value);
                        ESP_LOGI(TAG, "Received Data12: Key=%s, Value=%s", key, value);
                    }
                    // Continue in a similar fashion for all 32 fields...
                    else if (strcmp(key, "data13") == 0) {
                        form_data_copy.data13_value = atoi(value);
                        ESP_LOGI(TAG, "Received Data13: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data14") == 0) {
                        form_data_copy.data14_value = atoi(value);
                        ESP_LOGI(TAG, "Received Data14: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data15") == 0) {
                        form_data_copy.data15_value = atoi(value);
                        ESP_LOGI(TAG, "Received Data15: Key=%s, Value=%s", key, value);
                    } else if (strcmp(key, "data16") == 0) {
                        strcpy(form_data_copy.data16_value, value);
                        ESP_LOGI(TAG, "Received Data16: Key=%s, Value=%s", key, value);
                    }
                    else if (strcmp(key, "data17") == 0) {
                       form_data_copy.data17_value = atoi(value);
                       ESP_LOGI(TAG, "Received Data17: Key=%s, Value=%s", key, value);
                       }
                    else if (strcmp(key, "data18") == 0) {
                           form_data_copy.data18_value = atoi(value);
                           ESP_LOGI(TAG, "Received Data18: Key=%s, Value=%s", key, value);
                          }
                    else if (strcmp(key, "data19") == 0) {
                     form_data_copy.data19_value = atoi(value);
                     ESP_LOGI(TAG, "Received Data19: Key=%s, Value=%s", key, value);
                      }
                    else if (strcmp(key, "data20") == 0) {
                    form_data_copy.data20_value = atoi(value);
                    ESP_LOGI(TAG, "Received Data20: Key=%s, Value=%s", key, value);
                     }
                    else if (strcmp(key, "data21") == 0) {
                     form_data_copy.data21_value = atoi(value);
                     ESP_LOGI(TAG, "Received Data21: Key=%s, Value=%s", key, value);
                     }
                    else if (strcmp(key, "data22") == 0) {
                      form_data_copy.data22_value = atoi(value);
                      ESP_LOGI(TAG, "Received Data22: Key=%s, Value=%s", key, value);
                    }
                    else if (strcmp(key, "data23") == 0) {
                     form_data_copy.data23_value = atoi(value);
                     ESP_LOGI(TAG, "Received Data23: Key=%s, Value=%s", key, value);
                      }
                    else if (strcmp(key, "data24") == 0) {
                     form_data_copy.data24_value = atoi(value);
                     ESP_LOGI(TAG, "Received Data24: Key=%s, Value=%s", key, value);
                   }
                    else if (strcmp(key, "data25") == 0) {
                     form_data_copy.data25_value = atoi(value);
                     ESP_LOGI(TAG, "Received Data25: Key=%s, Value=%s", key, value);
                     }
                    else if (strcmp(key, "data26") == 0) {
                     form_data_copy.data26_value = atoi(value);
                     ESP_LOGI(TAG, "Received Data26: Key=%s, Value=%s", key, value);
                      }
                    else if (strcmp(key, "data27") == 0) {
                   form_data_copy.data27_value = atoi(value);
                   ESP_LOGI(TAG, "Received Data27: Key=%s, Value=%s", key, value);
                     }
                    else if (strcmp(key, "data28") == 0) {
                    form_data_copy.data28_value = atoi(value);
                    ESP_LOGI(TAG, "Received Data28: Key=%s, Value=%s", key, value);
                      }
                    else if (strcmp(key, "data29") == 0) {
                      form_data_copy.data29_value = atoi(value);
                      ESP_LOGI(TAG, "Received Data29: Key=%s, Value=%s", key, value);
                     }
                    else if (strcmp(key, "data30") == 0) {
                   form_data_copy.data30_value = atoi(value);
                   ESP_LOGI(TAG, "Received Data30: Key=%s, Value=%s", key, value);
                  }
                    else if (strcmp(key, "data31") == 0) {
                    form_data_copy.data31_value = atoi(value);
                    ESP_LOGI(TAG, "Received Data31: Key=%s, Value=%s", key, value);
                  }

                     // Once data32 is handled, the loop ends here.
                    else if (strcmp(key, "data32") == 0) {
                        form_data_copy.data32_value = atoi(value);
                        ESP_LOGI(TAG, "Received Data32: Key=%s, Value=%s", key, value);
                    }
                }
                token = strtok(NULL, "&");
            }

            // After processing, update the original form_data structure with the modified copy
           // form_data = form_data_copy;
        }
        free(buf);
    } else {
        ESP_LOGI(TAG, "No query parameters present in the URL");
    }

    // Respond with an appropriate message or page if needed
    httpd_resp_send(req, index_html, HTTPD_RESP_USE_STRLEN);
    return ESP_OK;
}
*/

/*
esp_err_t data_get_handler(httpd_req_t *req) {
    char *buf;
    size_t buf_len;
 //   FormData form_data_copy = form_data;
    buf_len = httpd_req_get_url_query_len(req) + 1;

    if (buf_len > 1) {
        buf = malloc(buf_len);

        if (httpd_req_get_url_query_str(req, buf, buf_len) == ESP_OK) {
            char key[55];
            char value[55];
          //  FormData form_data_copy = form_data;  // Make a copy of the form_data structure

            char *token = strtok(buf, "&");
            while (token != NULL) {
                if (sscanf(token, "%54[^=]=%54[^&]", key, value) == 2) {
                	// ESP_LOGI(TAG, "Received Data: Key=%s, Value=%s", key, value);
                	 if (strcmp(key, "data1") == 0) {
                	     form_data_copy.fw_status = atoi(value);
                	     ESP_LOGI(TAG, "Received Data1: Key=%s, Value=%s", key, value);
                	    }
                	 else if (strcmp(key, "data2") == 0) {
                	                 	           //form_data_copy.data2_value = atoi(value);
                	                 		       strcpy(form_data_copy.fw_uri, value);
                	                 	           ESP_LOGI(TAG, "Received Data2: Key=%s, Value=%s", key, value);
                	                 	           }
                	                 	 else if (strcmp(key, "data3") == 0) {
                	                 	       //form_data_copy.data3_value = atoi(value);
                	                 		 strcpy(form_data_copy.fw_servername, value);
                	                 	       ESP_LOGI(TAG, "Received Data3: Key=%s, Value=%s", key, value);
                	                 	                 }
                	                 	 else if (strcmp(key, "data4") == 0) {
                	                 		    strcpy(form_data_copy.fw_Port, value);
                	                 	        // form_data_copy.data4_value = atoi(value);
                	                 	        ESP_LOGI(TAG, "Received Data4: Key=%s, Value=%s", key, value);
                	                 	        }
                	                 	 else if (strcmp(key, "data5") == 0) {
                	                 	  // form_data_copy.data5_value = atoi(value);
                	                 		 strcpy(form_data_copy.wifi_ssid, value);
                	                 	   ESP_LOGI(TAG, "Received Data5: Key=%s, Value=%s", key, value);
                	                 	                  }
                	                 	 else if (strcmp(key, "data6") == 0) {
                	                 		 strcpy(form_data_copy.wifi_password, value);
                	                         //strcpy(form_data_copy.data6_value, value);
                	                        ESP_LOGI(TAG, "Received Data6: Key=%s, Value=%s", key, value);
                	                     } else if (strcmp(key, "data7") == 0) {
                	                         strcpy(form_data_copy.wifi_enable_sts, value);
                	                         ESP_LOGI(TAG, "Received Data7: Key=%s, Value=%s", key, value);
                	                     }
                	                     // Update other form_data_copy members based on keys/values
                	                     else if (strcmp(key, "data8") == 0) {
                	                         strcpy(form_data_copy.ethernet_enable_sts, value);
                	                         ESP_LOGI(TAG, "Received Data8: Key=%s, Value=%s", key, value);
                	                     } else if (strcmp(key, "data9") == 0) {
                	                         strcpy(form_data_copy.ipselection, value);
                	                         ESP_LOGI(TAG, "Received Data9: Key=%s, Value=%s", key, value);
                	                     }
                	                     // Continue for all 32 data fields...
                	                     else if (strcmp(key, "data10") == 0) {
                	                         strcpy(form_data_copy.networkoperator, value);
                	                         ESP_LOGI(TAG, "Received Data10: Key=%s, Value=%s", key, value);
                	                     } else if (strcmp(key, "data11") == 0) {
                	                     	//strcpy(Mob_Num, value);
                	                         //form_data_copy.data11_value = atoi(value);
                	                         //ESP_LOGI(TAG, "Received Data11: Key=%s, Value=%s", key, value);
                	                     } else if (strcmp(key, "data12") == 0) {
                	                         strcpy(form_data_copy.ocpp_uri, value);
                	                         ESP_LOGI(TAG, "Received Data12: Key=%s, Value=%s", key, value);
                	                     }
                	                     // Continue in a similar fashion for all 32 fields...
                	                     else if (strcmp(key, "data13") == 0) {
                	                     	strcpy(form_data_copy.OCPP_servername, value);
                	                         //form_data_copy.data13_value = atoi(value);
                	                         ESP_LOGI(TAG, "Received Data13: Key=%s, Value=%s", key, value);
                	                     } else if (strcmp(key, "data14") == 0) {
                	                     	strcpy(form_data_copy.OCPP_username, value);
                	                        // form_data_copy.data14_value = atoi(value);
                	                         ESP_LOGI(TAG, "Received Data14: Key=%s, Value=%s", key, value);
                	                     } else if (strcmp(key, "data15") == 0) {
                	                     	strcpy(form_data_copy.OCPP_Password, value);
                	                         //form_data_copy.data15_value = atoi(value);
                	                         ESP_LOGI(TAG, "Received Data15: Key=%s, Value=%s", key, value);
                	                     } else if (strcmp(key, "data16") == 0) {
                	                         strcpy(form_data_copy.OCPP_Port, value);
                	                         //ESP_LOGI(TAG, "Received Data16: Key=%s, Value=%s", key, value);
                	                     }
                	                     else if (strcmp(key, "data17") == 0) {
                	                     	strcpy(form_data_copy.ocpp_status, value);
                	                       // form_data_copy.data17_value = atoi(value);
                	                        //ESP_LOGI(TAG, "Received Data17: Key=%s, Value=%s", key, value);
                	                        }
                	                     else if (strcmp(key, "data18") == 0) {
                	                     	   strcpy(vendor_id, value);
                	                            //form_data_copy.data18_value = atoi(value);
                	                          //  ESP_LOGI(TAG, "Received Data18: Key=%s, Value=%s", key, value);
                	                           }
                	                     else if (strcmp(key, "data19") == 0) {
                	                     	strcpy(form_data_copy.serial_no, value);
                	                      //form_data_copy.data19_value = atoi(value);
                	                      //ESP_LOGI(TAG, "Received Data19: Key=%s, Value=%s", key, value);
                	                       }
                	                     else if (strcmp(key, "data20") == 0) {
                	                     strcpy(form_data_copy.Communication_Mode, value);
                	                     //form_data_copy.data20_value = atoi(value);
                	                     //ESP_LOGI(TAG, "Received Data20: Key=%s, Value=%s", key, value);
                	                      }
                	                     else if (strcmp(key, "data21") == 0) {
                	                      form_data_copy.under_voltage = atoi(value);
                	                     // ESP_LOGI(TAG, "Received Data21: Key=%s, Value=%s", key, value);
                	                      }
                	                     else if (strcmp(key, "data22") == 0) {
                	                       form_data_copy.over_voltage = atoi(value);
                	                      // ESP_LOGI(TAG, "Received Data22: Key=%s, Value=%s", key, value);
                	                     }
                	                     else if (strcmp(key, "data23") == 0) {
                	                      form_data_copy.over_current = atoi(value);
                	                      //ESP_LOGI(TAG, "Received Data23: Key=%s, Value=%s", key, value);
                	                       }
                	                     else if (strcmp(key, "data24") == 0) {
                	                      form_data_copy.STATE_A_LEVEL = atoi(value);
                	                      //ESP_LOGI(TAG, "Received Data24: Key=%s, Value=%s", key, value);
                	                    }
                	                     else if (strcmp(key, "data25") == 0) {
                	                      form_data_copy.STATE_B_LEVEL = atoi(value);
                	                      //ESP_LOGI(TAG, "Received Data25: Key=%s, Value=%s", key, value);
                	                      }
                	                     else if (strcmp(key, "data26") == 0) {
                	                      form_data_copy.STATE_C_LEVEL = atoi(value);
                	                      //ESP_LOGI(TAG, "Received Data26: Key=%s, Value=%s", key, value);
                	                       }
                	                     else if (strcmp(key, "data27") == 0) {
                	                    form_data_copy.STATE_D_LEVEL = atoi(value);
                	                    //ESP_LOGI(TAG, "Received Data27: Key=%s, Value=%s", key, value);
                	                      }
                	                     else if (strcmp(key, "data28") == 0) {
                	                     form_data_copy.auxinput = atoi(value);
                	                    // ESP_LOGI(TAG, "Received Data28: Key=%s, Value=%s", key, value);
                	                       }
                	                     else if (strcmp(key, "data29") == 0) {
                	                     	strcpy(form_data_copy.rfid1, value);
                	                       //form_data_copy.data29_value = atoi(value);
                	                      // ESP_LOGI(TAG, "Received Data29: Key=%s, Value=%s", key, value);
                	                      }
                	                     else if (strcmp(key, "data30") == 0) {
                	                     strcpy(form_data_copy.rfid2, value);
                	                    //form_data_copy.data30_value = atoi(value);
                	                    //ESP_LOGI(TAG, "Received Data30: Key=%s, Value=%s", key, value);
                	                   }
                	                     else if (strcmp(key, "data31") == 0) {
                	                      strcpy(form_data_copy.rfid3, value);
                	                     //form_data_copy.data31_value = atoi(value);
                	                     //ESP_LOGI(TAG, "Received Data31: Key=%s, Value=%s", key, value);
                	                   }
                	                      // Once data32 is handled, the loop ends here.
                	                     else if (strcmp(key, "data32") == 0) {
                	                         form_data_copy.ether_ip = atoi(value);
                	                     	//strcpy(form_data_copy.ether_ip, value);
                	                       //  ESP_LOGI(TAG, "Received Data32: Key=%s, Value=%s", key, value);
                	                     }
                	                     else if (strcmp(key, "data33") == 0) {
                	                             form_data_copy.ether_ip1 = atoi(value);
                	                             //strcpy(form_data_copy.ether_ip, value);
                	                         //   ESP_LOGI(TAG, "Received Data33: Key=%s, Value=%s", key, value);
                	                       }
                	                     else if (strcmp(key, "data34") == 0) {
                	                            form_data_copy.ether_ip2 = atoi(value);
                	                             //strcpy(form_data_copy.ether_ip, value);
                	                           //ESP_LOGI(TAG, "Received Data34: Key=%s, Value=%s", key, value);
                	                   }
                	                   else if (strcmp(key, "data35") == 0) {
                	                             form_data_copy.ether_getway = atoi(value);
                	                              //strcpy(form_data_copy.ether_ip, value);
                	                             // ESP_LOGI(TAG, "Received Data35: Key=%s, Value=%s", key, value);
                	                      }
                	                   else if (strcmp(key, "data36") == 0) {
                	                     form_data_copy.ether_getway1 = atoi(value);
                	                      //strcpy(form_data_copy.ether_ip, value);
                	                     //ESP_LOGI(TAG, "Received Data36: Key=%s, Value=%s", key, value);
                	                          }
                	                   else if (strcmp(key, "data37") == 0) {
                	                     form_data_copy.ether_getway2 = atoi(value);
                	                         //strcpy(form_data_copy.ether_ip, value);
                	                  //ESP_LOGI(TAG, "Received Data37: Key=%s, Value=%s", key, value);
                	                   }
                	                   else if (strcmp(key, "data38") == 0) {
                	                       form_data_copy.ether_subnetmask = atoi(value);
                	                       //strcpy(form_data_copy.ether_ip, value);
                	                    //   ESP_LOGI(TAG, "Received Data38: Key=%s, Value=%s", key, value);
                	                    }
                	                   else if (strcmp(key, "data39") == 0) {
                	                    form_data_copy.ether_subnetmask1 = atoi(value);
                	                     //strcpy(form_data_copy.ether_ip, value);
                	                     //ESP_LOGI(TAG, "Received Data39: Key=%s, Value=%s", key, value);
                	                  }
                	                   else if (strcmp(key, "data40") == 0) {
                	                    form_data_copy.ether_subnetmask2 = atoi(value);
                	                     //strcpy(form_data_copy.ether_ip, value);
                	                     //ESP_LOGI(TAG, "Received Data40: Key=%s, Value=%s", key, value);
                	                 }

                	                 }
                token = strtok(NULL, "&");
                            }

                            // After processing, update the original form_data structure with the modified copy
                           // form_data = form_data_copy;
                        }
                        free(buf);
                    } else {
                        ESP_LOGI(TAG, "No query parameters present in the URL");
                    }

                    // Respond with an appropriate message or page if needed
                    httpd_resp_send(req, index_html, HTTPD_RESP_USE_STRLEN);
                    return ESP_OK;
                }
*/


static void wifi_event_handler(void* arg, esp_event_base_t event_base,
                                    int32_t event_id, void* event_data)
{
    if (event_id == WIFI_EVENT_AP_STACONNECTED) {
        wifi_event_ap_staconnected_t* event = (wifi_event_ap_staconnected_t*) event_data;
        ESP_LOGI(TAG, "station "MACSTR" join, AID=%d",
                 MAC2STR(event->mac), event->aid);
    } else if (event_id == WIFI_EVENT_AP_STADISCONNECTED) {
        wifi_event_ap_stadisconnected_t* event = (wifi_event_ap_stadisconnected_t*) event_data;
        ESP_LOGI(TAG, "station "MACSTR" leave, AID=%d",
                 MAC2STR(event->mac), event->aid);
    }
}
/*
httpd_uri_t root_uri = {
    .uri = "/",
    .method = HTTP_GET,
    .handler = root_get_handler
};

httpd_uri_t login_uri = {
    .uri = "/login",
    .method = HTTP_GET,
    .handler = login_get_handler
};

httpd_uri_t login_submit_uri = {
    .uri = "/login",
    .method = HTTP_POST,
    .handler = login_post_handler
};

httpd_uri_t index_uri = {
    .uri = "/index",
    .method = HTTP_GET,
    .handler = index_get_handler
};

httpd_uri_t data_uri = {
    .uri = "/data",
    .method = HTTP_GET,
    .handler = data_get_handler
};

*/

void start_webserver() {
    httpd_config_t config = HTTPD_DEFAULT_CONFIG();
    config.stack_size = 6144; // Increase stack size if needed
    config.max_uri_handlers = 8;
    if (httpd_start(&server, &config) == ESP_OK) {

    	                 httpd_register_uri_handler(server, &root_uri); // Register root URI handler
    	    	        httpd_register_uri_handler(server, &login_uri);
    	    	        httpd_register_uri_handler(server, &favicon);
    	    	        httpd_register_uri_handler(server, &login_submit_uri);
//    	                httpd_register_uri_handler(server, &index_uri);
//    	                httpd_register_uri_handler(server, &data_uri);
////    	                httpd_register_uri_handler(server, &view_uri);
////						httpd_register_uri_handler(server, &data1_get_uri);
////						httpd_register_uri_handler(server, &otp_uri);
////						httpd_register_uri_handler(server, &data2_get_uri);
////    	    	        httpd_register_uri_handler(server, &logout_uri);
    	    	        if (httpd_register_uri_handler(server, &logout_uri) == ESP_OK) {
    	    	                printf("Logout URI handler registered successfully in start webserver.\n");
    	    	            } else {
    	    	                printf("Failed to register logout URI handler start webserver.\n");
    	    	            }

    }
    else
    {
	printf("WEB_SERVER: Error starting server!");
    }


}
static void stop_webserver(httpd_handle_t server) {

        httpd_stop(server);

}
void unregister_handler(httpd_handle_t server) {

    	        httpd_unregister_uri(server, "/login"); // Register root URI handler
    	        printf("logout call from unregiste handler\r\n");
    	        httpd_unregister_uri(server,"/logout");
    	        //xTaskNotify(xTask2,(1<<5),eSetBits);
    	        printf("logout1 call\r\n");


    }

/* old sereis */
char ethernet_connection;

#define DEBUG  0
static EventGroupHandle_t s_wifi_event_group;
/*new variable handler for acess point new sereis */
static EventGroupHandle_t s_wifi_event_ap_group;
esp_websocket_client_config_t websocket_cfg = {};

//esp_netif_config_t *cfg;
esp_netif_t *eth_netif;
esp_eth_handle_t eth_handle = NULL;
char websocket_connect=0,websocket_disconnect =0;
char next;
const char *sep = "*";
/****new****/
char ssid_decoded[32];
char password_decoded[32];
//url_decode(EXAMPLE_ESP_WIFI_AP_SSID,ssid_decoded, sizeof(ssid_decoded));
//url_decode(EXAMPLE_ESP_WIFI_AP_PASS_Encoded,password_decoded,sizeof(password_decoded));
//url_decode(password_encoded,password_decoded ,sizeof(password_decoded));
esp_websocket_client_handle_t client;
wifi_config_t  wifi_config = {
				   .sta = {
					   .ssid = EXAMPLE_ESP_WIFI_SSID,
					   .password = EXAMPLE_ESP_WIFI_PASS,
					   .threshold.authmode = WIFI_AUTH_WPA2_PSK,
					   .pmf_cfg = {
						   .capable = true,
						   .required = false
					   }
				   }

			   };
/* acess point in new series */
wifi_config_t wifi_config1 = {
       .ap = {
           .ssid = EXAMPLE_ESP_WIFI_AP_SSID,        // Set your AP's SSID (name)
    		  // .ssid = ssid_decoded,
           //.ssid_len = strlen("Your_AP_SSID"),
           .password = EXAMPLE_ESP_WIFI_AP_PASS,// Set your AP's password, can be NULL for open AP
			//   .password =password_decoded,
           .max_connection = 4,           // Maximum number of clients that can connect to the AP
           .authmode = WIFI_AUTH_WPA_WPA2_PSK, // Set your desired security mode
       },
   };


/* old series */
static const int RX_BUF_SIZE = 1024;

#define TXD_PIN (GPIO_NUM_26)
#define RXD_PIN (GPIO_NUM_22)


#define EX_UART_NUM (2)
#define PATTERN_CHR_NUM    (3)         /*!< Set the number of consecutive and identical characters received by receiver which defines a UART pattern*/
#define BUF_SIZE (1024)
#define RD_BUF_SIZE (BUF_SIZE)
static QueueHandle_t uart0_queue;
static TimerHandle_t shutdown_signal_timer;
char uri[150],username[20],password[20],fw_uri[150],fw_username[20],fw_password[20];
static int do_ping_cmd(void);
void ocpp_connect(void);
void strcpy_usr(char *,char *,int);
void strcat_usr(char *,char *,int,int);

static const uint16_t crc_tbl[16] = {
    0x0000, 0x1081, 0x2102, 0x3183,
    0x4204, 0x5285, 0x6306, 0x7387,
    0x8408, 0x9489, 0xa50a, 0xb58b,
    0xc60c, 0xd68d, 0xe70e, 0xf78f
};

//void ocpp_disconnect(void);
//void http_perform_as_stream_reader(void);
/*************Ethernet******************************/
/*
 char ip[20]= "172.16.3.239";
char gateway[20] = "172.16.3.1";
char netmask[20] = "255.255.0.0";
char dnsserver[20] = "8.8.8.8";
 */
char ip[20];
char gateway[20];
char netmask[20];
char dnsserver[20] = "8.8.8.8";
char status_evse;
esp_ping_handle_t ping;

unsigned char  ESPtxBuffer[512]={0};
unsigned short ESPtxBufferIndex=0;
unsigned short CRC=0;


static void shutdown_signaler(TimerHandle_t xTimer)
{
    ESP_LOGI(TAG, "No data received for %d seconds, signaling shutdown", 25);
   // status_evse = 9;
   // xSemaphoreGive(shutdown_sema);
}

#if CONFIG_EXAMPLE_USE_SPI_ETHERNET
#define INIT_SPI_ETH_MODULE_CONFIG(eth_module_config, num)                                      \
    do {                                                                                        \
        eth_module_config[num].spi_cs_gpio = CONFIG_EXAMPLE_ETH_SPI_CS ##num## _GPIO;           \
        eth_module_config[num].int_gpio = CONFIG_EXAMPLE_ETH_SPI_INT ##num## _GPIO;             \
        eth_module_config[num].phy_reset_gpio = CONFIG_EXAMPLE_ETH_SPI_PHY_RST ##num## _GPIO;   \
        eth_module_config[num].phy_addr = CONFIG_EXAMPLE_ETH_SPI_PHY_ADDR ##num;                \
    } while(0)

typedef struct {
    uint8_t spi_cs_gpio;
    uint8_t int_gpio;
    int8_t phy_reset_gpio;
    uint8_t phy_addr;
}spi_eth_module_config_t;
#endif
static void websocket_event_handler(void *handler_args, esp_event_base_t base, int32_t event_id, void *event_data)
{
	char buff[50];
    esp_websocket_event_data_t *data = (esp_websocket_event_data_t *)event_data;
    switch (event_id) {
    case WEBSOCKET_EVENT_CONNECTED:
        ESP_LOGI(TAG, "WEBSOCKET_EVENT_CONNECTED");
        if(websocket_connect == 0)
        {
        	status_evse = 3;
        	websocket_connect = 1;
        }
        websocket_disconnect = 0;
        break;
    case WEBSOCKET_EVENT_DISCONNECTED:
        ESP_LOGI(TAG, "WEBSOCKET_EVENT_DISCONNECTED");
        status_evse = 4;
        websocket_connect = 0;
        websocket_disconnect = 1;
        break;
    case WEBSOCKET_EVENT_DATA:
        ESP_LOGI(TAG, "WEBSOCKET_EVENT_DATA");
        ESP_LOGI(TAG, "Received opcode=%d", data->op_code);
        ESP_LOGW(TAG, "Received=%.*s", data->data_len, (char *)data->data_ptr);
        if(data->data_len > 8)
		{
			uart_write_bytes(EX_UART_NUM, (const char*) data->data_ptr, data->data_len);
			uart_write_bytes(EX_UART_NUM, "\r\n", 2);
		}
        break;
    case WEBSOCKET_EVENT_ERROR:
    	status_evse = 4;
    	websocket_connect = 0;
        ESP_LOGI(TAG, "WEBSOCKET_EVENT_ERROR");
        break;
    }
}

static void uart_event_task(void *pvParameters)
{
    uart_event_t event;
    uint16_t buffered_size;
    static uint16_t mulplyfrme = 1;
    //char *dtmp = (char*) malloc(RD_BUF_SIZE);
    char dtmp[1024];
    //uint8_t dtmp[500];
    char *found;//buff[100];
    int ret,len,j,i;
    char buffer[1024];
    static char OF;

    for(;;) {
        //Waiting for UART event.
        if(xQueueReceive(uart0_queue, (void * )&event, (TickType_t)portMAX_DELAY)) {

            bzero(dtmp, RD_BUF_SIZE);
#if DEBUG
            printf("uart[%d] event:\n", EX_UART_NUM);
#endif
            switch(event.type) {

                case UART_DATA:
                	uart_read_bytes(EX_UART_NUM, dtmp, event.size, portMAX_DELAY);
#if DEBUG
                	printf("message = %s\r\n",dtmp);
#endif
                    if(event.size >= 120)
                    {
                    	if(OF == 1)
                    	{
                    		strcat_usr((char*)&buffer[mulplyfrme],dtmp,event.size,mulplyfrme);

                    		mulplyfrme += event.size;
                    	}
                    	else
                    	{
                    		strcpy_usr(buffer,dtmp,event.size);
                    		OF = 1;
                    		mulplyfrme = event.size;
                    	}
                    }
                    else
                    {
                    	if(OF == 1)
                    	{
                    		strcat_usr((char*)&buffer[mulplyfrme],dtmp,event.size,mulplyfrme);
                    		mulplyfrme += event.size;
                    		OF = 0;
                    	}
                    	else
                    	{
                    		strcpy_usr(buffer,dtmp,event.size);
                    		mulplyfrme = event.size;
                    	}

//                    	printf("stm recieved byte = ");
//                    	for(int i = 0;i < mulplyfrme;i++ )
//                    	{
//                    		printf(" [%x] ",buffer[i]);
//                    	}
//                    	printf("\r\n");
                    	mulplyfrme = 0;
						if(buffer[0] == 0x02)
                    	{

                    		if(buffer[1] == espRestart)
                    		{
                    			if(buffer[5] == 0x01 && buffer[6] == 0x03)
                    			{

                    				xTaskNotify(xTask2,(1<<1),eSetBits);
                    			}

                    		}
                    		else if(buffer[1] == sendOcppuri)
                    		{
                    			int sep=0,Length=0,lclindex=0;

                    			uri[0]='w';
                    			uri[1]='s';
                    			uri[2]=':';
                    			uri[3]='/';
                    			uri[4]='/';
                    			status_evse = 2;
								Length=buffer[3];
								Length*=256;
								Length|=buffer[4];
								for(int index=0;index<Length;index++)
								{
									if(buffer [index +5] == 0x07)
									{
										sep++;
										if(sep==1)
										{
											uri[lclindex+5] =':';
											lclindex++;
										}
										else if(sep == 2)
										{
											//uri[index+5] ='/';
										}
										else
										{
											lclindex=0;
										}


									}
									else if(sep<3)
									{
										uri[lclindex+5] = buffer [index +5];
										lclindex++;
									}
									else if(sep == 3)
									{
										username[lclindex++] = buffer [index +5];
									}
									else if(sep == 4)
									{
										password[lclindex++] = buffer [index +5];
									}

								   }
//								printf("uri %s\r\n",uri);
//								printf("username %s\r\n",username);
//								printf("password %s\r\n",password);
#if DEBUG
											printf("uri %s\r\n",uri);
#endif
#if DEBUG
											printf("username %s\r\n",username);
#endif
#if DEBUG
											printf("password %s\r\n",password);
#endif
									xTaskNotify(xTask1,(1<<1),eSetBits);
											}


                    		else if(buffer[1] == ocppEnable)
							{
								if(buffer[6] == 0x03)
								{
									if(buffer[5] == 0x01) //ocpp enable
									{
										ocpp_connect();
									}
									else if(buffer[5] == 0x02) //ocpp disable
									{
										xTaskNotify(xTask1,(1<<1),eSetBits);
									}
								}
							}
                    		else if(buffer[1] == ocppApi)
							{
                    			int Length2=0;
                    			Length2=buffer[3];
                    			Length2*=256;
                    			Length2|=buffer[4];


                    			//#endif
								if(buffer[5] == '[')
								{
									ret = esp_websocket_client_send_text(client,(char*)&buffer[5],Length2, portMAX_DELAY);
									if(ret == -1)
									{
										status_evse = 4;
										websocket_connect = 0;
										websocket_disconnect = 1;
									}
									buffer[Length2+5] = '\0';
									printf("API message = %s\r\n",&buffer[5]);
								}

							}
							else if(buffer[1] == wifiparameters)
							{
								int sep=0,Length=0,lclindex=0;


								status_evse = -1;
								Length=buffer[3];
								Length*=256;
								Length|=buffer[4];
								for(int index=0;index<Length;index++)
								{
									if(buffer [index +5] == 0x07)
									{
										sep++;
										if(sep == 1)
										{
											wifi_config.sta.ssid[lclindex++] = '\0';
										}
										else if(sep == 2)
										{
											wifi_config.sta.password[lclindex++] = '\0';
										}
										lclindex=0;

									}
									else if(sep==0)
									{
										wifi_config.sta.ssid[lclindex++] = buffer [index +5];
									}
									else if(sep == 1)
									{
										wifi_config.sta.password[lclindex++] = buffer [index +5];
									}

								   }

								printf("ssid %s\t password %s\r\n", wifi_config.sta.ssid,wifi_config.sta.password);
								xTaskNotify(xTask2,(1<<2),eSetBits);

								//start_webserver();
							}
							else if(buffer[1] == fwUpgradestart)
							{
								//printf("hotspot firmware upgrade connected \r\n");
								//xTaskNotify(xTask2,(1<<4),eSetBits);
								//printf("hotspot11 connected firmware upgrade \r\n");

								int sep1=0,Length1=0,lclindex1=0;
								if(buffer[5]==1)
								{
								Length1=buffer[3];
								Length1*=256;
								Length1|=buffer[4];
								for(int index1=0;index1<Length1;index1++)
								{
									if(buffer [index1 +5] =='*')
									{
										sep1++;
//										if(sep1==1)
//										{
//											uri[index1+5] =':';
//										}
//										else if(sep1 == 2)
//										{
//											uri[index1+5] ='/';
//										}
										lclindex1=0;

									}
									else if(sep1==2)
									{
										fw_uri[lclindex1++] = buffer [index1 +5];
									}
									else if(sep1 == 3)
									{
										fw_username[lclindex1++] = buffer [index1 +5];
									}
									else if(sep1 == 4)
									{
										fw_password[lclindex1++] = buffer [index1 +5];
									}

								   }

#if DEBUG
											printf("fw_uri %s\r\n",fw_uri);
#endif
#if DEBUG
											printf("username %s\r\n",fw_username);
#endif
#if DEBUG
											printf("password %s\r\n",fw_password);
#endif
									xTaskNotify(xTask1,(1<<4),eSetBits);
									status_evse = -1;
								}
							}
							else if(buffer[1] == fwUpgradenext)
							{
								if(buffer[5]==1)
								{
									next =1;
								}
							}
							else if(buffer[1] == ethernetpara)
							{
								int sep=0,Length=0,lclindex=0;

							status_evse = -1;
							Length=buffer[3];
							Length*=256;
							Length|=buffer[4];
							printf("Ethernet = %s\r\n",buffer);
							for(int index=0;index<Length;index++)
							{
								if(buffer [index +5] == 0x07)
								{
									sep++;
									if(sep == 1)
									{
										ip[lclindex++] = '\0';
									}
									else if(sep == 2)
									{
										gateway[lclindex++] = '\0';
									}
									else if(sep == 3)
									{
										netmask[lclindex++] = '\0';
									}
									lclindex=0;

								}
								else if(sep==0)
								{
									ip[lclindex++] = buffer [index +5];
								}
								else if(sep == 1)
								{
									gateway[lclindex++] = buffer [index +5];
								}
								else if(sep == 2)
								{
									netmask[lclindex++] = buffer [index +5];
								}
							   }
							strcpy(dnsserver,"8.8.8.8");
							xTaskNotify(xTask2,(1<<0),eSetBits);
						//	status_evse = 9;

							}
                           /* new series */
							 else if(buffer[1] == configuration_mode)		//for blind unit
							{
								 if(buffer[5]==1)
								{
									 printf("activating hotspot\r\n");
									xTaskNotify(xTask2,(1<<4),eSetBits);
								}
							}
							 else if(buffer[1] == config_structRX)		//for blind unit
							{
								int sep=0,Length=0,lclindex=0;


								Length=buffer[3];
								Length*=256;
								Length|=buffer[4];
								// printf("size of stuct iss :%d \r\n",Length);
								 printf("size of stuct is :%d r\n",Length);
								 printf("uv status iss %u  \r\n", part1.under_voltage);
							      memcpy(&part1,&buffer[5],Length);
							      printf("uv status iss %u  \r\n", part1.under_voltage);
							      printf("Version V1.3_190624\r\n");
								//printf("fw status iss %u , %u \r\n", part1.under_voltage,buffer[5] );
								//	printf("rfid3 iss %s \r\n", form_data.rfid3 );
								//memcpy(&part1.under_voltage,&buffer[5],Length);
							//	printf("fw status is %d , %d \r\n", form_data.fw_status,buffer[1024] );
						//		printf("auxinput is %d \r\n",form_data.auxinput);


//								if (length == )
//								{
								status_evse = 13;
//								}
//								else
//								{
//									status_evse = 14;
//								}
							}
							 else if(buffer[1] == ack_datatx)		//for blind unit
							{

								 if(buffer[5]==1)			//data rx ok, restart esp
								{
//									    printf("restart esp...\r\n");
//										xTaskNotify(xTask2,(1<<1),eSetBits);//restart esp
									 status_evse = 16;
								}
								else 							//tx frame 0x74 again
								{
									status_evse = 15;
								}
							}



                    	}
					/*	else
						{
							 found = strtok(buffer,sep);

							if(found != NULL)
							{

								if(strcmp(found,"ethernet") == 0) // found[0] == 30
								{
									//found = NULL;
									found = strtok(NULL,sep);
									status_evse = -1;
#if DEBUG
									printf("Ethernet = %s\r\n",found);
#endif
									if(strcmp(found,"start") == 0)
									{
									    found = strtok(NULL,sep);
									    strcpy(&ip,found);

									    found = strtok(NULL,sep);
										strcpy(&gateway,found);

										found = strtok(NULL,sep);
										strcpy(netmask,found);

										//strcpy(dnsserver,"8.8.8.8");
									//	xTaskNotify(xTask2,(1<<0),eSetBits);

										status_evse = 9;
									}
								}


								else
								{
#if DEBUG
									printf("none of = %s\r\n",found);
#endif
								}
							}
							else
							{
#if DEBUG
								printf("hello message = %s\r\n",buffer);
#endif
							}
						}*/
                    }
                    break;
                //Event of HW FIFO overflow detected
                case UART_FIFO_OVF:
                    ESP_LOGI(TAG, "hw fifo overflow");
                    // If fifo overflow happened, you should consider adding flow control for your application.
                    // The ISR has already reset the rx FIFO,
                    // As an example, we directly flush the rx buffer here in order to read more data.
                    uart_flush_input(EX_UART_NUM);
                    xQueueReset(uart0_queue);
                    break;
                //Event of UART ring buffer full
                case UART_BUFFER_FULL:
                    ESP_LOGI(TAG, "ring buffer full");
                    // If buffer full happened, you should consider encreasing your buffer size
                    // As an example, we directly flush the rx buffer here in order to read more data.
                    uart_flush_input(EX_UART_NUM);
                  //  printf("buffer full \r\n");
                    xQueueReset(uart0_queue);
                    break;
                //Event of UART RX break detected
                case UART_BREAK:
                    ESP_LOGI(TAG, "uart rx break");
                    printf("buffer full \r\n");
                    break;
                //Event of UART parity check error
                case UART_PARITY_ERR:
                    ESP_LOGI(TAG, "uart parity error");
                    break;
                //Event of UART frame error
                case UART_FRAME_ERR:
                    ESP_LOGI(TAG, "uart frame error");
                    break;
                //UART_PATTERN_DET
                case UART_PATTERN_DET:
                    uart_get_buffered_data_len(EX_UART_NUM, &buffered_size);
                    int pos = uart_pattern_pop_pos(EX_UART_NUM);
                    ESP_LOGI(TAG, "[UART PATTERN DETECTED] pos: %d, buffered size: %d", pos, buffered_size);
                    if (pos == -1) {
                        // There used to be a UART_PATTERN_DET event, but the pattern position queue is full so that it can not
                        // record the position. We should set a larger queue size.
                        // As an example, we directly flush the rx buffer here.
                        uart_flush_input(EX_UART_NUM);
                    }else {
                        uart_read_bytes(EX_UART_NUM, dtmp, pos, 100 / portTICK_PERIOD_MS);
                        uint8_t pat[PATTERN_CHR_NUM + 1];
                        memset(pat, 0, sizeof(pat));
                        uart_read_bytes(EX_UART_NUM, pat, PATTERN_CHR_NUM, 100 / portTICK_PERIOD_MS);
#if DEBUG
                        printf("read data: %s\r\n", dtmp);
                        printf("read pat : %s\r\n", pat);
#endif
                    }
                    break;
                //Others
                default:
                    ESP_LOGI(TAG, "uart event type: %d", event.type);
                    break;
            }
        }
    }
    free(dtmp);
   // dtmp = NULL;
    vTaskDelete(NULL);
}


unsigned short Crc16(const uint8_t *data, uint32_t len)
{
        uint8_t  byte;
        uint16_t CrcVal=0;
    	while (len--)
	    {
    		byte= *data++;
    		CrcVal = ((CrcVal >> 4) & 0x0fff) ^ crc_tbl[((CrcVal ^ byte) & 15)];
        	byte>>= 4;
        	CrcVal = ((CrcVal >> 4) & 0x0fff) ^ crc_tbl[((CrcVal ^ byte) & 15)];
    	}
    	return CrcVal;
}
static void firmware_upgrade(void * pvParameters)
{
	 char buff[10];
	 unsigned char CRC_buff[300]={0};
	unsigned int read_len;
	char *header_val = NULL;
	esp_err_t err;
	unsigned int content_length;
    char *buffer = malloc(256 + 1);
    if (buffer == NULL) {
        ESP_LOGE(TAG, "Cannot malloc http receive buffer");
        return;
    }

    esp_http_client_config_t config = {};

    // .url = "http://192.168.15.151/hybrid-FOTA.bin",
	//	.event_handler = _http_event_handler,
	//	.buffer_size = 256,
    //};

	config.url = &fw_uri;
	config.buffer_size = 256;

    esp_http_client_handle_t client = esp_http_client_init(&config);
    esp_http_client_set_timeout_ms(client,10000);

    	if(client == NULL)
    	{
    		memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
			memset((unsigned char*)buff,0x00,sizeof(buff));

			ESPtxBufferIndex =0;
			ESPtxBuffer[ESPtxBufferIndex++]=0x02;//start byte //0
			ESPtxBuffer[ESPtxBufferIndex++]=0x88;//frame info firmware info //file not found
			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//sub frame  //2
			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length high //3
			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length Low  //4

			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//status  //5

			memcpy(&ESPtxBuffer[ESPtxBufferIndex],&buff,strlen(buff)); //6 &7

			ESPtxBufferIndex+=strlen(buff);

			ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte //8

			ESPtxBuffer[3]=((ESPtxBufferIndex-6)/256);  //3
			ESPtxBuffer[4]= (ESPtxBufferIndex-6) % 256;   //4
	//======================================================================================================================
			uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);

    		free(buffer);
    		vTaskDelete(NULL);
    		return;
    	}

    	// esp_http_client_fetch_headers(client);

    	err = esp_http_client_set_method(client, HTTP_METHOD_HEAD);
    	if(err != ESP_OK)
		{
    		printf("ESP client set method Error\r\n");
		}
    	 err = esp_http_client_perform(client);
    	if(err != ESP_OK)
    	{
    		printf("ESP client Perform Error\r\n");
//    		memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
//			memset((unsigned char*)buff,0x00,sizeof(buff));
//
//			ESPtxBufferIndex =0;
//			ESPtxBuffer[ESPtxBufferIndex++]=0x02;//start byte //0
//			ESPtxBuffer[ESPtxBufferIndex++]=0x88;//frame info firmware info //file not found
//			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//sub frame  //2
//			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length high //3
//			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length Low  //4
//
//			ESPtxBuffer[ESPtxBufferIndex++]=0x01;//status  //5
//
//			memcpy(&ESPtxBuffer[ESPtxBufferIndex],&buff,strlen(buff)); //6 &7
//
//			ESPtxBufferIndex+=strlen(buff);
//
//			ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte //8
//
//			ESPtxBuffer[3]=((ESPtxBufferIndex-6)/256);  //3
//			ESPtxBuffer[4]= (ESPtxBufferIndex-6) % 256;   //4
//	//======================================================================================================================
//			uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
//
//			free(buffer);
//			vTaskDelete(NULL);
//			return;
    	}
    	content_length = esp_http_client_get_content_length(client);

    	printf("content length %u\r\n" , content_length);
//============================================================================================================
    	memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
    	memset((unsigned char*)buff,0x00,sizeof(buff));

    	sprintf(&buff,"%u",content_length);
    	ESPtxBufferIndex =0;
    	ESPtxBuffer[ESPtxBufferIndex++]=0x02;//start byte //0
    	ESPtxBuffer[ESPtxBufferIndex++]=0x80;//frame info firmware info //1
    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;//sub frame  //2
    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length high //3
    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length Low  //4

    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;//status  //5

        memcpy(&ESPtxBuffer[ESPtxBufferIndex],&buff,strlen(buff)); //6 &7

        ESPtxBufferIndex+=strlen(buff);

        ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte //8

        ESPtxBuffer[3]=((ESPtxBufferIndex-6)/256);  //3
        ESPtxBuffer[4]= (ESPtxBufferIndex-6) % 256;   //4
//======================================================================================================================
    	uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);

		recieved_length = 0;
		while(1)
		{
			while(next == 0);
			next = 0;

			esp_http_client_close(client);
			if ((content_length - recieved_length) > 255) {
				asprintf(&header_val, "bytes=%u-%u", recieved_length, (recieved_length + 256 - 1));
				read_len = 256;

			} else {
				asprintf(&header_val, "bytes=%u-", recieved_length);
				read_len = (content_length - recieved_length);
			}

			if (header_val == NULL) {
				ESP_LOGE(TAG, "Failed to allocate memory for HTTP header");
			}

			esp_http_client_set_header(client, "Range", header_val);

			free(header_val);

			 esp_http_client_set_method(client, HTTP_METHOD_GET);

			if ((err = esp_http_client_open(client, 0)) != ESP_OK) {
				 ESP_LOGE(TAG, "Failed to open HTTP connection: %s", esp_err_to_name(err));
				 free(buffer);
				 return;
			}

			read_len = esp_http_client_read(client, buffer, read_len);

			if(read_len == -1)
			{
				printf("Read fw data Fail\r\n");
				status_evse = 4;
				websocket_connect = 0;
				websocket_disconnect = 1;
				break;
			}

			//-----------------------------------------------------------------

			    memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
		        memset((unsigned char*)CRC_buff,0x00,sizeof(CRC_buff));
		        memcpy(&CRC_buff[0],&buffer[0],read_len);
		        CRC=0;
		        CRC	=Crc16(&CRC_buff, read_len);
		     		        printf("CRC 0x%X\r\n",CRC);
		        ESPtxBufferIndex=0;
			    ESPtxBuffer[ESPtxBufferIndex++]=0x02;//start byte
		    	ESPtxBuffer[ESPtxBufferIndex++]=0x81;//frame info firmware info
		    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;//sub frame

		    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length high
		    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;//length Low
		    	ESPtxBuffer[ESPtxBufferIndex++]=0x01;

		    	ESPtxBuffer[ESPtxBufferIndex++]=CRC/256;
		    	ESPtxBuffer[ESPtxBufferIndex++]=CRC%256;
		        memcpy(&ESPtxBuffer[ESPtxBufferIndex],&buffer[0],read_len);

		        ESPtxBufferIndex+=read_len;

		        ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

		        ESPtxBuffer[3]=((ESPtxBufferIndex-6)/256);  //3
		        ESPtxBuffer[4]= (ESPtxBufferIndex-6) % 256;   //4

		        uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);

#if DEBUG
		printf("data:%s\r\n",buffer);
#endif

			recieved_length += read_len;
			//printf("fw len: %u\r\n",read_len);
			printf("fw len: [0X%x],[0X%x]\r\n",ESPtxBuffer[3],ESPtxBuffer[4]);
			if(recieved_length >= content_length)
			{
				printf("fw break : %u\r\n",read_len);
				break;

			}
		}
#if DEBUG
		printf("done_firmware\r\n");
#endif

		//sprintf(buff,"done_firmware*\r\n");
		//uart_write_bytes(EX_UART_NUM, (const char*) buff,strlen(buff));

		free(buffer);
		vTaskDelete(NULL);
}
static void websocket_app_start(void * pvParameters )
{
	 vTaskDelay(1000 / portTICK_RATE_MS);

	    uint32_t NotifierValue;
	    char buff[50];
	    while(1)
	    {
	    	if(xTaskNotifyWait(0xffffffff, 0, &NotifierValue, 0xff) == pdTRUE)
	    	{
#if DEBUG
	    		printf("notify,\r\n");
#endif
	    		if(NotifierValue & (1<<0))
	    		{
#if DEBUG
					printf("uri %s\r\n",uri);
#endif
					websocket_cfg.keep_alive_enable = true;
					websocket_cfg.subprotocol = "ocpp1.6";
					// websocket_cfg.task_prio = 5;
					websocket_cfg.task_stack = 6 * 1024;
					client = esp_websocket_client_init(&websocket_cfg);
					esp_websocket_register_events(client, WEBSOCKET_EVENT_ANY, websocket_event_handler, (void *)client);
					esp_websocket_client_start(client);
	    		}
	    		else if(NotifierValue & (1<<1))
	    		{
	    			if(ethernet_connection == 1)
	    			{

	    			}
	    			else
	    			{
	    				status_evse = 2;
	    			}
#if DEBUG
					printf("websocket destroy succsessfully\r\n");
#endif
					esp_websocket_client_destroy(client);
					memset(&websocket_cfg, 0, sizeof(websocket_cfg));
#if DEBUG
					printf("memory reset \r\n");
#endif
				    //free(client);
					memset(&client, 0, sizeof(client));
#if DEBUG
				    printf("client free\r\n");
#endif
	    		}
	    		else if(NotifierValue & (1<<2))
	    		{
	    			esp_wifi_set_config(WIFI_IF_STA, &wifi_config);
	    			esp_wifi_start();
	    			 //xEventGroupSetBits(s_wifi_event_group, ESPTOUCH_DONE_BIT);
	    		}
	    		else if(NotifierValue & (1<<3))
	    		{
	    			sprintf(buff,"ocpp*set_uri\r\n");
					uart_write_bytes(EX_UART_NUM, (const char*) buff,strlen(buff));
					uart_wait_tx_done(EX_UART_NUM, 100);
	    		}
	    		else if(NotifierValue & (1<<4))
				{
					xTaskCreate(&firmware_upgrade, "firmware", 8192, NULL, 5, NULL);
				}

	    	}
	    }
	    vTaskDelete(NULL);
}
static void cmd_ping_on_ping_success(esp_ping_handle_t hdl, void *args)
{
    uint8_t ttl;
    uint16_t seqno;
    uint32_t elapsed_time, recv_len;
    ip_addr_t target_addr;
    esp_ping_get_profile(hdl, ESP_PING_PROF_SEQNO, &seqno, sizeof(seqno));
    esp_ping_get_profile(hdl, ESP_PING_PROF_TTL, &ttl, sizeof(ttl));
    esp_ping_get_profile(hdl, ESP_PING_PROF_IPADDR, &target_addr, sizeof(target_addr));
    esp_ping_get_profile(hdl, ESP_PING_PROF_SIZE, &recv_len, sizeof(recv_len));
    esp_ping_get_profile(hdl, ESP_PING_PROF_TIMEGAP, &elapsed_time, sizeof(elapsed_time));
#if DEBUG
    printf("%d bytes from %s icmp_seq=%d ttl=%d time=%d ms\n",
           recv_len, ipaddr_ntoa((ip_addr_t*)&target_addr), seqno, ttl, elapsed_time);
#endif

}

static void cmd_ping_on_ping_timeout(esp_ping_handle_t hdl, void *args)
{
    uint16_t seqno;
    ip_addr_t target_addr;
    esp_ping_get_profile(hdl, ESP_PING_PROF_SEQNO, &seqno, sizeof(seqno));
    esp_ping_get_profile(hdl, ESP_PING_PROF_IPADDR, &target_addr, sizeof(target_addr));
    printf("From %s icmp_seq=%d timeout\n",ipaddr_ntoa((ip_addr_t*)&target_addr), seqno);
}

static void cmd_ping_on_ping_end(esp_ping_handle_t hdl, void *args)
{
    ip_addr_t target_addr;
    uint32_t transmitted;
    uint32_t received;
    uint32_t total_time_ms;
    char buff[50];
    esp_ping_get_profile(hdl, ESP_PING_PROF_REQUEST, &transmitted, sizeof(transmitted));
    esp_ping_get_profile(hdl, ESP_PING_PROF_REPLY, &received, sizeof(received));
    esp_ping_get_profile(hdl, ESP_PING_PROF_IPADDR, &target_addr, sizeof(target_addr));
    esp_ping_get_profile(hdl, ESP_PING_PROF_DURATION, &total_time_ms, sizeof(total_time_ms));
    uint32_t loss = (uint32_t)((1 - ((float)received) / transmitted) * 100);
    if (IP_IS_V4(&target_addr)) {
        printf("\n--- %s ping statistics ---\n", inet_ntoa(*ip_2_ip4(&target_addr)));
    } else {
        printf("\n--- %s ping statistics ---\n", inet6_ntoa(*ip_2_ip6(&target_addr)));
    }
    printf("%d packets transmitted, %d received, %d%% packet loss, time %dms\n",
           transmitted, received, loss, total_time_ms);
    // delete the ping sessions, so that we clean up all resources and can create a new ping session
    // we don't have to call delete function in the callback, instead we can call delete function from other tasks
    esp_ping_delete_session(hdl);

    if(received > 0)
    {
    	//internet connection
    	 status_evse = 1;
    	 printf("Recieved Ping \r\n");
    	//xTaskNotify(xTask1,(1<<0),eSetBits);
    	//initialize_sntp();
        //xTaskNotify(xTask1,(1<<2),eSetBits);
    }
    else if(ethernet_connection == 1)
    {

    }
    else
    {
    	status_evse = 5;
    	printf(" Not Recieved Ping \r\n");
    	 do_ping_cmd();
    }
}
static int do_ping_cmd()
{
    esp_ping_config_t config = ESP_PING_DEFAULT_CONFIG();
    config.timeout_ms = 512;
	config.interval_ms = 2000;
	config.data_size = 8;
	config.count = 5;
	config.tos = 2;

    // parse IP address

    ip_addr_t target_addr;
    memset(&target_addr, 0, sizeof(target_addr));
    {
        struct addrinfo hint;
        struct addrinfo *res = NULL;
        memset(&hint, 0, sizeof(hint));

        /* convert ip4 string or hostname to ip4 or ip6 address */
        if (getaddrinfo("8.8.4.4", NULL, &hint, &res) != 0) {
            printf("ping: unknown host %s\n", "8.8.4.4");
            return 1;
        }
        if (res->ai_family == AF_INET) {
            struct in_addr addr4 = ((struct sockaddr_in *) (res->ai_addr))->sin_addr;
            inet_addr_to_ip4addr(ip_2_ip4(&target_addr), &addr4);
        } else {
            struct in6_addr addr6 = ((struct sockaddr_in6 *) (res->ai_addr))->sin6_addr;
            inet6_addr_to_ip6addr(ip_2_ip6(&target_addr), &addr6);
        }
        freeaddrinfo(res);
    }
    config.target_addr = target_addr;

    /* set callback functions */
    esp_ping_callbacks_t cbs = {
        .on_ping_success = cmd_ping_on_ping_success,
        .on_ping_timeout = cmd_ping_on_ping_timeout,
        .on_ping_end = cmd_ping_on_ping_end,
        .cb_args = NULL
    };

    esp_ping_new_session(&config, &cbs, &ping);
    esp_ping_start(ping);
    return 0;
}
static void event_handler(void* arg, esp_event_base_t event_base,
                                int32_t event_id, void* event_data)
{
	 if(event_base == WIFI_EVENT && event_id == WIFI_EVENT_STA_START) {
		 printf("CREATE TASK \r\n");
#if DEBUG
		 printf("CREATE TASK \r\n");
#endif
		 esp_wifi_connect();
	    // xTaskCreate(smartconfig_example_task, "smartconfig_example_task", 4096, NULL, 3, NULL);
	}
    else if (event_base == WIFI_EVENT && event_id == WIFI_EVENT_STA_DISCONNECTED) {
    	printf("Reconnect\r\n");
#if DEBUG
    	printf("Reconnect\r\n");
#endif
    	//uart_write_bytes(EX_UART_NUM, (const char*)"wifi*disconnected\r\n",19);
        esp_wifi_connect();
        status_evse = 6;
        if(websocket_disconnect == 1)
        {
        	xTaskNotify(xTask2,(1<<1),eSetBits);
        }
        //xEventGroupClearBits(s_wifi_event_group, WIFI_CONNECTED_BIT);
    }
    else if (event_base == WIFI_EVENT && event_id == WIFI_EVENT_STA_CONNECTED) {
        //ip_event_got_ip_t* event = (ip_event_got_ip_t*) event_data;
#if DEBUG
    	printf("connect\r\n");
#endif
    	printf("Wifi connected \r\n");
        do_ping_cmd();
        //xEventGroupSetBits(s_wifi_event_group, WIFI_CONNECTED_BIT);
        //initialize_sntp();
        // get_time();
    }
	 /*
    else if (event_base == SC_EVENT && event_id == SC_EVENT_SCAN_DONE) {

    }*/
}

void init(void) {
    const uart_config_t uart_config = {
        .baud_rate = 115200,
        .data_bits = UART_DATA_8_BITS,
        .parity = UART_PARITY_DISABLE,
        .stop_bits = UART_STOP_BITS_1,
        .flow_ctrl = UART_HW_FLOWCTRL_DISABLE,
       .source_clk = UART_SCLK_APB,
		//.rx_flow_ctrl_thresh = 122,
    };
    // We won't use a buffer for sending data.
    uart_driver_install(2, RX_BUF_SIZE * 2, RX_BUF_SIZE * 2, 20, &uart0_queue, 0);
    uart_param_config(2, &uart_config);
    uart_set_pin(2, TXD_PIN, RXD_PIN, -1, -1);
    uart_pattern_queue_reset(2, 20);

    gpio_set_pull_mode(16, GPIO_PULLUP_ONLY);
    gpio_pad_select_gpio(16);
    gpio_set_direction(16, GPIO_MODE_INPUT);

}
static void eth_event_handler(void *arg, esp_event_base_t event_base,
                              int32_t event_id, void *event_data)
{
    uint8_t mac_addr[6] = {0};
    /* we can get the ethernet driver handle from event data */
    esp_eth_handle_t eth_handle = *(esp_eth_handle_t *)event_data;
    shutdown_signal_timer = xTimerCreate("Websocket shutdown timer", NO_DATA_TIMEOUT_SEC * 1000 / portTICK_PERIOD_MS,
    	                                         pdFALSE, NULL, shutdown_signaler);

    switch (event_id) {
    case ETHERNET_EVENT_CONNECTED:
        esp_eth_ioctl(eth_handle, ETH_CMD_G_MAC_ADDR, mac_addr);
        ESP_LOGI(TAG, "Ethernet Link Up");
        ESP_LOGI(TAG, "Ethernet HW Addr %02x:%02x:%02x:%02x:%02x:%02x",
                 mac_addr[0], mac_addr[1], mac_addr[2], mac_addr[3], mac_addr[4], mac_addr[5]);
        break;
    case ETHERNET_EVENT_DISCONNECTED:
        ESP_LOGI(TAG, "Ethernet Link Down");
        status_evse = 7;
        xTaskNotify(xTask1,(1<<1),eSetBits); //websocket disconnected
        ethernet_connection = 1;
       // esp_ping_stop(ping);
       // esp_ping_delete_session(ping);
        break;
    case ETHERNET_EVENT_START:
    	ethernet_connection =0;
        ESP_LOGI(TAG, "Ethernet Started");
        xTimerStart(shutdown_signal_timer, portMAX_DELAY);
        break;
    case ETHERNET_EVENT_STOP:
        ESP_LOGI(TAG, "Ethernet Stopped");
        break;
    default:
        break;
    }
}

/** Event handler for IP_EVENT_ETH_GOT_IP */
static void got_ip_event_handler(void *arg, esp_event_base_t event_base,
                                 int32_t event_id, void *event_data)
{
    ip_event_got_ip_t *event = (ip_event_got_ip_t *) event_data;
    const esp_netif_ip_info_t *ip_info = &event->ip_info;

    ESP_LOGI(TAG, "Ethernet Got IP Address");
    ESP_LOGI(TAG, "~~~~~~~~~~~");
    ESP_LOGI(TAG, "ETHIP:" IPSTR, IP2STR(&ip_info->ip));
    ESP_LOGI(TAG, "ETHMASK:" IPSTR, IP2STR(&ip_info->netmask));
    ESP_LOGI(TAG, "ETHGW:" IPSTR, IP2STR(&ip_info->gw));
    ESP_LOGI(TAG, "~~~~~~~~~~~");
    xTimerStop(shutdown_signal_timer, portMAX_DELAY);
    status_evse = 8;
    do_ping_cmd();
   // xTaskCreate(&websocket_app_start, "https_get_task", 8192, NULL, 5, NULL);
}

static void Network_interface(void * pvParameters )
{
	uint32_t NotifierValue;

	esp_task_wdt_add(NULL);
	esp_task_wdt_status(NULL);
        while(1)
		{
			if(xTaskNotifyWait(0xffffffff, 0, &NotifierValue, 0xff) == pdTRUE)
			{
				if(NotifierValue & (1<<0))
				{
					esp_netif_config_t cfg = ESP_NETIF_DEFAULT_ETH();
					eth_netif = esp_netif_new(&cfg);
					// Set default handlers to process TCP/IP stuffs

					ESP_ERROR_CHECK(esp_netif_dhcpc_stop(eth_netif));

					esp_ip_addr_t dns;
					esp_netif_ip_info_t info_t;
					esp_netif_dns_info_t dns_t;

					memset(&info_t, 0, sizeof(esp_netif_ip_info_t));
					memset(&dns_t, 0, sizeof(esp_netif_ip_info_t));

					printf("IP fetched : %s", ip);

					if(strcmp(ip, "255.255.255.255") == 0)
					{
						IP_CONFIG = ENABLE_DHCP;	

						printf("\r\nEnabling DHCP!!\n");
						ESP_ERROR_CHECK(esp_netif_dhcpc_start(eth_netif));										
					}
					else
					{
						IP_CONFIG = DISABLE_DHCP;
						printf("\r\nHandling static IP.\r\n");
						info_t.ip.addr = esp_ip4addr_aton((const char *)ip);
						info_t.gw.addr = esp_ip4addr_aton((const char *)gateway);
						info_t.netmask.addr = esp_ip4addr_aton((const char *)netmask);

						dns.u_addr.ip4.addr = esp_ip4addr_aton((const char *)dnsserver);
						dns_t.ip = dns;
						
						esp_netif_set_ip_info(eth_netif, &info_t);
						esp_netif_set_dns_info(eth_netif, ESP_NETIF_DNS_MAIN, &dns_t);					
				        }
					printf("\r\nESP event handler\n.");
					//ESP_ERROR_CHECK(esp_eth_set_default_handlers(eth_netif));
					// Register user defined event handlers
					ESP_ERROR_CHECK(esp_event_handler_register(ETH_EVENT, ESP_EVENT_ANY_ID, &eth_event_handler, NULL));
					ESP_ERROR_CHECK(esp_event_handler_register(IP_EVENT, IP_EVENT_ETH_GOT_IP, &got_ip_event_handler, NULL));

					eth_mac_config_t mac_config = ETH_MAC_DEFAULT_CONFIG();
					mac_config.smi_mdc_gpio_num = -1;
					mac_config.smi_mdio_gpio_num = -1;

					eth_phy_config_t phy_config = ETH_PHY_DEFAULT_CONFIG();
					phy_config.autonego_timeout_ms = 10;
					phy_config.reset_gpio_num = -1;
					phy_config.phy_addr = 1;
					phy_config.reset_gpio_num = 2;

					#if CONFIG_EXAMPLE_USE_INTERNAL_ETHERNET
						mac_config.smi_mdc_gpio_num = CONFIG_EXAMPLE_ETH_MDC_GPIO;
						mac_config.smi_mdio_gpio_num = CONFIG_EXAMPLE_ETH_MDIO_GPIO;
						esp_eth_mac_t *mac = esp_eth_mac_new_esp32(&mac_config);
					#if CONFIG_EXAMPLE_ETH_PHY_IP101
						esp_eth_phy_t *phy = esp_eth_phy_new_ip101(&phy_config);
					#elif CONFIG_EXAMPLE_ETH_PHY_RTL8201
						esp_eth_phy_t *phy = esp_eth_phy_new_rtl8201(&phy_config);
					#elif CONFIG_EXAMPLE_ETH_PHY_LAN8720
						esp_eth_phy_t *phy = esp_eth_phy_new_lan8720(&phy_config);
					#elif CONFIG_EXAMPLE_ETH_PHY_DP83848
						esp_eth_phy_t *phy = esp_eth_phy_new_dp83848(&phy_config);
					#elif CONFIG_EXAMPLE_ETH_PHY_KSZ8041
						esp_eth_phy_t *phy = esp_eth_phy_new_ksz8041(&phy_config);
					#endif
					#elif CONFIG_ETH_USE_SPI_ETHERNET
						gpio_install_isr_service(0);
						spi_device_handle_t spi_handle = NULL;
						spi_bus_config_t buscfg = {
							.miso_io_num = CONFIG_EXAMPLE_ETH_SPI_MISO_GPIO,
							.mosi_io_num = CONFIG_EXAMPLE_ETH_SPI_MOSI_GPIO,
							.sclk_io_num = CONFIG_EXAMPLE_ETH_SPI_SCLK_GPIO,
							.quadwp_io_num = -1,
							.quadhd_io_num = -1,
						};
						ESP_ERROR_CHECK(spi_bus_initialize(CONFIG_EXAMPLE_ETH_SPI_HOST, &buscfg, 1));
					#if CONFIG_EXAMPLE_USE_DM9051
						spi_device_interface_config_t devcfg = {
							.command_bits = 1,
							.address_bits = 7,
							.mode = 0,
							.clock_speed_hz = CONFIG_EXAMPLE_ETH_SPI_CLOCK_MHZ * 1000 * 1000,
							.spics_io_num = CONFIG_EXAMPLE_ETH_SPI_CS_GPIO,
							.queue_size = 20
						};
						ESP_ERROR_CHECK(spi_bus_add_device(CONFIG_EXAMPLE_ETH_SPI_HOST, &devcfg, &spi_handle));
						//dm9051 ethernet driver is based on spi driver
						eth_dm9051_config_t dm9051_config = ETH_DM9051_DEFAULT_CONFIG(spi_handle);
						dm9051_config.int_gpio_num = CONFIG_EXAMPLE_ETH_SPI_INT_GPIO;
						esp_eth_mac_t *mac = esp_eth_mac_new_dm9051(&dm9051_config, &mac_config);
						esp_eth_phy_t *phy = esp_eth_phy_new_dm9051(&phy_config);
					#elif CONFIG_EXAMPLE_USE_W5500
						spi_device_interface_config_t devcfg = {
							.command_bits = 16, // Actually it's the address phase in W5500 SPI frame
							.address_bits = 8,  // Actually it's the control phase in W5500 SPI frame
							.mode = 0,
							.clock_speed_hz = 20 * 1000 * 1000,
							.spics_io_num = 5,
							.queue_size = 20
						};
						ESP_ERROR_CHECK(spi_bus_add_device(CONFIG_EXAMPLE_ETH_SPI_HOST, &devcfg, &spi_handle));
						// w5500 ethernet driver is based on spi driver
						eth_w5500_config_t w5500_config = ETH_W5500_DEFAULT_CONFIG(spi_handle);
						mac_config.sw_reset_timeout_ms = 10;
						w5500_config.int_gpio_num = 34;
						esp_eth_mac_t *mac = esp_eth_mac_new_w5500(&w5500_config, &mac_config);
						esp_eth_phy_t *phy = esp_eth_phy_new_w5500(&phy_config);
					#endif
					#endif // CONFIG_ETH_USE_SPI_ETHERNET
						esp_eth_config_t config = ETH_DEFAULT_CONFIG(mac, phy);
						// esp_eth_handle_t eth_handle = NULL;
						ESP_ERROR_CHECK(esp_eth_driver_install(&config, &eth_handle));
					#if !CONFIG_EXAMPLE_USE_INTERNAL_ETHERNET
						// The SPI Ethernet module might doesn't have a burned factory MAC address, we cat to set it manually.
						//   02:00:00 is a Locally Administered OUI range so should not be used except when testing on a LAN under your control.
						unsigned char mac_base[6]={0};
						esp_err_t ret;
						ret = esp_efuse_mac_get_default(mac_base);
						if (ret != ESP_OK)
						{
							return ret;	
						}

						ESP_ERROR_CHECK(esp_eth_ioctl(eth_handle, ETH_CMD_S_MAC_ADDR,mac_base));
						/*ESP_ERROR_CHECK(esp_eth_ioctl(eth_handle, ETH_CMD_S_MAC_ADDR, (uint8_t[]) 
						{
							0x02, 0x00, 0x00, 0x12, 0x34, 0x56
						}));*/
					#endif
						printf("hello\n");
						// attach Ethernet driver to TCP/IP stack
						ESP_ERROR_CHECK(esp_netif_attach(eth_netif, esp_eth_new_netif_glue(eth_handle)));
						// start Ethernet driver state machine
						ESP_ERROR_CHECK(esp_eth_start(eth_handle));
				}
				else if(NotifierValue & (1<<1))
				{
					//esp_restart
					 esp_restart();
				}
				else if(NotifierValue & (1<<2))
				{
					//wifi connect
					s_wifi_event_group = xEventGroupCreate();

					esp_netif_t *sta_netif = esp_netif_create_default_wifi_sta();
					//assert(sta_netif);

					wifi_init_config_t cfg = WIFI_INIT_CONFIG_DEFAULT();
					ESP_ERROR_CHECK( esp_wifi_init(&cfg) );

					esp_event_handler_instance_t instance_any_id;
					esp_event_handler_instance_t instance_got_ip;
					ESP_ERROR_CHECK( esp_event_handler_instance_register(WIFI_EVENT, ESP_EVENT_ANY_ID, &event_handler,NULL,&instance_any_id));
					ESP_ERROR_CHECK( esp_event_handler_instance_register(IP_EVENT, IP_EVENT_STA_GOT_IP, &event_handler,NULL,&instance_got_ip) );

					ESP_ERROR_CHECK( esp_wifi_set_mode(WIFI_MODE_STA));
					esp_netif_set_hostname(sta_netif,"LUBI-CHARGER");
		//	esp_netif_set_hostname_api("LUBI-Charger");
					ESP_ERROR_CHECK( esp_wifi_set_config(WIFI_IF_STA, &wifi_config) );
					ESP_ERROR_CHECK( esp_wifi_start() );

				}
				else if(NotifierValue & (1<<3))
				{
					//reconnect
					esp_wifi_set_config(WIFI_IF_STA, &wifi_config);
					esp_wifi_start();
					//esp_netif_set_hostname(sta_netif,"LUBI-CHARGER");
				}
				else if(NotifierValue & (1<<4))
				{
				     esp_wifi_stop();
					 s_wifi_event_ap_group=xEventGroupCreate();
					  //wifi_init_softap();
					  esp_netif_t *sta_netif =  esp_netif_create_default_wifi_ap();
					  wifi_init_config_t cfg = WIFI_INIT_CONFIG_DEFAULT();
					  ESP_ERROR_CHECK (esp_wifi_init(&cfg));
					  esp_event_handler_instance_t instance_any_id;
					  esp_event_handler_instance_t instance_ap_start;
					/*if (event_base == WIFI_EVENT && event_id == WIFI_EVENT_AP_START) {
						ESP_LOGI("AP_EVENT", "AP started");
                         }*/
                         ESP_ERROR_CHECK( esp_event_handler_instance_register(WIFI_EVENT, ESP_EVENT_ANY_ID, &event_handler,NULL,&instance_any_id));
						 ESP_ERROR_CHECK(esp_event_handler_instance_register(WIFI_EVENT, WIFI_EVENT_AP_START, &event_handler, NULL, &instance_ap_start));
						 ESP_ERROR_CHECK (esp_wifi_set_mode(WIFI_MODE_AP));
						 ESP_ERROR_CHECK (esp_wifi_set_config(ESP_IF_WIFI_AP, &wifi_config1));
						 ESP_ERROR_CHECK (esp_wifi_start());

						 start_webserver();
						 //printf("Hospot activated.");
						 status_evse=11;
                                // hotspot create
								//	esp_wifi_set_config(WIFI_IF_STA, &wifi_config);
								//	esp_wifi_start();
									//esp_netif_set_hostname(sta_netif,"LUBI-CHARGER");
					}
					else if(NotifierValue & (1<<5))
					{
						vTaskDelay(pdMS_TO_TICKS(15000));
//						stop_webserver();
					   esp_wifi_stop();
					   printf("data send after logout\r\n");
					   status_evse=15;




					}


			}
			ESP_ERROR_CHECK(esp_task_wdt_reset());
		    vTaskDelay(pdMS_TO_TICKS(1 * 500));
		}
		vTaskDelete(NULL);
}
/** Event handler for Ethernet events */

void app_main(void)
{
	//start_webserver();
	char buff[50];
        	ESP_ERROR_CHECK( nvs_flash_init());
		    ESP_ERROR_CHECK(esp_netif_init());
		    ESP_ERROR_CHECK(esp_event_loop_create_default());
		    esp_log_level_set("*", ESP_LOG_DEBUG);
		    /* This helper function configures Wi-Fi or Ethernet, as selected in menuconfig.
		     * Read "Establishing Wi-Fi or Ethernet Connection" section in
		     * examples/protocols/README.md for more information about this function.
		     */

		   // ESP_ERROR_CHECK(example_connect());
		   // vTaskDelay(9000 / portTICK_PERIOD_MS);
		   // xTaskCreate(&websocket_app_start, "https_get_task", 8192, NULL, 5, NULL);
/*******************************************************************************************************************************************/
		    	esp_task_wdt_init(60, false);
		    	esp_task_wdt_add(xTaskGetIdleTaskHandleForCPU(0));
		    	esp_task_wdt_add(xTaskGetIdleTaskHandleForCPU(1));
		    	init();
		       	xTaskCreate(uart_event_task, "uart_event_task",4096, NULL, 5, NULL);

		       	sprintf(buff,"start*boot\r\n");
		       	uart_write_bytes(EX_UART_NUM, (const char*) buff,strlen(buff));
		       	ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));

		         xTaskCreate(&Network_interface,"https_get_task", 4096, NULL, 7, &xTask2);
		       	 xTaskCreate(&websocket_app_start,"https_get_task", 24576, NULL, 7, &xTask1);  //24576

		      	while(1)
		       	{
#if DEBUG
		      		printf("request .... \r\n");
#endif
		      		if(status_evse == 0)
		      		{
		      			//request connection
		      			//sprintf(buff,"request*network\r\n");
		      			memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
		      		   // memset((unsigned char*)buff,0x00,sizeof(buff));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte      //0
						ESPtxBuffer[ESPtxBufferIndex++]=0x82; //Request Network //1
						ESPtxBuffer[ESPtxBufferIndex++]=0x01; //command frame   //2

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high  //3
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low   //4
						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //status frame //5
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;                //6
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte      //7

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//              //8
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line      //9

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						printf("request network\r\n");
		      		}
		      		else if(status_evse == 1)
		      		{
		      			//REQUEST OCPP URI
//		      			sprintf(buff,"request*ocpp_uri\r\n");
		      			memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
		      		   // memset((unsigned char*)buff,0x00,sizeof(buff));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x83; // Intrernet connect
						ESPtxBuffer[ESPtxBufferIndex++]=0x01; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x01; //Internet Connect
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line
						printf("Internet connected\r\n Version:1.2.2 \r\n");
						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
		      			//status_evse = -1;
		      		}
		      		else if(status_evse == 2)
		      		{
		      			//REQUEST ENABLE
//		      			sprintf(buff,"request*ocpp_status\r\n");

		      			memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
		      		   // memset((unsigned char*)buff,0x00,sizeof(buff));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x84; // OCPP Status
						ESPtxBuffer[ESPtxBufferIndex++]=0x01; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x01; //Internet Connect
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex );
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
		      			status_evse = -1;
		      		}
		      		else if(status_evse == 3)
		      		{
//		      			sprintf(buff,"response*websocket*connected\r\n");
		      			memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
		      		   // memset((unsigned char*)buff,0x00,sizeof(buff));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x85; // websocket
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x01; // connected
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						printf("websocket connected\r\n");
						status_evse = -1;
		      		}
		      		else if(status_evse == 4)
					{
//						sprintf(buff,"response*websocket*error\r\n");
		      			memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x85; // websocket
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x00; // error
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						status_evse = -1;
					}
		      		else if(status_evse == 5)
					{
						//sprintf(buff,"response*internet*error\r\n");

						memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x83; // Intrernet connect
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //Internet Error
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));

						status_evse = -1;
					}
		      		else if(status_evse == 6)
					{
						//sprintf(buff,"response*wifi*error\r\n");
						memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=1; // wifi Error
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //wifi Error
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03; //end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r'; //
						ESPtxBuffer[ESPtxBufferIndex++]='\n'; //end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));

						status_evse = -1;
					}
		      		else if(status_evse == 7)
					{
						// sprintf(buff,"response*ethernet*downlink\r\n");

						memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x87; // Ethernet
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x00; // error
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						status_evse = -1;
					}
		      		else if(status_evse == 8)
					{
						//sprintf(buff,"response*ethernet*start\r\n");
						memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x87; // Ethernet
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x01; // start
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));

						status_evse = -1;
					}
		      		else if(status_evse == 9)
					{
					//	sprintf(buff,"response*ethernet*notfound\r\n");

						memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));

						ESPtxBufferIndex=0;
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						ESPtxBuffer[ESPtxBufferIndex++]=0x87; // Ethernet
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame

						ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						ESPtxBuffer[ESPtxBufferIndex++]=0x02; // notfound
						ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte

						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						status_evse = -1;
					}
		      		else if(status_evse == 10)
		      		{

		      		}
                  /* new series */
		      		else if(status_evse == 11)
		      		{
		      		   memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
                       ESPtxBufferIndex=0;
		      		   ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
		      		   ESPtxBuffer[ESPtxBufferIndex++]=0x71; // parameter send
		      		   ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame
		      		   ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
					   ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
					   ESPtxBuffer[ESPtxBufferIndex++]=0x01; //parameter Ready to send(esp->stm)	//esp in config mode
					   ESPtxBuffer[ESPtxBufferIndex++]=0x00;
					   ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte
					   ESPtxBuffer[ESPtxBufferIndex++]='\r';//
					   ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line
					   uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
					   ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
					   status_evse = -1;

                       }
		      		else if(status_evse == 12)			// implementaion pending
		      		{
		      	         memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
		      		     ESPtxBufferIndex=0;
		      		     ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
		      		     ESPtxBuffer[ESPtxBufferIndex++]=0x71; // parameter send
		      			 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame
		      			 ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
		                 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
		      		     ESPtxBuffer[ESPtxBufferIndex++]=0x02; //parameter not Ready to send error(esp->stm) ////esp in config mode failed
		      			 ESPtxBuffer[ESPtxBufferIndex++]=0x00;
		      			 ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte
		      			 ESPtxBuffer[ESPtxBufferIndex++]='\r';//
		      			 ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line
		      			 uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
		      	         ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
		      			status_evse = -1;

		      		}
		      		else if(status_evse == 13)			//  ack of sturct rec ok
					{
						 memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
						 ESPtxBufferIndex=0;
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						 ESPtxBuffer[ESPtxBufferIndex++]=0x73; // parameter send
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame
						 ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						 ESPtxBuffer[ESPtxBufferIndex++]=0x01; // data stucture from stm rx okay
						 ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						 ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte
						 ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						 ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line
						 uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						 ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						status_evse = -1;

					}
		    		else if(status_evse == 14)			// ack of sturct rec failed
					{
						 memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
						 ESPtxBufferIndex=0;
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						 ESPtxBuffer[ESPtxBufferIndex++]=0x73; // parameter send
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame
						 ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //length Low
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; // data stucture from stm rx failed
						 ESPtxBuffer[ESPtxBufferIndex++]=0x00;
						 ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte
						 ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						 ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line
						 uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						 ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						status_evse = -1;

					}
		    		else if(status_evse == 15)			// esp stuct data sent to stm
					{
		    			// printf("size of stucture is :%d r\n",Length);

						 memset((unsigned char*)ESPtxBuffer,0x00,sizeof(ESPtxBuffer));
						 ESPtxBufferIndex=0;
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //start byte
						 ESPtxBuffer[ESPtxBufferIndex++]=0x74; // parameter send
						 ESPtxBuffer[ESPtxBufferIndex++]=0x02; //command frame
						 ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length high
						 ESPtxBuffer[ESPtxBufferIndex++]=0x00; //length Low
//						 ipselection
//						 printf("RFID3:%s \r\n", part1.rfid3);
//						   printf("ETHERNET_IP:%s \r\n", part1.ether_ip);
//						   printf("GETWAY:%s \r\n", part1.ether_getway);
						   printf("enable:%s \r\n", part1.ethernet_enable_sts);
						 /*formdata is which is already working for data32_value structure based */
						 memcpy(&ESPtxBuffer[ESPtxBufferIndex],&part1,sizeof(part1));
						 //memcpy(&ESPtxBuffer[ESPtxBufferIndex],&form_data,sizeof(form_data)); //copy struct data to buffer
					//	 memcpy(&ESPtxBuffer[ESPtxBufferIndex],&form_data_copy,sizeof(FormData));
						 ESPtxBufferIndex+=sizeof(part1);
					//	ESPtxBufferIndex+=sizeof(form_data);
					//	ESPtxBufferIndex+=sizeof(form_data_copy);
						ESPtxBuffer[ESPtxBufferIndex++]=0x03;//end byte //8
						ESPtxBuffer[3]=((ESPtxBufferIndex-6)/256);  //3
						ESPtxBuffer[4]= (ESPtxBufferIndex-6) % 256;   //4
						ESPtxBuffer[ESPtxBufferIndex++]='\r';//
						ESPtxBuffer[ESPtxBufferIndex++]='\n';//end line

						 uart_write_bytes(EX_UART_NUM, (const char*) ESPtxBuffer,ESPtxBufferIndex);
						 ESP_ERROR_CHECK(uart_wait_tx_done(EX_UART_NUM, 100));
						 status_evse = -1;
					}
		    		else if(status_evse == 16)
		    		{
		    			 //esp_restart();
		    			 status_evse = -1;
		    		}

		      		else
		      		{
#if DEBUG
		      			printf("wait for....\r\n");
#endif
		      		}

		      		vTaskDelay(pdMS_TO_TICKS(5000));
		       	}
}

void ocpp_connect(void)
{

#if DEBUG
	printf("uri- %s\r\n",uri);
#endif

	//strcpy(websocket_cfg.uri,uri);
	websocket_cfg.uri = &uri;
	//memset(websocket_cfg.uri,uri,100);
#if DEBUG
	printf("websocket_uri: %s\r\n",websocket_cfg.uri);
#endif

	websocket_cfg.keep_alive_enable=true;
	websocket_cfg.keep_alive_idle = 120;
	websocket_cfg.subprotocol = "ocpp1.6";

	// websocket_cfg.task_prio = 5;
	websocket_cfg.task_stack = 6 * 1024;

	client = esp_websocket_client_init(&websocket_cfg);
	esp_websocket_register_events(client, WEBSOCKET_EVENT_ANY, websocket_event_handler, (void *)client);
	esp_websocket_client_start(client);

}
void strcpy_usr(char *dest,char *src,int size)
{
	while(size)
	{
		*dest = *src;
		dest++;
		src++;
		size--;
	}
}
void strcat_usr(char *dest,char *src,int size,int mltply)
{
//	for(int i =0;i<mltply;i++)
//	{
//		dest++;
//	}
	while(size)
	{
		*dest = *src;
		dest++;
		src++;
		size--;
	}
}

esp_err_t Get_Mac_address(char *macUpperCase)
{
	unsigned char mac_base[6]={0};
	esp_err_t ret;
	ret = esp_efuse_mac_get_default(mac_base);
	if (ret != ESP_OK)
	{
		return ret;	
	}
	

}
