/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define temp1_Pin GPIO_PIN_0  // PENAL TEMP
#define temp1_GPIO_Port GPIOC
#define temp2_Pin GPIO_PIN_1 // GUN1 +
#define temp2_GPIO_Port GPIOC
#define temp3_Pin GPIO_PIN_2 // GUN1 -
#define temp3_GPIO_Port GPIOC
#define temp4_Pin GPIO_PIN_3  // GUN2 +
#define temp4_GPIO_Port GPIOC
#define temp5_Pin GPIO_PIN_4 // GUN2 -
#define temp5_GPIO_Port GPIOC

#define fan1_Pin GPIO_PIN_1  // FAN 1
#define fan1_GPIO_Port GPIOA
#define fan2_Pin GPIO_PIN_2  // FAN 2
#define fan2_GPIO_Port GPIOA

/**
 * LED STRIP RB CHANGE
 */
#define blue1_Pin GPIO_PIN_6
#define blue1_GPIO_Port GPIOA

#define green1_Pin GPIO_PIN_7
#define green1_GPIO_Port GPIOA

#define red1_Pin GPIO_PIN_0
#define red1_GPIO_Port GPIOB

#define blue2_Pin GPIO_PIN_7
#define blue2_GPIO_Port GPIOB

#define green2_Pin GPIO_PIN_8
#define green2_GPIO_Port GPIOB

#define red2_Pin GPIO_PIN_9
#define red2_GPIO_Port GPIOB


#define heartbeat_Pin GPIO_PIN_15
#define heartbeat_GPIO_Port GPIOE

//USER_OUT pins
#define USER_OUT7_Pin GPIO_PIN_10
#define USER_OUT7_GPIO_Port GPIOB

#define test_Pin GPIO_PIN_11
#define test_GPIO_Port GPIOB

#define USER_OUT1_Pin GPIO_PIN_14
#define USER_OUT1_GPIO_Port GPIOB

#define USER_OUT2_Pin GPIO_PIN_15
#define USER_OUT2_GPIO_Port GPIOB

#define USER_OUT3_Pin GPIO_PIN_8
#define USER_OUT3_GPIO_Port GPIOD

#define USER_OUT4_Pin GPIO_PIN_9
#define USER_OUT4_GPIO_Port GPIOD

#define USER_OUT5_Pin GPIO_PIN_10
#define USER_OUT5_GPIO_Port GPIOD

#define USER_OUT6_Pin GPIO_PIN_11
#define USER_OUT6_GPIO_Port GPIOD

#define uart_rx_Pin GPIO_PIN_9
#define uart_rx_GPIO_Port GPIOA

#define uart_tx_Pin GPIO_PIN_10
#define uart_tx_GPIO_Port GPIOA

//USER_IN pins
#define USER_IN1_Pin GPIO_PIN_15		//RCD1
#define USER_IN1_GPIO_Port GPIOA

#define USER_IN2_Pin GPIO_PIN_10		//Door lock
#define USER_IN2_GPIO_Port GPIOC

#define USER_IN3_Pin GPIO_PIN_11		//Emergency switch
#define USER_IN3_GPIO_Port GPIOC

#define USER_IN4_Pin GPIO_PIN_12		//Reset key
#define USER_IN4_GPIO_Port GPIOC

#define USER_IN5_Pin GPIO_PIN_0			//AC main contactor
#define USER_IN5_GPIO_Port GPIOD

#define USER_IN6_Pin GPIO_PIN_1			//RCD2
#define USER_IN6_GPIO_Port GPIOD

#define USER_IN7_Pin GPIO_PIN_2			//SPD
#define USER_IN7_GPIO_Port GPIOD

#define USER_IN8_Pin GPIO_PIN_3			//Load sharing +
#define USER_IN8_GPIO_Port GPIOD

#define USER_IN9_Pin GPIO_PIN_4			//Load sharing -
#define USER_IN9_GPIO_Port GPIOD


/* USER CODE BEGIN Private defines */

///////////////////////-----------------OUTPINS-------------------///////////////////////
#define USER_OUT1_OFF	HAL_GPIO_WritePin(USER_OUT1_GPIO_Port, USER_OUT1_Pin, GPIO_PIN_SET);
#define USER_OUT1_ON 	HAL_GPIO_WritePin(USER_OUT1_GPIO_Port, USER_OUT1_Pin, GPIO_PIN_RESET);

#define USER_OUT2_OFF	HAL_GPIO_WritePin(USER_OUT2_GPIO_Port, USER_OUT2_Pin, GPIO_PIN_SET);
#define USER_OUT2_ON 	HAL_GPIO_WritePin(USER_OUT2_GPIO_Port, USER_OUT2_Pin, GPIO_PIN_RESET);

#define USER_OUT3_OFF 	HAL_GPIO_WritePin(USER_OUT3_GPIO_Port, USER_OUT3_Pin, GPIO_PIN_SET);
#define USER_OUT3_ON 	HAL_GPIO_WritePin(USER_OUT3_GPIO_Port, USER_OUT3_Pin, GPIO_PIN_RESET);

#define USER_OUT4_OFF 	HAL_GPIO_WritePin(USER_OUT4_GPIO_Port, USER_OUT4_Pin, GPIO_PIN_SET);
#define USER_OUT4_ON 	HAL_GPIO_WritePin(USER_OUT4_GPIO_Port, USER_OUT4_Pin, GPIO_PIN_RESET);

#define USER_OUT5_OFF 	HAL_GPIO_WritePin(USER_OUT5_GPIO_Port, USER_OUT5_Pin, GPIO_PIN_SET);
#define USER_OUT5_ON 	HAL_GPIO_WritePin(USER_OUT5_GPIO_Port, USER_OUT5_Pin, GPIO_PIN_RESET);

#define USER_OUT6_OFF 	HAL_GPIO_WritePin(USER_OUT6_GPIO_Port, USER_OUT6_Pin, GPIO_PIN_SET);
#define USER_OUT6_ON	HAL_GPIO_WritePin(USER_OUT6_GPIO_Port, USER_OUT6_Pin, GPIO_PIN_RESET);

#define USER_OUT7_OFF 	HAL_GPIO_WritePin(USER_OUT7_GPIO_Port, USER_OUT7_Pin, GPIO_PIN_SET);
#define USER_OUT7_ON 	HAL_GPIO_WritePin(USER_OUT7_GPIO_Port, USER_OUT7_Pin, GPIO_PIN_RESET);

#define DC_MAIN_GUN_1_ON { USER_OUT7_ON; USER_OUT1_ON;}		//OKAY
#define DC_MAIN_GUN_1_OFF { USER_OUT7_OFF; USER_OUT1_OFF;}	//OKAY

#define DC_MAIN_GUN_2_ON { USER_OUT2_ON; USER_OUT3_ON;}		//OKAY
#define DC_MAIN_GUN_2_OFF { USER_OUT2_OFF; USER_OUT3_OFF;}	//OKAY

#define AC_MAIN_ON USER_OUT4_ON;
#define AC_MAIN_OFF USER_OUT4_OFF;

#define LOAD_SHARING_ON { USER_OUT5_ON; USER_OUT6_ON;}
#define LOAD_SHARING_OFF { USER_OUT5_OFF; USER_OUT6_OFF;}

//TODO Testing
//changes made for load sharing and AC main output
//#define AC_MAIN_ON USER_OUT6_ON;
//#define AC_MAIN_OFF USER_OUT6_OFF;
//
//#define LOAD_SHARING_ON { USER_OUT5_ON; USER_OUT4_ON;}
//#define LOAD_SHARING_OFF { USER_OUT5_OFF; USER_OUT4_OFF;}

#define TEST_OFF HAL_GPIO_WritePin(test_GPIO_Port, test_Pin, GPIO_PIN_SET);
#define TEST_ON HAL_GPIO_WritePin(test_GPIO_Port, test_Pin, GPIO_PIN_RESET);
#define TEST_TOGGLE HAL_GPIO_TogglePin(test_GPIO_Port, test_Pin);

#define R_LED_OFF HAL_GPIO_WritePin(red1_GPIO_Port, red1_Pin, GPIO_PIN_SET);
#define R_LED_ON HAL_GPIO_WritePin(red1_GPIO_Port, red1_Pin, GPIO_PIN_RESET);

#define G_LED_OFF HAL_GPIO_WritePin(green1_GPIO_Port, green1_Pin, GPIO_PIN_SET);
#define G_LED_ON HAL_GPIO_WritePin(green1_GPIO_Port, green1_Pin, GPIO_PIN_RESET);
#define G_LED_TOGGLE HAL_GPIO_TogglePin(green1_GPIO_Port, green1_Pin);

#define B_LED_OFF HAL_GPIO_WritePin(blue1_GPIO_Port, blue1_Pin, GPIO_PIN_SET);
#define B_LED_ON HAL_GPIO_WritePin(blue1_GPIO_Port, blue1_Pin, GPIO_PIN_RESET);

#define fan1_OFF HAL_GPIO_WritePin(fan1_GPIO_Port, fan1_Pin, GPIO_PIN_SET);
#define fan1_ON HAL_GPIO_WritePin(fan1_GPIO_Port, fan1_Pin, GPIO_PIN_RESET);

#define fan2_OFF HAL_GPIO_WritePin(fan2_GPIO_Port, fan2_Pin, GPIO_PIN_SET);
#define fan2_ON HAL_GPIO_WritePin(fan2_GPIO_Port, fan2_Pin, GPIO_PIN_RESET);


#define ALL_RELAYOFF   {USER_OUT1_OFF; USER_OUT2_OFF; USER_OUT3_OFF; USER_OUT4_OFF; USER_OUT5_OFF; USER_OUT6_OFF; USER_OUT7_OFF}

////////////////////////-------------INPUT----------------------///////////////////////////////
#define USER_IN1_READ HAL_GPIO_ReadPin(USER_IN1_GPIO_Port, USER_IN1_Pin)

#define USER_IN2_READ HAL_GPIO_ReadPin(USER_IN2_GPIO_Port, USER_IN2_Pin)

#define USER_IN3_READ HAL_GPIO_ReadPin(USER_IN3_GPIO_Port, USER_IN3_Pin)

#define USER_IN4_READ HAL_GPIO_ReadPin(USER_IN4_GPIO_Port, USER_IN4_Pin)

#define USER_IN5_READ HAL_GPIO_ReadPin(USER_IN5_GPIO_Port, USER_IN5_Pin)

#define USER_IN6_READ HAL_GPIO_ReadPin(USER_IN6_GPIO_Port, USER_IN6_Pin)

#define USER_IN7_READ HAL_GPIO_ReadPin(USER_IN7_GPIO_Port, USER_IN7_Pin)

#define USER_IN8_READ HAL_GPIO_ReadPin(USER_IN8_GPIO_Port, USER_IN8_Pin)

#define USER_IN9_READ HAL_GPIO_ReadPin(USER_IN9_GPIO_Port, USER_IN9_Pin)


//#define USER_IN10_READ HAL_GPIO_ReadPin(USER_IN10_GPIO_Port,USER_IN10_Pin)


////////////////-------------------------------------------------///////////////////////////
//#define STATE_A_LEVEL   3550// 3680 //3650  // 3594  // 3530
//#define STATE_B_LEVEL   3100// 3189 //3230  // 3108  //
//#define STATE_C_LEVEL    2650//2722 //3220  // 2986  // 2667
//#define STATE_D_LEVEL    2260 //3120  // 2864  // 2248
//
//#define STATE_A   0
//#define STATE_B   1
//#define STATE_C   2
//#define STATE_D   3





/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
