/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    stm32f4xx_it.c
  * @brief   Interrupt Service Routines.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32f4xx_it.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "can_comm.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
extern char pwm_start_stop;



//Input read

volatile uint8_t Emergency_stop_count=0,Emergency_start_count=0;
volatile uint8_t doorlock1_stop_count=0,doorlock1_start_count=0;
volatile uint8_t doorlock2_stop_count=0,doorlock2_start_count=0;
volatile uint8_t resetkey_stop_count=0,resetkey_start_count=0;
volatile uint8_t smokedect_stop_count=0,smokedect_start_count=0;


volatile uint8_t Emergency_stop=0;
volatile uint8_t doorlock1_stop=0,doorlock2_stop=0,resetkey_stop=0,smokedect_stop=0;


volatile uint8_t SWstatus=0;


//output read(contactor sts )

volatile uint8_t ACMain_stop_count=0,ACMain_start_count=0;
volatile uint8_t DCMain_stop_count=0,DCMain_start_count=0;
volatile uint8_t PRECharge_stop_count=0,PRECharge_start_count=0;
volatile uint8_t AC02_stop_count=0,AC02_start_count=0;


volatile uint8_t ACMAIN_stop=0,DCMAIN_stop=0;
volatile uint8_t PRECharge_stop=0,AC02_stop=0;

volatile uint8_t starttimeouttick=0,timeoutflag=0;
extern struct chargersts chrgsts;
extern volatile uint8_t redsts,bluests,greensts,change;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
extern void adc_check();
/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/
extern DMA_HandleTypeDef hdma_adc1;
extern DMA_HandleTypeDef hdma_adc2;
extern ADC_HandleTypeDef hadc1;
extern ADC_HandleTypeDef hadc2;
extern CAN_HandleTypeDef hcan1;
extern CAN_HandleTypeDef hcan2;
extern TIM_HandleTypeDef htim1;
extern TIM_HandleTypeDef htim2;
extern TIM_HandleTypeDef htim3;
extern TIM_HandleTypeDef htim4;
extern TIM_HandleTypeDef htim5;
extern DMA_HandleTypeDef hdma_usart1_rx;
extern DMA_HandleTypeDef hdma_usart1_tx;
extern UART_HandleTypeDef huart1;
/* USER CODE BEGIN EV */

/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M4 Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
  * @brief This function handles Non maskable interrupt.
  */
void NMI_Handler(void)
{
  /* USER CODE BEGIN NonMaskableInt_IRQn 0 */

  /* USER CODE END NonMaskableInt_IRQn 0 */
  /* USER CODE BEGIN NonMaskableInt_IRQn 1 */
  while (1)
  {
  }
  /* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
  /* USER CODE BEGIN HardFault_IRQn 0 */

  /* USER CODE END HardFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_HardFault_IRQn 0 */
    /* USER CODE END W1_HardFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Memory management fault.
  */
void MemManage_Handler(void)
{
  /* USER CODE BEGIN MemoryManagement_IRQn 0 */

  /* USER CODE END MemoryManagement_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_MemoryManagement_IRQn 0 */
    /* USER CODE END W1_MemoryManagement_IRQn 0 */
  }
}

/**
  * @brief This function handles Pre-fetch fault, memory access fault.
  */
void BusFault_Handler(void)
{
  /* USER CODE BEGIN BusFault_IRQn 0 */

  /* USER CODE END BusFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_BusFault_IRQn 0 */
    /* USER CODE END W1_BusFault_IRQn 0 */
  }
}

/**
  * @brief This function handles Undefined instruction or illegal state.
  */
void UsageFault_Handler(void)
{
  /* USER CODE BEGIN UsageFault_IRQn 0 */

  /* USER CODE END UsageFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_UsageFault_IRQn 0 */
    /* USER CODE END W1_UsageFault_IRQn 0 */
  }
}

/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{
  /* USER CODE BEGIN SVCall_IRQn 0 */

  /* USER CODE END SVCall_IRQn 0 */
  /* USER CODE BEGIN SVCall_IRQn 1 */

  /* USER CODE END SVCall_IRQn 1 */
}

/**
  * @brief This function handles Debug monitor.
  */
void DebugMon_Handler(void)
{
  /* USER CODE BEGIN DebugMonitor_IRQn 0 */

  /* USER CODE END DebugMonitor_IRQn 0 */
  /* USER CODE BEGIN DebugMonitor_IRQn 1 */

  /* USER CODE END DebugMonitor_IRQn 1 */
}

/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{
  /* USER CODE BEGIN PendSV_IRQn 0 */

  /* USER CODE END PendSV_IRQn 0 */
  /* USER CODE BEGIN PendSV_IRQn 1 */

  /* USER CODE END PendSV_IRQn 1 */
}

/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
  /* USER CODE BEGIN SysTick_IRQn 0 */
//	if(pwm_start_stop==0)
//		{
//			adc_check();
//		}
#if target == gun1
	if(!USER_IN3_READ)
	{
		Emergency_stop_count++;
		if(Emergency_stop_count>=50)
		{
			Emergency_stop = 1;
			chrgsts.empress =1;
			SWstatus |= 0x01;
//			redledon;
//			blueledoff;
//			greenledoff;
//			USER_OUT7_ON;

//			USER_OUT8_OFF;
//			USER_OUT6_OFF;
			G_LED_OFF;	//GREEN
			timeoutflag=0;
			starttimeouttick=60;
			USER_OUT4_OFF;		//AC main supply off

//			can2TX_msg[can2TX_SWstatus]= SWstatus;
			Emergency_stop_count = 0;
		}
	}
	else
	{
		if(++Emergency_start_count > 50)
		{
			if(Emergency_stop ==1)
			{
//			blueledon;
//			USER_OUT6_ON; //BLUE ON
			chrgsts.empress =0;
			if(timeoutflag != 1)
			{


				timeoutflag=1;
			}
			}
//			redledoff;
			//USER_OUT7_OFF; // RED OFF
			SWstatus &= 0xFE;
//			can2TX_msg[can2TX_SWstatus]= SWstatus;
			Emergency_start_count =0;
			Emergency_stop_count=0;
			Emergency_stop=0;
		}
	}

	if(USER_IN2_READ)
	{
		doorlock1_stop_count++;
		if(doorlock1_stop_count>=50)
		{
			doorlock1_stop = 1;
			chrgsts.doorlock =1;
			SWstatus |= 0x02;
			doorlock1_stop_count = 0;
		}
	}
	else
	{
		if(++doorlock1_start_count > 50)
		{
			SWstatus &= 0xFD;
			chrgsts.doorlock =0;
			doorlock1_start_count =0;
			doorlock1_stop_count=0;
			doorlock1_stop=0;
		}
	}
//	if(!USER_IN2_READ)
//	{
//		doorlock2_stop_count++;
//		if(doorlock2_stop_count>=50)
//		{
//			doorlock2_stop = 1;
//			SWstatus |= 0x04;
//
//			doorlock2_stop_count = 0;
//		}
//	}
//	else
//	{
//		if(++doorlock2_start_count > 50)
//		{
//			SWstatus &= 0xFB;
//
//			doorlock2_start_count =0;
//			doorlock2_stop_count=0;
//			doorlock2_stop=0;
//		}
//	}
	if(!USER_IN4_READ)
	{
		resetkey_stop_count++;
		if(resetkey_stop_count>=50)
		{
			resetkey_stop = 1;
			chrgsts.resetactive =1;
			SWstatus |= 0x08;
//			can2TX_msg[can2TX_SWstatus]= SWstatus;
			resetkey_stop_count = 0;
		}
	}
	else
	{
		if(++resetkey_start_count > 50)
		{
			SWstatus &= 0xF7;
			chrgsts.resetactive =1;
//			can2TX_msg[can2TX_SWstatus]= SWstatus;
			resetkey_start_count =0;
			resetkey_stop_count=0;
			resetkey_stop=0;
		}
	}
//	if(!USER_IN5_READ)
//	{
//		smokedect_stop_count++;
//		if(smokedect_stop_count>=50)
//		{
//			smokedect_stop = 1;
//			SWstatus |= 0x10;
////			can2TX_msg[can2TX_SWstatus]= SWstatus;
//			smokedect_stop_count = 0;
//		}
//	}
//	else
//	{
//		if(++smokedect_start_count > 50)
//		{
//			smokedect_start_count =0;
//			SWstatus &= 0xEF;
////			can2TX_msg[can2TX_SWstatus]= SWstatus;
//			smokedect_stop_count=0;
//			smokedect_stop=0;
//		}
//	}

	/////////contactor switching///////////////
	if(USER_IN5_READ)
		{
		ACMain_stop_count++;
			if(ACMain_stop_count>=50)
			{
				ACMAIN_stop = 1;
				SWstatus |= 0x10;

				ACMain_stop_count = 0;
			}
		}
		else
		{
			if(++ACMain_start_count > 50)
			{
				ACMain_start_count =0;
				SWstatus &= 0xEF;

				ACMain_stop_count=0;
				ACMAIN_stop=0;
			}
		}
//	if(!USER_IN5_READ)
//		{
//		DCMain_stop_count++;
//			if(DCMain_stop_count>=50)
//			{
//				DCMAIN_stop = 1;
//				relaysts_ac02sts |= 0x20;
//	//			can2TX_msg[can2TX_SWstatus]= SWstatus;
//				DCMain_stop_count = 0;
//			}
//		}
//		else
//		{
//			if(++DCMain_start_count > 50)
//			{
//				DCMain_start_count =0;
//				relaysts_ac02sts &= 0xDF;
//	//			can2TX_msg[can2TX_SWstatus]= SWstatus;
//				DCMain_stop_count=0;
//				DCMAIN_stop=0;
//			}
//		}

	if(!USER_IN8_READ)			 	//SPD FEEDBACK
			{
			AC02_stop_count++;
				if(AC02_stop_count>=50)
				{
					AC02_stop = 1;
					SWstatus |= 0x80;
		//			can2TX_msg[can2TX_SWstatus]= SWstatus;
					AC02_stop_count = 0;
				}
			}
			else
			{
				if(++AC02_start_count > 50)
				{
					AC02_start_count =0;
					SWstatus &= 0x7F;
		//			can2TX_msg[can2TX_SWstatus]= SWstatus;
					AC02_stop_count=0;
					AC02_stop=0;
				}
			}
//
//	if(!USER_IN6_READ)							//dc MAIN NEGATIVE CONTACTOR
//			{
//			PRECharge_stop_count++;
//				if(PRECharge_stop_count>=50)
//				{
//					PRECharge_stop = 1;
//					relaysts_ac02sts |= 0x40;
//		//			can2TX_msg[can2TX_SWstatus]= SWstatus;
//					PRECharge_stop_count = 0;
//				}
//			}
//			else
//			{
//				if(++PRECharge_start_count > 50)
//				{
//					PRECharge_start_count =0;
//					relaysts_ac02sts &= 0xBF;
//		//			can2TX_msg[can2TX_SWstatus]= SWstatus;
//					PRECharge_stop_count=0;
//					PRECharge_stop=0;
//				}
//			}

		if(USER_IN6_READ)							//RCD  FEEDBACK
				{
				PRECharge_stop_count++;
					if(PRECharge_stop_count>=50)
					{
						PRECharge_stop = 1;
						SWstatus |= 0x40;
			//			can2TX_msg[can2TX_SWstatus]= SWstatus;
						PRECharge_stop_count = 0;
					}
				}
				else
				{
					if(++PRECharge_start_count > 50)
					{
						PRECharge_start_count =0;
						SWstatus &= 0xBF;
			//			can2TX_msg[can2TX_SWstatus]= SWstatus;
						PRECharge_stop_count=0;
						PRECharge_stop=0;
					}
				}
	//COMMENT LATER //ONLY FOR ARAI PANEL
//	SWstatus &= 0xBF;	//FOR ARAI PANEL
	SWstatus &= 0xDF;
#elif target == gun2

	SWstatus &= 0xFE;
	SWstatus &= 0xFD;
	SWstatus &= 0xF7;
	SWstatus &= 0xEF;
	SWstatus &= 0x7F;
	chrgsts.doorlock =0;
	chrgsts.resetactive =0;
	chrgsts.empress =0;
	if(!USER_IN2_READ)	// load sharing contactor + feedback
		{
			doorlock2_stop_count++;
			if(doorlock2_stop_count>=50)
			{
				doorlock2_stop = 1;
				SWstatus |= 0x04;
				doorlock2_stop_count = 0;
			}
		}
		else
		{
			if(++doorlock2_start_count > 50)
			{
				SWstatus &= 0xFB;
				doorlock2_start_count =0;
				doorlock2_stop_count=0;

			}
		}
		if(!USER_IN6_READ)							// load sharing contactor - feedback
		{
		PRECharge_stop_count++;
			if(PRECharge_stop_count>=50)
			{
				PRECharge_stop = 1;
				SWstatus |= 0x40;
				PRECharge_stop_count = 0;
			}
		}
		else
		{
			if(++PRECharge_start_count > 50)
			{
				PRECharge_start_count =0;
				SWstatus &= 0xBF;
				PRECharge_stop_count=0;
			}
		}
#endif


	///////////////////////////
//if(exfault == 1 || doorlock1_stop == 1 || Emergency_stop ==1 )
//{
//	USER_OUT7_ON;
//}
//else
//{
//	USER_OUT7_OFF;
//}

	if(chrgsts.empress == 1 || chrgsts.doorlock == 1 || chrgsts.exfault == 1)
	{
		if(redsts ==0)
			{
			redsts=1;
			change=1;
			}
			bluests=0;
			greensts=0;
//		B_LED_OFF;	//BLUE
//		R_LED_ON;	//RED
//		G_LED_OFF;	//GREEN

	}
	else if(chrgsts.charging == 1)
	{
		if(greensts==0)
		{
			greensts=1;
			change=1;
		}
		redsts=0;
		bluests=0;

//		B_LED_OFF;	//BLUE
//		R_LED_OFF;	//RED
//		G_LED_ON;	//GREEN
	}
	else
	{
		if(bluests==0)
		{
			bluests=1;
			change=1;
		}
		redsts=0;
		greensts=0;
//		B_LED_ON;	//BLUE
//		R_LED_OFF;	//RED
//		G_LED_OFF;	//GREEN
	}

	//////////////////////////////////////
	can2TX_msg[can2TX_SWstatus]= SWstatus;

  /* USER CODE END SysTick_IRQn 0 */
  HAL_IncTick();
  /* USER CODE BEGIN SysTick_IRQn 1 */

  /* USER CODE END SysTick_IRQn 1 */
}

/******************************************************************************/
/* STM32F4xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32f4xx.s).                    */
/******************************************************************************/

/**
  * @brief This function handles ADC1, ADC2 and ADC3 global interrupts.
  */
void ADC_IRQHandler(void)
{
  /* USER CODE BEGIN ADC_IRQn 0 */

  /* USER CODE END ADC_IRQn 0 */
  HAL_ADC_IRQHandler(&hadc1);
  HAL_ADC_IRQHandler(&hadc2);
  /* USER CODE BEGIN ADC_IRQn 1 */

  /* USER CODE END ADC_IRQn 1 */
}

/**
  * @brief This function handles CAN1 TX interrupts.
  */
void CAN1_TX_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_TX_IRQn 0 */

  /* USER CODE END CAN1_TX_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_TX_IRQn 1 */

  /* USER CODE END CAN1_TX_IRQn 1 */
}

/**
  * @brief This function handles CAN1 RX0 interrupts.
  */
void CAN1_RX0_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_RX0_IRQn 0 */

  /* USER CODE END CAN1_RX0_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_RX0_IRQn 1 */

  /* USER CODE END CAN1_RX0_IRQn 1 */
}

/**
  * @brief This function handles CAN1 RX1 interrupt.
  */
void CAN1_RX1_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_RX1_IRQn 0 */

  /* USER CODE END CAN1_RX1_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_RX1_IRQn 1 */

  /* USER CODE END CAN1_RX1_IRQn 1 */
}

/**
  * @brief This function handles CAN1 SCE interrupt.
  */
void CAN1_SCE_IRQHandler(void)
{
  /* USER CODE BEGIN CAN1_SCE_IRQn 0 */

  /* USER CODE END CAN1_SCE_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan1);
  /* USER CODE BEGIN CAN1_SCE_IRQn 1 */

  /* USER CODE END CAN1_SCE_IRQn 1 */
}

/**
  * @brief This function handles TIM1 update interrupt and TIM10 global interrupt.
  */
void TIM1_UP_TIM10_IRQHandler(void)
{
  /* USER CODE BEGIN TIM1_UP_TIM10_IRQn 0 */

  /* USER CODE END TIM1_UP_TIM10_IRQn 0 */
  HAL_TIM_IRQHandler(&htim1);
  /* USER CODE BEGIN TIM1_UP_TIM10_IRQn 1 *///
 // for(int i=0;i<300;i++);
//  if(pwm_start_stop==1)
//  	{
//  		adc_check();
//  	}
  /* USER CODE END TIM1_UP_TIM10_IRQn 1 */
}

/**
  * @brief This function handles TIM2 global interrupt.
  */
void TIM2_IRQHandler(void)
{
  /* USER CODE BEGIN TIM2_IRQn 0 */

  /* USER CODE END TIM2_IRQn 0 */
  HAL_TIM_IRQHandler(&htim2);
  /* USER CODE BEGIN TIM2_IRQn 1 */

  /* USER CODE END TIM2_IRQn 1 */
}

/**
  * @brief This function handles TIM3 global interrupt.
  */
void TIM3_IRQHandler(void)
{
  /* USER CODE BEGIN TIM3_IRQn 0 */

  /* USER CODE END TIM3_IRQn 0 */
  HAL_TIM_IRQHandler(&htim3);
  /* USER CODE BEGIN TIM3_IRQn 1 */

  /* USER CODE END TIM3_IRQn 1 */
}

/**
  * @brief This function handles TIM4 global interrupt.
  */
void TIM4_IRQHandler(void)
{
  /* USER CODE BEGIN TIM4_IRQn 0 */

  /* USER CODE END TIM4_IRQn 0 */
  HAL_TIM_IRQHandler(&htim4);
  /* USER CODE BEGIN TIM4_IRQn 1 */

  /* USER CODE END TIM4_IRQn 1 */
}

/**
  * @brief This function handles USART1 global interrupt.
  */
void USART1_IRQHandler(void)
{
  /* USER CODE BEGIN USART1_IRQn 0 */

  /* USER CODE END USART1_IRQn 0 */
  HAL_UART_IRQHandler(&huart1);
  /* USER CODE BEGIN USART1_IRQn 1 */

  /* USER CODE END USART1_IRQn 1 */
}

/**
  * @brief This function handles TIM5 global interrupt.
  */
void TIM5_IRQHandler(void)
{
  /* USER CODE BEGIN TIM5_IRQn 0 */

  /* USER CODE END TIM5_IRQn 0 */
  HAL_TIM_IRQHandler(&htim5);
  /* USER CODE BEGIN TIM5_IRQn 1 */

  /* USER CODE END TIM5_IRQn 1 */
}

/**
  * @brief This function handles DMA2 stream2 global interrupt.
  */
void DMA2_Stream2_IRQHandler(void)
{
  /* USER CODE BEGIN DMA2_Stream2_IRQn 0 */

  /* USER CODE END DMA2_Stream2_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_usart1_rx);
  /* USER CODE BEGIN DMA2_Stream2_IRQn 1 */

  /* USER CODE END DMA2_Stream2_IRQn 1 */
}

/**
  * @brief This function handles DMA2 stream3 global interrupt.
  */
void DMA2_Stream3_IRQHandler(void)
{
  /* USER CODE BEGIN DMA2_Stream3_IRQn 0 */

  /* USER CODE END DMA2_Stream3_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_adc2);
  /* USER CODE BEGIN DMA2_Stream3_IRQn 1 */

  /* USER CODE END DMA2_Stream3_IRQn 1 */
}

/**
  * @brief This function handles DMA2 stream4 global interrupt.
  */
void DMA2_Stream4_IRQHandler(void)
{
  /* USER CODE BEGIN DMA2_Stream4_IRQn 0 */

  /* USER CODE END DMA2_Stream4_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_adc1);
  /* USER CODE BEGIN DMA2_Stream4_IRQn 1 */

  /* USER CODE END DMA2_Stream4_IRQn 1 */
}

/**
  * @brief This function handles CAN2 TX interrupts.
  */
void CAN2_TX_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_TX_IRQn 0 */

  /* USER CODE END CAN2_TX_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_TX_IRQn 1 */

  /* USER CODE END CAN2_TX_IRQn 1 */
}

/**
  * @brief This function handles CAN2 RX0 interrupts.
  */
void CAN2_RX0_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_RX0_IRQn 0 */

  /* USER CODE END CAN2_RX0_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_RX0_IRQn 1 */

  /* USER CODE END CAN2_RX0_IRQn 1 */
}

/**
  * @brief This function handles CAN2 RX1 interrupt.
  */
void CAN2_RX1_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_RX1_IRQn 0 */

  /* USER CODE END CAN2_RX1_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_RX1_IRQn 1 */

  /* USER CODE END CAN2_RX1_IRQn 1 */
}

/**
  * @brief This function handles CAN2 SCE interrupt.
  */
void CAN2_SCE_IRQHandler(void)
{
  /* USER CODE BEGIN CAN2_SCE_IRQn 0 */

  /* USER CODE END CAN2_SCE_IRQn 0 */
  HAL_CAN_IRQHandler(&hcan2);
  /* USER CODE BEGIN CAN2_SCE_IRQn 1 */

  /* USER CODE END CAN2_SCE_IRQn 1 */
}

/**
  * @brief This function handles DMA2 stream7 global interrupt.
  */
void DMA2_Stream7_IRQHandler(void)
{
  /* USER CODE BEGIN DMA2_Stream7_IRQn 0 */

  /* USER CODE END DMA2_Stream7_IRQn 0 */
  HAL_DMA_IRQHandler(&hdma_usart1_tx);
  /* USER CODE BEGIN DMA2_Stream7_IRQn 1 */

  /* USER CODE END DMA2_Stream7_IRQn 1 */
}

/* USER CODE BEGIN 1 */

/* USER CODE END 1 */
