/*
 * can_comm.c
 *
 *  Created on: Jun 28, 2022
 *      Author: LUBI
 */
#include "can.h"
#include "can_comm.h"


union
{
	unsigned short int word;
	uint32_t dword;
	float dfloat;
	unsigned char byte[4];
}split_int;

CAN_RxHeaderTypeDef rx_header,rx_header2;

uint8_t rx_msg[20],error_isolation[10],error_status[10],can2_rx_msg[10];
uint8_t can2TX_msg[8],tx_can2flag=0;
volatile uint8_t relaysts_ac02sts =0;
uint16_t IMD_temperature=0;

uint8_t AC02_stop_flag=0,Authentication_done;
extern volatile uint8_t starttimeouttick,timeoutflag;
extern int fantimcntr;
extern uint8_t fantimflag;
uint8_t chargestart=0,fanstart=0;
volatile char exfault=0;

uint32_t HVposRes=0,HVnegRes=0;

/*
void maxwellTest(char id)
{
	CAN_TxHeaderTypeDef tx_header;
	uint8_t boot[]={0x03,0x00,0x00,0x30,0x00,0x00,0x00,0x00};
	uint8_t boot2[]={0x03,0x00,0X00,0x21,0x43,0x48,0x00,0x00};
	tx_header.DLC=8;
	tx_header.IDE = CAN_ID_EXT;
	tx_header.RTR = CAN_RTR_DATA;
	uint32_t mailbox;
	switch (id)
	{
	case 0:

//	tx_header.ExtId=0x06080780;
		tx_header.ExtId=0x0607FF80;

	if(HAL_CAN_AddTxMessage(&hcan2, &tx_header, boot, &mailbox) != HAL_OK)
	{
		Error_Handler();
	}
	break;
	case 1:

		//tx_header.ExtId=0x06080F80;

		tx_header.ExtId=0X060c1781; //82

		if(HAL_CAN_AddTxMessage(&hcan2, &tx_header, boot2, &mailbox) != HAL_OK)
		{
			Error_Handler();
		}
		break;

	case 2:


			//tx_header.ExtId=0x06081780;
			tx_header.ExtId=0X060c0781; //80




			if(HAL_CAN_AddTxMessage(&hcan2, &tx_header, boot2, &mailbox) != HAL_OK)
			{
				Error_Handler();
			}
			break;
	case 3:

			tx_header.ExtId=0x06081F80;



			if(HAL_CAN_AddTxMessage(&hcan2, &tx_header, boot, &mailbox) != HAL_OK)
			{
				Error_Handler();
			}
			break;
	case 4:


			tx_header.ExtId=0x06082780;




			if(HAL_CAN_AddTxMessage(&hcan2, &tx_header, boot, &mailbox) != HAL_OK)
			{
				Error_Handler();
			}
			break;
	case 5:

			tx_header.ExtId=0x06082F80;


			if(HAL_CAN_AddTxMessage(&hcan2, &tx_header, boot, &mailbox) != HAL_OK)
			{
				Error_Handler();
			}
			break;
	case 6:


			tx_header.ExtId=0x06083780;

			if(HAL_CAN_AddTxMessage(&hcan2, &tx_header, boot, &mailbox) != HAL_OK)
			{
				Error_Handler();
			}
			break;

	}
}

*/


struct chargersts chrgsts;
#if imd == syn
void can_tx_temperature(void)
{

	CAN_TxHeaderTypeDef tx_header;
	tx_header.DLC=1;
	tx_header.ExtId=0xA100101;
	tx_header.IDE = CAN_ID_EXT;
	tx_header.RTR = CAN_RTR_DATA;

	uint32_t mailbox;
	uint8_t message = 0x80;

	if(HAL_CAN_AddTxMessage(&hcan1, &tx_header, &message, &mailbox) != HAL_OK)
	{
		Error_Handler();
	}
//	while( HAL_CAN_IsTxMessagePending(&hcan1, mailbox));


//	while( HAL_CAN_IsTxMessagePending(&hcan1, mailbox));

//	HAL_UART_Transmit(&huart2, "TX OK", 5, 1000);
}

void can_tx_reset()
{
		CAN_TxHeaderTypeDef tx_header;
		tx_header.DLC=5;
		tx_header.ExtId=0xA100101;
		tx_header.IDE = CAN_ID_EXT;
		tx_header.RTR = CAN_RTR_DATA;

		uint32_t mailbox;
	uint8_t restart[]={0xc1,0x01,0x23,0x45,0x67};

		if(HAL_CAN_AddTxMessage(&hcan1, &tx_header, restart, &mailbox) != HAL_OK)
		{
			Error_Handler();
		}
//		while( HAL_CAN_IsTxMessagePending(&hcan1, mailbox));

//		while(!HAL_CAN_GetRxFifoFillLevel(&hcan1, CAN_RX_FIFO0));
//
//		if(HAL_CAN_GetRxMessage(&hcan1, CAN_RX_FIFO0, &rx_header, rx_msg) != HAL_OK)
//		{
//				Error_Handler();
//		}
}
void can_tx_vbmax()
{
	uint8_t vb_max[]={0xf0,0x02,0xf8};
	CAN_TxHeaderTypeDef tx_header;
	tx_header.DLC=3;
	tx_header.ExtId=0xA100101;
	tx_header.IDE = CAN_ID_EXT;
	tx_header.RTR = CAN_RTR_DATA;


	uint32_t mailbox;


		if(HAL_CAN_AddTxMessage(&hcan1, &tx_header, vb_max, &mailbox) != HAL_OK)
		{
			Error_Handler();
		}
		while( HAL_CAN_IsTxMessagePending(&hcan1, mailbox));

//		while(!HAL_CAN_GetRxFifoFillLevel(&hcan1, CAN_RX_FIFO0));
//
//			if(HAL_CAN_GetRxMessage(&hcan1, CAN_RX_FIFO0, &rx_header, rx_msg) != HAL_OK)
//			{
//					Error_Handler();
//			}
}
void can_tx_Isolation_State()
{
	CAN_TxHeaderTypeDef tx_header;
		tx_header.DLC=1;
		tx_header.ExtId=0xA100101;
		tx_header.IDE = CAN_ID_EXT;
		tx_header.RTR = CAN_RTR_DATA;

		uint8_t message = 0xE0;
		uint32_t mailbox;

		if(HAL_CAN_AddTxMessage(&hcan1, &tx_header, &message, &mailbox) != HAL_OK)
		{
			Error_Handler();
		}
//		while( HAL_CAN_IsTxMessagePending(&hcan1, mailbox));

//		while(!HAL_CAN_GetRxFifoFillLevel(&hcan1, CAN_RX_FIFO0));
//
//			if(HAL_CAN_GetRxMessage(&hcan1, CAN_RX_FIFO0, &rx_header, error_isolation) != HAL_OK)
//			{
//					Error_Handler();
//			}
}
void can_tx_Error_Flag()
{
	CAN_TxHeaderTypeDef tx_header;
	tx_header.DLC=1;
	tx_header.ExtId=0xA100101;
	tx_header.IDE = CAN_ID_EXT;
	tx_header.RTR = CAN_RTR_DATA;

	uint8_t message = 0xE5;

	uint32_t mailbox;

	if(HAL_CAN_AddTxMessage(&hcan1, &tx_header, &message, &mailbox) != HAL_OK)
	{
		Error_Handler();
	}
//	while( HAL_CAN_IsTxMessagePending(&hcan1, mailbox));

//	while(!HAL_CAN_GetRxFifoFillLevel(&hcan1, CAN_RX_FIFO0));
//
//		if(HAL_CAN_GetRxMessage(&hcan1, CAN_RX_FIFO0, &rx_header, error_status) != HAL_OK)
//		{
//				Error_Handler();
//		}
}
#endif
void can2_tx_frame(void)
{
	CAN_TxHeaderTypeDef tx_header1;
	tx_header1.DLC=8;
	tx_header1.ExtId=0xA100100;
	tx_header1.IDE = CAN_ID_EXT;
	tx_header1.RTR = CAN_RTR_DATA;
	uint32_t mailbox;

		if(HAL_CAN_AddTxMessage(&hcan2, &tx_header1, can2TX_msg, &mailbox) != HAL_OK)
		{
			Error_Handler();
		}
//		while( HAL_CAN_IsTxMessagePending(&hcan2, mailbox));

//		while(!HAL_CAN_GetRxFifoFillLevel(&hcan2, CAN_RX_FIFO1));
//
//		if(HAL_CAN_GetRxMessage(&hcan2, CAN_RX_FIFO1, &rx_header2, can2_rx_msg) != HAL_OK)
//		{
//		Error_Handler();
//		}
}
void can_filterconfig(void)
{
	CAN_FilterTypeDef canfilter;

	canfilter.FilterActivation = CAN_FILTER_ENABLE;
	canfilter.FilterBank = 0;
	canfilter.FilterFIFOAssignment = CAN_RX_FIFO0;
	canfilter.FilterIdHigh =0X0000;
	canfilter.FilterIdLow = 0X0000;
	canfilter.FilterMaskIdHigh = 0X0000;
	canfilter.FilterMaskIdLow = 0X0000;
	canfilter.FilterMode = CAN_FILTERMODE_IDMASK;
	canfilter.FilterScale = CAN_FILTERSCALE_32BIT;

	if( HAL_CAN_ConfigFilter(&hcan1, &canfilter) != HAL_OK)
	{
		Error_Handler();
	}

//	canfilter.FilterBank = 0;
//	canfilter.FilterFIFOAssignment = CAN_RX_FIFO1;
//	if( HAL_CAN_ConfigFilter(&hcan2, &canfilter) != HAL_OK)
//	{
//		Error_Handler();
//	}


}
void can2_filterconfig(void)
{
	CAN_FilterTypeDef canfilter2;
	uint32_t ExtId=0xA105695;
	canfilter2.FilterActivation = CAN_FILTER_ENABLE;
	canfilter2.FilterBank = 14;
	canfilter2.FilterFIFOAssignment = CAN_RX_FIFO0;
	canfilter2.FilterIdHigh =((ExtId << 3) >> 16) &0xffff;;
	canfilter2.FilterIdLow = (ExtId << 3) &0xffff| CAN_ID_EXT;;
	canfilter2.FilterMaskIdHigh = 0x1FFF;
	canfilter2.FilterMaskIdLow = 0XFFFF;
//	canfilter2.FilterMaskIdHigh = ((ExtId << 3) >> 16) &0xffff;
//	canfilter2.FilterMaskIdLow = (ExtId << 3) &0xffff| CAN_ID_EXT;
	canfilter2.FilterMode = CAN_FILTERMODE_IDMASK;
	canfilter2.FilterScale = CAN_FILTERSCALE_32BIT;

	if( HAL_CAN_ConfigFilter(&hcan2, &canfilter2) != HAL_OK)
	{
		Error_Handler();
	}
}

void HAL_CAN_RxFifo0MsgPendingCallback(CAN_HandleTypeDef *hcan)
{

	if(hcan->Instance==CAN1)
	{
		if(HAL_CAN_GetRxMessage(&hcan1, CAN_RX_FIFO0, &rx_header, rx_msg) != HAL_OK)
		{
		Error_Handler();
		}
#if imd == syn
		if(rx_msg[0] == 0xe5)
		{
			if(rx_msg[1] != 4)
			{
			can2TX_msg[can2TX_stsbits]=rx_msg[1];
			can2TX_msg[can2TX_errorFlag]=rx_msg[2];
			}
		}
		else if(rx_msg[0] == 0xe0)
		{
		can2TX_msg[can2TX_ele_isolationMSB]=rx_msg[2];
		can2TX_msg[can2TX_ele_isolationLSB]=rx_msg[3];
		}
		else if(rx_msg[0] == 0x80)
		{
			/*int NUM = (rx_msg[3] << 8) | (rx_msg[4]);
		can2TX_msg[can2TX_temperaturebyte1]=(uint8_t)NUM/1000;
		can2TX_msg[can2TX_temperaturebyte2]=0;*/
#if defined(imdtemp)
		can2TX_msg[can2TX_temperaturebyte1]=rx_msg[3];
		can2TX_msg[can2TX_temperaturebyte2]=rx_msg[4];
#endif
		}
#else			//qg imd
		if (rx_header.ExtId == 0x18ff5050)
		 {
			can2TX_msg[can2TX_stsbits]=rx_msg[0];
			HVposRes= HVnegRes  = 0;
			 HVposRes=((rx_msg[2] << 8) | rx_msg[3]);
			 HVnegRes=((rx_msg[4] << 8) | rx_msg[5]);
			 if(HVposRes >= HVnegRes)
			 {
				 can2TX_msg[can2TX_ele_isolationMSB]=rx_msg[4]; //send negative
				 can2TX_msg[can2TX_ele_isolationLSB]=rx_msg[5]; //send negative
			 }
			 else
			 {
				 can2TX_msg[can2TX_ele_isolationMSB]=rx_msg[2]; //send positive
				 can2TX_msg[can2TX_ele_isolationLSB]=rx_msg[3]; //send positive
			 }
				can2TX_msg[can2TX_errorFlag]= 0;

		 }
#endif
	}

	else if(hcan->Instance==CAN2)
	{
		if(HAL_CAN_GetRxMessage(&hcan2, CAN_RX_FIFO0, &rx_header2, can2_rx_msg) != HAL_OK)
		{
		Error_Handler();
		}
//		if(rx_header2.ExtId == 0xA100105 )
		{
			if(can2_rx_msg[0] == 0xAA)
			{
				Authentication_done = 1;
			}
			else if(can2_rx_msg[0] == 0xFF)
			{
				AC02_stop_flag = 1;
				Authentication_done = 0;
			}
			else if(can2_rx_msg[0] == 0x00)
			{
				AC02_stop_flag=0;
			}
			if(can2_rx_msg[1] == 1) // AC MAIN CONTACTOR
			{
				if((timeoutflag == 1 ) && 	(starttimeouttick == 00))
				{
				USER_OUT4_ON;
				timeoutflag=0;
				starttimeouttick=60;
				}
			}
			else
			{
//				USER_OUT5_OFF;
//				USER_OUT6_OFF;
			}

			if(can2_rx_msg[2] == 0xA5) // DC MAIN CONTACTOR
			{
				USER_OUT2_ON;
				USER_OUT3_ON;
//				USER_OUT8_ON;	//CHARGING LED
//				greenledon;
//				USER_OUT8_ON; 	//GREEN ON
//				USER_OUT7_OFF;	//RED OFF
//				USER_OUT6_OFF;	//BLUE OFF
				chrgsts.charging =1;
//				blueledoff;
//				redledoff;
				///fan on
//				USER_OUT9_ON;
//				fan1_ON;
//				fan2_ON;
//				B_LED_ON;
				chargestart=1;
//				fantimflag=0;
				if(fanstart == 0)
				{
					fanstart=1;
				}
//				fantimcntr=900;
			}
			else
			{
				USER_OUT2_OFF;
				USER_OUT3_OFF;
//				USER_OUT8_OFF;	 //GREEN OFF
//				blueledon;
//				greenledoff;
//				USER_OUT6_ON;	 //BLUE ON
//				USER_OUT8_OFF;   //RED OFF
				chrgsts.charging = 0;                          //CHANGE BY RONAK
				if(chargestart == 1)
				{
					chargestart = 0;
					fantimflag = 1;
				}
			}
			if(can2_rx_msg[3]  == 0xA5) // pre-charge CONTACTOR
			{
				USER_OUT1_ON;
			}
			else
			{
				USER_OUT1_OFF;
			}

			if(can2_rx_msg[4]  == 0xA5) // FAULT INNDICATOR //RESET SWITCH
			{
//				ALL_RELAYOFF;
//				USER_OUT7_ON;	//FAULT LED INDICATOR
//				exfault = 1;
//				redledon;
//				blueledoff;
//				greenledoff;
				chrgsts.exfault =1;
			}
			else
			{
//				USER_OUT7_OFF;
				chrgsts.exfault =0;
			}
#if target == gun2
			if(can2_rx_msg[5]  == 0xA5) // LOAD SHARING CONTACTOR 5&6
			{
				USER_OUT5_ON;	// LOAD SHARING CONTACTOR 5&6
				USER_OUT6_ON;	// LOAD SHARING CONTACTOR 5&6
			}
			else
			{
				USER_OUT5_OFF;
				USER_OUT6_OFF;
			}
#endif
			if(can2_rx_msg[6]  == 0xA5)
			{
				NVIC_SystemReset(); 	//hard reset the system
			}
			else
			{

			}
			tx_can2flag=1;
		}
	}

}
void HAL_CAN_ErrorCallback(CAN_HandleTypeDef *hcan)
{


}
