/*
 * cs5460a.h
 *
 *  Created on: May 21, 2025
 *      Author: electro.design5
 */

#ifndef INC_CS5460A_H_
#define INC_CS5460A_H_

#include "stm32g4xx_hal.h"
#include "main.h"

// Command definitions
#define CS5460A_RMS_VOLTAGE     0x18
#define CS5460A_RMS_CURRENT     0x16
#define CS5460A_TRUE_POWER      0x12		//0x14
#define CS5460A_STATUS          0x1E
#define CS5460A_MASK			0x34

#define CS5460A_Instantaneous_Voltage		0x10
#define CS5460A_Instantaneous_Current		0x1E

#define CS5460A_REG_CONFIG     	0x00

#define SYNC0					0xFE
#define SYNC1					0xFF

#define CS5460A_CFG_READ        0x00		// Config register read
#define CS5460A_CFG_READ_IGN    0x04		// Current gain register read
#define CS5460A_CFG_READ_VGN    0x08		// Voltage gain register read
#define CS5460A_CFG_READ_CYCLE  0x0A		// Cycle count register read

#define CS5460A_CFG_POWER_UP    0xA0		// Power-up/halt command

// Configuration values
#define CS5460A_CFG_GAIN0       0x00		//0x40  // PGA Gain 50x, IHPF=1, VHPF=1
#define CS5460A_CFG_GAIN1       0x01
#define CS5460A_CFG_GAIN2       0x00
#define CS5460A_CFG_GAIN3       0x61

#define CS5460A_CFG_IGN0        0x44		// Current channel gain (1.15935)
#define CS5460A_CFG_IGN1        0x4A
#define CS5460A_CFG_IGN2        0x32
#define CS5460A_CFG_IGN3        0xDF

#define CS5460A_CFG_VGN0        0x48		// Voltage channel gain (0.97823)
#define CS5460A_CFG_VGN1        0x3E
#define CS5460A_CFG_VGN2        0x9B
#define CS5460A_CFG_VGN3        0x5A

//#define CS5460A_START_CONV      0xE8  // Start continuous conversion
#define CS5460A_REG_CONFIG     	0x00
#define CS5460A_CMD_START      	0xE8

#define WRITE_REGISTER			0x40
#define READ_REGISTER			(~WRITE_REGISTER)

// Function prototypes
void CS5460A_SendSync(void);
void CS5460A_Init(void);
void CS5460A_Reset(void);
void CS5460A_WriteRegister(uint8_t reg, uint32_t value);

uint32_t CS5460A_ReadRegister(uint8_t reg);
uint32_t CS5460A_ReadRegister1(uint8_t reg);
unsigned long int CS5460A_ReadVoltage(void);
unsigned long int CS5460A_ReadCurrent(void);
unsigned long int CS5460A_ReadStatus(void);
unsigned long int CS5460A_ReadPower(void);

unsigned long int Instantaneous_Voltage(void);
unsigned long int Instantaneous_Current(void);

void CS5460A_ParseStatusRegister(uint32_t reg_val);
void CS5460A_ParseConfigRegister(uint32_t reg_value);
void CS5460A_ParseControlRegister(uint32_t reg_value);
unsigned long int CS5460A_ReadStatusRegister(void);
unsigned long int CS5460A_ReadConfugRegister(void);

/*
typedef struct
{
    uint8_t K     : 4;    // Bits 0-3
    uint8_t iCPU  : 1;    // Bit 4
    uint8_t IHPF  : 1;    // Bit 5
    uint8_t VHPF  : 1;    // Bit 6
    uint8_t RS    : 1;    // Bit 7

    uint8_t DL0   : 1;    // Bit 8
    uint8_t DL1   : 1;    // Bit 9
    uint8_t EOD   : 1;    // Bit 10
    uint8_t SI0   : 1;    // Bit 11
    uint8_t SI1   : 1;    // Bit 12
    uint8_t Res1  : 2;    // Bits 13-14 (Reserved)
    uint8_t EWA   : 1;    // Bit 15

    uint8_t Gi    : 1;    // Bit 16
    int8_t  PC    : 7;    // Bits 17-23 (signed 2's complement)
} CS5460A_ConfigBits_t;
*/

typedef struct
{
    uint8_t K;
    uint8_t iCPU;
    uint8_t IHPF;
    uint8_t VHPF;
    uint8_t RS;
    uint8_t DL0;
    uint8_t DL1;
    uint8_t EOD;
    uint8_t SI0;
    uint8_t SI1;
    uint8_t Res;
    uint8_t Res1;
    uint8_t EWA;
    uint8_t Gi;
    int8_t  PC0;
    int8_t  PC1;
    int8_t  PC2;
    int8_t  PC3;
    int8_t  PC4;
    int8_t  PC5;
    int8_t  PC6;
} CS5460A_ConfigBits_t;

typedef struct
{
	unsigned int IC;
	unsigned int LSD;
	unsigned int IOD;
	unsigned int VOD;
	unsigned int WDT;
	unsigned int ID0;
	unsigned int ID1;
	unsigned int ID2;
	unsigned int ID3;
	unsigned int Res;
	unsigned int EOOR;
	unsigned int EOR;
	unsigned int VROR;
	unsigned int IROR;
	unsigned int PWOR;
	unsigned int VOR;
	unsigned int IOR;
	unsigned int Res1;
	unsigned int MATH;
	unsigned int CRDY;
	unsigned int EDIR;
	unsigned int EOUT;
	unsigned int DRDY;
} Status_Mask_Registers;

typedef struct
{
	unsigned int STEP;
	unsigned int NOOSC;
	unsigned int NOCPU;
	unsigned int SYNC;
	unsigned int INTL;
	unsigned int Res;
	unsigned int MECH;
	unsigned int Res1;
	unsigned int STOP;
}controlRegister;



#endif /* INC_CS5460A_H_ */
