/*
 * cs5460a.c
 *
 *  Created on: May 21, 2025
 *      Author: electro.design5
 */

#include "cs5460a.h"
#include "spi.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "usart.h"

extern SPI_HandleTypeDef hspi2;
HAL_StatusTypeDef status;

CS5460A_ConfigBits_t cfg;
Status_Mask_Registers status_reg;
controlRegister config_reg;

int8_t pc_raw;

#define VOLTAGE_SCALE_FACTOR    0.00012207f
#define CURRENT_SCALE_FACTOR    0.000061035f
#define POWER_SCALE_FACTOR      0.000030517f
uint8_t rx_buffer1[5] = {0};
uint8_t rx_buffer2[4] = {0};


void CS5460A_Reset(void)		// SPI RESET PIN
{
    HAL_GPIO_WritePin(SPI2_RST_GPIO_Port, SPI2_RST_Pin, GPIO_PIN_RESET);
    HAL_Delay(20);
    HAL_GPIO_WritePin(SPI2_RST_GPIO_Port, SPI2_RST_Pin, GPIO_PIN_SET);
    HAL_Delay(100);
}

/*
void CS5460A_Init(void)
{
 //   CS5460A_Reset();
//    uint8_t tx_buffer[5] = {0};
//       tx_buffer[0] = SYNC1;
//       tx_buffer[1] = SYNC1;
//       tx_buffer[2] = SYNC1;
//       tx_buffer[3] = SYNC0;
//
//   //    HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_RESET);
//       status =  HAL_SPI_Transmit(&hspi2, tx_buffer, 4, HAL_MAX_DELAY);
    // Power up command
    CS5460A_WriteRegister(CS5460A_CFG_POWER_UP, 0);

    // Configure gain settings
    CS5460A_WriteRegister(CS5460A_CFG_GAIN0,
                         (CS5460A_CFG_GAIN0 << 24) |
                         (CS5460A_CFG_GAIN1 << 16) |
                         (CS5460A_CFG_GAIN2 << 8) |
                         CS5460A_CFG_GAIN3);

    // Start continuous conversion
    CS5460A_WriteRegister(CS5460A_CMD_START, 1);
}
*/



void CS5460A_SendSync(void)
{
    uint8_t sync_cmd[3] = {SYNC0, SYNC1, SYNC1};
    status = HAL_SPI_Transmit(&hspi2, sync_cmd, 3, 10);
}

//void CS5460A_Init(void)
//{
//
//	CS5460A_SendSync();
//
//    // Power up sequence
////    CS5460A_WriteRegister(0x00, 0x000000);  			// Send RESET or NOP first if required
//
//    // Write Configuration Register (Address 0x00)
//    uint32_t config = 0x000000;							// All config bits = 0
//													// For Modify Config Bits
//    config |= (1 << 0);   // K = 1
//    config |= (1 << 7);  // RS
//
//    CS5460A_WriteRegister(0x40, config);   				// Config register is at address 0x00
//    HAL_Delay(5);
//
//    // Start conversion
//    CS5460A_WriteRegister(0xE8, 0x01); 					// 0xE8 = START command
//}

void CS5460A_Init(void)
{
    CS5460A_SendSync();

    HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_RESET);		//30/07/25

    // Optional: software reset first (if required)
    CS5460A_WriteRegister(0x00, 0x000000);  // NOP/Reset

    // Step 1: Send RS bit alone to reset
    uint32_t config_reset = 0;
    config_reset |= (1 << 7);   // RS
    CS5460A_WriteRegister(0x40, config_reset);
    HAL_Delay(10);  // Allow chip to reset

    // Step 2: Write final configuration (K = 1)
    uint32_t config = 0;
    config |= (1 << 0);   // K = 1
    CS5460A_WriteRegister(0x40, config);
    printf("Wrote config: 0x%06lX\n", config);
    HAL_Delay(5);

    // Start conversion
    CS5460A_WriteRegister(0xE8, 0x01);

    HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_SET);		//30/07/25
}

void CS5460A_WriteRegister(uint8_t reg, uint32_t value)
{
    uint8_t tx_buffer[5];
//    uint8_t rx_buffer[5];

//    tx_buffer[0] = reg;
//    tx_buffer[1] = (value >> 16) & 0xFF;
//    tx_buffer[2] = (value >> 8) & 0xFF;
//    tx_buffer[3] = (value ) & 0xFF;

    tx_buffer[0] = reg;
    tx_buffer[1] = (value >> 16) & 0xFF;
    tx_buffer[2] = (value >> 8) & 0xFF;
    tx_buffer[3] = (value) & 0xFF;

    HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_RESET);		//30/07/25
    status =    HAL_SPI_Transmit(&hspi2, tx_buffer, 4, 10);
    HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_SET);		//30/07/25
}

uint32_t CS5460A_ReadRegister(uint8_t reg)
{
    uint8_t tx_buffer[5] = {0};
    tx_buffer[0] = reg;
    tx_buffer[1] = SYNC0;
    tx_buffer[2] = SYNC0;
    tx_buffer[3] = SYNC0;


    HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_RESET);		//30/07/25
    status =  HAL_SPI_TransmitReceive(&hspi2, tx_buffer,rx_buffer1, 4, 0xffffff);
    HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_SET);		//30/07/25

    return ((uint32_t)rx_buffer1[2] << 16) |
           ((uint32_t)rx_buffer1[1] << 8) |
           ((uint32_t)rx_buffer1[0] );
}

uint32_t CS5460A_ReadRegister1(uint8_t reg)
{
	uint8_t tx_buffer[4] = {reg, 0x00, 0x00, 0x00};

	HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_RESET);		//30/07/25
	status = HAL_SPI_TransmitReceive(&hspi2, tx_buffer, rx_buffer2, 4, 100);
	HAL_GPIO_WritePin(SPI2_SS1_GPIO_Port, SPI2_SS1_Pin, GPIO_PIN_SET);		//30/07/25

	return  ((uint32_t)rx_buffer2[0] << 16) |
			((uint32_t)rx_buffer2[1] << 8) |
			((uint32_t)rx_buffer2[2]);

}

unsigned long int Instantaneous_Voltage(void)
{
	unsigned long int  raw = CS5460A_ReadRegister1(CS5460A_Instantaneous_Voltage);
	return raw;
}

unsigned long int Instantaneous_Current(void)
{
	unsigned long int  raw = CS5460A_ReadRegister1(CS5460A_Instantaneous_Current);
	return raw;
}

unsigned long int CS5460A_ReadVoltage(void)
{
	unsigned long int raw = CS5460A_ReadRegister1(CS5460A_RMS_VOLTAGE);
    return raw;
//    return (float)raw * VOLTAGE_SCALE_FACTOR;
}

unsigned long int CS5460A_ReadCurrent(void)
{
	unsigned long int raw = CS5460A_ReadRegister1(CS5460A_RMS_CURRENT);
    return raw;
//    return (float)raw * CURRENT_SCALE_FACTOR;
}

unsigned long int CS5460A_ReadPower(void)
{
	unsigned long int raw = CS5460A_ReadRegister1(CS5460A_TRUE_POWER);
    return raw;

//    if (raw & 0x00800000)
//    {
//        raw |= 0xFF000000; // Sign extend
//        return (float)((int32_t)raw) * POWER_SCALE_FACTOR;
//    }
//    return (float)raw * POWER_SCALE_FACTOR;
}
unsigned long int CS5460A_ReadStatus(void)
{
	unsigned long int raw = CS5460A_ReadRegister1(0x1E);
    return raw;
}
/**********************************************************/

void CS5460A_ParseControlRegister(uint32_t reg_value)
{
	config_reg.STEP		= (reg_value >> 0) & 0x01;
	config_reg.NOOSC	= (reg_value >> 1) & 0x01;
	config_reg.NOCPU	= (reg_value >> 2) & 0x01;
	config_reg.SYNC		= (reg_value >> 3) & 0x01;
	config_reg.INTL		= (reg_value >> 4) & 0x01;
	config_reg.Res		= (reg_value >> 5) & 0x01;
	config_reg.MECH		= (reg_value >> 6) & 0x01;
	config_reg.Res1		= (reg_value >> 7) & 0x01;
	config_reg.STOP		= (reg_value >> 8) & 0x01;
}

//CS5460A_ConfigBits_t CS5460A_ParseConfigRegister(uint32_t reg_value)
void CS5460A_ParseConfigRegister(uint32_t reg_value)
{

//    cfg.K     = (reg_value >> 0) & 0x01;
	cfg.K     =  reg_value & 0x0F;
    cfg.iCPU  = (reg_value >> 4) & 0x01;
    cfg.IHPF  = (reg_value >> 5) & 0x01;
    cfg.VHPF  = (reg_value >> 6) & 0x01;
    cfg.RS    = (reg_value >> 7) & 0x01;
    cfg.DL0   = (reg_value >> 8) & 0x01;
    cfg.DL1   = (reg_value >> 9) & 0x01;
    cfg.EOD   = (reg_value >> 10) & 0x01;
    cfg.SI0   = (reg_value >> 11) & 0x01;
    cfg.SI1   = (reg_value >> 12) & 0x01;
    cfg.Res   = (reg_value >> 13) & 0x01;
    cfg.Res1  = (reg_value >> 14) & 0x01;
    cfg.EWA   = (reg_value >> 15) & 0x01;
    cfg.Gi    = (reg_value >> 16) & 0x01;
    cfg.PC0   = (reg_value >> 17) & 0x01;
    cfg.PC1   = (reg_value >> 18) & 0x01;
    cfg.PC2   = (reg_value >> 19) & 0x01;
    cfg.PC3   = (reg_value >> 20) & 0x01;
    cfg.PC4   = (reg_value >> 21) & 0x01;
    cfg.PC5   = (reg_value >> 22) & 0x01;
    cfg.PC6   = (reg_value >> 23) & 0x01;
}

void CS5460A_ParseStatusRegister(uint32_t reg_val)
{
	status_reg.IC    = (reg_val >> 0) & 0x01;
	status_reg.LSD   = (reg_val >> 2) & 0x01;
	status_reg.IOD   = (reg_val >> 3) & 0x01;
	status_reg.VOD   = (reg_val >> 4) & 0x01;
	status_reg.WDT   = (reg_val >> 5) & 0x01;
	status_reg.ID0   = (reg_val >> 6) & 0x01;
	status_reg.ID1   = (reg_val >> 7) & 0x01;
	status_reg.ID2   = (reg_val >> 8) & 0x01;
	status_reg.ID3   = (reg_val >> 9) & 0x01;
	status_reg.Res   = (reg_val >> 10) & 0x01;
	status_reg.EOOR  = (reg_val >> 11) & 0x01;
	status_reg.EOR   = (reg_val >> 12) & 0x01;
	status_reg.VROR  = (reg_val >> 13) & 0x01;
	status_reg.IROR  = (reg_val >> 14) & 0x01;
	status_reg.PWOR  = (reg_val >> 15) & 0x01;
	status_reg.VOR   = (reg_val >> 16) & 0x01;
	status_reg.IOR   = (reg_val >> 17) & 0x01;
	status_reg.Res1  = (reg_val >> 18) & 0x01;
	status_reg.MATH  = (reg_val >> 19) & 0x01;
	status_reg.CRDY  = (reg_val >> 20) & 0x01;
	status_reg.EDIR  = (reg_val >> 21) & 0x01;
	status_reg.EOUT  = (reg_val >> 22) & 0x01;
	status_reg.DRDY  = (reg_val >> 23) & 0x01;
}

unsigned long int CS5460A_ReadStatusRegister(void)
{
	unsigned long int raw = CS5460A_ReadRegister1(CS5460A_STATUS);
	return raw;
}

unsigned long int CS5460A_ReadConfugRegister(void)
{
	unsigned long int raw = CS5460A_ReadRegister1(0x00);
	return raw;
}



