/* USER CODE BEGIN Header */
/**
 ******************************************************************************
 * @file    stm32f4xx_it.c
 * @brief   Interrupt Service Routines.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32f4xx_it.h"
#include "FreeRTOS.h"
#include "task.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "modbus.h"
#include "OCPP.h"
#include <ctype.h>
#include <string.h>
#include "w25qxx.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */
char ether_connection_varify(void);
char wifi_connection_varify(void);
int validate_ip(unsigned char *ip);
/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/
extern DMA_HandleTypeDef hdma_adc1;
extern DMA_HandleTypeDef hdma_adc2;
extern ADC_HandleTypeDef hadc1;
extern ADC_HandleTypeDef hadc2;
extern TIM_HandleTypeDef htim1;
extern TIM_HandleTypeDef htim2;
extern TIM_HandleTypeDef htim5;
extern DMA_HandleTypeDef hdma_usart1_rx;
extern DMA_HandleTypeDef hdma_usart1_tx;
extern DMA_HandleTypeDef hdma_usart2_tx;
extern DMA_HandleTypeDef hdma_usart2_rx;
extern DMA_HandleTypeDef hdma_usart3_rx;
extern DMA_HandleTypeDef hdma_usart3_tx;
extern DMA_HandleTypeDef hdma_usart6_rx;
extern UART_HandleTypeDef huart1;
extern UART_HandleTypeDef huart2;
extern UART_HandleTypeDef huart3;
extern UART_HandleTypeDef huart6;
/* USER CODE BEGIN EV */
extern uint8_t rxmsg[100];
extern uint8_t server_packet[1024];
extern char current_page, otp_ocpp[30];

//void usart2_irqHandler_callback( UART_HandleTypeDef huart2);
unsigned int flag;
uint8_t rxBuffer, hmi_buff, hmi_buff1, WIFI_Setting;
char START_FLAG;
__IO ITStatus UartReady = RESET;
uint8_t i;
volatile uint16_t blue_led_blink = 0;
extern volatile uint8_t;
//extern uint8_t HMI_wifi_disconnect,HMI_websocket_connect,HMI_websocket_disconnect;
volatile uint16_t red_led_blink = 0, red_led_blink2 = 0, red_led_blink3 = 0,
		red_led_blink1 = 0;
volatile uint16_t green_led_blink = 0;
volatile uint8_t Emergency_stop_count = 0, RCD_count_Start = 0, RCD_count_Stop =
		0;
volatile uint16_t buzzer_enable_time = 0;
volatile char buzzer_enable;
volatile char adcchecktoggleFlag = 0;

volatile uint16_t count = 0, bytecount = 0, bytecount_M = 0, count_M = 0;

int rxindex = 0, rxindex1 = 0;
extern char pwm_start_stop, OCPP_setting, pwm_start_stop_1;
volatile extern char admin, history, mode, start, back_1, enter_1, Touch_Action,
		Clear_Register;
//extern uint8_t AC001_OCPP_Charger_Status;
extern void process_ReceiveArray(void);
volatile unsigned long int millisec = 0;
extern void adc_check();
uint8_t Internal_Error = 0;

volatile extern uint8_t LocalListAdding, Local_List_Update;
extern char websocket_success;
//extern uint8_t AC001_OCPP_Charger_Status;//,wifi_connected;
extern volatile char alarm;
char Local_Added = 0;
//extern uint32_t otp;
uint8_t adctempcnt = 0, adctempcnt_1 = 0, M_buff, M_buff1;
char tagid[15], Send_meter;
extern char EVSE_status[20];
char id[15], recieve_complete, Type2_OCPP_Authorization_Flag;
uint8_t hmi_buffer[130], internet_connection, Emergency_start_count;
volatile extern char read_flash;
extern struct Config_Parameter OCPP;
extern const struct Config_Parameter_OCPP default_params_ocpp;
//extern uint16_t Total_cost;
//extern uint32_t consume_energy;
//uint32_t charging_counter;

extern char Rfid_Add;
//extern uint8_t StateFlowOCPP(OCPP_States OCPP_State_ACType2);
char OCPP_data(void);
void delay_ms(uint32_t mS);

extern volatile uint16_t ticktimerflag, ticktickcnt;
extern volatile char flash_writing, flash_reading;

uint8_t RCD1_stop_count, RCD1_stop, RCD1_start_count;
uint8_t RCD2_stop_count, RCD2_stop, RCD2_start_count;
uint8_t RCD3_stop_count, RCD3_stop, RCD3_start_count;

extern uint16_t enrgyread1_timouttick, enrgyread2_timouttick,
		enrgyread3_timouttick;
extern uint8_t energymeter_err[3];

char START_FLAG, START_FLAG_M;

volatile uint8_t recieve_complete_2;
///////////V5.0.0A changes ///////////////////////////////
extern volatile uint8_t HMI_alarmstsupdate;
///////////////////////////////////////////////////////////
extern unsigned char meterquerycntr;
///////////////////////////////////////////////////////////
extern enum {
	no_alarm = 0, activealarm, mutealarm,
} alarmstatus;
////
//////////////////////////////////////////////////////////////
/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M4 Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
 * @brief This function handles Non maskable interrupt.
 */
void NMI_Handler(void) {
	/* USER CODE BEGIN NonMaskableInt_IRQn 0 */
	/* USER CODE END NonMaskableInt_IRQn 0 */
	/* USER CODE BEGIN NonMaskableInt_IRQn 1 */
	while (1) {

	}
	/* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
 * @brief This function handles Hard fault interrupt.
 */
void HardFault_Handler(void) {
	/* USER CODE BEGIN HardFault_IRQn 0 */

	/* USER CODE END HardFault_IRQn 0 */
	while (1) {
		/* USER CODE BEGIN W1_HardFault_IRQn 0 */
		/* USER CODE END W1_HardFault_IRQn 0 */
	}
}

/**
 * @brief This function handles Memory management fault.
 */
void MemManage_Handler(void) {
	/* USER CODE BEGIN MemoryManagement_IRQn 0 */

	/* USER CODE END MemoryManagement_IRQn 0 */
	while (1) {
		/* USER CODE BEGIN W1_MemoryManagement_IRQn 0 */
		/* USER CODE END W1_MemoryManagement_IRQn 0 */
	}
}

/**
 * @brief This function handles Pre-fetch fault, memory access fault.
 */
void BusFault_Handler(void) {
	/* USER CODE BEGIN BusFault_IRQn 0 */

	/* USER CODE END BusFault_IRQn 0 */
	while (1) {
		/* USER CODE BEGIN W1_BusFault_IRQn 0 */
		/* USER CODE END W1_BusFault_IRQn 0 */
	}
}

/**
 * @brief This function handles Undefined instruction or illegal state.
 */
void UsageFault_Handler(void) {
	/* USER CODE BEGIN UsageFault_IRQn 0 */

	/* USER CODE END UsageFault_IRQn 0 */
	while (1) {
		/* USER CODE BEGIN W1_UsageFault_IRQn 0 */
		/* USER CODE END W1_UsageFault_IRQn 0 */
	}
}

/**
 * @brief This function handles Debug monitor.
 */
void DebugMon_Handler(void) {
	/* USER CODE BEGIN DebugMonitor_IRQn 0 */

	/* USER CODE END DebugMonitor_IRQn 0 */
	/* USER CODE BEGIN DebugMonitor_IRQn 1 */

	/* USER CODE END DebugMonitor_IRQn 1 */
}

/**
 * @brief This function handles System tick timer.
 */
void SysTick_Handler(void) {
	/* USER CODE BEGIN SysTick_IRQn 0 */

	/*if(++counter > 100)
	 {
	 OCPP_data();
	 counter = 0;
	 }*/
//
//	if(blue_led_blink)blue_led_blink--;
	if (red_led_blink)
		red_led_blink--;
	if (red_led_blink1)
		red_led_blink1--;
	if (red_led_blink2)
		red_led_blink2--;
	if (red_led_blink3)
		red_led_blink3--;

	if (enrgyread1_timouttick)
		enrgyread1_timouttick--;
//	else
//	{
//		energymeter_err[0] = 1;
//		charger_status_G1.error = PowerMeterFailure;
//		if((charger_status_G1.start == 1) && (charger_status_G1.charging_status == Charging_ChargerPoint ))
//		{
//			charger_status_G1.charging_status = SuspendedEVSE_ChargerPoint;
//			charger_status_G1.stop = 1;
//			stop_charging =1;
//			Type2_OCPP_Authorization_Flag =1;
//		}
//
//	}
//	if(enrgyread2_timouttick) enrgyread2_timouttick--;
//	else
//	{
//		energymeter_err[1] = 1;
//		charger_status_G2.error = PowerMeterFailure;
//		if((charger_status_G2.start == 1) && (charger_status_G2.charging_status == Charging_ChargerPoint ))
//		{
//			charger_status_G2.stop = 1;
//			stop_charging =1;
//			Type2_OCPP_Authorization_Flag =1;
//			charger_status_G2.charging_status = SuspendedEVSE_ChargerPoint;
//		}
//	}
//	if(enrgyread3_timouttick) enrgyread3_timouttick--;
//	else
//	{
//		energymeter_err[2] = 1;
//		charger_status_G3.error = PowerMeterFailure;
//		if((charger_status_G3.start == 1) && (charger_status_G3.charging_status == Charging_ChargerPoint ))
//		{
//			charger_status_G3.stop = 1;
//			stop_charging =1;
//			Type2_OCPP_Authorization_Flag =1;
//			charger_status_G3.charging_status = SuspendedEVSE_ChargerPoint;
//		}
//	}

//	if(green_led_blink)green_led_blink--;
	if (buzzer_enable_time)
		buzzer_enable_time--;

	if (!EMG_SW_READ) {
		Emergency_stop_count++;
		if (Emergency_stop_count >= 50) {
			Internal_Error = 1;

			charger_status_G1.reson = EmergencyStop;
#if defined(dualgun)
				charger_status_G2.reson = EmergencyStop;

				charger_status_G2.error	= InternalError;
#endif
			charger_status_G1.error = InternalError;

#if defined(dualgun)
				if(charger_status_G2.start == Started)
				{
					charger_status_G2.stop = Try_To_Stop;
				}


#endif
			Emergency_stop_count = 0;
		}
	} else {
		if (++Emergency_start_count > 50) {
			Emergency_start_count = 0;
			Emergency_stop_count = 0;

			if (charger_status_G1.error == InternalError) {
				charger_status_G1.error = NoError_ChargerPoint;
				charger_status_G2.error = NoError_ChargerPoint;
				charger_status_G3.error = NoError_ChargerPoint;
				Internal_Error = 0;
			}
#ifdef RCDFEEDBACK
			if (RCD_READ) {
				if (++RCD_count_Start >= 5) {
					RCD_count_Start = 0;
					Internal_Error = 1;
					charger_status_G1.error = InternalError;
					charger_status_G1.reson = Local;
				}
			} else {
				if (++RCD_count_Stop > 5) {
					RCD_count_Stop = 0;
					Internal_Error = 0;
					if (charger_status_G1.error == InternalError) {
						charger_status_G1.error = NoError_ChargerPoint;
						charger_status_G2.error = NoError_ChargerPoint;
						charger_status_G3.error = NoError_ChargerPoint;
						Internal_Error = 0;
					}
				}
			}
#endif
		}
	}

	if (Internal_Error == 1) {
		if (charger_status_G1.start == Started) {
			charger_status_G1.stop = Try_To_Stop;
		}
	}

	//////////////////////////////////////////////////////////////////

	if (Internal_Error) {
		if (red_led_blink == 0) {
			red_led_blink = 500;
			TOGGLE_G1_RED;
			BLUE_G1_OFF;
			GREEN_G1_OFF;

			TOGGLE_G2_RED;
			BLUE_G2_OFF;
			GREEN_G2_OFF;

			if (alarmstatus != mutealarm)	//v5.0.0A
					{
				alarmstatus = activealarm;
				HMI_alarmstsupdate = 1;
			}

			//TOGGLE_BUZZER;
		}
	} else {
		if ((charger_status_G1.charging_status == Faulted_ChargerPoint)
				|| (charger_status_G2.charging_status == Faulted_ChargerPoint)
				|| (charger_status_G3.charging_status == Faulted_ChargerPoint)) {
			////////V5.0.0A//////////
//				alarm = 1;

			if (alarmstatus != mutealarm) {
				alarmstatus = activealarm;
				HMI_alarmstsupdate = 1;
			}

			////////////////////////
		} else {
			////////V5.0.0A//////////
//				alarm = 0;
			if (alarmstatus != no_alarm) {
				alarmstatus = no_alarm;
				HMI_alarmstsupdate = 1;
			}
			///////////////////////
		}

		if (charger_status_G1.charging_status == Faulted_ChargerPoint) {
			if (red_led_blink1 == 0) {
				red_led_blink1 = 500;

				TOGGLE_G1_RED;
				BLUE_G1_OFF;
				GREEN_G1_OFF;

				TOGGLE_G2_RED;
				BLUE_G2_OFF;
				GREEN_G2_OFF;

				if ((RCD1_stop != 1)) {
					alarm = 1;
				}
				//alarm = 1;
				//TOGGLE_BUZZER;
			}
		} else if (charger_status_G1.charging_status == Charging_ChargerPoint) {
			GREEN_G1_ON;
			RED_G1_OFF;
			BLUE_G1_OFF;
			//BUZZER_OFF

			GREEN_G2_ON;
			RED_G2_OFF;
			BLUE_G2_OFF;

		} else {
			BLUE_G1_ON;
			GREEN_G1_OFF;
			RED_G1_OFF;

			BLUE_G2_ON;
			GREEN_G2_OFF;
			RED_G2_OFF;
		}
#if defined(dualgun)
			if(charger_status_G2.charging_status == Faulted_ChargerPoint)
			{
				if(red_led_blink2 == 0)
				{
					red_led_blink2=500;
					TOGGLE_G2_RED;
					if( RCD2_stop != 1)
					{
						alarm = 1;
					}
					//TOGGLE_BUZZER;
				}
				BLUE_G2_OFF;
				GREEN_G2_OFF;
			}
			else if(charger_status_G2.charging_status == Charging_ChargerPoint)
			{
				GREEN_G2_ON;
				RED_G2_OFF;
				BLUE_G2_OFF;
				BUZZER_OFF
			}
			else
			{
				BLUE_G2_ON;
				GREEN_G2_OFF;
				RED_G2_OFF;
				BUZZER_OFF;
			}

#endif

	}

//			if(alarm)

	if (alarmstatus == activealarm)	//V5.0.0A
			{
		if (!buzzer_enable_time) {
			buzzer_enable_time = 500;
			buzzer_enable = !buzzer_enable;
		}
		if (buzzer_enable) {
			TOGGLE_BUZZER;
		} else {
			BUZZER_OFF;
		}
	} else {
		BUZZER_OFF;
	}
//
//	if((pwm_start_stop==0) && (flash_writing == 0) && ++adctempcnt >100)
//		{
//			adc_check();
//			adctempcnt=0;
//		}

	if ((pwm_start_stop == 0) && (++adctempcnt > 100)) {
		if (flash_writing != 1) {
			adc_check();
		}
		adctempcnt = 0;
	}
#if defined(dualgun)
		if(pwm_start_stop_1==0  && ( ++adctempcnt_1 >100))
		{
			if(flash_writing != 1)
			{
				adc_check_2();
			}
			adctempcnt_1=0;
		}
#endif

	/*if((pwm_start_stop==0) &&(pwm_start_stop_1==0))
	 {
	 adc_check();
	 }*/

	/* USER CODE END SysTick_IRQn 0 */
	HAL_IncTick();
#if (INCLUDE_xTaskGetSchedulerState == 1 )
	if (xTaskGetSchedulerState() != taskSCHEDULER_NOT_STARTED) {
#endif /* INCLUDE_xTaskGetSchedulerState */
		xPortSysTickHandler();
#if (INCLUDE_xTaskGetSchedulerState == 1 )
	}
#endif /* INCLUDE_xTaskGetSchedulerState */
	/* USER CODE BEGIN SysTick_IRQn 1 */

	/* USER CODE END SysTick_IRQn 1 */
}
/******************************************************************************/
/* STM32F4xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32f4xx.s).                    */
/******************************************************************************/

/**
 * @brief This function handles DMA1 stream1 global interrupt.
 */
void DMA1_Stream1_IRQHandler(void) {
	/* USER CODE BEGIN DMA1_Stream1_IRQn 0 */

	/* USER CODE END DMA1_Stream1_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart3_rx);
	/* USER CODE BEGIN DMA1_Stream1_IRQn 1 */

	/* USER CODE END DMA1_Stream1_IRQn 1 */
}
/**
 * @brief This function handles DMA1 stream3 global interrupt.
 */
void DMA1_Stream3_IRQHandler(void) {
	/* USER CODE BEGIN DMA1_Stream3_IRQn 0 */

	/* USER CODE END DMA1_Stream3_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart3_tx);
	/* USER CODE BEGIN DMA1_Stream3_IRQn 1 */

	/* USER CODE END DMA1_Stream3_IRQn 1 */
}

/**
 * @brief This function handles DMA1 stream5 global interrupt.
 */
void DMA1_Stream5_IRQHandler(void) {
	/* USER CODE BEGIN DMA1_Stream5_IRQn 0 */

	/* USER CODE END DMA1_Stream5_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart2_rx);
	/* USER CODE BEGIN DMA1_Stream5_IRQn 1 */

	/* USER CODE END DMA1_Stream5_IRQn 1 */
}

/**
 * @brief This function handles DMA1 stream6 global interrupt.
 */
void DMA1_Stream6_IRQHandler(void) {
	/* USER CODE BEGIN DMA1_Stream6_IRQn 0 */

	/* USER CODE END DMA1_Stream6_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart2_tx);
	/* USER CODE BEGIN DMA1_Stream6_IRQn 1 */

	/* USER CODE END DMA1_Stream6_IRQn 1 */
}

/**
 * @brief This function handles ADC1, ADC2 and ADC3 global interrupts.
 */
void ADC_IRQHandler(void) {
	/* USER CODE BEGIN ADC_IRQn 0 */

	/* USER CODE END ADC_IRQn 0 */
	HAL_ADC_IRQHandler(&hadc1);
	HAL_ADC_IRQHandler(&hadc2);
	/* USER CODE BEGIN ADC_IRQn 1 */

	/* USER CODE END ADC_IRQn 1 */
}

/**
 * @brief This function handles TIM1 update interrupt and TIM10 global interrupt.
 */
void TIM1_UP_TIM10_IRQHandler(void) {
	/* USER CODE BEGIN TIM1_UP_TIM10_IRQn 0 */

	/* USER CODE END TIM1_UP_TIM10_IRQn 0 */
	HAL_TIM_IRQHandler(&htim1);

	/* USER CODE BEGIN TIM1_UP_TIM10_IRQn 1 */
//  for(int i=0;i<4090;i++);
	HAL_TIM_Base_Start_IT(&htim5);
	// HAL_TIM_Base_Start_IT(&htim5);
	//HAL_TIMEx_OnePulseN_Start_IT(&htim5, TIM_CHANNEL_ALL);
	//HAL_TIM_OnePulse_Start_IT(&htim5, TIM_CHANNEL_ALL);
	//adc_check();
	/* USER CODE END TIM1_UP_TIM10_IRQn 1 */
}

/**
 * @brief This function handles TIM2 global interrupt.
 */
void TIM2_IRQHandler(void) {
	/* USER CODE BEGIN TIM2_IRQn 0 */

	/* USER CODE END TIM2_IRQn 0 */
	HAL_TIM_IRQHandler(&htim2);
	/* USER CODE BEGIN TIM2_IRQn 1 */

	/* USER CODE END TIM2_IRQn 1 */
}

void TIM5_IRQHandler(void) {
	/* USER CODE BEGIN TIM2_IRQn 0 */

	/* USER CODE END TIM2_IRQn 0 */
	HAL_TIM_IRQHandler(&htim5);
//  adc_check();
#if defined(dualgun)
  if(pwm_start_stop == 1 && pwm_start_stop_1 == 1)
    {
  //	  adcchecktoggleFlag ^= adcchecktoggleFlag;
  	  if(adcchecktoggleFlag == 1)
  	  {
  		  adc_check();
  		  adcchecktoggleFlag=0;
  	  }
  	  else
  	  {
  		  adc_check_2();
  		  adcchecktoggleFlag=1;
  	  }
    }
  else if(pwm_start_stop==1)
  	{
  		adc_check();
  	}
    else if(pwm_start_stop_1==1)
  	{
  		adc_check_2();
  	}
#else

	if (pwm_start_stop == 1) {
		adc_check();
	}

#endif
	/* USER CODE BEGIN TIM2_IRQn 1 */

	/* USER CODE END TIM2_IRQn 1 */
}
/**
 * @brief This function handles USART1 global interrupt.
 */
void USART1_IRQHandler(void) {
	/* USER CODE BEGIN USART1_IRQn 0 */
	__HAL_UART_FLUSH_DRREGISTER(&huart1);
	// HAL_UART_Receive_DMA(&huart1,(uint8_t*)rxmsg,37);
	HAL_UART_Receive_DMA(&huart1, (uint8_t*) &M_buff, 1);
	/* USER CODE END USART1_IRQn 0 */
	HAL_UART_IRQHandler(&huart1);

	/* USER CODE BEGIN USART1_IRQn 1 */
	// for(int i=0;i<2000;i++);
	// HAL_UART_Transmit(&huart6,rxmsg,37,0xffffff);
	/* USER CODE END USART1_IRQn 1 */
}

/**
 * @brief This function handles USART2 global interrupt.
 */
void USART2_IRQHandler(void) {
	/* USER CODE BEGIN USART2_IRQn 0 */
	/*
	 * HAL_UART_AbortReceive(&huart2);

	 //	if(USART2-> HAL_UART_STATE_TIMEOUT)
	 //	if(USART2 -> RxState == HAL_UART_STATE_TIMEOUT)
	 if (huart2.RxState == HAL_UART_STATE_READY)
	 {
	 //	DMA1->CNDTR=10;
	 //HAL_UART_AbortReceive(&huart2);
	 HAL_UART_Receive_DMA(&huart2, (uint8_t*)server_packet,100);
	 i=0;
	 while(server_packet[i] != '\r')
	 {
	 rx[i]= server_packet[i];
	 i++;
	 }
	 rx[i] = '\r';
	 i++;
	 rx[i] = '\n';
	 i++;
	 rx[i] = '\0';
	 HAL_UART_Transmit_DMA(&huart1, (uint8_t*)rx,i+1);
	 i =0;

	 //USART2->ICR=USART_ICR_RTOCF;
	 huart2.RxState=HAL_UART_STATE_RESET;

	 //	memset(server_packet,0, 8*sizeof(char));

	 //	HAL_GPIO_TogglePin(LD4_GPIO_Port, LD4_Pin);

	 process_ReceiveArray();

	 }
	 */
	//HAL_UART_Receive_DMA(&huart2, (uint8_t*)server_packet, 98);
	//   AC001_OCPP_Charger_Status = 0;
	//OCPP_State_ACType2 = 1;
	//AC001_OCPP_Charger_Status = 0;
	//
	__HAL_UART_FLUSH_DRREGISTER(&huart2);
	HAL_UART_Receive_DMA(&huart2, &rxBuffer, 1);
	/* USER CODE END USART2_IRQn 0 */
	HAL_UART_IRQHandler(&huart2);
	/* USER CODE BEGIN USART2_IRQn 1 */

	/* USER CODE END USART2_IRQn 1 */
}

/**
 * @brief This function handles USART3 global interrupt.
 */
void USART3_IRQHandler(void) {
	/* USER CODE BEGIN USART3_IRQn 0 */
	__HAL_UART_FLUSH_DRREGISTER(&huart3);
	HAL_UART_Receive_DMA(&huart3, &hmi_buff, 1);
	/* USER CODE END USART3_IRQn 0 */
	HAL_UART_IRQHandler(&huart3);
	/* USER CODE BEGIN USART3_IRQn 1 */

	/* USER CODE END USART3_IRQn 1 */
}

/**
 * @brief This function handles DMA2 stream0 global interrupt.
 */
/**
 * @brief This function handles DMA2 stream1 global interrupt.
 */
void DMA2_Stream1_IRQHandler(void) {
	/* USER CODE BEGIN DMA2_Stream1_IRQn 0 */

	/* USER CODE END DMA2_Stream1_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart6_rx);
	/* USER CODE BEGIN DMA2_Stream1_IRQn 1 */

	/* USER CODE END DMA2_Stream1_IRQn 1 */
}

/**
 * @brief This function handles DMA2 stream2 global interrupt.
 */
void DMA2_Stream2_IRQHandler(void) {
	/* USER CODE BEGIN DMA2_Stream2_IRQn 0 */

	/* USER CODE END DMA2_Stream2_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart1_rx);
	/* USER CODE BEGIN DMA2_Stream2_IRQn 1 */

	/* USER CODE END DMA2_Stream2_IRQn 1 */
}

/**
 * @brief This function handles DMA2 stream3 global interrupt.
 */
void DMA2_Stream3_IRQHandler(void) {
	/* USER CODE BEGIN DMA2_Stream3_IRQn 0 */
	/* USER CODE END DMA2_Stream3_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_adc2);
	/* USER CODE BEGIN DMA2_Stream3_IRQn 1 */

	/* USER CODE END DMA2_Stream3_IRQn 1 */
}
void DMA2_Stream4_IRQHandler(void) {
	/* USER CODE BEGIN DMA2_Stream4_IRQn 0 */

	/* USER CODE END DMA2_Stream4_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_adc1);
	/* USER CODE BEGIN DMA2_Stream4_IRQn 1 */

	/* USER CODE END DMA2_Stream4_IRQn 1 */
}
/**
 * @brief This function handles DMA2 stream7 global interrupt.
 */
void DMA2_Stream7_IRQHandler(void) {
	/* USER CODE BEGIN DMA2_Stream7_IRQn 0 */

	/* USER CODE END DMA2_Stream7_IRQn 0 */
	HAL_DMA_IRQHandler(&hdma_usart1_tx);
	/* USER CODE BEGIN DMA2_Stream7_IRQn 1 */

	/* USER CODE END DMA2_Stream7_IRQn 1 */
}

/**
 * @brief This function handles USART6 global interrupt.
 */
void USART6_IRQHandler(void) {
	/* USER CODE BEGIN USART6_IRQn 0 */
	__HAL_UART_FLUSH_DRREGISTER(&huart6);
	HAL_UART_Receive_DMA(&huart6, id, 13);
	/* USER CODE END USART6_IRQn 0 */
	HAL_UART_IRQHandler(&huart6);
	/* USER CODE BEGIN USART6_IRQn 1 */

	/* USER CODE END USART6_IRQn 1 */
}
void EXTI9_5_IRQHandler(void) {
	/* USER CODE BEGIN EXTI9_5_IRQn 0 */

	/* USER CODE END EXTI9_5_IRQn 0 */
	HAL_GPIO_EXTI_IRQHandler(GPIO_PIN_5);
	/* USER CODE BEGIN EXTI9_5_IRQn 1 */

	/* USER CODE END EXTI9_5_IRQn 1 */
}
/* USER CODE BEGIN 1 */
void HAL_UART_ErrorCallback(UART_HandleTypeDef *huart) {
	if (huart->Instance == USART6) {
		//HAL_UART_DeInit(&huart6);
		HAL_UART_Receive_DMA(&huart6, (uint8_t*) id, 13);
	} else if (huart->Instance == USART2) {
		//HAL_UART_DeInit(&huart2);
		HAL_UART_Receive_DMA(&huart2, &rxBuffer, 1);
	} else if (huart->Instance == USART3) {
		//HAL_UART_DeInit(&huart3);
		HAL_UART_Receive_DMA(&huart3, &hmi_buff, 1);
	} else if (huart->Instance == USART1) {
		//	HAL_UART_DeInit(&huart1);
		HAL_UART_Receive_DMA(&huart1, (uint8_t*) &M_buff, 1);
	}

}
void HAL_UART_RxCpltCallback(UART_HandleTypeDef *huart) {
	if (huart->Instance == USART2) {
		__HAL_UART_FLUSH_DRREGISTER(&huart2); // Clear the buffer to prevent overrun

		if ((rxBuffer == '\n' || rxBuffer == '\r') && (rxindex >= 3)) // If Enter
				{
			server_packet[rxindex] = '\r';
			rxindex++;
			server_packet[rxindex] = '\n';

			//HAL_UART_Transmit(&huaGrt6, (uint8_t*)server_packet,rxindex+1,0xffff);
			recieve_complete_2 = 1;
			//process_ReceiveArray();
			rxindex = 0;
		} else if ((rxBuffer != '\n') && (rxBuffer != '\r')) {
			server_packet[rxindex] = rxBuffer; // Add that character to the string
			rxindex++;
		}
	} else if (huart->Instance == USART1) {
		__HAL_UART_FLUSH_DRREGISTER(&huart1); // Clear the buffer to prevent overrun
#if meter == normal
		if (bytecount_M) {
			rxmsg[count_M++] = M_buff;
			bytecount_M--;
			if (bytecount_M == 0) {
				modbus_check();
				Send_meter = 0;
			}
		}
		if (START_FLAG_M == 1) {
			bytecount_M = M_buff + 2;
			rxmsg[2] = M_buff;
			START_FLAG_M = 0;
			count_M = 3;
		}

		if (Send_meter == 1) {
			if ((M_buff == 03) && (M_buff1 == 01)) {
				START_FLAG_M = 1;
				count_M = 2;
				rxmsg[0] = M_buff1;
				rxmsg[1] = M_buff;
			}

		} else if (Send_meter == 2) {
			if ((M_buff == 04) && (M_buff1 == 02)) {
				START_FLAG_M = 1;
				count_M = 2;
				rxmsg[0] = M_buff1;
				rxmsg[1] = M_buff;
			}
		}
		M_buff1 = M_buff;
#else
          			if(bytecount_M)
					{
						rxmsg[count_M++] = M_buff;
						bytecount_M--;
						if(bytecount_M == 0)
						{
							modbus_check();
							Send_meter = 0;
						}
					}
					if(START_FLAG_M == 1)
					{
						bytecount_M = M_buff+2;
						rxmsg[2] = M_buff;
						START_FLAG_M = 0;
						count_M=3;
					}

					if(Send_meter == 1)
					{
						if((M_buff == 04) && ( M_buff1 == 01  || M_buff1 == 02) )
						{
							START_FLAG_M = 1;
							count_M = 2;
							rxmsg[0] = M_buff1;
							rxmsg[1] = M_buff;
						}
					}
					M_buff1 = M_buff;
#endif
	}

	else if (huart->Instance == USART6) {

		__HAL_UART_FLUSH_DRREGISTER(&huart6); // Clear the buffer to prevent overrun
		// HAL_UART_Transmit(&huart6,(uint8_t *)id,14,0xffff);

		if ((id[0] == 0x5A) && (id[1] == 0xA5)) {
			if ((current_page == 2) || (current_page == 31) || (current_page == 32)) {
				for (i = 4; i < 12; i++) {
					tagid[i - 4] = id[i];
				}

				tagid[i - 4] = '\0';
				Type2_OCPP_Authorization_Flag = 1;

//					 if(strcmp(tagid,OCPP.rfid1) == 0)
//					 {
//						 Type2_OCPP_Authorization_Flag = 1;
//					 }
//					 else if(strcmp(tagid,OCPP.rfid2) == 0)
//					 {
//						 Type2_OCPP_Authorization_Flag = 1;
//					 }
//					 else if(strcmp(tagid,OCPP.rfid3) == 0)
//					 {
//						 Type2_OCPP_Authorization_Flag = 1;
//					 }
//					 else if(strcmp(tagid,OCPP.rfid4) == 0)
//					 {
//						 Type2_OCPP_Authorization_Flag = 1;
//					 }
//					 else if(strcmp(tagid,OCPP.rfid5) == 0)
//					 {
//						 Type2_OCPP_Authorization_Flag = 1;
//					 }
//					 else
//					 {
//						 Type2_OCPP_Authorization_Flag = 0;
//						 incorrect_rfid = 1;
//						 charger_status_G1.Authentication_done = 0;
//						 charger_status_G3.Authentication_done = 0;
//					 }

				/* if(Type2_OCPP_Authorization_Flag == 1)
				 {
				 if(charger_status_G1.start == Authenticate)
				 {
				 strcpy(charger_status_G1.start_tagid,tagid);
				 //charger_status_G1.Authentication_done = 1;
				 correct_rfid = 1;
				 charger_status_G1.start = Try_To_Start;
				 charger_status_G1.reson = Local;
				 }
				 else if(charger_status_G2.start == Authenticate)
				 {
				 strcpy(charger_status_G2.start_tagid,tagid);
				 charger_status_G2.start = Try_To_Start;
				 charger_status_G2.reson = Local;
				 // charger_status_G2.Authentication_done = 1;
				 correct_rfid = 1;
				 }
				 else if(charger_status_G3.start == Authenticate)
				 {
				 strcpy(charger_status_G3.start_tagid,tagid);
				 charger_status_G3.reson = Local;
				 //charger_status_G2.start = Try_To_Start;;
				 charger_status_G3.Authentication_done = 1;
				 correct_rfid = 1;
				 }
				 else if(charger_status_G2.stop == Authenticate)
				 {
				 charger_status_G2.stop = Try_To_Stop;
				 charger_status_G2.reson = Local;
				 correct_rfid = 1;
				 charger_status_G2.charging_status = Finishing_ChargerPoint;
				 }
				 else if(charger_status_G1.stop == Authenticate)
				 {
				 charger_status_G1.stop = Try_To_Stop;
				 charger_status_G1.reson = Local;
				 correct_rfid = 1;
				 charger_status_G1.charging_status = Finishing_ChargerPoint;
				 }
				 else if(charger_status_G3.stop == Authenticate)
				 {
				 charger_status_G3.stop = Try_To_Stop;
				 charger_status_G3.reson = Local;
				 correct_rfid = 1;
				 charger_status_G3.charging_status = Finishing_ChargerPoint;
				 }
				 }*/
			} else if (current_page == 24) {
				for (i = 4; i < 12; i++) {
					tagid[i - 4] = id[i];
				}

				tagid[i - 4] = '\0';

				if (Rfid_Add) {
					strncpy(rfid_data.TagId[Rfid_Add], tagid, 12);
					rfid_data.status[Rfid_Add] = 1;
					LocalListAdding = Rfid_Add;
					enQueue_hmi(2402);		//4.1.4
					Rfid_Add = 0;
				}
				/*
				 if(Rfid_Add == 1)
				 {
				 strcpy(rfid_data_to_flash.TagId[Local_Added],tagid);
				 Clear_Register = 24;
				 }
				 else if(Rfid_Add == 2)
				 {
				 strcpy(OCPP.rfid2,tagid);
				 Clear_Register = 24;
				 }
				 else if(Rfid_Add == 3)
				 {
				 strcpy(OCPP.rfid3,tagid);
				 Clear_Register = 24;
				 }
				 else if(Rfid_Add == 4)
				 {
				 strcpy(OCPP.rfid4,tagid);
				 Clear_Register = 24;
				 }
				 else if(Rfid_Add == 5)
				 {
				 strcpy(OCPP.rfid5,tagid);
				 Clear_Register = 24;
				 }
				 Rfid_Add = 0;
				 */
			}
		}
		//HAL_UART_Receive_DMA(&huart6,id,14);
	} else if (huart->Instance == USART3) {

		__HAL_UART_FLUSH_DRREGISTER(&huart3); // Clear the buffer to prevent overrun

		if (bytecount) {
			hmi_buffer[count++] = hmi_buff;
			bytecount--;
			if (bytecount == 0) {
				HMI_Process(hmi_buffer);
				recieve_complete = 1;
			}
		}
		if (START_FLAG == 1) {
			bytecount = hmi_buff;
			START_FLAG = 0;
			count = 0;
			//HMI_Process(hmi_buffer);
		}
		if ((hmi_buff1 == 0x5a) && (hmi_buff == 0xa5)) {
			START_FLAG = 1;
			//		USART_ClearITPendingBit(&huart3, USART_CR1_RXNEIE);
		}
		hmi_buff1 = hmi_buff;
	}
}
void HAL_ADC_ConvCpltCallback(ADC_HandleTypeDef *hadc) {

}
void HAL_UART_TxCpltCallback(UART_HandleTypeDef *UartHandle) {
	UartReady = SET;
}

char ether_connection_varify(void) {
//	if(validate_ip(OCPP.ether_ip) == NULL)
//	{
//		return 0;
//	}
//	if(validate_ip(OCPP.ether_getway) == NULL)
//	{
//		return 0;
//	}
//	if(validate_ip(OCPP.ether_subnetmask) == NULL)
//	{
//		return 0;
//	}
//
	return 1;
}
int validate_ip(unsigned char *ip) { //check whether the IP is valid or not
//   if (ip == NULL)
//   {
//      return 0;
//   }
//
//  if((ip[0] > 255))// || (ip[1] > 255) (ip[2] > 255) || (ip[3] > 255))
//   {
//	   return 0;
//   }
//      return 1;
}
char wifi_connection_varify(void) {
	if (OCPP.wifi_ssid == NULL) {
		return 0;
	}
	return 1;
}
void delay_ms(uint32_t mS) {
	millisec = mS;
	while (millisec) {
		;
	}
}

/* USER CODE END 1 */
/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
