/*
 * hmi.c
 *
 *  Created on: Aug 4, 2021
 *      Author: lubi
 */
/**************INCLUDE BLOCK**************/

#include "modbus.h"
#include "main.h"
#include "usart.h"
#include "OCPP.h"
#include "w25qxx.h"
#include "hmi.h"

/***********INCLUDE BLOCK END*************/

/***** Data Type, Constant, and Macro Definitions *****/

/* Global variables*/

uint8_t gunrunning_flag = 0;
uint8_t incorrect_rfid, correct_rfid;
char rtc_ocpp_flag;
extern uint8_t RCD1_stop, RCD2_stop, RCD3_stop;
int timer_temp = 0;
unsigned char toggle;
volatile extern uint8_t LocalListAdding, Local_List_Update;
extern uint8_t CURRENT_STATE, CURRENT_STATE_1;
//////--fota upadte var---//
#if defined(NAYARA)
extern uint16_t GasDetection;
#endif

extern char fw_update, Send_meter;

/////////////////////////////
/////////4g changes////////////////
char network_switch_flag = 0;
/////////////////////////////////
/////////////4.1.4 changes///////
extern uint8_t Store_Key_Parameter;
///////////////////////////////////
//////////////////V4.x.7 changes//////////////////////
extern int strcmp_1(unsigned char *b, unsigned char *a);
extern int strlen_1(unsigned char *data);

///////////////V4.x.8//////////////////////////
///////////////V4.x.8//////////////////////////
extern unsigned char hmi_resetCause;
extern reset_cause_t reset_cause;	//v4.x.8
//////////////////////////////////////////////////////
//V501change
volatile uint8_t HMI_alarmstsupdate;
extern uint16_t hmicp_val, hmicp_val_1;
//V501change
void HMI_Process(unsigned char hmi[]) {
	unsigned char i;
	if (hmi[0] == 0x83) {
		if ((hmi[2] == 0x14) && (hmi[1] == 0x00)) {
			//	HMI_Page(hmi[6]);
			current_page = hmi[5];
			//if(current_page == 0)
			{
				//HMI_Send(1);
				//HMI_Send(204);
			}
		}
		//else if((hmi[2] == (uint8_t)Main_Button) && (hmi[1] == (uint8_t)(Main_Button >> 8)))
		else if ((hmi[2] == 0x40) && (hmi[1] == 0x10)) {
			if (hmi[5] != 0) {
				//Touch_Action = Main_screen;
				Main_Page = hmi[5]; //Main Page
			}
		} else if ((hmi[2] == (uint8_t) Authentication_RFid_Button)
				&& (hmi[1] == (uint8_t) (Authentication_RFid_Button >> 8))) {
			if (hmi[5] != 0) {
				Authentic_Page = hmi[5]; //Authorization
				//Touch_Action = Authentication_screen;
			}
		} else if ((hmi[2] == (uint8_t) Admin_Password_Button)
				&& (hmi[1] == (uint8_t) (Admin_Password_Button >> 8))) {
			if (hmi[5] != 0) {
				Admin_Pass_Page = hmi[5]; //Admin Password
				//Touch_Action = Admin_Password_screen;
			}
		} else if ((hmi[2] == (unsigned char) Admin_Menu_Button)
				&& (hmi[1] == (unsigned char) (Admin_Menu_Button >> 8))) {
			if (hmi[5] != 0) {
				Admin_Setting_Page = hmi[5]; // Admin Setting
				//Touch_Action = Admin_Menu_screen;
			}
		} else if ((hmi[2] == (unsigned char) Network_Button)
				&& (hmi[1] == (unsigned char) (Network_Button >> 8))) {
			if (hmi[5] != 0) {
				WI_fi_Page = hmi[5]; // wifi
				//Touch_Action = Network_screen;
			}
		} else if ((hmi[2] == (unsigned char) OCPP_Button)
				&& (hmi[1] == (unsigned char) (OCPP_Button >> 8))) {
			if (hmi[5] != 0) {
				OCPP_Page = hmi[5]; // ocpp
				//Touch_Action = OCPP_screen;
			}
		} else if ((hmi[2] == (unsigned char) fwupgrade_Button)
				&& (hmi[1] == (unsigned char) (fwupgrade_Button >> 8))) {
			if (hmi[5] != 0) {
				fw_Page = hmi[5]; // firmware upgrade
				//Touch_Action = OCPP_screen;
			}
		} else if ((hmi[2] == (unsigned char) production_Button)
				&& (hmi[1] == (unsigned char) (production_Button >> 8))) {
			if (hmi[5] != 0) {
				production_page = hmi[5]; //Production Page
			}
		}
		//////////////////4G CHANGES///////////////////

		else if ((hmi[2] == (unsigned char) GSM_Button)
				&& (hmi[1] == (unsigned char) (GSM_Button >> 8))) {
			if (hmi[5] != 0) {
				gsm_page = hmi[5]; // gsm
				//Touch_Action = OCPP_screen;
			}
		} else if ((hmi[2] == (unsigned char) ethernet_button)
				&& (hmi[1] == (unsigned char) (ethernet_button >> 8))) {
			if (hmi[5] != 0) {
				ethernet_page = hmi[5]; // ethernet
				//Touch_Action = OCPP_screen;
			}
		} else if ((hmi[2] == (unsigned char) wifi_button)
				&& (hmi[1] == (unsigned char) (wifi_button >> 8))) {
			if (hmi[5] != 0) {
				wifi_page = hmi[5]; //wifi Page
			}
		}

		/////////////////////////////////////////////
		////////////V4.1.0//////////////////////////
		else if ((hmi[2] == (unsigned char) congifmenu_button)
				&& (hmi[1] == (unsigned char) (congifmenu_button >> 8))) {
			if (hmi[5] != 0) {
				configmenu_page = hmi[5]; //configmenu Page
			}
		}
		////////////////////////////////////////////
		/*else if((hmi[2] == 0x09) &&( hmi[1] == 0x80))
		 {
		 if(hmi[5] != 0)
		 {
		 GUN_Page = hmi[5]; // gun
		 if(GUN_Page > 2)
		 {
		 OCPP.charger_rating = GUN_Page;
		 }
		 Touch_Action = 7;
		 }
		 }*/
		else if ((hmi[2] == (unsigned char) history_Button)
				&& (hmi[1] == (unsigned char) (history_Button >> 8))) {
			if (hmi[5] != 0) {
				history_page = hmi[5]; // gun
				//Touch_Action = History_screen;
			}
		} else if ((hmi[2] == (unsigned char) Gun_reading_Button)
				&& (hmi[1] == (unsigned char) (Gun_reading_Button >> 8))) {
			if (hmi[5] != 0) {
				Gun_parameter = hmi[5]; // gun

				//if(GUN_Page > 2)
				{
					//charger_rating = GUN_Page;
					//OCPP.charger_rating = GUN_Page;
				}
				//Touch_Action = Gun_Reading_screen;
			}
		} else if ((hmi[2] == (unsigned char) Protection_Button)
				&& (hmi[1] == (unsigned char) (Protection_Button >> 8))) {
			if (hmi[5] != 0) {
				Protection_Page = hmi[5]; // gun
				//Touch_Action = Protection_screen;
			}
		}
//V501change
		else if ((hmi[2] == (unsigned char) cp_config)
				&& (hmi[1] == (unsigned char) (cp_config >> 8))) {
			if (hmi[5] != 0) {
				cpconfigmenu_page = hmi[5]; // gun
			}
		}
//V501change
		else if ((hmi[2] == (unsigned char) Password_setting_Button)
				&& (hmi[1] == (unsigned char) (Password_setting_Button >> 8))) {
			if (hmi[5] != 0) {
				Password_setting_Page = hmi[5]; // gun
				//Touch_Action = Password_setting_screen;
			}
		} else if ((hmi[2] == (unsigned char) RTC_Button)
				&& (hmi[1] == (unsigned char) (RTC_Button >> 8))) {
			if (hmi[5] != 0) {
				Rtc_Page = hmi[5]; // gun
				//Touch_Action = RTC_screen;
			}
		} else if ((hmi[2] == (uint8_t) select_charging_Button)
				&& (hmi[1] == (uint8_t) (select_charging_Button >> 8))) {
			if (hmi[5] != 0) {
				charging_setting_Page = hmi[5]; // gun
				//Touch_Action = Select_Charging_Screen;
			}
		} else if ((hmi[2] == (unsigned char) charging_setting_Button)
				&& (hmi[1] == (unsigned char) (charging_setting_Button >> 8))) {
			if (hmi[5] != 0) {
				pricing_setting_Page = hmi[5]; // gun
				//Touch_Action = Charging_Setting_screen;
			}
		} else if ((hmi[2] == (unsigned char) Billing_Button)
				&& (hmi[1] == (unsigned char) (Billing_Button >> 8))) {
			if (hmi[5] != 0) {
				Bill_Page = hmi[5]; // gun
				//Touch_Action = Billing_screen;
			}
		} else if ((hmi[2] == (unsigned char) rfid_scan)
				&& (hmi[1] == (unsigned char) (rfid_scan >> 8))) {
			if (hmi[5] != 0) {
				rfid_page = hmi[5]; // gun
				//Touch_Action = rfid_screen;
			}
		} else if ((hmi[2] == 0x00) && (hmi[1] == 0x50)) {
			if (hmi[3] == 5) {
				OCPP.under_voltage = hmi[4];
				OCPP.under_voltage = (OCPP.under_voltage << 8) | hmi[5]; // 5000

				OCPP.over_voltage = hmi[6];
				OCPP.over_voltage = (OCPP.over_voltage << 8) | hmi[7];   // 5001

				OCPP.over_current_AC02 = hmi[8];
				OCPP.over_current_AC02 = (OCPP.over_current_AC02 << 8) | hmi[9]; // 5002

				OCPP.Over_Tempreture = hmi[11];
				/*OCPP.Over_Tempreture = (OCPP.Over_Tempreture << 8) | hmi[11];*/ // 5003
				OCPP.HC_LEL = hmi[13];
				//OCPP.HC_LEL = (OCPP.HC_LEL << 8) | hmi[13];  // 5004

				enQueue_hmi(Admin_Menu_screen);
				write_para = 1;
			}
		} else if ((hmi[2] == 0x10) && (hmi[1] == 0x50)) {
			if (hmi[3] == 3) {
				year = hmi[4];
				month = hmi[5];

				date = hmi[6];
				hour = hmi[7];

				min = hmi[8];
				sec = hmi[9];

				RTC_Set(year, month, date, hour, min, sec, 3);

				//Clear_Register = RTC_screen;
				//	back_page = RTC_screen;
				enQueue_hmi(Admin_Menu_screen);
				RTC_HMI(year, month, date, hour, min, sec);
				//Write_Params();
			}
		} else if ((hmi[2] == 0x10) && (hmi[1] == 0x00)) {
			if (hmi[3] == 4) {
				year = hmi[4];
				month = hmi[5];

				date = hmi[6];
				hour = hmi[8];

				min = hmi[9];
				sec = hmi[10];

				RTC_Set(year, month, date, hour, min, sec, 3);
			}
		} else if ((hmi[2] == 0x20) && (hmi[1] == 0x50)) {
			if (hmi[3] == 2) {
				charge_by_time = hmi[4];
				charge_by_time = (charge_by_time << 8) | hmi[5];

				charging_unit = hmi[6];
				charging_unit = (charging_unit << 8) | hmi[7];

				//Clear_Register =Select_Charging_Screen;
			}
		} else if ((hmi[2] == 0x30) && (hmi[1] == 0x50)) {
			if (hmi[3] == 4) {
				OCPP.energy_charges = hmi[4];
				OCPP.energy_charges = (OCPP.energy_charges << 8) | hmi[5];

				OCPP.time_charges = hmi[6];
				OCPP.time_charges = (OCPP.time_charges << 8) | hmi[7];

				OCPP.energy_charges_AC02 = hmi[8];
				OCPP.energy_charges_AC02 = (OCPP.energy_charges_AC02 << 8)
						| hmi[9];

				OCPP.time_charges_AC02 = hmi[10];
				OCPP.time_charges_AC02 = (OCPP.time_charges_AC02 << 8)
						| hmi[11];

				//Clear_Register = Charging_Setting_screen;
				// HMI_Send(Admin_Menu_screen); //ocpp
				enQueue_hmi(Admin_Menu_screen);
				//		back_page = Charging_Setting_screen;
				write_para = 1;
			}
		} else if ((hmi[2] == 0x40) && (hmi[1] == 0x50)) {
			if (hmi[3] == 3) {
				Total_time = hmi[4];
				Total_time = (Total_time << 8) | hmi[5];

				Total_unit = hmi[6];
				Total_unit = (Total_unit << 8) | hmi[7];

				Total_cost = hmi[8];
				Total_cost = (Total_cost << 8) | hmi[9];

				//Clear_Register = 11;
			}
		} else if ((hmi[1] == 0x10) && (hmi[2] == 0x3d)) {
			if (hmi[3] == 3) {
				otp[0] = hmi[4];
				otp[1] = hmi[5];
				otp[2] = hmi[6];
				otp[3] = hmi[7];
				otp[4] = hmi[8];
				otp[5] = hmi[9];
				otp[6] = '\0';
				//Clear_Register = 1;
			}
		} else if ((hmi[1] == 0x20) && (hmi[2] == 0x00)) {
			if (hmi[3] == 2) {
				HMI_Password[0] = hmi[4];
				HMI_Password[1] = hmi[5];
				HMI_Password[2] = hmi[6];
				HMI_Password[3] = hmi[7];
				HMI_Password[4] = '\0';
				Clear_Register = Admin_Password_screen;
			}
		} else if ((hmi[1] == 0x20) && (hmi[2] == 0x10)) {
			if (hmi[3] == 9) {
				HMI_Password[0] = hmi[4];
				HMI_Password[1] = hmi[5];
				HMI_Password[2] = hmi[6];
				HMI_Password[3] = hmi[7];
				HMI_Password[4] = '\0';

				New_Password[0] = hmi[10];
				New_Password[1] = hmi[11];
				New_Password[2] = hmi[12];
				New_Password[3] = hmi[13];
				New_Password[4] = '\0';

				Re_Password[0] = hmi[16];
				Re_Password[1] = hmi[17];
				Re_Password[2] = hmi[18];
				Re_Password[3] = hmi[19];
				Re_Password[4] = '\0';

				if (strcmp_1(HMI_Password, OCPP.config_password) == 0) {
					if (strcmp_1(New_Password, "7620") == 0) {

					} else if (strcmp_1(New_Password, "2076") == 0) {

					}
//V501change
					else if (strcmp_1(New_Password, "2069") == 0) {

					}
//V501change
					else if (strcmp_1(New_Password, Re_Password) == 0) {
						OCPP.config_password[0] = New_Password[0];
						OCPP.config_password[1] = New_Password[1];
						OCPP.config_password[2] = New_Password[2];
						OCPP.config_password[3] = New_Password[3];
						write_para = 1;
					}
					//	back_page = Password_setting_screen;
					enQueue_hmi(Admin_Menu_screen);
				} else {
					//	Clear_Register = Password_setting_screen;
				}
			}
		}
		///////////////////////4G changes///////////////////////////
		else if ((hmi[1] == 0x40) && (hmi[2] == 0x00)) {
			if (hmi[3] == 16) {
				for (i = 0; i < 16; i++) {
					if (hmi[4 + i] != 0xFF) {
						OCPP.wifi_ssid[i] = hmi[4 + i];
					} else {
						break;
					}
				}
				OCPP.wifi_ssid[i] = '\0';

				for (i = 0; i < 16; i++) {
					if (hmi[20 + i] != 0xFF) {
						OCPP.wifi_password[i] = hmi[20 + i];
					} else {
						break;
					}
				}

				OCPP.wifi_password[i] = '\0';

				//Clear_Register = Network_screen;
				back_page = network_select_screen;
				enQueue_hmi(wifi_screen); //ocpp
				write_para = 1;
				//Write_Params();
				WIFI_Setting = 1;

			}
		} else if ((hmi[1] == 0x40) && (hmi[2] == 0x10)) {
			if (hmi[3] == 6) {
				for (i = 0; i < 4; i++) {
					OCPP.ether_ip[i] = hmi[4 + i];
				}
				OCPP.ether_ip[i] = '\0';

				for (i = 0; i < 4; i++) {
					OCPP.ether_getway[i] = hmi[8 + i];
				}
				OCPP.ether_getway[i] = '\0';

				for (i = 0; i < 4; i++) {
					OCPP.ether_subnetmask[i] = hmi[12 + i];
				}
				OCPP.ether_subnetmask[i] = '\0';
				//Clear_Register = Network_screen;
				back_page = network_select_screen;
				enQueue_hmi(ethernet_screen); //ocpp
				write_para = 1;
				//Write_Params();
				WIFI_Setting = 1;
			}
		}

		else if ((hmi[1] == 0x25) && (hmi[2] == 0x00)) {
			if (hmi[3] == (6 + 16)) {
				for (i = 0; i < 12; i++) {
					if (hmi[4 + i] != 0xFF) {
						GSM.mobile_no[i] = hmi[4 + i];
					} else {
						break;
					}
				}
				GSM.mobile_no[i] = '\0';
				for (i = 0; i < 28; i++) {
					if (hmi[16 + i] != 0xff) {
						OCPP.networkoperator[i] = hmi[16 + i];
					} else {
						break;
					}
				}
				OCPP.networkoperator[i] = '\0';
				//Clear_Register = Network_screen;
				back_page = network_select_screen;
				enQueue_hmi(GSM_screen); //ocpp
				write_para = 1;
				//Write_Params();
				WIFI_Setting = 1;
			}
		}
		/////////////////////////////////////////
		else if ((hmi[1] == 0x2F) && (hmi[2] == 0xFF)) {
			if (hmi[3] == 39) {
				memset(OCPP.ocpp_uri, '\0', sizeof(OCPP.ocpp_uri));
				OCPP.ocpp_status[0] = hmi[5];
				for (i = 0; i < 100; i++) {
					if (hmi[6 + i] != 0xff) {
						OCPP.ocpp_uri[i] = hmi[6 + i];
					} else {
						break;
					}
				}

				OCPP.ocpp_uri[i] = '\0';
				//	Clear_Register = OCPP_screen;
				//	Write_Params();
				//	OCPP_setting = 1;
			}
		} else if ((hmi[1] == 0x30) && (hmi[2] == 0x40)) {
			if (hmi[3] == 42) {
				memset(OCPP.OCPP_servername, '\0',
						sizeof(OCPP.OCPP_servername));
				memset(OCPP.OCPP_username, '\0', sizeof(OCPP.OCPP_username));
				memset(OCPP.OCPP_Password, '\0', sizeof(OCPP.OCPP_Password));
				memset(OCPP.OCPP_Port, '\0', sizeof(OCPP.OCPP_Port));

				for (i = 0; i < 30; i++) {
					if (hmi[4 + i] != 0xff) {
						OCPP.OCPP_servername[i] = hmi[4 + i];
					} else {
						break;
					}
				}
				OCPP.OCPP_servername[i] = '\0';
				for (i = 0; i < 20; i++) {
					if (hmi[36 + i] != 0xff) {
						OCPP.OCPP_username[i] = hmi[36 + i];
					} else {
						break;
					}
				}
				OCPP.OCPP_username[i] = '\0';

				for (i = 0; i < 20; i++) {
					if (hmi[58 + i] != 0xff) {
						OCPP.OCPP_Password[i] = hmi[58 + i];
					} else {
						break;
					}
				}
				OCPP.OCPP_Password[i] = '\0';

				for (i = 0; i < 6; i++) {
					if (hmi[80 + i] != 0xff) {
						OCPP.OCPP_Port[i] = hmi[80 + i];
					} else {
						break;
					}
				}
				OCPP.OCPP_Port[i] = '\0';
				//Clear_Register = OCPP_screen;
				//back_page =OCPP_screen;
				enQueue_hmi(Admin_Menu_screen);
				//Write_Params();
				write_para = 1;
				OCPP_setting = 1;
			}
		} else if ((hmi[1] == 0x35) && (hmi[2] == 0x00)) {
			if (hmi[3] == 39) {
				memset(OCPP.fw_uri, '\0', sizeof(OCPP.fw_uri));
				//ocpp_status= hmi[5];
				for (i = 0; i < 100; i++) {
					if (hmi[4 + i] != 0xff) {
						OCPP.fw_uri[i] = hmi[4 + i];
					} else {
						break;
					}
				}
				OCPP.fw_uri[i] = '\0';
				//	Clear_Register = OCPP_screen;
				//	Write_Params();
				//	OCPP_setting = 1;
			}
		} else if ((hmi[1] == 0x35) && (hmi[2] == 0x40)) {
			if (hmi[3] == 41) {
				memset(OCPP.fw_servername, '\0', sizeof(OCPP.fw_servername));
				memset(OCPP.fw_username, '\0', sizeof(OCPP.fw_username));
				memset(OCPP.fw_Password, '\0', sizeof(OCPP.fw_Password));
				memset(OCPP.fw_Port, '\0', sizeof(OCPP.fw_Port));
				for (i = 0; i < 30; i++) {
					if (hmi[4 + i] != 0xff) {
						OCPP.fw_servername[i] = hmi[4 + i];
					} else {
						break;
					}
				}
				OCPP.fw_servername[i] = '\0';
				for (i = 0; i < 20; i++) {
					if (hmi[36 + i] != 0xff) {
						OCPP.fw_username[i] = hmi[36 + i];
					} else {
						break;
					}
				}
				OCPP.fw_username[i] = '\0';
				for (i = 0; i < 20; i++) {
					if (hmi[58 + i] != 0xff) {
						OCPP.fw_Password[i] = hmi[58 + i];
					} else {
						break;
					}
				}
				OCPP.fw_Password[i] = '\0';
				for (i = 0; i < 4; i++) {
					if (hmi[80 + i] != 0xff) {
						OCPP.fw_Port[i] = hmi[80 + i];
					} else {
						break;
					}
				}
				OCPP.fw_Port[i] = '\0';
				OCPP.fw_status = 64;
				//Clear_Register = OCPP_screen;
				fw_update = 1;
				//back_page = Firmware_upgrade_screen;
				enQueue_hmi(Admin_Menu_screen);
				write_para = 1;
			}
		} else if ((hmi[1] == 0x35) && (hmi[2] == 0x70)) {
			if (hmi[3] == 16) {
				memset(OCPP.vendor_id, '\0', sizeof(OCPP.vendor_id));
				memset(OCPP.serial_no, '\0', sizeof(OCPP.serial_no));
				for (i = 0; i < 14; i++) {
					if (hmi[4 + i] != 0xff) {
						OCPP.serial_no[i] = hmi[4 + i];
					} else {
						break;
					}
				}
				OCPP.serial_no[i] = '\0';
				for (i = 0; i < 14; i++) {
					if (hmi[20 + i] != 0xff) {
						OCPP.vendor_id[i] = hmi[20 + i];
					} else {
						break;
					}
				}
				OCPP.vendor_id[i] = '\0';
				//Clear_Register = OCPP_screen;
				//back_page =production_screen;
				enQueue_hmi(Admin_Menu_screen);
				//Write_Params();
				write_para = 1;
			}
		}
//V501change
		else if ((hmi[1] == 0x36) && (hmi[2] == 0x00)) {
			if (hmi[3] == 5) {
				OCPP.STATE_A_LEVEL = hmi[4];
				OCPP.STATE_A_LEVEL = (OCPP.STATE_A_LEVEL << 8) | hmi[5];

				OCPP.STATE_B_LEVEL = hmi[6];
				OCPP.STATE_B_LEVEL = (OCPP.STATE_B_LEVEL << 8) | hmi[7];

				OCPP.STATE_C_LEVEL = hmi[8];
				OCPP.STATE_C_LEVEL = (OCPP.STATE_C_LEVEL << 8) | hmi[9];

				OCPP.STATE_D_LEVEL = hmi[10];
				OCPP.STATE_D_LEVEL = (OCPP.STATE_D_LEVEL << 8) | hmi[11];

				OCPP.auxinput = hmi[12];
				OCPP.auxinput = (OCPP.auxinput << 8) | hmi[13];

				enQueue_hmi(Admin_Menu_screen);

				//Write_Params();
				write_para = 1;
			}
		}
		//V501change
	} else if (hmi[0] == 0x82) {
		if ((hmi[1] == 0x4f) && (hmi[2] == 0x4b)) {
			;
		}
	}
//	HMI_Send(103);
}

/**
 * @brief Send HMI (Human-Machine Interface) data based on the current page.
 *
 * This function sends specific HMI data based on the provided current_page value.
 *
 * @param[in] current_page The current page for which HMI data needs to be sent.
 *                         Valid values are 0, 1, 2, etc., representing different pages.
 *
 * @return NA
 */
void HMI_Send(int current_page) {
	switch (current_page) {
	case 0:
		SET_TOUCH[9] = 0x00; //PAGE 0 logo
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 1:
		SET_TOUCH[9] = 0x01; //page 1 Main
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		//remote_start = 0;
		break;
	case 2:
		SET_TOUCH[9] = 0x02; //PAGE 2 Authentication Page
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 5:
		SET_TOUCH[9] = 0x05; //page 5  Admin Password
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 6:
		SET_TOUCH[9] = 6; //Admin Menu
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 8:
		SET_TOUCH[9] = 8; //OCPP
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 9:
		SET_TOUCH[9] = 9; //Network
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 12:
		SET_TOUCH[9] = 12; //Protection
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 13:
		SET_TOUCH[9] = 13; //Gun Reading
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 14:
		SET_TOUCH[9] = 14; //Password Setting
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 16:
		SET_TOUCH[9] = 16; //RTC
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 17:
		SET_TOUCH[9] = 17; //Select Charging
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 18:
		SET_TOUCH[9] = 18; //charging setting
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 19:
		SET_TOUCH[9] = 19; //Billing
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 20:
		SET_TOUCH[9] = 20; //History
		timer_temp = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 24:
		SET_TOUCH[9] = 24; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 27:
		SET_TOUCH[9] = 27; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 28:
		SET_TOUCH[9] = 28; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 29:
		SET_TOUCH[9] = 29; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 30:
		SET_TOUCH[9] = 30; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 31:
		SET_TOUCH[9] = 31; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 32:
		SET_TOUCH[9] = 32; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 33:
		SET_TOUCH[9] = 33; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 34:
		SET_TOUCH[9] = 34; //Rfid scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 35:
		SET_TOUCH[9] = 35; //firmware Upgrade
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 37:
		SET_TOUCH[9] = 37; //Production Upgrade
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
		////////////4G changes ////////////////
	case 38:
		SET_TOUCH[9] = 38; //netework select screen
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 40:
		SET_TOUCH[9] = 40; //gsm parameters scan
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 42:
		SET_TOUCH[9] = 42; //ethernet screen
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
	case 44:
		SET_TOUCH[9] = 44; //wifi scrren
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
		///////////////////////////////////
		/////////v4.1.0////////////
	case 46:
		SET_TOUCH[9] = 46; //wifi scrren
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
///////////////////////////
//V501change
	case 48:
		SET_TOUCH[9] = 48; //cp_val scrren
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) SET_TOUCH, 10);
		break;
//V501change

	case 50:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x31;  //ocpp connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x01;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 51:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x31;  //ocpp disconnect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 52:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x32;  //wi-fi connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x01;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 53:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x32;  //wi-fi disconnect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 54:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x33;  //gun1 not connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x02;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 55:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x33;  //gun1 charging
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 56:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x33;  //gun1 fault
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x01;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 57:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x34;  //gun2 not connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x02;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 58:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x34;  //gun2 charging
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 59:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x34;  //gun2 fault
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x01;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 60:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x35;  //gun3 not connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x02;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 61:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x35;  //gun3 charging
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 62:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x35;  //gun3 fault
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x01;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;

	case 63:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x33;  //gun1 connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x03;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 64:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x34;  //gun2 connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x03;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;

	case 65:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x35;  //gun2 connect
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x03;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;

	case 66:							//V5.0.0A CHNAGES////////////////
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x37;  //alarm status update
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = alarmstatus;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;

//	case 70:
//			WRITE_TOUCH[2] = 0x08;
//			WRITE_TOUCH[4] = 0x10;
//			WRITE_TOUCH[5] = 0x60;  //gun1 move
//			WRITE_TOUCH[6] = 'G';
//			WRITE_TOUCH[7] = 'U';
//			WRITE_TOUCH[8] = 'N';
//			WRITE_TOUCH[9] = '-';
//			WRITE_TOUCH[10] = '1';
//			HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,11);
//			break;
//		case 71:
//			WRITE_TOUCH[2] = 0x08;
//			WRITE_TOUCH[4] = 0x10;
//			WRITE_TOUCH[5] = 0x60;  //gun2 move
//			WRITE_TOUCH[6] = 'G';
//			WRITE_TOUCH[7] = 'U';
//			WRITE_TOUCH[8] = 'N';
//			WRITE_TOUCH[9] = '-';
//			WRITE_TOUCH[10] = '2';
//			HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,11);
//			break;
//		case 72:
//			WRITE_TOUCH[2] = 0x08;
//			WRITE_TOUCH[4] = 0x10;
//			WRITE_TOUCH[5] = 0x60;  //gun3 move
//			WRITE_TOUCH[6] = 'G';
//			WRITE_TOUCH[7] = 'U';
//			WRITE_TOUCH[8] = 'N';
//			WRITE_TOUCH[9] = '-';
//			WRITE_TOUCH[10] = '3';
//			HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,11);
//			break;
	case 96:
		WRITE_TOUCH[2] = 17; //Unavailable_ChargerPoint
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'U';
		WRITE_TOUCH[7] = 'n';
		WRITE_TOUCH[8] = 'a';
		WRITE_TOUCH[9] = 'v';
		WRITE_TOUCH[10] = 'a';
		WRITE_TOUCH[11] = 'i';
		WRITE_TOUCH[12] = 'l';
		WRITE_TOUCH[13] = 'a';
		WRITE_TOUCH[14] = 'b';
		WRITE_TOUCH[15] = 'l';
		WRITE_TOUCH[16] = 'e';
		WRITE_TOUCH[17] = ' ';
		WRITE_TOUCH[18] = ' ';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
	case 97:
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) PIC_NOW, 7);
		break;
	case 98:
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) RTC_READ, 7);
		break;
	case 99:
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) RTC_OCPP, 14);
		break;
	case 100:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x10; //(unsigned char)(Main_Button >> 8);
		READ_TOUCH[5] = 0x40; //(unsigned char)(Main_Button);
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) READ_TOUCH, 7);
		//read touch
		break;
	case 101:
		WRITE_TOUCH[2] = 0x09;
		WRITE_TOUCH[4] = (unsigned char) (Main_Button >> 8);
		;
		WRITE_TOUCH[5] = (unsigned char) (Main_Button);
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		//touch = 0;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 102:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x3A;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
		//write touch
	case 103:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x3A;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x01;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 104:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x3A;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x02;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 105:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x3A;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x03;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 106:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x3A;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x04;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 107:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x3A;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x05;
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 108:
		///////////////V3.3.1////////////////////////////////////////////////
		if (charger_status_G1.error == GroundFailure
				|| charger_status_G2.error == GroundFailure) {
			WRITE_TOUCH[2] = 17;
			WRITE_TOUCH[4] = 0x10;
			WRITE_TOUCH[5] = 0x20;
			WRITE_TOUCH[6] = 'G';
			WRITE_TOUCH[7] = 'r';
			WRITE_TOUCH[8] = 'o';
			WRITE_TOUCH[9] = 'u';
			WRITE_TOUCH[10] = 'n';
			WRITE_TOUCH[11] = 'd';
			WRITE_TOUCH[12] = ' ';
			WRITE_TOUCH[13] = 'F';
			WRITE_TOUCH[14] = 'a';
			WRITE_TOUCH[15] = 'u';
			WRITE_TOUCH[16] = 'l';
			WRITE_TOUCH[17] = 't';
			WRITE_TOUCH[18] = ' ';
			WRITE_TOUCH[19] = ' ';
		} else if (charger_status_G1.error == PowerSwitchFailure
				|| charger_status_G2.error == PowerSwitchFailure) {
			WRITE_TOUCH[2] = 17;
			WRITE_TOUCH[4] = 0x10;
			WRITE_TOUCH[5] = 0x20;
			WRITE_TOUCH[6] = 'P';
			WRITE_TOUCH[7] = 'O';
			WRITE_TOUCH[8] = 'W';
			WRITE_TOUCH[9] = 'E';
			WRITE_TOUCH[10] = 'R';
			WRITE_TOUCH[11] = ' ';
			WRITE_TOUCH[12] = 'F';
			WRITE_TOUCH[13] = 'A';
			WRITE_TOUCH[14] = 'I';
			WRITE_TOUCH[15] = 'L';
			WRITE_TOUCH[16] = 'U';
			WRITE_TOUCH[17] = 'R';
			WRITE_TOUCH[18] = 'E';
			WRITE_TOUCH[19] = ' ';
		} else if (charger_status_G1.error == InternalError
				&& charger_status_G1.reson
						== EmergencyStop/*|| charger_status_G2.error == InternalError*/) {
			WRITE_TOUCH[2] = 17;
			WRITE_TOUCH[4] = 0x10;
			WRITE_TOUCH[5] = 0x20;
			WRITE_TOUCH[6] = 'E';
			WRITE_TOUCH[7] = 'M';
			WRITE_TOUCH[8] = 'E';
			WRITE_TOUCH[9] = 'R';
			WRITE_TOUCH[10] = 'G';
			WRITE_TOUCH[11] = 'E';
			WRITE_TOUCH[12] = 'N';
			WRITE_TOUCH[13] = 'C';
			WRITE_TOUCH[14] = 'Y';
			WRITE_TOUCH[15] = ' ';
			WRITE_TOUCH[16] = 'S';
			WRITE_TOUCH[17] = 'T';
			WRITE_TOUCH[18] = 'O';
			WRITE_TOUCH[19] = 'P';
		} else if (charger_status_G1.error == InternalError
				&& charger_status_G1.reson
						== Local/*|| charger_status_G2.error == InternalError*/) {
			WRITE_TOUCH[2] = 17;
			WRITE_TOUCH[4] = 0x10;
			WRITE_TOUCH[5] = 0x20;
			WRITE_TOUCH[6] = 'R';
			WRITE_TOUCH[7] = 'C';
			WRITE_TOUCH[8] = 'D';
			WRITE_TOUCH[9] = ' ';
			WRITE_TOUCH[10] = 'T';
			WRITE_TOUCH[11] = 'R';
			WRITE_TOUCH[12] = 'I';
			WRITE_TOUCH[13] = 'P';
			WRITE_TOUCH[14] = 'P';
			WRITE_TOUCH[15] = 'E';
			WRITE_TOUCH[16] = 'D';
			WRITE_TOUCH[17] = ' ';
			WRITE_TOUCH[18] = ' ';
			WRITE_TOUCH[19] = ' ';
		} else if (charger_status_G1.error == OtherError
				|| charger_status_G2.error == OtherError) {
			WRITE_TOUCH[2] = 17;
			WRITE_TOUCH[4] = 0x10;
			WRITE_TOUCH[5] = 0x20;
			WRITE_TOUCH[6] = 'H';
			WRITE_TOUCH[7] = 'C';
			WRITE_TOUCH[8] = ' ';
			WRITE_TOUCH[9] = 'D';
			WRITE_TOUCH[10] = 'E';
			WRITE_TOUCH[11] = 'T';
			WRITE_TOUCH[12] = 'E';
			WRITE_TOUCH[13] = 'C';
			WRITE_TOUCH[14] = 'T';
			WRITE_TOUCH[15] = 'E';
			WRITE_TOUCH[16] = 'D';
			WRITE_TOUCH[17] = ' ';
			WRITE_TOUCH[18] = ' ';
			WRITE_TOUCH[19] = ' ';
		} else if (charger_status_G1.error == HighTemperature
				|| charger_status_G2.error == HighTemperature) {
			WRITE_TOUCH[2] = 17;
			WRITE_TOUCH[4] = 0x10;
			WRITE_TOUCH[5] = 0x20;
			WRITE_TOUCH[6] = 'H';
			WRITE_TOUCH[7] = 'I';
			WRITE_TOUCH[8] = 'G';
			WRITE_TOUCH[9] = 'H';
			WRITE_TOUCH[10] = 'T';
			WRITE_TOUCH[11] = 'E';
			WRITE_TOUCH[12] = 'M';
			WRITE_TOUCH[13] = 'P';
			WRITE_TOUCH[14] = 'E';
			WRITE_TOUCH[15] = 'R';
			WRITE_TOUCH[16] = 'A';
			WRITE_TOUCH[17] = 'T';
			WRITE_TOUCH[18] = 'U';
			WRITE_TOUCH[19] = 'R';
		} else {
			WRITE_TOUCH[2] = 17;
			WRITE_TOUCH[4] = 0x10;
			WRITE_TOUCH[5] = 0x20;
			WRITE_TOUCH[6] = 'E';
			WRITE_TOUCH[7] = 'R';
			WRITE_TOUCH[8] = 'R';
			WRITE_TOUCH[9] = 'O';
			WRITE_TOUCH[10] = 'R';
			WRITE_TOUCH[11] = ':';
			if (charger_status_G1.error == UnderVoltage) {
				WRITE_TOUCH[12] = 'U';
				WRITE_TOUCH[13] = 'V';
			} else if (charger_status_G1.error == OverVoltage) {
				WRITE_TOUCH[12] = 'O';
				WRITE_TOUCH[13] = 'V';
			} else if (charger_status_G1.error == OverCurrentFailure) {
				WRITE_TOUCH[12] = 'O';
				WRITE_TOUCH[13] = 'C';
			} else if (charger_status_G1.error == PowerMeterFailure) {
				WRITE_TOUCH[12] = 'P';
				WRITE_TOUCH[13] = 'F';
			}

			WRITE_TOUCH[14] = ' ';
			WRITE_TOUCH[15] = ' ';
			WRITE_TOUCH[16] = ' ';
			WRITE_TOUCH[17] = ' ';
			WRITE_TOUCH[18] = ' ';
			WRITE_TOUCH[19] = ' ';
			////GUN2
//					if(charger_status_G2.error == UnderVoltage )
//					{
//						WRITE_TOUCH[15] = 'U';
//						WRITE_TOUCH[16] = 'V';
//					}
//					else if(charger_status_G2.error == OverVoltage )
//					{
//						WRITE_TOUCH[15] = 'O';
//						WRITE_TOUCH[16] = 'V';
//					}
//					else if(charger_status_G2.error == OverCurrentFailure )
//					{
//						WRITE_TOUCH[15] = 'O';
//						WRITE_TOUCH[16] = 'C';
//					}
//					else if(charger_status_G2.error == PowerMeterFailure )
//					{
//						WRITE_TOUCH[15] = 'P';
//						WRITE_TOUCH[16] = 'F';
//					}
//					WRITE_TOUCH[17] = ' ';
//					//GUN3
//					if(charger_status_G3.error == UnderVoltage )
//					{
//						WRITE_TOUCH[18] = 'U';
//						WRITE_TOUCH[19] = 'V';
//					}
//					else if(charger_status_G3.error == OverVoltage )
//					{
//						WRITE_TOUCH[18] = 'O';
//						WRITE_TOUCH[19] = 'V';
//					}
//					else if(charger_status_G3.error == OverCurrentFailure )
//					{
//						WRITE_TOUCH[18] = 'O';
//						WRITE_TOUCH[19] = 'C';
//					}
//					else if(charger_status_G3.error == PowerMeterFailure )
//					{
//						WRITE_TOUCH[18] = 'P';
//						WRITE_TOUCH[19] = 'F';
//					}
			//WRITE_TOUCH[18] = ' ';
			//WRITE_TOUCH[19] = ' ';
		}
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;

		//////////////////////////////////////////////////////////////////////////
	case 109:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'N';
		WRITE_TOUCH[7] = 'o';
		WRITE_TOUCH[8] = ' ';
		WRITE_TOUCH[9] = 'E';
		WRITE_TOUCH[10] = 'r';
		WRITE_TOUCH[11] = 'r';
		WRITE_TOUCH[12] = 'o';
		WRITE_TOUCH[13] = 'r';
		WRITE_TOUCH[14] = ' ';
		WRITE_TOUCH[15] = ' ';
		WRITE_TOUCH[16] = ' ';
		WRITE_TOUCH[17] = ' ';
		WRITE_TOUCH[18] = ' ';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 110:
		HAL_UART_Transmit_DMA(&huart3, charger_status_G1.hmi, 22);
		break;
	case 120:
		HAL_UART_Transmit_DMA(&huart3, charger_status_G2.hmi, 22);
		break;
	case 121:
		HAL_UART_Transmit_DMA(&huart3, charger_status_G3.hmi, 22);
		break;
	case 111:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x80;
		WRITE_TOUCH[5] = 0x07;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00; // start
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 112:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = 0x80;
		WRITE_TOUCH[5] = 0x07;
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x01; //stop
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 113:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'E';
		WRITE_TOUCH[7] = 'V';
		WRITE_TOUCH[8] = ' ';
		WRITE_TOUCH[9] = 'C';
		WRITE_TOUCH[10] = 'h';
		WRITE_TOUCH[11] = 'a';
		WRITE_TOUCH[12] = 'r';
		WRITE_TOUCH[13] = 'g';
		WRITE_TOUCH[14] = 'i';
		WRITE_TOUCH[15] = 'n';
		WRITE_TOUCH[16] = 'g';
		WRITE_TOUCH[17] = ' ';
		WRITE_TOUCH[18] = ' ';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 114:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'E';
		WRITE_TOUCH[7] = 'M';
		WRITE_TOUCH[8] = 'E';
		WRITE_TOUCH[9] = 'R';
		WRITE_TOUCH[10] = 'G';
		WRITE_TOUCH[11] = 'E';
		WRITE_TOUCH[12] = 'N';
		WRITE_TOUCH[13] = 'C';
		WRITE_TOUCH[14] = 'Y';
		WRITE_TOUCH[15] = ' ';
		WRITE_TOUCH[16] = 'S';
		WRITE_TOUCH[17] = 'T';
		WRITE_TOUCH[18] = 'O';
		WRITE_TOUCH[19] = 'P';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;

	case 224:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'R';
		WRITE_TOUCH[7] = 'C';
		WRITE_TOUCH[8] = 'D';
		WRITE_TOUCH[9] = ' ';
		WRITE_TOUCH[10] = 'F';
		WRITE_TOUCH[11] = 'A';
		WRITE_TOUCH[12] = 'I';
		WRITE_TOUCH[13] = 'L';
		WRITE_TOUCH[14] = ':';
		if (RCD1_stop)
			WRITE_TOUCH[15] = '1';
		else
			WRITE_TOUCH[15] = '-';
		WRITE_TOUCH[16] = ',';
		if (RCD2_stop)
			WRITE_TOUCH[17] = '2';
		else
			WRITE_TOUCH[17] = '-';
		WRITE_TOUCH[18] = ',';
		if (RCD3_stop)
			WRITE_TOUCH[19] = '3';
		else
			WRITE_TOUCH[19] = '-';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 225:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'P';
		WRITE_TOUCH[7] = 'M';
		WRITE_TOUCH[8] = ' ';
		WRITE_TOUCH[9] = 'E';
		WRITE_TOUCH[10] = 'R';
		WRITE_TOUCH[11] = 'R';
		WRITE_TOUCH[12] = 'O';
		WRITE_TOUCH[13] = 'R';
		WRITE_TOUCH[14] = ':';
		if (charger_status_G1.error == PowerMeterFailure)
			WRITE_TOUCH[15] = '1';
		else
			WRITE_TOUCH[15] = '-';
		WRITE_TOUCH[16] = ',';
		if (charger_status_G2.error == PowerMeterFailure)
			WRITE_TOUCH[17] = '2';
		else
			WRITE_TOUCH[17] = '-';
		WRITE_TOUCH[18] = ',';
		if (charger_status_G3.error == PowerMeterFailure)
			WRITE_TOUCH[19] = '3';
		else
			WRITE_TOUCH[19] = '-';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 226:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'P';
		WRITE_TOUCH[7] = 'O';
		WRITE_TOUCH[8] = 'W';
		WRITE_TOUCH[9] = 'E';
		WRITE_TOUCH[10] = 'R';
		WRITE_TOUCH[11] = ' ';
		WRITE_TOUCH[12] = 'F';
		WRITE_TOUCH[13] = 'A';
		WRITE_TOUCH[14] = 'I';
		WRITE_TOUCH[15] = 'L';
		WRITE_TOUCH[16] = 'U';
		WRITE_TOUCH[17] = 'R';
		WRITE_TOUCH[18] = 'E';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
//	case 227:
//					WRITE_TOUCH[2] = 17;
//					WRITE_TOUCH[4] = 0x10;
//					WRITE_TOUCH[5] = 0x20;
//					WRITE_TOUCH[6] = 'A';
//					WRITE_TOUCH[7] = 'L';
//					WRITE_TOUCH[8] = 'L';
//					WRITE_TOUCH[9] = ' ';
//					WRITE_TOUCH[10] = 'R';
//					WRITE_TOUCH[11] = 'C';
//					WRITE_TOUCH[12] = 'D';
//					WRITE_TOUCH[13] = ' ';
//					WRITE_TOUCH[14] = 'F';
//					WRITE_TOUCH[15] = 'A';
//					WRITE_TOUCH[16] = 'I';
//					WRITE_TOUCH[17] = 'L';
//					WRITE_TOUCH[18] = 'E';
//					WRITE_TOUCH[19] = 'D';
//					HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,20);
//					break;
	case 115:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'U';
		WRITE_TOUCH[7] = 'N';
		WRITE_TOUCH[8] = 'D';
		WRITE_TOUCH[9] = 'E';
		WRITE_TOUCH[10] = 'R';
		WRITE_TOUCH[11] = ' ';
		WRITE_TOUCH[12] = 'V';
		WRITE_TOUCH[13] = 'O';
		WRITE_TOUCH[14] = 'L';
		WRITE_TOUCH[15] = 'T';
		WRITE_TOUCH[16] = 'A';
		WRITE_TOUCH[17] = 'G';
		WRITE_TOUCH[18] = 'E';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 116:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'O';
		WRITE_TOUCH[7] = 'V';
		WRITE_TOUCH[8] = 'E';
		WRITE_TOUCH[9] = 'R';
		WRITE_TOUCH[10] = ' ';
		WRITE_TOUCH[11] = 'V';
		WRITE_TOUCH[12] = 'O';
		WRITE_TOUCH[13] = 'L';
		WRITE_TOUCH[14] = 'T';
		WRITE_TOUCH[15] = 'A';
		WRITE_TOUCH[16] = 'G';
		WRITE_TOUCH[17] = 'E';
		WRITE_TOUCH[18] = ' ';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 117:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'G';
		WRITE_TOUCH[7] = 'r';
		WRITE_TOUCH[8] = 'o';
		WRITE_TOUCH[9] = 'u';
		WRITE_TOUCH[10] = 'n';
		WRITE_TOUCH[11] = 'd';
		WRITE_TOUCH[12] = ' ';
		WRITE_TOUCH[13] = 'F';
		WRITE_TOUCH[14] = 'a';
		WRITE_TOUCH[15] = 'u';
		WRITE_TOUCH[16] = 'l';
		WRITE_TOUCH[17] = 't';
		WRITE_TOUCH[18] = ' ';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 118:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x20;
		WRITE_TOUCH[6] = 'O';
		WRITE_TOUCH[7] = 'C';
		WRITE_TOUCH[8] = 'P';
		WRITE_TOUCH[9] = 'P';
		WRITE_TOUCH[10] = ' ';
		WRITE_TOUCH[11] = 'E';
		WRITE_TOUCH[12] = 'r';
		WRITE_TOUCH[13] = 'r';
		WRITE_TOUCH[14] = 'o';
		WRITE_TOUCH[15] = 'r';
		WRITE_TOUCH[16] = ' ';
		WRITE_TOUCH[17] = ' ';
		WRITE_TOUCH[18] = ' ';
		WRITE_TOUCH[19] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 119:
		WRITE_TOUCH[2] = 0x07 + 8;
		WRITE_TOUCH[4] = 0x10;
		WRITE_TOUCH[5] = 0x08; //WRITE BUTTON

		WRITE_TOUCH[6] = (charger_status_G1.charging_time >> 8);
		WRITE_TOUCH[7] = charger_status_G1.charging_time;

		WRITE_TOUCH[9] = charger_status_G1.Bill_Amount; //
		WRITE_TOUCH[8] = (charger_status_G1.Bill_Amount >> 8);

		WRITE_TOUCH[10] = (charger_status_G1.Tempreture >> 8);
		WRITE_TOUCH[11] = charger_status_G1.Tempreture;

		WRITE_TOUCH[13] = GasDetection; //
		WRITE_TOUCH[12] = (GasDetection >> 8);

		WRITE_TOUCH[14] = (charger_status_G3.charging_time >> 8);
		WRITE_TOUCH[15] = charger_status_G3.charging_time;

		WRITE_TOUCH[17] = charger_status_G3.Bill_Amount; //
		WRITE_TOUCH[16] = (charger_status_G3.Bill_Amount >> 8);

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 18, 0xffff);
		break;

	case 200:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (uint8_t) (Authentication_RFid_Button >> 8);
		READ_TOUCH[5] = (uint8_t) Authentication_RFid_Button;
		READ_TOUCH[6] = 0x01; //Read bUTTON
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 201:
		WRITE_TOUCH[2] = 0x09;
		WRITE_TOUCH[4] = (uint8_t) (Authentication_RFid_Button >> 8);
		WRITE_TOUCH[5] = (uint8_t) Authentication_RFid_Button; //WRITE BUTTON
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = 0x00;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;

		/*case 202:
		 READ_TOUCH[2] = 0x04;
		 READ_TOUCH[4] = 0x10;
		 READ_TOUCH[5] = 0x3d;  // OTP
		 READ_TOUCH[6] = 0x03;  //Read Byte
		 HAL_UART_Transmit_DMA(&huart3, (uint8_t*)READ_TOUCH,7);
		 break;
		 case 203:
		 WRITE_TOUCH[2] = 0x09; //write OTP and Enter as 0
		 WRITE_TOUCH[4] = 0x10;
		 WRITE_TOUCH[5] = 0x3D;
		 WRITE_TOUCH[6] = '-';
		 WRITE_TOUCH[7] = '-';
		 WRITE_TOUCH[8] = '-';
		 WRITE_TOUCH[9] = '-';
		 WRITE_TOUCH[10]= '-';
		 WRITE_TOUCH[11]= '-';
		 HAL_UART_Transmit_DMA(&huart3, (uint8_t*)WRITE_TOUCH,12);
		 break;
		 */
	case 204:
		OTP_SUCCESS[2] = 16; //msg success
		OTP_SUCCESS[6] = 'S';
		OTP_SUCCESS[7] = 'U';
		OTP_SUCCESS[8] = 'C';
		OTP_SUCCESS[9] = 'C';
		OTP_SUCCESS[10] = 'E';
		OTP_SUCCESS[11] = 'S';
		OTP_SUCCESS[12] = 'S';
		OTP_SUCCESS[13] = 'F';
		OTP_SUCCESS[14] = 'U';
		OTP_SUCCESS[15] = 'L';
		OTP_SUCCESS[16] = 'L';
		OTP_SUCCESS[17] = ' ';
		OTP_SUCCESS[18] = ' ';
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) OTP_SUCCESS, 19);
		break;
	case 205:
		OTP_SUCCESS[2] = 16; //msg Incorrect otp
		OTP_SUCCESS[6] = 'I';
		OTP_SUCCESS[7] = 'N';
		OTP_SUCCESS[8] = 'C';
		OTP_SUCCESS[9] = 'O';
		OTP_SUCCESS[10] = 'R';
		OTP_SUCCESS[11] = 'R';
		OTP_SUCCESS[12] = 'E';
		OTP_SUCCESS[13] = 'C';
		OTP_SUCCESS[14] = 'T';
		OTP_SUCCESS[15] = ' ';
		OTP_SUCCESS[16] = ' ';
		OTP_SUCCESS[17] = ' ';
		OTP_SUCCESS[18] = ' ';
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) OTP_SUCCESS, 19);
		break;
	case 218:
		OTP_SUCCESS[2] = 16;
		OTP_SUCCESS[6] = 'R';
		OTP_SUCCESS[7] = 'F';
		OTP_SUCCESS[8] = 'I';
		OTP_SUCCESS[9] = 'D';
		OTP_SUCCESS[10] = ' ';
		OTP_SUCCESS[11] = 'V';
		OTP_SUCCESS[12] = 'A';
		OTP_SUCCESS[13] = 'L';
		OTP_SUCCESS[14] = 'I';
		OTP_SUCCESS[15] = 'D';
		OTP_SUCCESS[16] = ' ';
		OTP_SUCCESS[17] = ' ';
		OTP_SUCCESS[18] = ' ';
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) OTP_SUCCESS, 19);
		break;
	case 219:
		OTP_SUCCESS[2] = 16;
		OTP_SUCCESS[6] = 'R';
		OTP_SUCCESS[7] = 'F';
		OTP_SUCCESS[8] = 'I';
		OTP_SUCCESS[9] = 'D';
		OTP_SUCCESS[10] = ' ';
		OTP_SUCCESS[11] = 'I';
		OTP_SUCCESS[12] = 'N';
		OTP_SUCCESS[13] = 'V';
		OTP_SUCCESS[14] = 'A';
		OTP_SUCCESS[15] = 'L';
		OTP_SUCCESS[16] = 'I';
		OTP_SUCCESS[17] = 'D';
		OTP_SUCCESS[18] = ' ';
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) OTP_SUCCESS, 19);
		break;
	case 220:
		OTP_SUCCESS[2] = 16;
		OTP_SUCCESS[6] = ' ';
		OTP_SUCCESS[7] = ' ';
		OTP_SUCCESS[8] = ' ';
		OTP_SUCCESS[9] = ' ';
		OTP_SUCCESS[10] = ' ';
		OTP_SUCCESS[11] = ' ';
		OTP_SUCCESS[12] = ' ';
		OTP_SUCCESS[13] = ' ';
		OTP_SUCCESS[14] = ' ';
		OTP_SUCCESS[15] = ' ';
		OTP_SUCCESS[16] = ' ';
		OTP_SUCCESS[17] = ' ';
		OTP_SUCCESS[18] = ' ';
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) OTP_SUCCESS, 19);
		break;
	case 300:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (Admin_Password_Button >> 8);
		READ_TOUCH[5] = (unsigned char) Admin_Password_Button; //Admin Password read
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 301:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (Admin_Password_Button >> 8); //Admin Password write
		WRITE_TOUCH[5] = (unsigned char) Admin_Password_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 302:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x20;
		READ_TOUCH[5] = 0x00; //Read Password
		READ_TOUCH[6] = 2;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 303:
		WRITE_TOUCH[2] = 0x07;
		WRITE_TOUCH[4] = 0x20;
		WRITE_TOUCH[5] = 0x00;
		WRITE_TOUCH[6] = '\0';
		WRITE_TOUCH[7] = '\0';
		WRITE_TOUCH[8] = '\0';
		WRITE_TOUCH[9] = '\0';
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 10, 0xffff);
		break;
	case 400:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (Admin_Menu_Button >> 8);
		READ_TOUCH[5] = (unsigned char) Admin_Menu_Button; //Admin Setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 401:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (Admin_Menu_Button >> 8); //Admin Setting
		WRITE_TOUCH[5] = (unsigned char) Admin_Menu_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 500:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (Network_Button >> 8);
		READ_TOUCH[5] = (unsigned char) Network_Button; //Network
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 501:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (Network_Button >> 8); //Network
		WRITE_TOUCH[5] = (unsigned char) Network_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 502:
//			READ_TOUCH[2] = 0x04;
//			READ_TOUCH[4] = 0x40;
//			READ_TOUCH[5] = 0x00;
//			READ_TOUCH[6] = 16+6;
//			HAL_UART_Transmit_DMA(&huart3, (uint8_t*)READ_TOUCH,7);
//			break;
	case 503:
//			WRITE_TOUCH[2] = 35+12; //WIFI WRITE Password and SSID
//			WRITE_TOUCH[4] = 0x40;
//			WRITE_TOUCH[5] = 0x00;
//			for(int i =0;i<16;i++)
//			{
//				if(OCPP.wifi_ssid[i] != '\0')
//				{
//					WRITE_TOUCH[6+i] = OCPP.wifi_ssid[i];
//				}
//				else
//				{
//					while(i < 16)
//					{
//						WRITE_TOUCH[6+i] = '\0';
//						i++;
//					}
//					break;
//				}
//			}
//			for(int i =0;i<16;i++)
//			{
//				if(OCPP.wifi_password[i] != '\0')
//				{
//					WRITE_TOUCH[22+i] = OCPP.wifi_password[i];
//				}
//				else
//				{
//					while(i < 16)
//					{
//						WRITE_TOUCH[22+i] = '\0';
//						i++;
//					}
//					break;
//				}
//			}
//			WRITE_TOUCH[38] = OCPP.ether_ip[0];
//
//			WRITE_TOUCH[39] = OCPP.ether_ip[1];
//
//			WRITE_TOUCH[40] = OCPP.ether_ip[2];
//
//			WRITE_TOUCH[41] = OCPP.ether_ip[3];
//
//			WRITE_TOUCH[42] = OCPP.ether_getway[0];
//
//			WRITE_TOUCH[43] = OCPP.ether_getway[1];
//
//			WRITE_TOUCH[44] = OCPP.ether_getway[2];
//
//			WRITE_TOUCH[45] = OCPP.ether_getway[3];
//
//			WRITE_TOUCH[46] = OCPP.ether_subnetmask[0];
//
//			WRITE_TOUCH[47] = OCPP.ether_subnetmask[1];
//
//			WRITE_TOUCH[48] = OCPP.ether_subnetmask[2];
//
//			WRITE_TOUCH[49] = OCPP.ether_subnetmask[3];
//
//			HAL_UART_Transmit(&huart3, (uint8_t*)WRITE_TOUCH,50,0xffff);
		break;
		//////////////////4G changes//////////////
	case 504:	///wifi parameters
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x40;
		READ_TOUCH[5] = 0x00;
		READ_TOUCH[6] = 16;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 505:
		WRITE_TOUCH[2] = 35; //WIFI WRITE Password and SSID
		WRITE_TOUCH[4] = 0x40;
		WRITE_TOUCH[5] = 0x00;
		for (int i = 0; i < 16; i++) {
			if (OCPP.wifi_ssid[i] != '\0') {
				WRITE_TOUCH[6 + i] = OCPP.wifi_ssid[i];
			} else {
				while (i < 16) {
					WRITE_TOUCH[6 + i] = '\0';
					i++;
				}
				break;
			}
		}
		for (int i = 0; i < 16; i++) {
			if (OCPP.wifi_password[i] != '\0') {
				WRITE_TOUCH[22 + i] = OCPP.wifi_password[i];
			} else {
				while (i < 16) {
					WRITE_TOUCH[22 + i] = '\0';
					i++;
				}
				break;
			}
		}
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 38, 0xffff);
		break;
	case 506:	///ethernet parameters
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x40;
		READ_TOUCH[5] = 0x10;
		READ_TOUCH[6] = 6;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 507:
		WRITE_TOUCH[2] = 12; //WIFI WRITE Password and SSID
		WRITE_TOUCH[4] = 0x40;
		WRITE_TOUCH[5] = 0x10;

		WRITE_TOUCH[6] = OCPP.ether_ip[0];

		WRITE_TOUCH[7] = OCPP.ether_ip[1];

		WRITE_TOUCH[8] = OCPP.ether_ip[2];

		WRITE_TOUCH[9] = OCPP.ether_ip[3];

		WRITE_TOUCH[10] = OCPP.ether_getway[0];

		WRITE_TOUCH[11] = OCPP.ether_getway[1];

		WRITE_TOUCH[12] = OCPP.ether_getway[2];

		WRITE_TOUCH[13] = OCPP.ether_getway[3];

		WRITE_TOUCH[14] = OCPP.ether_subnetmask[0];

		WRITE_TOUCH[15] = OCPP.ether_subnetmask[1];

		WRITE_TOUCH[16] = OCPP.ether_subnetmask[2];

		WRITE_TOUCH[17] = OCPP.ether_subnetmask[3];

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 18, 0xffff);

		break;

	case 508:	///GSM parameters
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x25;
		READ_TOUCH[5] = 0x00;
		READ_TOUCH[6] = 6 + 16; //v4.x.6 changes
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 509:
		WRITE_TOUCH[2] = 48 + 18; //GSM WRITE Password and SSID
		WRITE_TOUCH[4] = 0x25;
		WRITE_TOUCH[5] = 0x00;

		for (int i = 0; i < 12; i++) {
			if (GSM.mobile_no[i] != '\0') {
				WRITE_TOUCH[6 + i] = GSM.mobile_no[i];
			} else {
				while (i < 12) {
					WRITE_TOUCH[6 + i] = '\0';
					i++;
				}
				break;
			}
		}
		for (int i = 0; i < (14 + 18); i++) {
			if (OCPP.networkoperator[i] != '\0') {
				WRITE_TOUCH[18 + i] = OCPP.networkoperator[i];
			} else {
				while (i < (14 + 18)) //v4.x.6 changes
				{
					WRITE_TOUCH[18 + i] = '\0';
					i++;
				}
				break;
			}
		}
		WRITE_TOUCH[50] = GSM.csq[0]; //v4.x.6 changes

		WRITE_TOUCH[51] = GSM.csq[1];
		for (int i = 0; i < 20; i++) {
			if (GSM.imeino[i] != '\0') {
				WRITE_TOUCH[52 + i] = GSM.imeino[i];
			} else {
				while (i < 20) {
					WRITE_TOUCH[52 + i] = '\0';
					i++;
				}
				break;
			}
		}

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 54 + 18, 0xffff);

		break;
	case 510:
		WRITE_TOUCH[2] = 0x05 + 4;
		WRITE_TOUCH[4] = (unsigned char) (wifi_E_D_Icon >> 8); // enable
		WRITE_TOUCH[5] = (unsigned char) wifi_E_D_Icon;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = GSM.wifi_enable_sts;
		WRITE_TOUCH[8] = 0;
		WRITE_TOUCH[9] = GSM.ethernet_enable_sts;
		WRITE_TOUCH[10] = 0;
		WRITE_TOUCH[11] = GSM.gsm_enable_sts;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 12, 0xffff);
		break;

		///////////////V4.x.6 changes//////////////
	case 512:
		WRITE_TOUCH[2] = 0x05 + 4;
		WRITE_TOUCH[4] = (unsigned char) (ipv4v6sec_Icon >> 8); // enable
		WRITE_TOUCH[5] = (unsigned char) ipv4v6sec_Icon;
		if (OCPP.ipselection == 0) //V4=1
				{
			WRITE_TOUCH[6] = 0;
			WRITE_TOUCH[7] = 0; //v4
			WRITE_TOUCH[8] = 0;
			WRITE_TOUCH[9] = 0; //v6
			WRITE_TOUCH[10] = 0;
			WRITE_TOUCH[11] = 1;	//v4v6
		} else if (OCPP.ipselection == 1)	//V6=1
				{
			WRITE_TOUCH[6] = 0;
			WRITE_TOUCH[7] = 0;	//v4
			WRITE_TOUCH[8] = 0;
			WRITE_TOUCH[9] = 1;	//v6
			WRITE_TOUCH[10] = 0;
			WRITE_TOUCH[11] = 0;	//v4v6
		} else if (OCPP.ipselection == 2)	//V4V6=1
				{
			WRITE_TOUCH[6] = 0;
			WRITE_TOUCH[7] = 1;
			WRITE_TOUCH[8] = 0;
			WRITE_TOUCH[9] = 0;
			WRITE_TOUCH[10] = 0;
			WRITE_TOUCH[11] = 0;
		}

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 12, 0xffff);
		break;

		///////////////////////////////////////////

		///////////////////////////////////////////
		/////////////////V4.1.0///////////////////
	case 511:
		WRITE_TOUCH[2] = 0x05 + 8 + 14; //  bytes of firmware version
		WRITE_TOUCH[4] = (unsigned char) (firmwareVersion >> 8); // enable
		WRITE_TOUCH[5] = (unsigned char) firmwareVersion;
		WRITE_TOUCH[6] = 'V';
		WRITE_TOUCH[7] = '6';
		WRITE_TOUCH[8] = '.';
		WRITE_TOUCH[9] = '0';
		WRITE_TOUCH[10] = hmi_resetCause + 48;	//v4.x.8
		WRITE_TOUCH[11] = ' ';
		WRITE_TOUCH[12] = ' ';
		WRITE_TOUCH[13] = ' ';
		WRITE_TOUCH[14] = ' ';
		WRITE_TOUCH[15] = GSM.firmware[1];
		WRITE_TOUCH[16] = GSM.firmware[3];
		WRITE_TOUCH[17] = GSM.firmware[5];
		WRITE_TOUCH[18] = ' ';
		WRITE_TOUCH[19] = ' ';
		WRITE_TOUCH[20] = 0;
		WRITE_TOUCH[21] = Ocpp_Setting.stoptransinternetLoss;
		WRITE_TOUCH[22] = 0;
		if (Ocpp_Setting.Operative[0] == Unavailable_ChargerPoint) {
			WRITE_TOUCH[23] = 0;
		} else {
			WRITE_TOUCH[23] = 1;
		}
		WRITE_TOUCH[24] = 0;
		WRITE_TOUCH[25] = Ocpp_Setting.LocalPreAuth;
		WRITE_TOUCH[26] = 0;
		WRITE_TOUCH[27] = Ocpp_Setting.AllowOfflineTXUnknownId;
		WRITE_TOUCH[28] = 0;
		WRITE_TOUCH[29] = Ocpp_Setting.LocalAuthOffln;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 30, 0xffff);
		break;
		/////////////////////////////////////////////
	case 600:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (OCPP_Button >> 8);
		READ_TOUCH[5] = (unsigned char) OCPP_Button; //OCPP Read
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 601:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (OCPP_Button >> 8); //OCPP WRITE
		WRITE_TOUCH[5] = (unsigned char) OCPP_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 602:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x2F;
		READ_TOUCH[5] = 0xFF; //OCPP uri and ocpp
		READ_TOUCH[6] = 26 + 13;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 605:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x30;
		READ_TOUCH[5] = 0x40; //46 //OCPP read server name password
		READ_TOUCH[6] = 42;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 603:
		WRITE_TOUCH[2] = 106;
		WRITE_TOUCH[4] = 0x2F;
		WRITE_TOUCH[5] = 0xFF; //OCPP WRITE Uri
		WRITE_TOUCH[6] = 0x00;
		WRITE_TOUCH[7] = OCPP.ocpp_status[0];
		for (int i = 0; i < 100; i++) {
			WRITE_TOUCH[8 + i] = OCPP.ocpp_uri[i];
		}

		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 109);
		Touch_Action = 61;
		break;

	case 606:
		WRITE_TOUCH[2] = 85 + 2;
		WRITE_TOUCH[4] = 0x30;
		WRITE_TOUCH[5] = 0x40; //46 //OCPP WRITE Uri
		for (int i = 0; i < 30; i++) {
			WRITE_TOUCH[6 + i] = OCPP.OCPP_servername[i];
		}
		for (int i = 0; i < 20; i++) {
			WRITE_TOUCH[38 + i] = OCPP.OCPP_username[i];
		}
		for (int i = 0; i < 20; i++) {
			WRITE_TOUCH[60 + i] = OCPP.OCPP_Password[i];
		}
		for (int i = 0; i < 6; i++) {
			WRITE_TOUCH[82 + i] = OCPP.OCPP_Port[i];
		}

		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 90);
		break;

	case 604:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (OCPP_E_D_Icon >> 8); //OCPP enable
		WRITE_TOUCH[5] = (unsigned char) OCPP_E_D_Icon;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = OCPP.ocpp_status[0];
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
		/*case 1400:
		 READ_TOUCH[2] = 0x04;
		 READ_TOUCH[4] = 0x80;
		 READ_TOUCH[5] = 0x09; // Read Gun
		 READ_TOUCH[6] = 1;
		 HAL_UART_Transmit_DMA(&huart3, (uint8_t*)READ_TOUCH,7);
		 break;
		 case 1401:
		 WRITE_TOUCH[2] = 0x05;
		 WRITE_TOUCH[4] = 0x80; //Gun WRITE
		 WRITE_TOUCH[5] = 0x09;
		 WRITE_TOUCH[6] = 0;
		 WRITE_TOUCH[7] = 0;
		 HAL_UART_Transmit(&huart3, (uint8_t*)WRITE_TOUCH,8,0xffff);
		 break;
		 case 1402:
		 READ_TOUCH[2] = 0x04;
		 READ_TOUCH[4] = 0x40;
		 READ_TOUCH[5] = 0x70; //OCPP
		 READ_TOUCH[6] = 9;
		 HAL_UART_Transmit_DMA(&huart3, (uint8_t*)READ_TOUCH,7);
		 break;
		 case 1403:
		 WRITE_TOUCH[2] = 26;
		 WRITE_TOUCH[4] = 0x40;
		 WRITE_TOUCH[5] = 0x70; //vendor id & connector id
		 WRITE_TOUCH[6] = 0x00;
		 WRITE_TOUCH[7] = 0x01;
		 for(int i =0;i<16;i++)
		 {
		 if(OCPP.vendor_id[i] != '\0')
		 {
		 WRITE_TOUCH[8+i] = OCPP.vendor_id[i];
		 }
		 else
		 {
		 while(i < 16)
		 {
		 WRITE_TOUCH[8+i] = '\0';
		 i++;
		 }
		 break;
		 }
		 }
		 if(OCPP.charger_rating == 3)
		 {
		 WRITE_TOUCH[24] = '0';
		 WRITE_TOUCH[25] = '7';
		 WRITE_TOUCH[26] = '-'; //charger Rating
		 WRITE_TOUCH[27] = 'k';
		 WRITE_TOUCH[28]= 'W';
		 }
		 else if(OCPP.charger_rating == 4)
		 {
		 WRITE_TOUCH[24] = '1';
		 WRITE_TOUCH[25] = '1';
		 WRITE_TOUCH[26] = '-'; //charger Rating
		 WRITE_TOUCH[27] = 'k';
		 WRITE_TOUCH[28]= 'W';
		 }
		 else if(OCPP.charger_rating == 5)
		 {
		 WRITE_TOUCH[24] = '2';
		 WRITE_TOUCH[25] = '2';
		 WRITE_TOUCH[26] = '-'; //charger Rating
		 WRITE_TOUCH[27] = 'k';
		 WRITE_TOUCH[28]= 'W';
		 }
		 else if(OCPP.charger_rating == 6)
		 {
		 WRITE_TOUCH[24] = '4';
		 WRITE_TOUCH[25] = '4';
		 WRITE_TOUCH[26] = '-'; //charger Rating
		 WRITE_TOUCH[27] = 'k';
		 WRITE_TOUCH[28] = 'W';
		 }
		 HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,29);
		 break;
		 case 1404:
		 WRITE_TOUCH[2] = 0x08;
		 WRITE_TOUCH[4] = 0x40;
		 WRITE_TOUCH[5] = 0x79;
		 WRITE_TOUCH[6] = '0';
		 WRITE_TOUCH[7] = '7';
		 WRITE_TOUCH[8] = '-'; //charger Rating
		 WRITE_TOUCH[9] = 'k';
		 WRITE_TOUCH[10]= 'W';
		 HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,11);
		 break;
		 case 1405:
		 WRITE_TOUCH[2] = 0x08; //
		 WRITE_TOUCH[4] = 0x40;
		 WRITE_TOUCH[5] = 0x79;
		 WRITE_TOUCH[6] = '1';
		 WRITE_TOUCH[7] = '1';
		 WRITE_TOUCH[8] = '-'; //charger Rating
		 WRITE_TOUCH[9] = 'k';
		 WRITE_TOUCH[10]= 'W';
		 HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,11);
		 break;
		 case 1406:
		 WRITE_TOUCH[2] = 0x08; //
		 WRITE_TOUCH[4] = 0x40;
		 WRITE_TOUCH[5] = 0x79;
		 WRITE_TOUCH[6] = '2';
		 WRITE_TOUCH[7] = '2';
		 WRITE_TOUCH[8] = '-'; //charger Rating
		 WRITE_TOUCH[9] = 'k';
		 WRITE_TOUCH[10]= 'W';
		 HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,11);
		 break;
		 case 1407:
		 WRITE_TOUCH[2] = 0x08;
		 WRITE_TOUCH[4] = 0x40;
		 WRITE_TOUCH[5] = 0x79;
		 WRITE_TOUCH[6] = '4';
		 WRITE_TOUCH[7] = '4';
		 WRITE_TOUCH[8] = '-'; //charger Rating
		 WRITE_TOUCH[9] = 'k';
		 WRITE_TOUCH[10]= 'W';
		 HAL_UART_Transmit_IT(&huart3, (uint8_t*)WRITE_TOUCH,11);
		 break;
		 case 1408:
		 READ_TOUCH[2] = 0x04;
		 READ_TOUCH[4] = 0x80;
		 READ_TOUCH[5] = 0x0b; //OCPP
		 READ_TOUCH[6] = 1;
		 HAL_UART_Transmit_DMA(&huart3, (uint8_t*)READ_TOUCH,7);
		 break;*/

	case 1200:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (Protection_Button >> 8);
		READ_TOUCH[5] = (unsigned char) Protection_Button; // Read PROTECTION
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1201:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (Protection_Button >> 8); //Protection Write
		WRITE_TOUCH[5] = (unsigned char) Protection_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 1202:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x50;
		READ_TOUCH[5] = 0x00;
		READ_TOUCH[6] = 5;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1203:
		WRITE_TOUCH[2] = 9 + 4;
		WRITE_TOUCH[4] = 0x50;
		WRITE_TOUCH[5] = 0x00; // write protection parameter

		WRITE_TOUCH[7] = OCPP.under_voltage;
		WRITE_TOUCH[6] = (OCPP.under_voltage >> 8);

		WRITE_TOUCH[9] = OCPP.over_voltage;
		WRITE_TOUCH[8] = (OCPP.over_voltage >> 8);

		WRITE_TOUCH[11] = OCPP.over_current_AC02;
		WRITE_TOUCH[10] = (OCPP.over_current_AC02 >> 8);

		WRITE_TOUCH[13] = OCPP.Over_Tempreture;
		WRITE_TOUCH[12] = 0; //(OCPP.Over_Tempreture >> 8);

		WRITE_TOUCH[15] = OCPP.HC_LEL;
		WRITE_TOUCH[14] = 0; //(OCPP.HC_LEL >> 8);

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 16, 0xffff);
		break;
	case 2000:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (history_Button >> 8);
		READ_TOUCH[5] = (unsigned char) history_Button; // history
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 2001:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (history_Button >> 8); //history Write
		WRITE_TOUCH[5] = (unsigned char) history_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 2002:
		/*READ_TOUCH[2] = 0x04;
		 READ_TOUCH[4] = 0x20;
		 READ_TOUCH[5] = 0x10;  //
		 READ_TOUCH[6] = 9;
		 HAL_UART_Transmit_DMA(&huart3, (uint8_t*)READ_TOUCH,7);
		 */
		//   History(page);
		break;
	case 2003:
		//History(1);
		WRITE_TOUCH[2] = 68 + 3;
		WRITE_TOUCH[4] = 0x5F;
		WRITE_TOUCH[5] = 0xFF; // write password setting parameter
		WRITE_TOUCH[6] = '0';
		WRITE_TOUCH[7] = '0';
		//char *ptr = &data_from_flash;

		for (int i = 1; i < 69; i++) {
			WRITE_TOUCH[7 + i] = '\0'; //ptr[i];
		}

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 74, 0xffff);

		break;
	case 2004:
		if (--page) {
			History(page);
		} else {
			page = 1;
			History(page);
		}
		break;
	case 2005:
		if ((History(++page)) == 0) {
			--page;
		}
		break;
	case 2006:
		WRITE_TOUCH[2] = 14;
		WRITE_TOUCH[4] = 0x60;
		WRITE_TOUCH[5] = 0x30; // write password setting parameter
		WRITE_TOUCH[6] = 'P';
		WRITE_TOUCH[7] = 'L';
		WRITE_TOUCH[8] = 'E';
		WRITE_TOUCH[9] = 'A';
		WRITE_TOUCH[10] = 'S';
		WRITE_TOUCH[11] = 'E';
		WRITE_TOUCH[12] = ' ';
		WRITE_TOUCH[13] = 'W';
		WRITE_TOUCH[14] = 'A';
		WRITE_TOUCH[15] = 'I';
		WRITE_TOUCH[16] = 'T';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 17);
		erage_chip = 1;
		break;

	case 2007:
		WRITE_TOUCH[2] = 14;
		WRITE_TOUCH[4] = 0x60;
		WRITE_TOUCH[5] = 0x30; // write password setting parameter
		WRITE_TOUCH[6] = ' ';
		WRITE_TOUCH[7] = ' ';
		WRITE_TOUCH[8] = ' ';
		WRITE_TOUCH[9] = ' ';
		WRITE_TOUCH[10] = ' ';
		WRITE_TOUCH[11] = ' ';

		WRITE_TOUCH[12] = ' ';
		WRITE_TOUCH[13] = ' ';
		WRITE_TOUCH[14] = ' ';
		WRITE_TOUCH[15] = ' ';
		WRITE_TOUCH[16] = ' ';
		HAL_UART_Transmit_IT(&huart3, (uint8_t*) WRITE_TOUCH, 17);
		break;

	case 1400:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (Password_setting_Button >> 8);
		READ_TOUCH[5] = (unsigned char) Password_setting_Button; // password setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1401:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (Password_setting_Button >> 8); //password setting Write
		WRITE_TOUCH[5] = (unsigned char) Password_setting_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 1402:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x20;
		READ_TOUCH[5] = 0x10;
		READ_TOUCH[6] = 9;
		HAL_UART_Transmit(&huart3, (uint8_t*) READ_TOUCH, 7, 0xffff);
		break;
	case 1403:
		WRITE_TOUCH[2] = 18;
		WRITE_TOUCH[4] = 0x50;
		WRITE_TOUCH[5] = 0x00; // write password setting parameter

		for (int i = 0; i < 18; i++) {
			WRITE_TOUCH[7 + i] = '-';
		}
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 21, 0xffff);
		break;
	case 1600:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (RTC_Button >> 8);
		READ_TOUCH[5] = (unsigned char) RTC_Button; // rtc setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1601:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (RTC_Button >> 8); //rtc setting Write
		WRITE_TOUCH[5] = (unsigned char) RTC_Button;
		;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 1602:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x50;
		READ_TOUCH[5] = 0x10;
		READ_TOUCH[6] = 3;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1603:
		WRITE_TOUCH[2] = 9;
		WRITE_TOUCH[4] = 0x50;
		WRITE_TOUCH[5] = 0x10; // write password setting parameter
		WRITE_TOUCH[6] = year;
		WRITE_TOUCH[7] = month;
		WRITE_TOUCH[8] = date;
		WRITE_TOUCH[9] = hour;
		WRITE_TOUCH[10] = min;
		WRITE_TOUCH[11] = sec;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 12, 0xffff);
		break;
	case 1700:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (uint8_t) (select_charging_Button >> 8); //80;
		READ_TOUCH[5] = (uint8_t) select_charging_Button; //0e; // charging setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1701:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (uint8_t) (select_charging_Button >> 8);
		; //charging setting Write
		WRITE_TOUCH[5] = (uint8_t) select_charging_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 1702:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x50;
		READ_TOUCH[5] = 0x20;
		READ_TOUCH[6] = 2;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1703:
		WRITE_TOUCH[2] = 9;
		WRITE_TOUCH[4] = 0x50;
		WRITE_TOUCH[5] = 0x20; // write charging setting parameter

		WRITE_TOUCH[7] = charge_by_time;
		WRITE_TOUCH[6] = (charge_by_time >> 8);

		WRITE_TOUCH[9] = charging_unit;
		WRITE_TOUCH[8] = (charging_unit >> 8);

		WRITE_TOUCH[10] = automatic_charging;
		WRITE_TOUCH[11] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 12, 0xffff);
		break;
	case 1704:
		WRITE_TOUCH[2] = 7;
		WRITE_TOUCH[4] = 0x50;
		WRITE_TOUCH[5] = 0x22; // write charging setting parameter
		WRITE_TOUCH[7] = automatic_charging;
		WRITE_TOUCH[6] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;

	case 1800:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (charging_setting_Button >> 8);
		;
		READ_TOUCH[5] = (unsigned char) charging_setting_Button; // charging setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1801:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (charging_setting_Button >> 8); //charging setting Write
		WRITE_TOUCH[5] = (unsigned char) charging_setting_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 1802:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x50;
		READ_TOUCH[5] = 0x30;
		READ_TOUCH[6] = 4;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1803:
		WRITE_TOUCH[2] = 7 + 4;
		WRITE_TOUCH[4] = 0x50;
		WRITE_TOUCH[5] = 0x30; // write charging setting parameter

		WRITE_TOUCH[7] = OCPP.energy_charges;
		WRITE_TOUCH[6] = (OCPP.energy_charges >> 8);

		WRITE_TOUCH[9] = OCPP.time_charges;
		WRITE_TOUCH[8] = (OCPP.time_charges >> 8);

		WRITE_TOUCH[11] = OCPP.energy_charges_AC02;
		WRITE_TOUCH[10] = (OCPP.energy_charges_AC02 >> 8);

		WRITE_TOUCH[13] = OCPP.time_charges_AC02;
		WRITE_TOUCH[12] = (OCPP.time_charges_AC02 >> 8);

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 14, 0xffff);
		break;
	case 2400:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (rfid_scan >> 8);
		READ_TOUCH[5] = (unsigned char) rfid_scan; // charging setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 2401:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (rfid_scan >> 8); //rfid
		WRITE_TOUCH[5] = (unsigned char) rfid_scan;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 2402:
		WRITE_TOUCH[2] = 39 + 24;
		WRITE_TOUCH[4] = 0x20;
		WRITE_TOUCH[5] = 0x30; // write rfid
		for (int i = 0; i < 12; i++) {
			WRITE_TOUCH[6 + i] = rfid_data.TagId[1][i];
			WRITE_TOUCH[18 + i] = rfid_data.TagId[2][i];
			WRITE_TOUCH[30 + i] = rfid_data.TagId[3][i];
			WRITE_TOUCH[42 + i] = rfid_data.TagId[4][i];
			WRITE_TOUCH[54 + i] = rfid_data.TagId[5][i];
		}
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 66, 0xffff);
		break;
	case 2406:
		WRITE_TOUCH[2] = 39 + 24;
		WRITE_TOUCH[4] = 0x20;
		WRITE_TOUCH[5] = 0x30; // write rfid
		for (int i = 0; i < 12; i++) {
			WRITE_TOUCH[6 + i] = rfid_data.TagId[1][i];
			WRITE_TOUCH[18 + i] = rfid_data.TagId[2][i];
			WRITE_TOUCH[30 + i] = rfid_data.TagId[3][i];
			WRITE_TOUCH[42 + i] = rfid_data.TagId[4][i];
			WRITE_TOUCH[54 + i] = rfid_data.TagId[5][i];
		}
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 66, 0xffff);
		break;
		/*case 2503:
		 WRITE_TOUCH[2] = 9;
		 WRITE_TOUCH[4] = 0x50;
		 WRITE_TOUCH[5] = 0x40; // write charging setting parameter

		 WRITE_TOUCH[7] = Total_time;
		 WRITE_TOUCH[6] = (Total_time >> 8);

		 WRITE_TOUCH[9] = Total_unit;
		 WRITE_TOUCH[8] = (Total_unit >> 8);

		 WRITE_TOUCH[11] = Total_cost;
		 WRITE_TOUCH[10] = (Total_cost >> 8);

		 HAL_UART_Transmit(&huart3, (uint8_t*)WRITE_TOUCH,12,0xffff);
		 break;
		 */case 1300:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (Gun_reading_Button >> 8);
		READ_TOUCH[5] = (unsigned char) Gun_reading_Button; // charging setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit(&huart3, (uint8_t*) READ_TOUCH, 7, 0XFFFF);
		break;
	case 1301:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (Gun_reading_Button >> 8); //charging setting Write
		WRITE_TOUCH[5] = (unsigned char) Gun_reading_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 1302:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x50;
		READ_TOUCH[5] = 0x40;
		READ_TOUCH[6] = 3;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1900:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (Billing_Button >> 8);
		READ_TOUCH[5] = (unsigned char) Billing_Button; // charging setting
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit(&huart3, (uint8_t*) READ_TOUCH, 7, 0XFFFF);
		break;
	case 1901:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (Billing_Button >> 8); //charging setting Write
		WRITE_TOUCH[5] = (unsigned char) Billing_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 8, 0xffff);
		break;
	case 1902:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x50;
		READ_TOUCH[5] = 0x40;
		READ_TOUCH[6] = 3;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 1903:
		WRITE_TOUCH[2] = 9;
		WRITE_TOUCH[4] = 0x50;
		WRITE_TOUCH[5] = 0x40; // write charging setting parameter

		WRITE_TOUCH[7] = Total_time;
		WRITE_TOUCH[6] = (Total_time >> 8);

		WRITE_TOUCH[9] = Total_unit;
		WRITE_TOUCH[8] = (Total_unit >> 8);

		WRITE_TOUCH[11] = Total_cost;
		WRITE_TOUCH[10] = (Total_cost >> 8);

		HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 12, 0xffff);
		break;
	case 3000:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (fwupgrade_Button >> 8);
		READ_TOUCH[5] = (unsigned char) fwupgrade_Button; //firmware Read
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 3001:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (fwupgrade_Button >> 8); //firmware WRITE
		WRITE_TOUCH[5] = (unsigned char) fwupgrade_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 3002:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x35;
		READ_TOUCH[5] = 0x00; //Firmware uri
		READ_TOUCH[6] = 39;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 3005:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x35;
		READ_TOUCH[5] = 0x40; //46 //firmware read server name password
		READ_TOUCH[6] = 41;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 3003:
		WRITE_TOUCH[2] = 106;
		WRITE_TOUCH[4] = 0x35;
		WRITE_TOUCH[5] = 0x00; //OCPP WRITE Uri
		for (int i = 0; i < 100; i++) {
			WRITE_TOUCH[6 + i] = OCPP.fw_uri[i];
		}
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 109);
		Touch_Action = 62;
		break;
	case 3006:
		WRITE_TOUCH[2] = 85;
		WRITE_TOUCH[4] = 0x35;
		WRITE_TOUCH[5] = 0x40; //46 //OCPP WRITE Uri
		for (int i = 0; i < 30; i++) {
			WRITE_TOUCH[6 + i] = OCPP.fw_servername[i];
		}
		for (int i = 0; i < 20; i++) {
			WRITE_TOUCH[38 + i] = OCPP.fw_username[i];
		}
		for (int i = 0; i < 20; i++) {
			WRITE_TOUCH[60 + i] = OCPP.fw_Password[i];
		}
		for (int i = 0; i < 4; i++) {
			WRITE_TOUCH[82 + i] = OCPP.fw_Port[i];
		}
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 88);
		break;
	case 3700:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = (unsigned char) (production_Button >> 8);
		READ_TOUCH[5] = (unsigned char) production_Button; //firmware Read
		READ_TOUCH[6] = 1;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 3701:
		WRITE_TOUCH[2] = 0x05;
		WRITE_TOUCH[4] = (unsigned char) (production_Button >> 8); //firmware WRITE
		WRITE_TOUCH[5] = (unsigned char) production_Button;
		WRITE_TOUCH[6] = 0;
		WRITE_TOUCH[7] = 0;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 8);
		break;
	case 3702:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x35;
		READ_TOUCH[5] = 0x70; //serial no / vendor id
		READ_TOUCH[6] = 16;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 3703:
		WRITE_TOUCH[2] = 35;
		WRITE_TOUCH[4] = 0x35;
		WRITE_TOUCH[5] = 0x70; // serial no ,vendor id
		for (int i = 0; i < 15; i++) {
			WRITE_TOUCH[6 + i] = OCPP.serial_no[i]; //6 - 21
		}
		for (int i = 0; i < 15; i++) {
			WRITE_TOUCH[22 + i] = OCPP.vendor_id[i]; //22 - 38
		}
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 38);
		break;
//V501change
	case 3704:
		READ_TOUCH[2] = 0x04;
		READ_TOUCH[4] = 0x36;
		READ_TOUCH[5] = 0x00; //CP_VAL
		READ_TOUCH[6] = 5;
		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) READ_TOUCH, 7);
		break;
	case 3705:
		WRITE_TOUCH[2] = 17;
		WRITE_TOUCH[4] = 0x36;
		WRITE_TOUCH[5] = 0x00; // serial no ,vendor id

		WRITE_TOUCH[7] = OCPP.STATE_A_LEVEL;
		WRITE_TOUCH[6] = (OCPP.STATE_A_LEVEL >> 8);

		WRITE_TOUCH[9] = OCPP.STATE_B_LEVEL;
		WRITE_TOUCH[8] = (OCPP.STATE_B_LEVEL >> 8);

		WRITE_TOUCH[11] = OCPP.STATE_C_LEVEL;
		WRITE_TOUCH[10] = (OCPP.STATE_C_LEVEL >> 8);

		WRITE_TOUCH[13] = OCPP.STATE_D_LEVEL;
		WRITE_TOUCH[12] = (OCPP.STATE_D_LEVEL >> 8);

		WRITE_TOUCH[15] = OCPP.auxinput;
		WRITE_TOUCH[14] = (OCPP.auxinput >> 8);

		WRITE_TOUCH[17] = hmicp_val;
		WRITE_TOUCH[16] = (hmicp_val >> 8);

		WRITE_TOUCH[19] = hmicp_val_1;
		WRITE_TOUCH[18] = (hmicp_val_1 >> 8);

		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 20);
		break;
	case 3706:
		WRITE_TOUCH[2] = 7;
		WRITE_TOUCH[4] = 0x36;
		WRITE_TOUCH[5] = 0x05; // serial no ,vendor id

		WRITE_TOUCH[7] = hmicp_val;
		WRITE_TOUCH[6] = (hmicp_val >> 8);

		WRITE_TOUCH[9] = hmicp_val_1;
		WRITE_TOUCH[8] = (hmicp_val_1 >> 8);

		HAL_UART_Transmit_DMA(&huart3, (uint8_t*) WRITE_TOUCH, 10);
		break;

//V501change
	default:
		break;

	}
}
/**
 * @brief Process and send HMI (Human-Machine Interface) data.
 *
 * This function processes the HMI data and sends specific HMI data based on
 * the current page and various conditions.
 *
 * @note This function uses a circular queue to manage HMI data.
 * @note Icons and notifications are enqueued based on specific conditions.
 * @note Energy meter data query for gun2 and gun3 is sent in this function.
 *
 * @return NA .
 */

void HMI_data(void) {

	static uint8_t previous_page = 0;
	++HMI_Page;
	uint8_t i = 0;

//////////////////////////V3.3.1//////////////////
	if ((HMI_Page % 15) == 0) {
		if (isEmpty_hmi() == true) {

		} else {
			HMI_Send(deQueue_hmi()); //heart
		}
	}
///////////////////////////////////////////////////

	if (HMI_Page > 200) {
		HMI_Page = 1;
		if (current_page == 36) {
			enQueue_hmi(0);
		} else if (current_page != previous_page) {
			timer_temp = 0;
			previous_page = current_page;
		} else if (current_page != 1) {
			if (++timer_temp >= 100) {
				//enQueue_hmi(1);
				if (current_page == Authentication_screen) {
					Authentic_Page = Back;
				} else if ((current_page == Gun_Reading_screen)
						|| (current_page == Gun_Reading_screen_G2)
						|| (current_page == Gun_Reading_screen_G3)) //
						{
					Gun_parameter = Back;
				} else if (current_page == OCPP_screen) {

				} else {
					enQueue_hmi(1);
				}
			}
		} else {
			timer_temp = 0;
		}
		Energy_MeterRead(1);
		//else
		{
#if defined(selecdual)

#else
#if defined(dualgun)
		if(toggle == 1)
			{
				if(Send_meter == 0)
				{
					Energy_MeterRead(1);
					toggle = 0;
				}

			}
			else
			{
				if(Send_meter == 0)
				{
					Energy_MeterRead(2);
					toggle = 1;
				}
			}
#else
			//if(Send_meter == 0)
			{
				Energy_MeterRead(1);
			}
#endif
#endif
		}

		//HAL_UART_Transmit_DMA(&huart3, (uint8_t*)PIC_NOW,7);
	} else {
		if ((HMI_Page == 2) && (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
			//HAL_UART_Transmit_IT(&huart3, (uint8_t*)PIC_NOW,7);
			enQueue_hmi(97);
		} else if ((HMI_Page == 10)
				&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
			if (HMI_wifi_connect || HMI_websocket_connect || HMI_wifi_disconnect
					|| incorrect_rfid || correct_rfid
					|| HMI_websocket_disconnect || rtc_ocpp_flag
					|| internal_rtc_read || update_variable
					|| HMI_alarmstsupdate) {
				if (rtc_ocpp_flag) {
					enQueue_hmi(99); //icon
					rtc_ocpp_flag = 0;
				} else if (internal_rtc_read == 1) {
					enQueue_hmi(98); //icon
					internal_rtc_read = 0;
				} else if (incorrect_rfid == 1) {
					enQueue_hmi(219); //incorrect_rfid
					incorrect_rfid = 0;
				} else if (correct_rfid == 1) {
					enQueue_hmi(218); //correct_rfid
					correct_rfid = 0;
				} else if (update_variable) {
					enQueue_hmi(119); //icon
					update_variable = 0;
				} else if (HMI_wifi_connect == 1) // && (wifi_connected == 1))
						{
					enQueue_hmi(52); //icon
					HMI_wifi_connect = 0;
				} else if (HMI_wifi_disconnect == 1) // && (wifi_connected == 1))
						{
					enQueue_hmi(53); //icon
					HMI_wifi_disconnect = 0;
				} else if (HMI_alarmstsupdate)	//V5.0.0A
				{
					enQueue_hmi(66); //icon
					HMI_alarmstsupdate = 0;
				} else if ((websocket_success == 1)
						&& (HMI_websocket_connect == 1)) {
					enQueue_hmi(50);
					HMI_websocket_connect = 0;
				} else if ((HMI_websocket_disconnect == 1)
						&& (websocket_success == 0)) {
					enQueue_hmi(51);
					HMI_websocket_disconnect = 0;
				}
			} else {
				update_variable = 1;
			}
		} else if ((HMI_Page == 20)
				&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
			if (Touch_Action != 0) {
				if (Touch_Action == Main_screen) {
					enQueue_hmi(101);
				} else if (Touch_Action == Authentication_screen) {
					enQueue_hmi(201);
				} else if (Touch_Action == Admin_Password_screen) {
					enQueue_hmi(301);
				} else if (Touch_Action == Admin_Menu_screen) {
					enQueue_hmi(401);
				} else if (Touch_Action == Network_screen) {
					enQueue_hmi(501);
				} else if (Touch_Action == OCPP_screen) {
					enQueue_hmi(601);
				} else if (Touch_Action == 61) {
					enQueue_hmi(606);
				} else if (Touch_Action == 62) {
					enQueue_hmi(3006);
				}
				/* else if(Touch_Action == 7)
				 {
				 enQueue_hmi(1401);
				 }*/
				else if (Touch_Action == Protection_screen) {
					enQueue_hmi(1201);
				} else if (Touch_Action == Password_setting_screen) {
					enQueue_hmi(1401);
				} else if (Touch_Action == RTC_screen) {
					enQueue_hmi(1601);
				} else if (Touch_Action == Select_Charging_Screen) {
					enQueue_hmi(1701);
				} else if (Touch_Action == Charging_Setting_screen) {
					enQueue_hmi(1801);
				} else if (Touch_Action == Billing_screen) {
					enQueue_hmi(1901);
				} else if (Touch_Action == History_screen) {
					enQueue_hmi(2001);
				} else if (Touch_Action == Gun_Reading_screen) {
					enQueue_hmi(1301);
				} else if (Touch_Action == rfid_screen) {
					enQueue_hmi(2401);
				} else if (Touch_Action == Firmware_upgrade_screen) {
					enQueue_hmi(2401);
				}
				Touch_Action = 0;
			} else if (Clear_Register != 0) {
				if (Clear_Register == 1) {
					// enQueue_hmi(203);
				} else if (Clear_Register == Admin_Password_screen) {
					enQueue_hmi(303);
				} else if (Clear_Register == Network_screen) {
					enQueue_hmi(503);
				} else if (Clear_Register == OCPP_screen) {
					enQueue_hmi(603); //ocpp
				}
				/*else if(Clear_Register == 5)
				 {
				 enQueue_hmi(1403); //gun
				 }*/
				else if (Clear_Register == Protection_screen) {
					enQueue_hmi(1203); //protection
				} else if (Clear_Register == Password_setting_screen) {
					enQueue_hmi(1403); //password
				} else if (Clear_Register == RTC_screen) {
					enQueue_hmi(2203);
				} else if (Clear_Register == Select_Charging_Screen) {
					enQueue_hmi(1703);
				} else if (Clear_Register == Charging_Setting_screen) {
					enQueue_hmi(1803);
				} else if (Clear_Register == Billing_screen) {
					enQueue_hmi(1903); //Bill
				} else if (Clear_Register == rfid_screen) {
					//read_rfid_last_data(0);
					// enQueue_hmi(2402); //RFid
				} else if (Clear_Register == History_screen) {
					page = 0;
					enQueue_hmi(2005); //RFid
				} else if (Clear_Register == Firmware_upgrade_screen) {
					page = 0;
					enQueue_hmi(3003); //read fw upgrade
				} else if (Clear_Register == production_screen) {
					page = 0;
					enQueue_hmi(3703); //read fw upgrade
				}
//V501change
				else if (Clear_Register == cpconfig_screen) {
					page = 0;
					enQueue_hmi(3705); //read fw upgrade
				}
//V501change
				else if (Clear_Register == Back_screen) {
					enQueue_hmi(2007);
					history_page = Back;
				}
				/////////////////////4G CHANGES//////////////////
				else if (Clear_Register == GSM_screen) {
					enQueue_hmi(509);		//v4.x.6 changes
					enQueue_hmi(510);
					enQueue_hmi(512);
				} else if (Clear_Register == wifi_screen) {
					enQueue_hmi(505);	//v4.x.6 changes
					enQueue_hmi(510);
				} else if (Clear_Register == ethernet_screen) {
					enQueue_hmi(507);	//v4.x.6 changes
					enQueue_hmi(510);
				}
				/////////////////////////////////////////////////
				/////////////V4.1.0///////////////////////
				else if (Clear_Register == configmenu_screen) {
					enQueue_hmi(511);
				}
				//////////////////////////////////////

				Clear_Register = 0;
			} else if (back_page != 0) {
				if (back_page == 1) {
					// enQueue_hmi(203);
				}
//				 else if(back_page == Admin_Password_screen)
//				 {
//					 enQueue_hmi(303);
//				 }
				////////////////4G CHANGES//////////////////
				else if (back_page == network_select_screen) {
					enQueue_hmi(Admin_Menu_screen);
				} else if (back_page == GSM_screen) {
					enQueue_hmi(network_select_screen); //ocpp
				} else if (back_page == ethernet_screen) {
					enQueue_hmi(network_select_screen);
				} else if (back_page == wifi_screen) {
					enQueue_hmi(network_select_screen); //ocpp
				}

				//////////////////////////////////////////
				/////////////////V4.1.0//////////////////////
				else if (back_page == configmenu_screen) {
					enQueue_hmi(Main_screen);
				}
				///////////////////////////////////////////
				else if (back_page == Network_screen) {
					enQueue_hmi(Admin_Menu_screen);
				} else if (back_page == OCPP_screen) {
					enQueue_hmi(Admin_Menu_screen); //ocpp
				}
				/*else if(Clear_Register == 5)
				 {
				 enQueue_hmi(1403); //gun
				 }*/
				else if (back_page == Protection_screen) {
					enQueue_hmi(Admin_Menu_screen);
				} else if (back_page == Password_setting_screen) {
					enQueue_hmi(Main_screen);
				} else if (back_page == RTC_screen) {
					enQueue_hmi(Admin_Menu_screen);
				}
//				 else if(back_page == Select_Charging_Screen)
//				 {
//					 enQueue_hmi(1703); // charge by time
//				 }
				else if (back_page == Charging_Setting_screen) {
					enQueue_hmi(Admin_Menu_screen);
				}
//				 else if(back_page == 	Billing_screen)
//				 {
//					 enQueue_hmi(1903); //Bill
//				 }
//				 else if(back_page == rfid_screen)
//				 {
//					 enQueue_hmi(2402); //RFid
//				 }
//V501change
				else if ((back_page == Firmware_upgrade_screen)
						|| (back_page == production_screen)
						|| (back_page == cpconfig_screen)) {
					enQueue_hmi(Admin_Menu_screen);
				}
//V501change
#if cpchange == no
				 else if((back_page == Firmware_upgrade_screen) || (back_page == production_screen) )
				 {
					 enQueue_hmi(Admin_Menu_screen);
				 }
#endif
				else if (back_page == History_screen) {
					// page = 0;
					// enQueue_hmi(2005); //RFid
					enQueue_hmi(Admin_Menu_screen);
				}
				back_page = 0;
			}

			// enQueue_hmi(100);
		} else if (HMI_Page == 40) {
			/////////////////////V3.3.1////////////////////////changes ///removed from main_screen
			if (gun_1) {
				if (gun_1 == G_charging) {
					enQueue_hmi(gun1_charging);
					enQueue_hmi(Main_screen);
				} else if (gun_1 == G_connected) {
					enQueue_hmi(gun1_connect);
				} else if (gun_1 == G_Error) {
					enQueue_hmi(gun1_fault);
				} else if (gun_1 == G_Discharging) {
					enQueue_hmi(Billing_screen);
					enQueue_hmi(gun1_not_connect);
					//charger_status_G1.stop =0;
				} else if (gun_1 == G_NoError) {
					enQueue_hmi(gun1_not_connect);
				}
				gun_1 = 0;
			}

			if (gun_2) {
				if (gun_2 == G_charging) {
					enQueue_hmi(gun2_charging);
					enQueue_hmi(Main_screen);
				} else if (gun_2 == G_connected) {
					enQueue_hmi(gun2_connect);
				} else if (gun_2 == G_Error) {
					enQueue_hmi(gun2_fault);
				} else if (gun_2 == G_Discharging) {
					enQueue_hmi(Billing_screen_G2);
					enQueue_hmi(gun2_not_connect);
					//charger_status_G1.stop =0;
				} else if (gun_2 == G_NoError) {
					enQueue_hmi(gun2_not_connect);
				}
				gun_2 = 0;
			}
			if (gun_3) {
				if (gun_3 == G_charging) {
					enQueue_hmi(gun3_charging);
					enQueue_hmi(Main_screen);
				} else if (gun_3 == G_connected) {
					enQueue_hmi(gun3_connect);
				} else if (gun_3 == G_Error) {
					enQueue_hmi(gun3_fault);
				} else if (gun_3 == G_Discharging) {
					enQueue_hmi(Billing_screen_G3);
					enQueue_hmi(gun3_not_connect);
					//charger_status_G1.stop =0;
				} else if (gun_3 == G_NoError) {
					enQueue_hmi(gun3_not_connect);
				}
				gun_3 = 0;
			}
			//////////////////////////////////////////////////////////////////

		} else {
//		   if(((HMI_Page == 80)) && (huart1.gState != HAL_UART_STATE_BUSY_TX))
//		   {
//			//   Energy_MeterRead(3);
////				#if defined(selecdual)
////					   Send_Meterquery(meterquerycntr);
////					   Send_meter=1;
////				#endif
//
//		   }
			if (current_page == Main_screen) // Main Page
					{
				if (((HMI_Page == 80))
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					//////////////////////V3.3.1//////////////////////////////////////////changes
					if (Ocpp_Setting.Operative[0] == Unavailable_ChargerPoint) {
						enQueue_hmi(96);
					}
#if defined(dualgun)
				else if(charger_status_G1.error != NoError_ChargerPoint || charger_status_G2.error != NoError_ChargerPoint  )
				{
					enQueue_hmi(108); //error
				}
#else
					else if (charger_status_G1.error != NoError_ChargerPoint) {
						enQueue_hmi(108); //error
					}
#endif
					/////////////////////////////////////////////////////////////////////////
					else if ((!ocpp_boot_status)
							&& (OCPP.ocpp_status[0] == 1)) {
						enQueue_hmi(118);
					} else {
						enQueue_hmi(109); //ev not connected
					}
				} else if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {	/////////////////////V3.3.1///////////////////////////
					if (Main_Page == Gun1) {
						Main_Page = 0;
						HMI_Page = 0;
						if (charger_status_G1.error == NoError_ChargerPoint) {
							if (charger_status_G1.start == Stoped
									&& (CURRENT_STATE == STATE_B)
									&& (Ocpp_Setting.Operative[1]
											== Available_ChargerPoint)) {
								gun_start = Gun1;
								//charger_status_G1.start = 25;
								gunrunning_flag = 1;
								enQueue_hmi(Select_Charging_Screen);
							} else if (charger_status_G1.start == Started) {
								gun_stop = Gun1;
								//	charger_status_G1.stop = 25;
								gunrunning_flag = 1;
								enQueue_hmi(Gun_Reading_screen);
							}
						}
					} else if (Main_Page == Gun2) {
						Main_Page = 0;
						HMI_Page = 0;

						if (charger_status_G2.error == NoError_ChargerPoint) {
							if (charger_status_G2.start == Stoped
									&& (CURRENT_STATE_1 == STATE_B)
									&& (Ocpp_Setting.Operative[2]
											== Available_ChargerPoint)) {
								//charger_status_G2.start = 25;
								gun_start = Gun2;
								gunrunning_flag = 1;
								enQueue_hmi(Select_Charging_Screen_G2);
							} else if (charger_status_G2.start == Started) {
								gun_stop = Gun2;
								gunrunning_flag = 1;
								//charger_status_G2.stop = 25;
								enQueue_hmi(Gun_Reading_screen_G2);
							}
						}
					} else if (Main_Page == Gun3) {
						Main_Page = 0;
						HMI_Page = 0;

						if (charger_status_G3.error == NoError_ChargerPoint) {
							if ((charger_status_G3.start == Stoped)) {
								//charger_status_G3.start = 35;
								gun_start = Gun3;
								gunrunning_flag = 1;
								enQueue_hmi(Select_Charging_Screen_G3);
							} else if (charger_status_G3.start == Started) {
								gun_stop = Gun3;
								gunrunning_flag = 1;
								//charger_status_G3.stop = 35;
								enQueue_hmi(Gun_Reading_screen_G3);
							}
						}
					}

					else if (Main_Page == alarmbutton)		//V5.0.0A
							{
						Main_Page = 0;
						HMI_Page = 0;
						if (alarmstatus == activealarm) {
							alarmstatus = mutealarm;
							HMI_alarmstsupdate = 1;
						}
					}

//////////////////////V3.3.1/////////////////////////////////////
					else if (Main_Page == Admin_page) {
						Main_Page = 0;
						HMI_Page = 0;
//					if((charger_status_G2.charging_status != Charging_ChargerPoint) &&(charger_status_G1.charging_status != Charging_ChargerPoint) &&(charger_status_G3.charging_status != Charging_ChargerPoint))
						{
							enQueue_hmi(Admin_Password_screen);
						}
					}
				}
			} else if ((current_page == Authentication_screen)
					|| (current_page == Authentication_screen_G2)
					|| (current_page == Authentication_screen_G3)) {
				if (((HMI_Page % 30) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (clear_rfid == 1) {
						enQueue_hmi(220); //correct_rfid
						clear_rfid = 0;
					} else if (Authentic_Page == Back) {
						if (charger_status_G1.start == Authenticate) {
							charger_status_G1.start = Stoped;
						}

						if (charger_status_G2.start == Authenticate) {
							charger_status_G2.start = Stoped;
						}

						if (charger_status_G3.start == Authenticate) {
							charger_status_G3.start = Stoped;
						}

						if (charger_status_G1.stop == Authenticate) {
							charger_status_G1.stop = Stoped;
						}

						if (charger_status_G2.stop == Authenticate) {
							charger_status_G2.stop = Stoped;
						}

						if (charger_status_G3.stop == Authenticate) {
							charger_status_G3.stop = Stoped;
						}

						Authentic_Page = 0;
						HMI_Page = 0;
						enQueue_hmi(Main_screen);
					} else if (Authentic_Page == enter) {
						Authentic_Page = Back;
						HMI_Page = 0;
						//	enQueue_hmi(Main_screen);
					}
				}
			} else if (current_page == Admin_Password_screen) // &&(huart3.gState != HAL_UART_STATE_BUSY_TX)) //Admin Password
					{
				if (((HMI_Page % 25) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (Admin_Pass_Page == Back) {
						Admin_Pass_Page = 0;
						HMI_Page = 0;
						enQueue_hmi(Main_screen); //go to main page

					} else if (Admin_Pass_Page == enter) {
						action_otp = 1;
						Admin_Pass_Page = 0;
						enQueue_hmi(302); //read password
					} else if (action_otp == 1) {
						action_otp = 0;
						if (strcmp_1(HMI_Password, (OCPP.config_password))
								== 0) {
							//send ok message and go to net page
							next_page = 1;
							// enQueue_hmi(204);
						} else if (strcmp_1(HMI_Password, "7620") == 0) {
							next_page = 2;
						} else if (strcmp_1(HMI_Password, "2076") == 0) {
							next_page = 3;
							reset_cause = 0;	//V4.x.8
						}
//V501change
						else if (strcmp_1(HMI_Password, "2069") == 0) {
							next_page = 4;
							reset_cause = 0;	//V4.x.8
							update_variable = 1;
						}
//V501change
						else if (strcmp_1(HMI_Password, "9999") == 0) {
							OCPP.config_password[0] = OCPP.config_password[1] =
									OCPP.config_password[2] =
											OCPP.config_password[3] = '9';
							next_page = 1;
							write_para = 1;
						} else {

						}
					} else if (next_page == 1) {
						next_page = 0;
						HMI_Page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
						// clear write register
					} else if (next_page == 2) {
						next_page = 0;
						HMI_Page = 0;
						Clear_Register = production_screen;
						enQueue_hmi(production_screen); //go to main page
						// clear write register
					} else if (next_page == 3) {
						next_page = 0;
						HMI_Page = 0;
						Clear_Register = configmenu_screen;
						enQueue_hmi(configmenu_screen); //go to main page
						// clear write register
					}
//V501change
					else if (next_page == 4) {
						next_page = 0;
						HMI_Page = 0;
						Clear_Register = cpconfig_screen;
						enQueue_hmi(cpconfig_screen); //go to main page
						// clear write register
					}
//V501change
				}
			} else if (current_page == production_screen)  //ocpp
					{
				if (((HMI_Page % 80) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (production_page == Back) {
						HMI_Page = 0;
						production_page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (production_page == Save) {
						production_page = 0; //read OCPP uri
						enQueue_hmi(3702);
					}
				}
			}
//V501change
			else if (current_page == cpconfig_screen)  //ocpp
					{
				if (((HMI_Page % 80) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (cpconfigmenu_page == Back) {
						cpconfigmenu_page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (cpconfigmenu_page == Save) {
						cpconfigmenu_page = 0; //read OCPP uri
						enQueue_hmi(3704);
					} else {
						enQueue_hmi(3706); // // count display every 120 ms
					}
					HMI_Page = 0;
				}
			}
//V501change
			else if (current_page == Admin_Menu_screen) //&&(huart3.gState != HAL_UART_STATE_BUSY_TX)) //ADMIN
					{
				if (((HMI_Page % 25) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (Admin_Setting_Page == Network_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						//Clear_Register = Network_screen;
						enQueue_hmi(network_select_screen); //go to Network
					} else if (Admin_Setting_Page == Rfid_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = rfid_screen;
						//	read_rfid_last_data(1);
						enQueue_hmi(rfid_screen); //go to  RFID page
					} else if (Admin_Setting_Page == Ocpp_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = OCPP_screen;
						enQueue_hmi(OCPP_screen); //go to OCPP
					} else if (Admin_Setting_Page == History_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = History_screen;
						enQueue_hmi(History_screen); //go to GUN page
					} else if (Admin_Setting_Page == Pricing_setting_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = Charging_Setting_screen;
						enQueue_hmi(Charging_Setting_screen); //go to Price Setting page
					} else if (Admin_Setting_Page == Protection_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = Protection_screen;
						enQueue_hmi(Protection_screen); //go to Protection page
					} else if (Admin_Setting_Page == Set_Password_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						enQueue_hmi(Password_setting_screen); //go to Firmware detail page
					} else if (Admin_Setting_Page == RTC_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						enQueue_hmi(RTC_screen); //go to userdetail page
					} else if (Admin_Setting_Page == exit_b) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						enQueue_hmi(Main_screen); //go to userdetail page
					} else if (Admin_Setting_Page == Firmware_upgrade_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = Firmware_upgrade_screen;
						enQueue_hmi(Firmware_upgrade_screen); //go to firmware detail page
					}
				}
			} else if (current_page == OCPP_screen)  //ocpp
					{
				if (((HMI_Page % 80) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (OCPP_Page == Back) {
						HMI_Page = 0;
						OCPP_Page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (OCPP_Page == Save) {
						OCPP_Page = 0; //read OCPP uri
						next_page = 1;
						enQueue_hmi(602);
					} else if (next_page == 1) {
						OCPP_Page = 0;
						next_page = 0;
						enQueue_hmi(605);
					} else if (OCPP_Page == ocpp) {
						if (OCPP.ocpp_status[0] == 1) {
							OCPP.ocpp_status[0] = 0;
						} else {
							OCPP.ocpp_status[0] = 1;
						}
						enQueue_hmi(604);
						OCPP_Page = 0;
						//next_page =1;
					}
				}
			} else if (current_page == Firmware_upgrade_screen) //firmware upgrade
					{
				if (((HMI_Page % 80) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (fw_Page == Back) {
						HMI_Page = 0;
						fw_Page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (fw_Page == Firmware_upgrade) {
						fw_Page = 0; //read OCPP uri
						next_page = 1;
						enQueue_hmi(3002);
					} else if (next_page == 1) {
						fw_Page = 0;
						next_page = 0;
						enQueue_hmi(3005);
					}
				}
			}
//		else if(current_page == Network_screen) //wifi
//		{
//			if(((HMI_Page % 50) == 0)&&(huart3.gState != HAL_UART_STATE_BUSY_TX))
//			{
//				if(WI_fi_Page == Back)
//				{
//					HMI_Page = 0;
//					WI_fi_Page = 0;
//					enQueue_hmi(Admin_Menu_screen); //go to main page
//				}
//				else if(WI_fi_Page == Save)
//				{
//					WI_fi_Page = 0;
//					enQueue_hmi(502);
//						//read ssid and Password
//				}
//			}
//		}
			///////////4G changes///////////////////////////
			else if (current_page == network_select_screen) {
				if (((HMI_Page % 25) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {

					if (Admin_Setting_Page == Wifi_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = wifi_screen;
						enQueue_hmi(wifi_screen); //go to  wifi screen
					}
#if defined(newhw)
					else if (Admin_Setting_Page == Ethernet_tb) //make changes here
							{
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = ethernet_screen;
						enQueue_hmi(ethernet_screen); //go to ethernet
					} else if (Admin_Setting_Page == GSM_tb) {
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						Clear_Register = GSM_screen;
						enQueue_hmi(GSM_screen); //go to  gsm screen
					}
#endif
					else if (Admin_Setting_Page == exit_b) //make changes here
							{
						HMI_Page = 0;
						Admin_Setting_Page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					}
				}
			} else if (current_page == GSM_screen) {
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (gsm_page == Back) //make changes here
							{
						HMI_Page = 0;
						gsm_page = 0;
						enQueue_hmi(network_select_screen); //go to main page
					} else if (gsm_page == Save) {
						gsm_page = 0;
						network_switch_flag = 1;

						enQueue_hmi(508);
						write_para = 1;
						//read ssid and Password
					} else if (gsm_page == GSM_ENABLE) {
						if (GSM.gsm_enable_sts == 1) {
							GSM.gsm_enable_sts = 0;
						} else {

							GSM.wifi_enable_sts = 0;
							GSM.ethernet_enable_sts = 0;
							GSM.gsm_enable_sts = 1;
							OCPP.Communication_Mode = 1; // for GSM  V4.1.1
						}
						enQueue_hmi(510);
						gsm_page = 0;
					} else if ((gsm_page == ipv4selen)
							|| (gsm_page == ipv6selen)
							|| (gsm_page == ipv4v6selen)) {
						if (gsm_page == ipv4selen)
							OCPP.ipselection = 0;
						else if (gsm_page == ipv6selen)
							OCPP.ipselection = 1;
						else if (gsm_page == ipv4v6selen)
							OCPP.ipselection = 2;

						enQueue_hmi(512);
						gsm_page = 0;
					}

				}
			} else if (current_page == ethernet_screen) {
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (ethernet_page == Back) //make changes here
							{
						HMI_Page = 0;
						ethernet_page = 0;
						enQueue_hmi(network_select_screen); //go to main page
					} else if (ethernet_page == Save) {
						ethernet_page = 0;
						enQueue_hmi(506);
						network_switch_flag = 1;
						write_para = 1;
						//read ssid and Password
					} else if (ethernet_page == ethernet_enable) {
						if (GSM.ethernet_enable_sts == 1) {
							GSM.ethernet_enable_sts = 0;
						} else {
							GSM.gsm_enable_sts = 0;
							GSM.wifi_enable_sts = 0;
							GSM.ethernet_enable_sts = 1;
							OCPP.Communication_Mode = 3; // for GSM  V4.1.1
						}
						enQueue_hmi(510);
						ethernet_page = 0;
					}

				}
			} else if (current_page == wifi_screen) {
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (wifi_page == Back) //make changes here
							{
						HMI_Page = 0;
						wifi_page = 0;
						enQueue_hmi(network_select_screen); //go to main page
					} else if (wifi_page == Save) {
						wifi_page = 0;
						network_switch_flag = 1;
						enQueue_hmi(504);
						write_para = 1;
						//read ssid and Password
					} else if (wifi_page == wifi_enable) {
						if (GSM.wifi_enable_sts == 1) {
							GSM.wifi_enable_sts = 0;
						} else {
							GSM.gsm_enable_sts = 0;

							GSM.ethernet_enable_sts = 0;
							GSM.wifi_enable_sts = 1;
							OCPP.Communication_Mode = 2; // for GSM  V4.1.1
						}
						enQueue_hmi(510);
						wifi_page = 0;
					}
				}
			}
			//////////////////////////////////////////////////////////
			///////////////////////V4.1.0/////////////////////////////////
			else if (current_page == configmenu_screen) {
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (configmenu_page == Back) //make changes here
							{
						HMI_Page = 0;
						configmenu_page = 0;
						Store_Key_Parameter = 1;
						enQueue_hmi(Main_screen); //go to main page
					} else if (configmenu_page
							== stopchargingInternetLoss_enable) {
						if (Ocpp_Setting.stoptransinternetLoss == 1) {
							Ocpp_Setting.stoptransinternetLoss = 0;
						} else {
							Ocpp_Setting.stoptransinternetLoss = 1;
						}
						enQueue_hmi(511);
						configmenu_page = 0;
					} else if (configmenu_page == chargeravailable_enable) {
						if (Ocpp_Setting.Operative[0]
								== Unavailable_ChargerPoint) {
							Ocpp_Setting.Operative[0] = Available_ChargerPoint;
							Ocpp_Setting.Operative[1] = Available_ChargerPoint;
							Ocpp_Setting.Operative[2] = Available_ChargerPoint;
							Ocpp_Setting.Operative[3] = Available_ChargerPoint;
							charger_status_G1.charging_status =
									Available_ChargerPoint;
							charger_status_G1.timer =
									Ocpp_Setting.StatusDuration;

						} else {
							Ocpp_Setting.Operative[0] =
									Unavailable_ChargerPoint;
							Ocpp_Setting.Operative[1] =
									Unavailable_ChargerPoint;
							Ocpp_Setting.Operative[2] =
									Unavailable_ChargerPoint;
							Ocpp_Setting.Operative[3] =
									Unavailable_ChargerPoint;
							charger_status_G1.charging_status =
									Unavailable_ChargerPoint;
							charger_status_G1.timer =
									Ocpp_Setting.StatusDuration;
						}
						enQueue_hmi(511);
						configmenu_page = 0;
					} else if (configmenu_page == preauthorization_enable) {
						if (Ocpp_Setting.LocalPreAuth == 1) {
							Ocpp_Setting.LocalPreAuth = 0;
						} else {
							Ocpp_Setting.LocalPreAuth = 1;
						}
						enQueue_hmi(511);
						configmenu_page = 0;
					} else if (configmenu_page
							== ENofflinetranstwithunknID_enable) {
						if (Ocpp_Setting.AllowOfflineTXUnknownId == 1) {
							Ocpp_Setting.AllowOfflineTXUnknownId = 0;
						} else {
							Ocpp_Setting.AllowOfflineTXUnknownId = 1;
						}
						enQueue_hmi(511);
						configmenu_page = 0;
					} else if (configmenu_page == lclauthOffline_enable) {
						if (Ocpp_Setting.LocalAuthOffln == 1) {
							Ocpp_Setting.LocalAuthOffln = 0;
						} else {
							Ocpp_Setting.LocalAuthOffln = 1;
						}
						enQueue_hmi(511);
						configmenu_page = 0;
					}

				}
			}

			/////////////////////////////////////////////////////////////
			else if (current_page == Protection_screen) //Protection
					{
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (Protection_Page == Back) {
						HMI_Page = 0;
						Protection_Page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (Protection_Page == Save) {
						enQueue_hmi(1202);
						Protection_Page = 0; //Read Protection
					} else if (Touch_Action == 0) {
						//enQueue_hmi(1200);
					}
				}
			} else if (current_page == History_screen) //HISTORY
					{
				if (((HMI_Page % 100) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (history_page == Back) {
						HMI_Page = 0;
						history_page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (Clear_Register == Back_screen) {
						Clear_Register = 0;
						history_page = Back;
						enQueue_hmi(2007);
						// history_page = Back;
					} else if (history_page == clear) {
						HMI_Page = 0;
						history_page = 0;
						next_page = 1;
						enQueue_hmi(2003);
						//clear log from memory and hmi
					} else if (next_page == 1) {
						HMI_Page = 0;
						history_page = 0;
						next_page = 0;
						enQueue_hmi(2006);
					} else if (history_page == down) {
						HMI_Page = 0;
						history_page = 0;
						enQueue_hmi(2004);
						//next five
					} else if (history_page == up) {
						HMI_Page = 0;
						history_page = 0; //back
						enQueue_hmi(2005);
					}
				}
			} else if (current_page == Password_setting_screen) //PASSWORD
					{
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (Password_setting_Page == exit_b) {
						HMI_Page = 0;
						Password_setting_Page = 0;
						enQueue_hmi(Main_screen); //go to main page
					} else if (Password_setting_Page == Save) {
						enQueue_hmi(1402);
						Password_setting_Page = 0; //Read Protection
					}
				}
			} else if (current_page == RTC_screen) //RTC
					{
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (Rtc_Page == Back) {
						HMI_Page = 0;
						Rtc_Page = 0;
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (Rtc_Page == enter) {
						enQueue_hmi(1602);
						Rtc_Page = 0; //Read Protection
					}
				}
			} else if ((current_page == Select_Charging_Screen)
					|| (current_page == Select_Charging_Screen_G2)
					|| (current_page == Select_Charging_Screen_G3)) //charging setting
					{
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (charging_setting_Page == Back) {
						HMI_Page = 0;
						charging_setting_Page = 0;
						if (current_page == Select_Charging_Screen) {
							charger_status_G1.start = Stoped;
						}

						if (current_page == Select_Charging_Screen_G2) {
							charger_status_G2.start = Stoped;
						}

						if (current_page == Select_Charging_Screen_G3) {
							charger_status_G3.start = Stoped;
						}
						enQueue_hmi(Main_screen); //go to main page
					} else if (charging_setting_Page == Save) {
						enQueue_hmi(1702);
						next_page = 1;
						charging_setting_Page = 0; //Read charging
					} else if (charging_setting_Page == Automatic) {

						automatic_charging = 1;
						charge_by_time = 0;
						charging_unit = 0;

						next_page = 1;
						charging_setting_Page = 0; //Read charging
						//	enQueue_hmi(Authentication_screen);
						//automatic_charging = 0;
						//enQueue_hmi(1704);
					} else if (next_page == 1) {
						next_page = 0;
						if (gun_start == Gun1) {
							charger_status_G1.start = Authenticate;
							charger_status_G1.charge_by_time = charge_by_time;
							charger_status_G1.charge_by_energy = charging_unit;
							charger_status_G1.charge_by_automatic =
									automatic_charging;
						} else if (gun_start == Gun2) {
							charger_status_G2.start = Authenticate;
							charger_status_G2.charge_by_time = charge_by_time;
							charger_status_G2.charge_by_energy = charging_unit;
							charger_status_G2.charge_by_automatic =
									automatic_charging;
						} else if (gun_start == Gun3) {
							charger_status_G3.start = Authenticate;
							charger_status_G3.charge_by_time = charge_by_time;
							charger_status_G3.charge_by_energy = charging_unit;
							charger_status_G3.charge_by_automatic =
									automatic_charging;
						}

						if (automatic_charging == 1) {
							clear_rfid = 1;
							/*if(Ocpp_Setting.AllowOfflineTXUnknownId == true)
							 {
							 if(current_page == Select_Charging_Screen)
							 {
							 charger_status_G1.Authentication_done =1;
							 //									charger_status_G1.start = Try_To_Start;
							 //									charger_status_G1.reson = Local;
							 }
							 else if(current_page == Select_Charging_Screen_G2)
							 {
							 charger_status_G2.Authentication_done =1;
							 //									charger_status_G2.start = Try_To_Start;
							 //									charger_status_G2.reson = Local;
							 }
							 else if(current_page == Select_Charging_Screen_G3)
							 {
							 charger_status_G3.Authentication_done =1;
							 //	charger_status_G3.start = Try_To_Start;
							 //	charger_status_G3.reson = Local;
							 }
							 }
							 else
							 {*/
							if (current_page == Select_Charging_Screen)
								enQueue_hmi(Authentication_screen);
							else if (current_page == Select_Charging_Screen_G2)
								enQueue_hmi(Authentication_screen_G2);
							else if (current_page == Select_Charging_Screen_G3)
								enQueue_hmi(Authentication_screen_G3);
							//}

							automatic_charging = 0;
						} else if ((charge_by_time != 0)
								|| (charging_unit != 0)) {
							clear_rfid = 1;
							/*if(Ocpp_Setting.AllowOfflineTXUnknownId == true)
							 {
							 if(current_page == Select_Charging_Screen)
							 {
							 charger_status_G1.Authentication_done =1;
							 //									charger_status_G1.start = Try_To_Start;
							 //									charger_status_G1.reson = Local;
							 }
							 else if(current_page == Select_Charging_Screen_G2)
							 {
							 charger_status_G2.Authentication_done =1;
							 //									charger_status_G2.start = Try_To_Start;
							 //									charger_status_G2.reson = Local;
							 }
							 else if(current_page == Select_Charging_Screen_G3)
							 {
							 charger_status_G3.Authentication_done =1;
							 //charger_status_G3.start = Try_To_Start;
							 //charger_status_G3.reson = Local;
							 }
							 }
							 else*/
							{
								if (current_page == Select_Charging_Screen)
									enQueue_hmi(Authentication_screen);
								else if (current_page
										== Select_Charging_Screen_G2)
									enQueue_hmi(Authentication_screen_G2);
								else if (current_page
										== Select_Charging_Screen_G3)
									enQueue_hmi(Authentication_screen_G3);
							}

//							if(current_page == Select_Charging_Screen) enQueue_hmi(Authentication_screen);
//							else if(current_page == Select_Charging_Screen_G2) enQueue_hmi(Authentication_screen_G2);
//							else if(current_page == Select_Charging_Screen_G3) enQueue_hmi(Authentication_screen_G3);
							automatic_charging = 0;
						}
					}
					///////////////////////////////////////////////////////////////////////
				}
			} else if (current_page == Charging_Setting_screen) //pricing setting
					{
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (pricing_setting_Page == enter) {
						HMI_Page = 0;
						enQueue_hmi(1802);
						pricing_setting_Page = 0;
						//go to main page
					} else if (pricing_setting_Page == Back) {
						enQueue_hmi(Admin_Menu_screen);
						pricing_setting_Page = 0; //Read pricing
					} else if (Touch_Action == 0) {
						//enQueue_hmi(1800);
					}
				}
			} else if ((current_page == Billing_screen)
					|| (current_page == Billing_screen_G2)
					|| (current_page == Billing_screen_G3)) //Bill
					{
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {

					if (Bill_Page == Back) {
						next_page_bill = 0;
						HMI_Page = 0;
						Bill_Page = 0;
						update_variable = 1;
						//Billing_done = 1;
						enQueue_hmi(Main_screen); //go to main page
					} else if (Bill_Page == enter) {
						next_page_bill = 0;
						//enQueue_hmi(2502);
						Billing_done = 1;
						HMI_Page = 0;
						Bill_Page = 0; //Read charging
						update_variable = 1;
						enQueue_hmi(Main_screen);
					}
				}
			} else if ((current_page == Gun_Reading_screen)
					|| (current_page == Gun_Reading_screen_G2)
					|| (current_page == Gun_Reading_screen_G3)) //
					{
				if ((HMI_Page == 30)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {

					if (gun_stop == Gun1) {
						//charger_status_G1.stop = 25;
						enQueue_hmi(110); // Energy Mater Data
					} else if (gun_stop == Gun2) {
						//charger_status_G2.stop = 25;
						enQueue_hmi(120); // Energy Mater Data
					} else if (gun_stop == Gun3) {
						//charger_status_G3.stop = 25;
						enQueue_hmi(121); // Energy Mater Data
					}
				}
//			else if(((HMI_Page % 50) == 0) && (huart3.gState != HAL_UART_STATE_BUSY_TX))
//			{
//				//////////////////////////////////V3.3.1/////////////////
//				 if(gun_stop == Gun1)
//				{
//					//charger_status_G1.stop = 25;
//					enQueue_hmi(110); // Energy Mater Data
//				}
//				else if(gun_stop == Gun2)
//				{
//					//charger_status_G2.stop = 25;
//					enQueue_hmi(120); // Energy Mater Data
//				}
//				else if(gun_stop == Gun3)
//				{
//					//charger_status_G3.stop = 25;
//					enQueue_hmi(121); // Energy Mater Data
//				}
//			}
				else if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (Gun_parameter == stop) {
						HMI_Page = 0;
						Gun_parameter = 0;
						clear_rfid = 1;

						/*	if(Ocpp_Setting.AllowOfflineTXUnknownId == true)
						 {
						 if(gun_stop == Gun1)
						 {
						 charger_status_G1.stop = Try_To_Stop;
						 charger_status_G1.reson = Local;
						 charger_status_G1.charging_status = Finishing_ChargerPoint;
						 }
						 if(gun_stop == Gun2)
						 {
						 charger_status_G2.stop = Try_To_Stop;
						 charger_status_G2.reson = Local;
						 charger_status_G2.charging_status = Finishing_ChargerPoint;
						 }

						 if(gun_stop == Gun3)
						 {
						 charger_status_G3.stop = Try_To_Stop;
						 charger_status_G3.reson = Local;
						 charger_status_G3.charging_status = Finishing_ChargerPoint;
						 }
						 }
						 else*/
						{
							if (gun_stop == Gun1) {
								charger_status_G1.stop = Authenticate;
								clear_rfid = 1;
								enQueue_hmi(Authentication_screen);
							}
							if (gun_stop == Gun2) {
								charger_status_G2.stop = Authenticate;
								clear_rfid = 1;
								enQueue_hmi(Authentication_screen_G2);
							}

							if (gun_stop == Gun3) {
								charger_status_G3.stop = Authenticate;
								clear_rfid = 1;
								enQueue_hmi(Authentication_screen_G3);
							}
						}
						//enQueue_hmi(25); //go to main page
					} else if (Gun_parameter == Back) {
						if (gun_stop == Gun1) {
							charger_status_G1.stop = Stoped;

						}
						if (gun_stop == Gun2) {
							charger_status_G2.stop = Stoped;

						}

						if (gun_stop == Gun3) {
							charger_status_G3.stop = Stoped;

						}
						HMI_Page = 0;
						gun_stop = 0;
						Gun_parameter = 0; //Read charging
						enQueue_hmi(Main_screen);

					}
//////////////////////////////////////////////////////////////////////////////////////////
				}
			} else if (current_page == rfid_screen) //Bill
					{
				if (((HMI_Page % 50) == 0)
						&& (huart3.gState != HAL_UART_STATE_BUSY_TX)) {
					if (rfid_page == Back) {
						HMI_Page = 0;
						Rfid_Add = 0;
						rfid_page = 0;
						//Clear_Register = 24;//4.1.4
						enQueue_hmi(Admin_Menu_screen); //go to main page
					} else if (rfid_page == Save) {
						rfid_page = 0; //Read charging
						HMI_Page = 0;
						if (LocalListAdding != 0) //4.1.5 change
								{
							rfid_pointer.Added_rfid = 0; // LocalListAdding;
							rfid_pointer.version = 0;
//								rfid_pointer.Added_rfid = LocalListAdding;
							rfid_pointer.lastPointer = (3816 * 4096);
							Rfid_Add = 0;
							//	write_para = 1;
							Local_List_Update = 1;
						}
						enQueue_hmi(Admin_Menu_screen);
					} else if (rfid_page == Rfid1_Add) {
						HMI_Page = 0;
						rfid_page = 0;
						Rfid_Add = 1;
					} else if (rfid_page == Rfid1_Remove) {
						if (rfid_data.status[1] == 1) {
							for (i = 0; i < 13; i++) {
								rfid_data.TagId[1][i] = '\0';
							}
							LocalListAdding = rfid_pointer.Added_rfid;
							rfid_data.status[1] = 0;
						}

						HMI_Page = 0;
						rfid_page = 0;
						enQueue_hmi(2402);
					} else if (rfid_page == Rfid2_Add) {
						Rfid_Add = 2;
						HMI_Page = 0;
						rfid_page = 0;
					} else if (rfid_page == Rfid2_Remove) {
						if (rfid_data.status[2] == 1) {
							for (i = 0; i < 13; i++) {
								rfid_data.TagId[2][i] = '\0';
							}
							LocalListAdding = rfid_pointer.Added_rfid;
							rfid_data.status[2] = 0;
						}
						HMI_Page = 0;
						rfid_page = 0;
						enQueue_hmi(2402);
					} else if (rfid_page == Rfid3_Add) {
						HMI_Page = 0;
						rfid_page = 0;
						Rfid_Add = 3;
					} else if (rfid_page == Rfid3_Remove) {
						if (rfid_data.status[3] == 1) {
							for (i = 0; i < 13; i++) {
								rfid_data.TagId[3][i] = '\0';
							}
							rfid_data.status[3] = 0;
							LocalListAdding = rfid_pointer.Added_rfid;
						}
						HMI_Page = 0;
						rfid_page = 0;
						enQueue_hmi(2402);
					} else if (rfid_page == Rfid4_Add) {
						Rfid_Add = 4;
						HMI_Page = 0;
						rfid_page = 0;
					} else if (rfid_page == Rfid4_Remove) {
						if (rfid_data.status[4] == 1) {
							for (i = 0; i < 13; i++) {
								rfid_data.TagId[4][i] = '\0';
							}
							rfid_data.status[4] = 0;
							LocalListAdding = rfid_pointer.Added_rfid;
						}
						HMI_Page = 0;
						rfid_page = 0;
						enQueue_hmi(2402);
					} else if (rfid_page == Rfid5_Add) {
						Rfid_Add = 5;
						HMI_Page = 0;
						rfid_page = 0;
					} else if (rfid_page == Rfid5_Remove) {
						if (rfid_data.status[5] == 1) {
							for (i = 0; i < 13; i++) {
								rfid_data.TagId[5][i] = '\0';
							}
							rfid_data.status[5] = 0;
							LocalListAdding = rfid_pointer.Added_rfid;
						}
						HMI_Page = 0;
						rfid_page = 0;
						enQueue_hmi(2402);
					} else if (Touch_Action == 0) {
						//enQueue_hmi(2400);
					}
				}
			}
		}
	}
}
/**
 * @brief Retrieve and transmit historical data from memory for a specified page.
 *
 * This function retrieves historical data for the specified page and transmits it
 * over UART. The data is formatted and transmitted in a specific protocol.
 *
 * @param[in] page The page number for which historical data needs to be retrieved.
 * @return 0 if reading data from memory fails.
 *
 * @note The historical data is read from a specific location in flash memory.
 * @note The transmitted data includes password setting parameters and historical information.
 */
uint8_t History(uint16_t page) {
	uint16_t ret;
	char myString[5];
	if (page > 9999) {
		return 0;
	}
	if (byte_in < sizeof(data_from_flash)) {
		return 0;
	}

	ret = read_last_data(page);
	if (ret == 0) {
		return 0;
	}

	snprintf(myString, 5, "%u", page);
	//itoa(page, myString, 5);

	WRITE_TOUCH[2] = 68 + 3 + 4;
	WRITE_TOUCH[4] = 0x5F;
	WRITE_TOUCH[5] = 0xFE; // write password setting parameter

	WRITE_TOUCH[6] = (uint8_t) ((page % 10000 / 1000) + '0');
	WRITE_TOUCH[7] = (uint8_t) ((page % 1000 / 100) + '0');
	WRITE_TOUCH[8] = (uint8_t) ((page % 100 / 10) + '0');
	WRITE_TOUCH[9] = (page % 10 + '0');

	char *ptr = &data_from_flash;
	if (ptr[0] == '$') {
		//ptr[1] = (page >> 4) + '0';
		//ptr[2] = page + '0';
	}
	//ptr[2] = '\0';
	for (int i = 1; i < 69; i++) {
		WRITE_TOUCH[9 + i] = (uint8_t) ptr[i];
	}

	HAL_UART_Transmit(&huart3, (uint8_t*) WRITE_TOUCH, 78, 0xffff);
	return ret;
}
////////////////////////////////////V3.3.1///////////////////////////////
/**
 * @brief Enqueue a value into the HMI (Human-Machine Interface) data queue.
 *
 * This function adds a value to the HMI data queue if it is not full.
 *
 * @param[in] value The value to be enqueued into the HMI data queue.
 * @return NA (No meaningful return value).
 *
 * @note If the queue is full, the value is not enqueued.
 * @note If the queue is initially empty, the front index is set to 0.
 */
void enQueue_hmi(unsigned int value) {
	if (isFull_hmi() == true) {

	} else {
		if (FRONT_hmi == -1) {
			FRONT_hmi = 0;
		}

		REAR_hmi++;

		//int value;
		// printf("Enter a value to be add: ");
		//scanf("%d",&value);
		queue_data_hmi[REAR_hmi] = value;
		// printf("%d is added to the Queue\n", value);
	}
}
/**
 * @brief Dequeue a value from the HMI (Human-Machine Interface) data queue.
 *
 * This function removes and returns a value from the HMI data queue if it is not empty.
 *
 * @return The dequeued value from the HMI data queue.
 * @return Return the dequeued value
 *
 * @note If the queue becomes empty after dequeue, the front and rear indices are reset to -1.
 */
unsigned int deQueue_hmi() {
	unsigned int val;

	//else
	{
		//printf("%d is deleted\r\n",
		val = queue_data_hmi[FRONT_hmi];

		FRONT_hmi++;

		/* Reset it, if we reached the end */
		if (FRONT_hmi > REAR_hmi) {
			FRONT_hmi = REAR_hmi = -1;
		}
	}
	return val;
}
/**
 * @brief Check if the HMI (Human-Machine Interface) data queue is empty.
 *
 * This function checks if the HMI data queue is empty based on the front index.
 *
 * @return true if the HMI data queue is empty, false otherwise.
 */
char isEmpty_hmi() {
	char isQueueEmpty = false;

	if (FRONT_hmi == -1) {
		isQueueEmpty = true;
	}

	return (isQueueEmpty);
}
/**
 * @brief Check if the HMI (Human-Machine Interface) data queue is full.
 *
 * This function checks if the HMI data queue is full based on the rear index.
 *
 * @return true if the HMI data queue is full, false otherwise.
 */
char isFull_hmi() {
	char isQueueFull = false;

	if (REAR_hmi == MAX_hmi - 1) {
		isQueueFull = true;
	}

	return (isQueueFull);
}
/**
 * @brief Peek at the front element of the HMI (Human-Machine Interface) data queue.
 *
 * This function checks if the HMI data queue is empty and prints the front element
 * if it is not empty.
 *
 * @note This function does not remove the element from the queue.
 * @return NA (No meaningful return value).
 */
void peek_hmi() {
	if (isEmpty_hmi() == true) {
		//  printf("Queue is Empty!!!\n");
	} else {
		//printf("Top Element is %d\n", queue[FRONT]);
	}
}
//////////////////////////////////////////////////////////////////////////////////
