
typedef enum Conn_States
{
  Idle_con = 0U,
  PluggedIn_con,
  Disconnected_con,
  Error_con,
}Conn_States;

typedef enum EV_Status
{
  No_Error,
  BMS_SOCReached,
  TotalVoltageReached,
  SingleVoltageReached,
  ChargerSuspended,
  InsulationFault,
  OutConnOverTemp,
  BMSOutConnOverTemp,
  ConnFault,
  BatSetOverTemp,
  HighVoltRelayFault,
  CheckPt2Fault,
  OtherFault,
  ExcessCurrent,
  AbnormalVoltage,
  VendorCodeFault,
  TO_CRM,
  TO_CRM_AA,
  TO_CTS_CML,
  TO_CRO,
  TO_CCS,
  TO_CST,
  TO_CSD,
}EV_Status;

typedef enum EVSE_Status
{
  Idle_status,
  ChargerSuspended_ByCharger,
  ChargerSuspended_Artificially,
  ChargerSuspended_DuetoFault,
  ChargerSuspended_BMSSuspends,
  ChargerSuspended_EmergencyStop,
  ChargerSuspended_ThresholdBritch,
  ChargerSuspended_CurrentMismatch,
  ChargerSuspended_OverTemperature,
  ChargerSuspended_ConnectorFault,
  ChargerSuspended_OverTempIntPart,
  ChargerSuspended_TransmitFault,
  Powermodule_State,
  idle,
  initialisation,
  charging,
  discharging,
  emergency,
  OCPP_Charger_State,
  Available,
  Preparing,
  Charging_status,
  SuspendedEV,
  DC001_safetyInterlock_State,
  NoError,
  DC001_GunLock_fb_In,
  DC001_InsulationFault,
  DC001_EarthLeakage,
  DC001_OpenDoorFault,
  ChargerSuspended_OtherFaults,
  ChargerSuspended_BMSManfCodeError,
  ChargerSuspended_VoltageAbnormal,
  TO_BCL,
  TO_BCS,
  TO_BRO,
  TO_BST,
  TO_BCP,
  TO_BRM,
  TO_BSD,
}EVSE_Status;

typedef enum PowerModule_States
{
  idle_pm,
  initialisation_pm,
  charging_pm,
  discharging_pm,
  emergency_pm,
}PowerModule_States;

typedef enum OCPP_States
{
  idle_ocpp,
  initialisation_ocpp,

  G1_Authorization_ocpp =16 ,
  G2_Authorization_ocpp = 17,
  G3_Authorization_ocpp = 18,

  G1_charging_ocpp = 5,
  G1_discharging_ocpp = 8,
  //emergency_ocpp,
  G1_MeterValue_Periodic_ocpp = 11,

  G1_StatusNotification_ocpp=2,

  G2_StatusNotification_ocpp = 3,
  G2_charging_ocpp = 6,
  G2_discharging_ocpp = 9,
  G2_MeterValue_Periodic_ocpp = 12,

  G3_StatusNotification_ocpp=4,
  G3_charging_ocpp = 7,
  G3_discharging_ocpp = 10,
  G3_MeterValue_Periodic_ocpp = 13,

  DataTransferChargingType_G1_ocpp = 19,
  DataTransferChargingType_G2_ocpp = 20,
  DataTransferChargingType_G3_ocpp = 21,

  FirmwareNotification_Req = 22,
  datatansfer = 23,
  Heartbeat_ocpp = 24,
  G_StatusNotification_ocpp = 25,

  G1_MeterValue_Began_ocpp = 26,
  G1_MeterValue_End_ocpp = 27,
  G1_MeterValue_ClockAlign_ocpp = 28,

  G2_MeterValue_Began_ocpp = 29,
  G2_MeterValue_End_ocpp = 30,
  G2_MeterValue_ClockAlign_ocpp = 31,

  G3_MeterValue_Began_ocpp = 32,
  G3_MeterValue_End_ocpp = 33,
  G3_MeterValue_ClockAlign_ocpp = 34,
  G_MeterValue_ClockAlign_ocpp = 35,
  Stop_Tx_On_Cach_Memory = 36,
  power_ON_available_ocpp=37		//v4.x.8

}OCPP_States;

typedef enum Safety_Interlock
{
  Safety_NoError,
  Safety_DC001_GunLockfb_In,
  Safety_DC001_InsulationFault,
  Safety_DC001_EarthLeakage,
  Safety_DC001_OpenDoorFault,
  Safety_ChargerSuspended_OtherFaults,
  Safety_ChargerSuspended_BMSManfCodeError,
  Safety_ChargerSuspended_VoltageAbnormal,
  Safety_TO_BCL,
  Safety_TO_BCS,
  Safety_TO_BRO,
  Safety_TO_BST,
  Safety_TO_BCP,
  Safety_TO_BRM,
  Safety_TO_BSD,
  Safety_DC001_Emergency_In,
  Safety_Powermodule_Error,
  Safety_Powermodule_Connection_status,
  Safety_EnergyMeter_Connection_status,
  Safety_DC001_OCPP__Errorcode,
  Safety_DC001_OCPP__Active,
  Safety_DC001_OCPP__Emergency,
  Safety_DC001_OCPP__Reason,
  Safety_DC001_Comm_SuspendCharging_EVSE_Out,
  Safety_DC001_Comm_SuspendCharging_EV_In,
  Safety_DC001_CAN_Commmunication_Status,
  Safety_TCP_Communication_status,
  Safety_IMD_Connection_status,
}Safety_Interlock;

extern volatile OCPP_States OCPP_State_ACType2;
extern char wifi_connected;
void modbus_check(void);
unsigned short int CRC16 (unsigned char *, unsigned short int );
//void modbus_exemtion(unsigned char);
//void HMI_Page(int );
void HMI_Process(unsigned char []);
void HMI_Send(int );
void Energy_MeterRead(char);
void Send_Meterquery(unsigned char);
extern unsigned char meterquerycntr;
void make_query(unsigned char,unsigned char ,unsigned int ,unsigned int);
