/**
  ******************************************************************************
  * @file    tim.c
  * @brief   This file provides code for the configuration
  *          of the TIM instances.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under Ultimate Liberty license
  * SLA0044, the "License"; You may not use this file except in compliance with
  * the License. You may obtain a copy of the License at:
  *                             www.st.com/SLA0044
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "tim.h"

/* USER CODE BEGIN 0 */
char timer,timer_1s,timer_100ms,update_CP_Count,update_CP_1_Count,fwUpdateTimer = 0;
extern UART_HandleTypeDef huart3;
uint8_t start_timer;
extern char ocpp_timer;
uint16_t Dutycycle=0;
char pwm_start_stop=0,pwm_start_stop_1;

uint16_t PWM_DutyCycle=1;
extern uint8_t PWM_stop_flag;
/* USER CODE END 0 */

TIM_HandleTypeDef htim1;
TIM_HandleTypeDef htim2;
TIM_HandleTypeDef htim5;

uint16_t temptimertick=0,temptimerflag=0;

/* TIM1 init function */
void MX_TIM1_Init(void)
{

  /* USER CODE BEGIN TIM1_Init- 0 */

  /* USER CODE END TIM1_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};
  TIM_OC_InitTypeDef sConfigOC = {0};
  TIM_BreakDeadTimeConfigTypeDef sBreakDeadTimeConfig = {0};

  /* USER CODE BEGIN TIM1_Init 1 */

  /* USER CODE END TIM1_Init 1 */
  htim1.Instance = TIM1;
  htim1.Init.Prescaler = 475;
  htim1.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim1.Init.Period = 100;
  htim1.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim1.Init.RepetitionCounter = 0;
  htim1.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim1) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim1, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  if (HAL_TIM_PWM_Init(&htim1) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim1, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigOC.OCMode = TIM_OCMODE_PWM1;
  sConfigOC.Pulse = 50;
  sConfigOC.OCPolarity = TIM_OCPOLARITY_HIGH;
  sConfigOC.OCNPolarity = TIM_OCNPOLARITY_HIGH;
  sConfigOC.OCFastMode = TIM_OCFAST_ENABLE;
  sConfigOC.OCIdleState = TIM_OCIDLESTATE_RESET;
  sConfigOC.OCNIdleState = TIM_OCNIDLESTATE_RESET;
  if (HAL_TIM_PWM_ConfigChannel(&htim1, &sConfigOC, TIM_CHANNEL_1) != HAL_OK)
  {
    Error_Handler();
  }
  sConfigOC.Pulse = 50;
  sConfigOC.OCFastMode = TIM_OCFAST_ENABLE;
  if (HAL_TIM_PWM_ConfigChannel(&htim1, &sConfigOC, TIM_CHANNEL_2) != HAL_OK)
  {
    Error_Handler();
  }
  sBreakDeadTimeConfig.OffStateRunMode = TIM_OSSR_DISABLE;
  sBreakDeadTimeConfig.OffStateIDLEMode = TIM_OSSI_DISABLE;
  sBreakDeadTimeConfig.LockLevel = TIM_LOCKLEVEL_OFF;
  sBreakDeadTimeConfig.DeadTime = 0;
  sBreakDeadTimeConfig.BreakState = TIM_BREAK_DISABLE;
  sBreakDeadTimeConfig.BreakPolarity = TIM_BREAKPOLARITY_HIGH;
  sBreakDeadTimeConfig.AutomaticOutput = TIM_AUTOMATICOUTPUT_DISABLE;
  if (HAL_TIMEx_ConfigBreakDeadTime(&htim1, &sBreakDeadTimeConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM1_Init 2 */

  /* USER CODE END TIM1_Init 2 */
  HAL_TIM_MspPostInit(&htim1);

}
/* TIM2 init function */
void MX_TIM2_Init(void)
{

  /* USER CODE BEGIN TIM2_Init 0 */

  /* USER CODE END TIM2_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};

  /* USER CODE BEGIN TIM2_Init 1 */

  /* USER CODE END TIM2_Init 1 */
  htim2.Instance = TIM2;
  htim2.Init.Prescaler = 1000;
  htim2.Init.CounterMode = TIM_COUNTERMODE_UP;
  htim2.Init.Period = 479;
  htim2.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim2.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_ENABLE;
  if (HAL_TIM_Base_Init(&htim2) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim2, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim2, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM2_Init 2 */

  /* USER CODE END TIM2_Init 2 */

}
void MX_TIM5_Init(void)
{

  /* USER CODE BEGIN TIM5_Init 0 */

  /* USER CODE END TIM5_Init 0 */

  TIM_ClockConfigTypeDef sClockSourceConfig = {0};
  TIM_MasterConfigTypeDef sMasterConfig = {0};

  /* USER CODE BEGIN TIM5_Init 1 */

  /* USER CODE END TIM5_Init 1 */
  htim5.Instance = TIM5;
  htim5.Init.Prescaler = 480;
  htim5.Init.CounterMode = TIM_COUNTERMODE_UP;
#if meter == selec
  htim5.Init.Period = 13; //25
#else
  htim5.Init.Period = 26; //25 //26 //12
#endif
  htim5.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  htim5.Init.AutoReloadPreload = TIM_AUTORELOAD_PRELOAD_DISABLE;
  if (HAL_TIM_Base_Init(&htim5) != HAL_OK)
  {
    Error_Handler();
  }
  sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim5, &sClockSourceConfig) != HAL_OK)
  {
    Error_Handler();
  }
  sMasterConfig.MasterOutputTrigger = TIM_TRGO_RESET;
  sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
  if (HAL_TIMEx_MasterConfigSynchronization(&htim5, &sMasterConfig) != HAL_OK)
  {
    Error_Handler();
  }
  /* USER CODE BEGIN TIM5_Init 2 */

  /* USER CODE END TIM5_Init 2 */

}

void HAL_TIM_Base_MspInit(TIM_HandleTypeDef* tim_baseHandle)
{

  if(tim_baseHandle->Instance==TIM1)
  {
  /* USER CODE BEGIN TIM1_MspInit 0 */

  /* USER CODE END TIM1_MspInit 0 */
    /* TIM1 clock enable */
    __HAL_RCC_TIM1_CLK_ENABLE();

    /* TIM1 interrupt Init */
    HAL_NVIC_SetPriority(TIM1_UP_TIM10_IRQn, 0, 0);
    HAL_NVIC_EnableIRQ(TIM1_UP_TIM10_IRQn);
  /* USER CODE BEGIN TIM1_MspInit 1 */

  /* USER CODE END TIM1_MspInit 1 */
  }
  else if(tim_baseHandle->Instance==TIM2)
  {
  /* USER CODE BEGIN TIM2_MspInit 0 */

  /* USER CODE END TIM2_MspInit 0 */
    /* TIM2 clock enable */
    __HAL_RCC_TIM2_CLK_ENABLE();

    /* TIM2 interrupt Init */
    HAL_NVIC_SetPriority(TIM2_IRQn, 0, 0);
    HAL_NVIC_EnableIRQ(TIM2_IRQn);
  /* USER CODE BEGIN TIM2_MspInit 1 */

  /* USER CODE END TIM2_MspInit 1 */
  }
  if(tim_baseHandle->Instance==TIM5)
    {
    /* USER CODE BEGIN TIM5_MspInit 0 */

    /* USER CODE END TIM5_MspInit 0 */
      /* Peripheral clock enable */
      __HAL_RCC_TIM5_CLK_ENABLE();
      /* TIM5 interrupt Init */
      HAL_NVIC_SetPriority(TIM5_IRQn, 0, 0);
      HAL_NVIC_EnableIRQ(TIM5_IRQn);
    /* USER CODE BEGIN TIM5_MspInit 1 */

    /* USER CODE END TIM5_MspInit 1 */
    }
}
void HAL_TIM_MspPostInit(TIM_HandleTypeDef* timHandle)
{

  GPIO_InitTypeDef GPIO_InitStruct = {0};
  if(timHandle->Instance==TIM1)
  {
  /* USER CODE BEGIN TIM1_MspPostInit 0 */

  /* USER CODE END TIM1_MspPostInit 0 */

    __HAL_RCC_GPIOE_CLK_ENABLE();
    /**TIM1 GPIO Configuration
    PE9     ------> TIM1_CH1
    PE11     ------> TIM1_CH2
    */
    GPIO_InitStruct.Pin = PWM_Gun1_Pin;
    GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull = GPIO_PULLUP;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_MEDIUM;
    GPIO_InitStruct.Alternate = GPIO_AF1_TIM1;
    HAL_GPIO_Init(PWM_Gun1_GPIO_Port, &GPIO_InitStruct);

    GPIO_InitStruct.Pin = PWM_Gun2_Pin;
    GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull = GPIO_PULLUP;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
    GPIO_InitStruct.Alternate = GPIO_AF1_TIM1;
    HAL_GPIO_Init(PWM_Gun2_GPIO_Port, &GPIO_InitStruct);

  /* USER CODE BEGIN TIM1_MspPostInit 1 */

  /* USER CODE END TIM1_MspPostInit 1 */
  }

}
void HAL_TIM_Base_MspDeInit(TIM_HandleTypeDef* tim_baseHandle)
{

  if(tim_baseHandle->Instance==TIM1)
  {
  /* USER CODE BEGIN TIM1_MspDeInit 0 */

  /* USER CODE END TIM1_MspDeInit 0 */
    /* Peripheral clock disable */
    __HAL_RCC_TIM1_CLK_DISABLE();

    /* TIM1 interrupt Deinit */
    HAL_NVIC_DisableIRQ(TIM1_UP_TIM10_IRQn);
  /* USER CODE BEGIN TIM1_MspDeInit 1 */

  /* USER CODE END TIM1_MspDeInit 1 */
  }
  else if(tim_baseHandle->Instance==TIM2)
  {
  /* USER CODE BEGIN TIM2_MspDeInit 0 */

  /* USER CODE END TIM2_MspDeInit 0 */
    /* Peripheral clock disable */
    __HAL_RCC_TIM2_CLK_DISABLE();

    /* TIM2 interrupt Deinit */
    HAL_NVIC_DisableIRQ(TIM2_IRQn);
  /* USER CODE BEGIN TIM2_MspDeInit 1 */

  /* USER CODE END TIM2_MspDeInit 1 */
  }
  if(tim_baseHandle->Instance==TIM5)
    {
    /* USER CODE BEGIN TIM5_MspDeInit 0 */

    /* USER CODE END TIM5_MspDeInit 0 */
      /* Peripheral clock disable */
      __HAL_RCC_TIM5_CLK_DISABLE();

      /* TIM5 interrupt DeInit */
      HAL_NVIC_DisableIRQ(TIM5_IRQn);
    /* USER CODE BEGIN TIM5_MspDeInit 1 */

    /* USER CODE END TIM5_MspDeInit 1 */
    }
}

/* USER CODE BEGIN 1 */
/**
  * @brief  Deinitializes TIM1 PWM channel.
  * @note   This function stops the PWM output on TIM1 Channel 1.
  * @retval None
  */
void Deinit_timer()
{
  HAL_TIM_PWM_DeInit(&htim1);
}
/**
  * @brief  Starts PWM output on TIM1 Channel 1.
  * @note   This function initializes and starts PWM output on TIM1 Channel 1
  *         with the specified duty cycle.
  * @note   If PWM is already started, this function updates the duty cycle.
  * @retval None
  */
void start_pwm()
{
	    if((pwm_start_stop == 0) /*&& (pwm_start_stop_1 == 0)*/)
		{
			HAL_Delay(100);
#if meter == normal
			Dutycycle=53;
#else
			Dutycycle=27;
#endif
//			Deinit_timer();
//			MX_TIM1_Init();
//			HAL_TIM_Base_MspInit(&htim1);
//			HAL_TIM_Base_Start_IT(&htim1);
		}

	    if(PWM_DutyCycle && (pwm_start_stop == 0))
	    	{
	    		HAL_TIM_PWM_Start_IT(&htim1, TIM_CHANNEL_1);
	    		pwm_start_stop=1;
	    	}

	/*if(PWM_DutyCycle && (pwm_start_stop==0))
	{
		HAL_Delay(100);
		Dutycycle=PWM_DutyCycle;
		Deinit_timer();
		MX_TIM1_Init();
		HAL_TIM_Base_MspInit(&htim1);
        HAL_TIM_Base_Start_IT(&htim1);
//	    HAL_TIM_PWM_Start_IT(&htim1, TIM_CHANNEL_1);
		pwm_start_stop=1;
	}*/
}
/**
  * @brief  Stops PWM output on TIM1 Channel 1.
  * @note   This function stops the PWM output on TIM1 Channel 1.
  * @retval None
  */
void stop_pwm()
{
	if(pwm_start_stop==1)
	{
		HAL_Delay(10);
		htim1.Instance-> CCR1=0;
		pwm_start_stop=0;
		HAL_TIM_PWM_Stop(&htim1, TIM_CHANNEL_1);
	}
}
/***********************************************************************************************************************************************************************/
/**
  * @brief  Stops PWM output on TIM1 Channel 2.
  * @note   This function stops the PWM output on TIM1 Channel 2.
  * @retval None
  */
void start_pwm_1()
{
	if((pwm_start_stop == 0) && (pwm_start_stop_1 == 0))
	{
		HAL_Delay(100);
#if meter == normal
			Dutycycle=53;
#else
			Dutycycle=27;
#endif
//		Deinit_timer();
//		MX_TIM1_Init();
//		HAL_TIM_Base_MspInit(&htim1);
//		HAL_TIM_Base_Start_IT(&htim1);
	}
	if(PWM_DutyCycle && (pwm_start_stop_1 == 0))
	{
		HAL_TIM_PWM_Start_IT(&htim1, TIM_CHANNEL_2);
		pwm_start_stop_1=1;
	}
}
void stop_pwm_1()
{
	if(pwm_start_stop_1==1)
	{
		HAL_Delay(10);
		htim1.Instance-> CCR2=0;
		pwm_start_stop_1=0;
		HAL_TIM_PWM_Stop(&htim1, TIM_CHANNEL_2);

	}
}
/***********************************************************************************************************************************************************************/

void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim)
{

  /* Prevent unused argument(s) compilation warning */
	if(htim->Instance==TIM1)
	{
		UNUSED(htim);
  //  adc_check();

		if(pwm_start_stop == 1)
		{
#if meter == normal
			htim1.Instance-> CCR1=53;
#else

		htim1.Instance-> CCR1=53;
#endif
		}
		else
		{
			htim1.Instance-> CCR1=0;
		}
#if defined(dualgun)
		if(pwm_start_stop_1 == 1)
		{
#if meter == normal
			htim1.Instance-> CCR2=53;
#else
			htim1.Instance-> CCR2=27;
#endif
		}
		else
		{
			htim1.Instance-> CCR2=0;
		}
#endif
	}

	else if(htim->Instance==TIM2) {

		start_timer = 1;
		if(++timer_1s >= 100)
		{
			if(++ocpp_timer > 3)
			{
				ocpp_timer = 0;
			}
			timer_1s = 0;
			fwUpdateTimer = 1;
			OCPP_data();
			Billing_calculation();
			if(++temptimertick >= 10)
				{

				temptimerflag=1;
				temptimertick=0;
				}
			HTBEATTOGGLE;
		}
		else if(++timer_100ms > 10)
		{
			timer_100ms =0;
			update_CP_Count = 1;
			update_CP_1_Count = 1;
		}
		/*if(count == 0)
		{
			start_timer = 1;
		}
		else
		{
			if(++timer_1s > 10)
			{
				if(++ocpp_timer > 2)
				{
					ocpp_timer = 0;
				}
				timer_1s = 0;
				OCPP_data();
				Billing_calculation();
			}
		}*/
		//count = !count;

			if(huart3.gState == HAL_UART_STATE_BUSY_TX_RX)
			{
				timer++;
				if(timer > 30)
				{
					HAL_NVIC_DisableIRQ(USART3_IRQn);
					HAL_NVIC_EnableIRQ(USART3_IRQn);
					timer = 0;
				}
			}
			else
			{
				timer =0;
			}
	}
	else if(htim->Instance==TIM5) {

		UNUSED(htim);
		HAL_TIM_Base_Stop(&htim5);
	}
}
/* USER CODE END 1 */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
