/*
 * OCPP.h
 *
 *  Created on: 13-Jan-2020
 *      Author: aed
 */
/**************INCLUDE BLOCK**************/
#ifndef OCPP_H_
#define OCPP_H_

#include <stdint.h>

/***** Data Type, Constant, and Macro Definitions *****/

/* Constant DATA */

/* enum struct parameters */

struct Config_Parameter
{
	char fw_status;//364
	char fw_uri[100]; //181
	char fw_servername[30]; //211
	char fw_username[20]; //231
	char fw_Password[20]; //251
	char fw_Port[5]; //256
	char Communication_Mode;
	char wifi_ssid[20];
	char wifi_password[20];
	unsigned char ether_ip[10]; //61
	unsigned char ether_getway[10]; //71
	unsigned char ether_subnetmask[10];  //81
	char ipselection;				//v5.0.0
	char networkoperator[32];		//v5.0.0
	unsigned int Boot_Magic_value;
	char Mob_Num;
	char config_password[6];
	int energy_charges;
	int time_charges;
	int energy_charges_AC02;
	int time_charges_AC02;
	char ocpp_uri[100]; //181
	char OCPP_servername[30]; //211
	char OCPP_username[20]; //231
	char OCPP_Password[20]; //251
	char OCPP_Port[7]; //256
	char ocpp_status[2]; //258
	signed int under_voltage; //337
	signed int over_voltage; //341
	signed int over_current; //345
	signed int over_current_AC02;
	char vendor_id[16]; //13+350=363
	char serial_no[16];
//V501change
	unsigned int STATE_A_LEVEL;
	unsigned int STATE_B_LEVEL;
	unsigned int STATE_C_LEVEL;
	unsigned int STATE_D_LEVEL;
	unsigned int auxinput;
	uint32_t acc_enery1;
	uint32_t acc_enery2;
	uint32_t acc_enery3;

//V501change
	unsigned int magic_value; //368
};

struct Config_Parameter_OCPP
{
	unsigned char LocalAuthListEnbl;
	unsigned int FailedTx_Intvl;
	unsigned char FailedAttempt;
	unsigned char StopTxInvalidId;
	unsigned char ResetRetry;
	unsigned int StatusDuration;
	unsigned int MeterIntvl;
	unsigned char LocalPreAuth;
	unsigned char LocalAuthOffln;
	unsigned int ClkAlgnIntvl;
	unsigned char AuthRemotTx;
	unsigned char AuthCachEnable;
	unsigned char AllowOfflineTXUnknownId;
	unsigned int HeartbeatIntvl;
	unsigned char Operative[4];
	unsigned int dummy;
	unsigned char stoptransinternetLoss;
	unsigned char count;
	unsigned char offset;
	unsigned int AUX;
	unsigned char gfd;
	unsigned int magic_value; //368
};
//////////////////4G_parameter///////////////

struct gsm_Parameter
{
	char gsm_enable_sts;
	char wifi_enable_sts;
	char ethernet_enable_sts;
	char mobile_no[12];
	char imeino[20];
	char csq[3];
	char lattitude[20];
	char longitude[20];
	char firmware[10];
};

struct Config_Parameter_Cach_Memory
{
	//unsigned long int transaction_id[10]; //40   //remove
	unsigned char Tag_Id[10][20];     //200
	//unsigned char StopTxTime[10][28]; //200   // remove
	//unsigned int Metervalue[10]; //20          // remove
	//unsigned char Reson[10]; //10       // remove
	unsigned char counter; //1
	unsigned char dummy; //1
	char expiry_tag[10][28];
	unsigned int magic_value; // //2
};

////Charger Related ////////////////////////////////////////////////////////
enum DataTransferStatus {

        /// <remarks/>
        Accepted,

        /// <remarks/>
        Rejected,

        /// <remarks/>
        UnknownMessageId,

        /// <remarks/>
        UnknownVendorId,
    };
enum RegistrationStatus {

        /// <remarks/>
        Accepted_ChargerPointReg,

        /// <remarks/>
        Pending_ChargerPointReg,

        /// <remarks/>
        Rejected_ChargerPointReg,
    };
enum DiagnosticsStatus {

        /// <remarks/>
        Idle_ChargerPointDiag,

        /// <remarks/>
        Uploaded,

        /// <remarks/>
        UploadFailed,

        /// <remarks/>
        Uploading,
    };
enum FirmwareStatus {

        /// <remarks/>
        Downloaded,

        /// <remarks/>
        DownloadFailed,

        /// <remarks/>
        Downloading,

        /// <remarks/>
        Idle_ChargerPointFirmWare,

        /// <remarks/>
        InstallationFailed,

        /// <remarks/>
       Installed,

        /// <remarks/>
        Installing,
    };
enum ChargePointErrorCode {

        /// <remarks/>
        ConnectorLockFailure,

        /// <remarks/>
        EVCommunicationError,

        /// <remarks/>
        GroundFailure,

        /// <remarks/>
        HighTemperature,

        /// <remarks/>
        InternalError,

        /// <remarks/>
        LocalListConflict,

        /// <remarks/>
        NoError_ChargerPoint,

        /// <remarks/>
        OtherError,

        /// <remarks/>
        OverCurrentFailure,

        /// <remarks/>
        OverVoltage,

        /// <remarks/>
        PowerMeterFailure,

        /// <remarks/>
        PowerSwitchFailure,

        /// <remarks/>
        ReaderFailure,

        /// <remarks/>
        ResetFailure,

        /// <remarks/>
        UnderVoltage,

        /// <remarks/>
        WeakSignal,
    };
enum ChargePointStatus {

        /// <remarks/>
        Available_ChargerPoint = 0,

        /// <remarks/>
        Preparing_ChargerPoint,

        /// <remarks/>
        Charging_ChargerPoint,

        /// <remarks/>
        SuspendedEV_ChargerPoint,

        /// <remarks/>
        SuspendedEVSE_ChargerPoint,

        /// <remarks/>
        Finishing_ChargerPoint,

        /// <remarks/>
        Reserved_ChargerPoint,

        /// <remarks/>
        Faulted_ChargerPoint,

        /// <remarks/>
        Unavailable_ChargerPoint,
    };

enum Location {

        /// <remarks/>
        Body,

        /// <remarks/>
        Cable,

        /// <remarks/>
        EV,

        /// <remarks/>
        Inlet,

        /// <remarks/>
        Outlet,
    };
typedef enum   {

        /// <remarks/>
        EmergencyStop,

        /// <remarks/>
        EVDisconnected,

        /// <remarks/>
        HardReset,

        /// <remarks/>
        Local,

        /// <remarks/>
        Other,

        /// <remarks/>
        PowerLoss,

        /// <remarks/>
        Reboot,

        /// <remarks/>
        Remote,

        /// <remarks/>
        SoftReset,

        /// <remarks/>
        UnlockCommand,

        /// <remarks/>
        DeAuthorized,
    }Reason;
enum AuthorizationStatus {

        /// <remarks/>
        Accepted_ChargerPoint=1,

        /// <remarks/>
        Blocked_ChargerPoint,

        /// <remarks/>
        Expired_ChargerPoint,

        /// <remarks/>
        Invalid_ChargerPoint,

        /// <remarks/>
        ConcurrentTx_ChargerPoint,
    };

enum Ocpp_Status
{
	init_EVSE=0,

	G_StatusNotification,

	G1_StatusNotification,
	G2_StatusNotification,
	G3_StatusNotification,

	G1_StartCharging_EVSE,
	G2_StartCharging_EVSE,
	G3_StartCharging_EVSE,

	G1_StopCharging_EVSE,
	G2_StopCharging_EVSE,
	G3_StopCharging_EVSE,

	G1_MeterValue_Periodic,
	G2_MeterValue_Periodic,
	G3_MeterValue_Periodic,

	Finish_EVSE,

	idle_EVSE,

	G1_Authorise_EVSE,
	G2_Authorise_EVSE,
	G3_Authorise_EVSE,
	G1_CustomChargingType,
	G2_CustomChargingType,
	G3_CustomChargingType,
	FirmwareStatusNotification,

	  G1_MeterValue_Began = 26,
	  G1_MeterValue_End = 27,
	  G1_MeterValue_ClockAlign = 28,

	  G2_MeterValue_Began = 29,
	  G2_MeterValue_End = 30,
	  G2_MeterValue_ClockAlign = 31,

	  G3_MeterValue_Began = 32,
	  G3_MeterValue_End = 33,
	  G3_MeterValue_ClockAlign = 34,
	  G_MeterValue_ClockAlign = 35,
	  powerON_available=37		//v4.x.8
};

//3.3.1 changes///////////
enum Start_Stop{
	Try_To_Start=1,
	Started,
	Try_To_Stop,
	Stoped,
	Error,
	Authenticate = 25
};

enum Gun_Status{
	G_connected=1,
	G_charging,
	G_Error,
	G_Discharging,
	G_NoError
};
enum OcppResponse{

	Boot_Success=1,
	Boot_Fail,

	StartTransaction_Req,
	StartTransaction_Success,
	StartTransaction_Fail,

	StopTransaction_Req,
	StopTransaction_Success,
	StopTranscation_Fail,

	Current_Demand,

	Authorise_Req,
	Authorise_Success,
	Authorise_Fail,

	Not_Connect,
};
enum On_Going_Tx{

	Tx_Success,
	Tx_Pending,
	Tx_Fail,
};
/* Global variables*/
struct expiryDate
{
	uint8_t year;
	uint8_t month;
	uint8_t date;
};

struct expiryTime
{
	uint8_t Hour;
	uint8_t Minute;
	uint8_t Second;
};

struct stFirmwareUpgrade
{
	uint32_t counter;
	char status;
	struct expiryDate expDate;
	struct expiryTime expTime;
};


typedef char String[120];
// typedef char String1[100];
//typedef char StringRec[100];

/* Extern Data Declarations */

extern char meter1whclear,meter2whclear;
extern String Rec1[30];
extern char timestamp[100];

extern struct gsm_Parameter GSM;
extern struct Config_Parameter_Cach_Memory Cash_Memory;
extern struct Config_Parameter OCPP;
extern struct Config_Parameter_OCPP Ocpp_Setting;

/* Static Data Declarations */

/***** Data Type, Constant, and Macro Definitions END *****/

/***** Public Function Bodies *****/

void process_ReceiveArray(void);/* Process the receiving messages from server */
void process_incoming_string();
unsigned long process_transId(String TransString);
unsigned long process_Value(String TransString);
char IDtagValidation(char *data);
char ExpiryDate(char Rec[120]);
int Time_calculation(String rtc , String expiery);
unsigned char connectorid(String TransString);
void process_time(String CheckString);
char * process_otp(String TransString);
//int Remote_Stop_Tr(String TransString);
int process_interval(String TransString);
void parse_remote_start_tx(char Array[5][50]);
char Parse_fw_uri(char uri[200]);
char firwareupdateTimecalculation(char date_time[100]);
int strcmp_1(unsigned char *b,unsigned char *a);
int strlen_1(unsigned char *data);
const char* strstr_1(const char* X, const char* Y);
int compare(const char *X, const char *Y);

void Authorizereq(char Idtoken[21],int ChargerID,int connector,unsigned RandumNumber);/* Send the authorization request to server */
void BootNotification(char chargePointModel[], char chargePointVendor[], char Model[], int ChargerID, int connector, unsigned RandumNumber, char ChargerType[]);/* Send the BootNotification */
char StopTransactionreq(unsigned RandumNumber,String Idtoken,unsigned long int meterstopvalue,char * reason,unsigned int transactionId,int ChargerID,int connector,String datetime);
void Metervalue_ClockAlign(int ChargerID,int connector,unsigned int RandumNumber,unsigned transactionId,float current,float voltage,float power,float energy,String DateTime);/* Send the metervalues.PERIODIC to server */
void Metervalue_Began(int ChargerID,int connector,unsigned int RandumNumber,unsigned transactionId,float current,float voltage,float power,float energy,String DateTime);/* Send the metervalues.BEGAN to server */
void Metervalue_End(int ChargerID,int connector,unsigned int RandumNumber,unsigned transactionId,float current,float voltage,float power,float energy,String DateTime);/* Send the metervalues.END to server */
void Metervalue_Periodic(int ChargerID,int connector,unsigned int RandumNumber,unsigned transactionId,float current,float voltage,float power,float energy,String DateTime);/* Send the metervalues.During Transaction to servber */
void Metervalue_ClockAlign_System(int ChargerID,int connector,unsigned int RandumNumber,unsigned int transactionId,float current,float voltage,float power,float energy,String DateTime);
void Heartbeat_1(int RandumNumber);/* Send the heartbeat */
void parse_BootNotification(char Array[5][50]);
void Heartbeat(int ChargerID,int connectorm,unsigned RandumNumber);/* Send the heartbeat */
char StartTransactionreq(unsigned RandumNumber,int ChargerID,int connectorid, String Idtoken,unsigned long int meterstartval,String ReservationId, String datetime);/* Send the StartTransactionreq  */
void DataTransfer(unsigned RandumNumber,String vendorid,String MessageID);/* transfer the dada */
void DataSend(String Data,int ChargerID,int connector);/* transfer the dada */
void StatusNotification(unsigned RandumNumber, int ChargerID, int connector, char * status, char* datetime, char * error);/* Send the status of charger */
void SetTime(String Rec);/* Set the time */
void parse_remote_start_tx(char Array[5][50]);
void RemoteStartTransaction(String RandumNumber, String Resp_status);
void RemoteStopTransaction(int RandumNumber, String Resp_status);
char FirmwareStatusNotificationreq(unsigned int RandumNumber,char * status);
/***** Public Function Bodies END *****/


#endif /* OCPP_H_ */
