/*
 * cs5460a.h
 *
 *  Created on: May 21, 2025
 *      Author: electro.design5
 */

#ifndef INC_CS5460A_H_
#define INC_CS5460A_H_

#include "stm32g0xx_hal.h"
#include "main.h"

// Command definitions
#define CS5460A_RMS_VOLTAGE     0x18
#define CS5460A_RMS_CURRENT     0x16
#define CS5460A_TRUE_POWER      0x14

#define CS5460A_CFG_READ        0x00  // Config register read
#define CS5460A_CFG_READ_IGN    0x04  // Current gain register read
#define CS5460A_CFG_READ_VGN    0x08  // Voltage gain register read
#define CS5460A_CFG_READ_CYCLE  0x0A  // Cycle count register read

#define CS5460A_CFG_POWER_UP    0xA0  // Power-up/halt command

// Configuration values
#define CS5460A_CFG_GAIN0       0x40  // PGA Gain 50x, IHPF=1, VHPF=1
#define CS5460A_CFG_GAIN1       0x01
#define CS5460A_CFG_GAIN2       0x00
#define CS5460A_CFG_GAIN3       0x61

#define CS5460A_CFG_IGN0        0x44  // Current channel gain (1.15935)
#define CS5460A_CFG_IGN1        0x4A
#define CS5460A_CFG_IGN2        0x32
#define CS5460A_CFG_IGN3        0xDF

#define CS5460A_CFG_VGN0        0x48  // Voltage channel gain (0.97823)
#define CS5460A_CFG_VGN1        0x3E
#define CS5460A_CFG_VGN2        0x9B
#define CS5460A_CFG_VGN3        0x5A

#define CS5460A_START_CONV      0xE8  // Start continuous conversion

// Function prototypes
void CS5460A_Init(void);
void CS5460A_Reset(void);
void CS5460A_WriteRegister(uint8_t reg, uint32_t value);
uint32_t CS5460A_ReadRegister(uint8_t reg);
float CS5460A_ReadVoltage(void);
float CS5460A_ReadCurrent(void);
float CS5460A_ReadPower(void);

#endif /* INC_CS5460A_H_ */
